/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.TestGridSession;
import software.amazon.awssdk.services.devicefarm.model.TestGridSessionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestGridSessionsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListTestGridSessionsResponse> {
    private static final SdkField<List<TestGridSession>> TEST_GRID_SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testGridSessions").getter(ListTestGridSessionsResponse.getter(ListTestGridSessionsResponse::testGridSessions)).setter(ListTestGridSessionsResponse.setter(Builder::testGridSessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testGridSessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestGridSession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestGridSessionsResponse.getter(ListTestGridSessionsResponse::nextToken)).setter(ListTestGridSessionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_GRID_SESSIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTestGridSessionsResponse.memberNameToFieldInitializer();
    private final List<TestGridSession> testGridSessions;
    private final String nextToken;

    private ListTestGridSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.testGridSessions = builder.testGridSessions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTestGridSessions() {
        return this.testGridSessions != null && !(this.testGridSessions instanceof SdkAutoConstructList);
    }

    public final List<TestGridSession> testGridSessions() {
        return this.testGridSessions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestGridSessions() ? this.testGridSessions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestGridSessionsResponse)) {
            return false;
        }
        ListTestGridSessionsResponse other = (ListTestGridSessionsResponse)((Object)obj);
        return this.hasTestGridSessions() == other.hasTestGridSessions() && Objects.equals(this.testGridSessions(), other.testGridSessions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTestGridSessionsResponse").add("TestGridSessions", this.hasTestGridSessions() ? this.testGridSessions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testGridSessions": {
                return Optional.ofNullable(clazz.cast(this.testGridSessions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testGridSessions", TEST_GRID_SESSIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTestGridSessionsResponse, T> g) {
        return obj -> g.apply((ListTestGridSessionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<TestGridSession> testGridSessions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestGridSessionsResponse model) {
            super(model);
            this.testGridSessions(model.testGridSessions);
            this.nextToken(model.nextToken);
        }

        public final List<TestGridSession.Builder> getTestGridSessions() {
            List<TestGridSession.Builder> result = TestGridSessionsCopier.copyToBuilder(this.testGridSessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestGridSessions(Collection<TestGridSession.BuilderImpl> testGridSessions) {
            this.testGridSessions = TestGridSessionsCopier.copyFromBuilder(testGridSessions);
        }

        @Override
        public final Builder testGridSessions(Collection<TestGridSession> testGridSessions) {
            this.testGridSessions = TestGridSessionsCopier.copy(testGridSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testGridSessions(TestGridSession ... testGridSessions) {
            this.testGridSessions(Arrays.asList(testGridSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testGridSessions(Consumer<TestGridSession.Builder> ... testGridSessions) {
            this.testGridSessions(Stream.of(testGridSessions).map(c -> (TestGridSession)((TestGridSession.Builder)TestGridSession.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTestGridSessionsResponse build() {
            return new ListTestGridSessionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestGridSessionsResponse> {
        public Builder testGridSessions(Collection<TestGridSession> var1);

        public Builder testGridSessions(TestGridSession ... var1);

        public Builder testGridSessions(Consumer<TestGridSession.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

