/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstallToRemoteAccessSessionRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, InstallToRemoteAccessSessionRequest> {
    private static final SdkField<String> REMOTE_ACCESS_SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remoteAccessSessionArn").getter(InstallToRemoteAccessSessionRequest.getter(InstallToRemoteAccessSessionRequest::remoteAccessSessionArn)).setter(InstallToRemoteAccessSessionRequest.setter(Builder::remoteAccessSessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccessSessionArn").build()}).build();
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(InstallToRemoteAccessSessionRequest.getter(InstallToRemoteAccessSessionRequest::appArn)).setter(InstallToRemoteAccessSessionRequest.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOTE_ACCESS_SESSION_ARN_FIELD, APP_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstallToRemoteAccessSessionRequest.memberNameToFieldInitializer();
    private final String remoteAccessSessionArn;
    private final String appArn;

    private InstallToRemoteAccessSessionRequest(BuilderImpl builder) {
        super(builder);
        this.remoteAccessSessionArn = builder.remoteAccessSessionArn;
        this.appArn = builder.appArn;
    }

    public final String remoteAccessSessionArn() {
        return this.remoteAccessSessionArn;
    }

    public final String appArn() {
        return this.appArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAccessSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstallToRemoteAccessSessionRequest)) {
            return false;
        }
        InstallToRemoteAccessSessionRequest other = (InstallToRemoteAccessSessionRequest)((Object)obj);
        return Objects.equals(this.remoteAccessSessionArn(), other.remoteAccessSessionArn()) && Objects.equals(this.appArn(), other.appArn());
    }

    public final String toString() {
        return ToString.builder((String)"InstallToRemoteAccessSessionRequest").add("RemoteAccessSessionArn", (Object)this.remoteAccessSessionArn()).add("AppArn", (Object)this.appArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "remoteAccessSessionArn": {
                return Optional.ofNullable(clazz.cast(this.remoteAccessSessionArn()));
            }
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("remoteAccessSessionArn", REMOTE_ACCESS_SESSION_ARN_FIELD);
        map.put("appArn", APP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstallToRemoteAccessSessionRequest, T> g) {
        return obj -> g.apply((InstallToRemoteAccessSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String remoteAccessSessionArn;
        private String appArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InstallToRemoteAccessSessionRequest model) {
            super(model);
            this.remoteAccessSessionArn(model.remoteAccessSessionArn);
            this.appArn(model.appArn);
        }

        public final String getRemoteAccessSessionArn() {
            return this.remoteAccessSessionArn;
        }

        public final void setRemoteAccessSessionArn(String remoteAccessSessionArn) {
            this.remoteAccessSessionArn = remoteAccessSessionArn;
        }

        @Override
        public final Builder remoteAccessSessionArn(String remoteAccessSessionArn) {
            this.remoteAccessSessionArn = remoteAccessSessionArn;
            return this;
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InstallToRemoteAccessSessionRequest build() {
            return new InstallToRemoteAccessSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DeviceFarmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InstallToRemoteAccessSessionRequest> {
        public Builder remoteAccessSessionArn(String var1);

        public Builder appArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

