/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTestGridProjectResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<GetTestGridProjectResponse.Builder, GetTestGridProjectResponse> {
    private static final SdkField<TestGridProject> TEST_GRID_PROJECT_FIELD = SdkField
            .<TestGridProject> builder(MarshallingType.SDK_POJO).memberName("testGridProject")
            .getter(getter(GetTestGridProjectResponse::testGridProject)).setter(setter(Builder::testGridProject))
            .constructor(TestGridProject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testGridProject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_GRID_PROJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TestGridProject testGridProject;

    private GetTestGridProjectResponse(BuilderImpl builder) {
        super(builder);
        this.testGridProject = builder.testGridProject;
    }

    /**
     * <p>
     * A <a>TestGridProject</a>.
     * </p>
     * 
     * @return A <a>TestGridProject</a>.
     */
    public final TestGridProject testGridProject() {
        return testGridProject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testGridProject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestGridProjectResponse)) {
            return false;
        }
        GetTestGridProjectResponse other = (GetTestGridProjectResponse) obj;
        return Objects.equals(testGridProject(), other.testGridProject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTestGridProjectResponse").add("TestGridProject", testGridProject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testGridProject":
            return Optional.ofNullable(clazz.cast(testGridProject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testGridProject", TEST_GRID_PROJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTestGridProjectResponse, T> g) {
        return obj -> g.apply((GetTestGridProjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTestGridProjectResponse> {
        /**
         * <p>
         * A <a>TestGridProject</a>.
         * </p>
         * 
         * @param testGridProject
         *        A <a>TestGridProject</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testGridProject(TestGridProject testGridProject);

        /**
         * <p>
         * A <a>TestGridProject</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestGridProject.Builder} avoiding the
         * need to create one manually via {@link TestGridProject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestGridProject.Builder#build()} is called immediately and its
         * result is passed to {@link #testGridProject(TestGridProject)}.
         * 
         * @param testGridProject
         *        a consumer that will call methods on {@link TestGridProject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testGridProject(TestGridProject)
         */
        default Builder testGridProject(Consumer<TestGridProject.Builder> testGridProject) {
            return testGridProject(TestGridProject.builder().applyMutation(testGridProject).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private TestGridProject testGridProject;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestGridProjectResponse model) {
            super(model);
            testGridProject(model.testGridProject);
        }

        public final TestGridProject.Builder getTestGridProject() {
            return testGridProject != null ? testGridProject.toBuilder() : null;
        }

        public final void setTestGridProject(TestGridProject.BuilderImpl testGridProject) {
            this.testGridProject = testGridProject != null ? testGridProject.build() : null;
        }

        @Override
        public final Builder testGridProject(TestGridProject testGridProject) {
            this.testGridProject = testGridProject;
            return this;
        }

        @Override
        public GetTestGridProjectResponse build() {
            return new GetTestGridProjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
