/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to install an Android application (in .apk format) or an iOS application (in .ipa format) as
 * part of a remote access session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstallToRemoteAccessSessionRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<InstallToRemoteAccessSessionRequest.Builder, InstallToRemoteAccessSessionRequest> {
    private static final SdkField<String> REMOTE_ACCESS_SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remoteAccessSessionArn").getter(getter(InstallToRemoteAccessSessionRequest::remoteAccessSessionArn))
            .setter(setter(Builder::remoteAccessSessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccessSessionArn").build())
            .build();

    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(InstallToRemoteAccessSessionRequest::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REMOTE_ACCESS_SESSION_ARN_FIELD, APP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String remoteAccessSessionArn;

    private final String appArn;

    private InstallToRemoteAccessSessionRequest(BuilderImpl builder) {
        super(builder);
        this.remoteAccessSessionArn = builder.remoteAccessSessionArn;
        this.appArn = builder.appArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the remote access session about which you are requesting information.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the remote access session about which you are requesting information.
     */
    public final String remoteAccessSessionArn() {
        return remoteAccessSessionArn;
    }

    /**
     * <p>
     * The ARN of the app about which you are requesting information.
     * </p>
     * 
     * @return The ARN of the app about which you are requesting information.
     */
    public final String appArn() {
        return appArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(remoteAccessSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstallToRemoteAccessSessionRequest)) {
            return false;
        }
        InstallToRemoteAccessSessionRequest other = (InstallToRemoteAccessSessionRequest) obj;
        return Objects.equals(remoteAccessSessionArn(), other.remoteAccessSessionArn())
                && Objects.equals(appArn(), other.appArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstallToRemoteAccessSessionRequest").add("RemoteAccessSessionArn", remoteAccessSessionArn())
                .add("AppArn", appArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "remoteAccessSessionArn":
            return Optional.ofNullable(clazz.cast(remoteAccessSessionArn()));
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("remoteAccessSessionArn", REMOTE_ACCESS_SESSION_ARN_FIELD);
        map.put("appArn", APP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstallToRemoteAccessSessionRequest, T> g) {
        return obj -> g.apply((InstallToRemoteAccessSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, InstallToRemoteAccessSessionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the remote access session about which you are requesting information.
         * </p>
         * 
         * @param remoteAccessSessionArn
         *        The Amazon Resource Name (ARN) of the remote access session about which you are requesting
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessSessionArn(String remoteAccessSessionArn);

        /**
         * <p>
         * The ARN of the app about which you are requesting information.
         * </p>
         * 
         * @param appArn
         *        The ARN of the app about which you are requesting information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String remoteAccessSessionArn;

        private String appArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InstallToRemoteAccessSessionRequest model) {
            super(model);
            remoteAccessSessionArn(model.remoteAccessSessionArn);
            appArn(model.appArn);
        }

        public final String getRemoteAccessSessionArn() {
            return remoteAccessSessionArn;
        }

        public final void setRemoteAccessSessionArn(String remoteAccessSessionArn) {
            this.remoteAccessSessionArn = remoteAccessSessionArn;
        }

        @Override
        public final Builder remoteAccessSessionArn(String remoteAccessSessionArn) {
            this.remoteAccessSessionArn = remoteAccessSessionArn;
            return this;
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InstallToRemoteAccessSessionRequest build() {
            return new InstallToRemoteAccessSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
