/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeviceInstancesResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListDeviceInstancesResponse.Builder, ListDeviceInstancesResponse> {
    private static final SdkField<List<DeviceInstance>> DEVICE_INSTANCES_FIELD = SdkField
            .<List<DeviceInstance>> builder(MarshallingType.LIST)
            .memberName("deviceInstances")
            .getter(getter(ListDeviceInstancesResponse::deviceInstances))
            .setter(setter(Builder::deviceInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDeviceInstancesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_INSTANCES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DeviceInstance> deviceInstances;

    private final String nextToken;

    private ListDeviceInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.deviceInstances = builder.deviceInstances;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceInstances property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceInstances() {
        return deviceInstances != null && !(deviceInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that contains information about your device instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceInstances} method.
     * </p>
     * 
     * @return An object that contains information about your device instances.
     */
    public final List<DeviceInstance> deviceInstances() {
        return deviceInstances;
    }

    /**
     * <p>
     * An identifier that can be used in the next call to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return An identifier that can be used in the next call to this operation to return the next set of items in the
     *         list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceInstances() ? deviceInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceInstancesResponse)) {
            return false;
        }
        ListDeviceInstancesResponse other = (ListDeviceInstancesResponse) obj;
        return hasDeviceInstances() == other.hasDeviceInstances() && Objects.equals(deviceInstances(), other.deviceInstances())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDeviceInstancesResponse")
                .add("DeviceInstances", hasDeviceInstances() ? deviceInstances() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceInstances":
            return Optional.ofNullable(clazz.cast(deviceInstances()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deviceInstances", DEVICE_INSTANCES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceInstancesResponse, T> g) {
        return obj -> g.apply((ListDeviceInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDeviceInstancesResponse> {
        /**
         * <p>
         * An object that contains information about your device instances.
         * </p>
         * 
         * @param deviceInstances
         *        An object that contains information about your device instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceInstances(Collection<DeviceInstance> deviceInstances);

        /**
         * <p>
         * An object that contains information about your device instances.
         * </p>
         * 
         * @param deviceInstances
         *        An object that contains information about your device instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceInstances(DeviceInstance... deviceInstances);

        /**
         * <p>
         * An object that contains information about your device instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devicefarm.model.DeviceInstance.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.devicefarm.model.DeviceInstance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devicefarm.model.DeviceInstance.Builder#build()} is called immediately
         * and its result is passed to {@link #deviceInstances(List<DeviceInstance>)}.
         * 
         * @param deviceInstances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devicefarm.model.DeviceInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceInstances(java.util.Collection<DeviceInstance>)
         */
        Builder deviceInstances(Consumer<DeviceInstance.Builder>... deviceInstances);

        /**
         * <p>
         * An identifier that can be used in the next call to this operation to return the next set of items in the
         * list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that can be used in the next call to this operation to return the next set of items in
         *        the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<DeviceInstance> deviceInstances = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceInstancesResponse model) {
            super(model);
            deviceInstances(model.deviceInstances);
            nextToken(model.nextToken);
        }

        public final List<DeviceInstance.Builder> getDeviceInstances() {
            List<DeviceInstance.Builder> result = DeviceInstancesCopier.copyToBuilder(this.deviceInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceInstances(Collection<DeviceInstance.BuilderImpl> deviceInstances) {
            this.deviceInstances = DeviceInstancesCopier.copyFromBuilder(deviceInstances);
        }

        @Override
        public final Builder deviceInstances(Collection<DeviceInstance> deviceInstances) {
            this.deviceInstances = DeviceInstancesCopier.copy(deviceInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceInstances(DeviceInstance... deviceInstances) {
            deviceInstances(Arrays.asList(deviceInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceInstances(Consumer<DeviceInstance.Builder>... deviceInstances) {
            deviceInstances(Stream.of(deviceInstances).map(c -> DeviceInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDeviceInstancesResponse build() {
            return new ListDeviceInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
