/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <a>TestGridSession</a> is a single instance of a browser launched from the URL provided by a call to
 * <a>CreateTestGridUrl</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestGridSession implements SdkPojo, Serializable, ToCopyableBuilder<TestGridSession.Builder, TestGridSession> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(TestGridSession::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TestGridSession::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("created").getter(getter(TestGridSession::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<Instant> ENDED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("ended")
            .getter(getter(TestGridSession::ended)).setter(setter(Builder::ended))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ended").build()).build();

    private static final SdkField<Double> BILLING_MINUTES_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("billingMinutes").getter(getter(TestGridSession::billingMinutes)).setter(setter(Builder::billingMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingMinutes").build()).build();

    private static final SdkField<String> SELENIUM_PROPERTIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("seleniumProperties").getter(getter(TestGridSession::seleniumProperties))
            .setter(setter(Builder::seleniumProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seleniumProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD,
            CREATED_FIELD, ENDED_FIELD, BILLING_MINUTES_FIELD, SELENIUM_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String status;

    private final Instant created;

    private final Instant ended;

    private final Double billingMinutes;

    private final String seleniumProperties;

    private TestGridSession(BuilderImpl builder) {
        this.arn = builder.arn;
        this.status = builder.status;
        this.created = builder.created;
        this.ended = builder.ended;
        this.billingMinutes = builder.billingMinutes;
        this.seleniumProperties = builder.seleniumProperties;
    }

    /**
     * <p>
     * The ARN of the session.
     * </p>
     * 
     * @return The ARN of the session.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The state of the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestGridSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the session.
     * @see TestGridSessionStatus
     */
    public final TestGridSessionStatus status() {
        return TestGridSessionStatus.fromValue(status);
    }

    /**
     * <p>
     * The state of the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestGridSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the session.
     * @see TestGridSessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time that the session was started.
     * </p>
     * 
     * @return The time that the session was started.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The time the session ended.
     * </p>
     * 
     * @return The time the session ended.
     */
    public final Instant ended() {
        return ended;
    }

    /**
     * <p>
     * The number of billed minutes that were used for this session.
     * </p>
     * 
     * @return The number of billed minutes that were used for this session.
     */
    public final Double billingMinutes() {
        return billingMinutes;
    }

    /**
     * <p>
     * A JSON object of options and parameters passed to the Selenium WebDriver.
     * </p>
     * 
     * @return A JSON object of options and parameters passed to the Selenium WebDriver.
     */
    public final String seleniumProperties() {
        return seleniumProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(ended());
        hashCode = 31 * hashCode + Objects.hashCode(billingMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(seleniumProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestGridSession)) {
            return false;
        }
        TestGridSession other = (TestGridSession) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(created(), other.created()) && Objects.equals(ended(), other.ended())
                && Objects.equals(billingMinutes(), other.billingMinutes())
                && Objects.equals(seleniumProperties(), other.seleniumProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestGridSession").add("Arn", arn()).add("Status", statusAsString()).add("Created", created())
                .add("Ended", ended()).add("BillingMinutes", billingMinutes()).add("SeleniumProperties", seleniumProperties())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "ended":
            return Optional.ofNullable(clazz.cast(ended()));
        case "billingMinutes":
            return Optional.ofNullable(clazz.cast(billingMinutes()));
        case "seleniumProperties":
            return Optional.ofNullable(clazz.cast(seleniumProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("created", CREATED_FIELD);
        map.put("ended", ENDED_FIELD);
        map.put("billingMinutes", BILLING_MINUTES_FIELD);
        map.put("seleniumProperties", SELENIUM_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestGridSession, T> g) {
        return obj -> g.apply((TestGridSession) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestGridSession> {
        /**
         * <p>
         * The ARN of the session.
         * </p>
         * 
         * @param arn
         *        The ARN of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The state of the session.
         * </p>
         * 
         * @param status
         *        The state of the session.
         * @see TestGridSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestGridSessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The state of the session.
         * </p>
         * 
         * @param status
         *        The state of the session.
         * @see TestGridSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestGridSessionStatus
         */
        Builder status(TestGridSessionStatus status);

        /**
         * <p>
         * The time that the session was started.
         * </p>
         * 
         * @param created
         *        The time that the session was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The time the session ended.
         * </p>
         * 
         * @param ended
         *        The time the session ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ended(Instant ended);

        /**
         * <p>
         * The number of billed minutes that were used for this session.
         * </p>
         * 
         * @param billingMinutes
         *        The number of billed minutes that were used for this session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingMinutes(Double billingMinutes);

        /**
         * <p>
         * A JSON object of options and parameters passed to the Selenium WebDriver.
         * </p>
         * 
         * @param seleniumProperties
         *        A JSON object of options and parameters passed to the Selenium WebDriver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seleniumProperties(String seleniumProperties);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String status;

        private Instant created;

        private Instant ended;

        private Double billingMinutes;

        private String seleniumProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(TestGridSession model) {
            arn(model.arn);
            status(model.status);
            created(model.created);
            ended(model.ended);
            billingMinutes(model.billingMinutes);
            seleniumProperties(model.seleniumProperties);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestGridSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getEnded() {
            return ended;
        }

        public final void setEnded(Instant ended) {
            this.ended = ended;
        }

        @Override
        public final Builder ended(Instant ended) {
            this.ended = ended;
            return this;
        }

        public final Double getBillingMinutes() {
            return billingMinutes;
        }

        public final void setBillingMinutes(Double billingMinutes) {
            this.billingMinutes = billingMinutes;
        }

        @Override
        public final Builder billingMinutes(Double billingMinutes) {
            this.billingMinutes = billingMinutes;
            return this;
        }

        public final String getSeleniumProperties() {
            return seleniumProperties;
        }

        public final void setSeleniumProperties(String seleniumProperties) {
            this.seleniumProperties = seleniumProperties;
        }

        @Override
        public final Builder seleniumProperties(String seleniumProperties) {
            this.seleniumProperties = seleniumProperties;
            return this;
        }

        @Override
        public TestGridSession build() {
            return new TestGridSession(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
