/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTestGridUrlRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<CreateTestGridUrlRequest.Builder, CreateTestGridUrlRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectArn").getter(getter(CreateTestGridUrlRequest::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()).build();

    private static final SdkField<Integer> EXPIRES_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("expiresInSeconds").getter(getter(CreateTestGridUrlRequest::expiresInSeconds))
            .setter(setter(Builder::expiresInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            EXPIRES_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String projectArn;

    private final Integer expiresInSeconds;

    private CreateTestGridUrlRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.expiresInSeconds = builder.expiresInSeconds;
    }

    /**
     * <p>
     * ARN (from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>) to associate with the short-term URL.
     * </p>
     * 
     * @return ARN (from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>) to associate with the short-term
     *         URL.
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * Lifetime, in seconds, of the URL.
     * </p>
     * 
     * @return Lifetime, in seconds, of the URL.
     */
    public final Integer expiresInSeconds() {
        return expiresInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(expiresInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTestGridUrlRequest)) {
            return false;
        }
        CreateTestGridUrlRequest other = (CreateTestGridUrlRequest) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(expiresInSeconds(), other.expiresInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTestGridUrlRequest").add("ProjectArn", projectArn())
                .add("ExpiresInSeconds", expiresInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "expiresInSeconds":
            return Optional.ofNullable(clazz.cast(expiresInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectArn", PROJECT_ARN_FIELD);
        map.put("expiresInSeconds", EXPIRES_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTestGridUrlRequest, T> g) {
        return obj -> g.apply((CreateTestGridUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTestGridUrlRequest> {
        /**
         * <p>
         * ARN (from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>) to associate with the short-term URL.
         * </p>
         * 
         * @param projectArn
         *        ARN (from <a>CreateTestGridProject</a> or <a>ListTestGridProjects</a>) to associate with the
         *        short-term URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * Lifetime, in seconds, of the URL.
         * </p>
         * 
         * @param expiresInSeconds
         *        Lifetime, in seconds, of the URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresInSeconds(Integer expiresInSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String projectArn;

        private Integer expiresInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTestGridUrlRequest model) {
            super(model);
            projectArn(model.projectArn);
            expiresInSeconds(model.expiresInSeconds);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final Integer getExpiresInSeconds() {
            return expiresInSeconds;
        }

        public final void setExpiresInSeconds(Integer expiresInSeconds) {
            this.expiresInSeconds = expiresInSeconds;
        }

        @Override
        public final Builder expiresInSeconds(Integer expiresInSeconds) {
            this.expiresInSeconds = expiresInSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTestGridUrlRequest build() {
            return new CreateTestGridUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
