/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the remote endpoints for viewing and controlling a device during a remote access session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoteAccessEndpoints implements SdkPojo, Serializable,
        ToCopyableBuilder<RemoteAccessEndpoints.Builder, RemoteAccessEndpoints> {
    private static final SdkField<String> REMOTE_DRIVER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remoteDriverEndpoint").getter(getter(RemoteAccessEndpoints::remoteDriverEndpoint))
            .setter(setter(Builder::remoteDriverEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteDriverEndpoint").build())
            .build();

    private static final SdkField<String> INTERACTIVE_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interactiveEndpoint").getter(getter(RemoteAccessEndpoints::interactiveEndpoint))
            .setter(setter(Builder::interactiveEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interactiveEndpoint").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOTE_DRIVER_ENDPOINT_FIELD,
            INTERACTIVE_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String remoteDriverEndpoint;

    private final String interactiveEndpoint;

    private RemoteAccessEndpoints(BuilderImpl builder) {
        this.remoteDriverEndpoint = builder.remoteDriverEndpoint;
        this.interactiveEndpoint = builder.interactiveEndpoint;
    }

    /**
     * <p>
     * URL for controlling the device using WebDriver-compliant clients, like Appium, during the remote access session.
     * </p>
     * 
     * @return URL for controlling the device using WebDriver-compliant clients, like Appium, during the remote access
     *         session.
     */
    public final String remoteDriverEndpoint() {
        return remoteDriverEndpoint;
    }

    /**
     * <p>
     * URL for viewing and interacting with the device during the remote access session.
     * </p>
     * 
     * @return URL for viewing and interacting with the device during the remote access session.
     */
    public final String interactiveEndpoint() {
        return interactiveEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(remoteDriverEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(interactiveEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteAccessEndpoints)) {
            return false;
        }
        RemoteAccessEndpoints other = (RemoteAccessEndpoints) obj;
        return Objects.equals(remoteDriverEndpoint(), other.remoteDriverEndpoint())
                && Objects.equals(interactiveEndpoint(), other.interactiveEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoteAccessEndpoints")
                .add("RemoteDriverEndpoint", remoteDriverEndpoint() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InteractiveEndpoint", interactiveEndpoint() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "remoteDriverEndpoint":
            return Optional.ofNullable(clazz.cast(remoteDriverEndpoint()));
        case "interactiveEndpoint":
            return Optional.ofNullable(clazz.cast(interactiveEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("remoteDriverEndpoint", REMOTE_DRIVER_ENDPOINT_FIELD);
        map.put("interactiveEndpoint", INTERACTIVE_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoteAccessEndpoints, T> g) {
        return obj -> g.apply((RemoteAccessEndpoints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemoteAccessEndpoints> {
        /**
         * <p>
         * URL for controlling the device using WebDriver-compliant clients, like Appium, during the remote access
         * session.
         * </p>
         * 
         * @param remoteDriverEndpoint
         *        URL for controlling the device using WebDriver-compliant clients, like Appium, during the remote
         *        access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteDriverEndpoint(String remoteDriverEndpoint);

        /**
         * <p>
         * URL for viewing and interacting with the device during the remote access session.
         * </p>
         * 
         * @param interactiveEndpoint
         *        URL for viewing and interacting with the device during the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactiveEndpoint(String interactiveEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private String remoteDriverEndpoint;

        private String interactiveEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteAccessEndpoints model) {
            remoteDriverEndpoint(model.remoteDriverEndpoint);
            interactiveEndpoint(model.interactiveEndpoint);
        }

        public final String getRemoteDriverEndpoint() {
            return remoteDriverEndpoint;
        }

        public final void setRemoteDriverEndpoint(String remoteDriverEndpoint) {
            this.remoteDriverEndpoint = remoteDriverEndpoint;
        }

        @Override
        public final Builder remoteDriverEndpoint(String remoteDriverEndpoint) {
            this.remoteDriverEndpoint = remoteDriverEndpoint;
            return this;
        }

        public final String getInteractiveEndpoint() {
            return interactiveEndpoint;
        }

        public final void setInteractiveEndpoint(String interactiveEndpoint) {
            this.interactiveEndpoint = interactiveEndpoint;
        }

        @Override
        public final Builder interactiveEndpoint(String interactiveEndpoint) {
            this.interactiveEndpoint = interactiveEndpoint;
            return this;
        }

        @Override
        public RemoteAccessEndpoints build() {
            return new RemoteAccessEndpoints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
