/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about the remote access session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoteAccessSession implements SdkPojo, Serializable,
        ToCopyableBuilder<RemoteAccessSession.Builder, RemoteAccessSession> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RemoteAccessSession::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RemoteAccessSession::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("created").getter(getter(RemoteAccessSession::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RemoteAccessSession::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("result")
            .getter(getter(RemoteAccessSession::resultAsString)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(RemoteAccessSession::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<Instant> STARTED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("started").getter(getter(RemoteAccessSession::started)).setter(setter(Builder::started))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("started").build()).build();

    private static final SdkField<Instant> STOPPED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("stopped").getter(getter(RemoteAccessSession::stopped)).setter(setter(Builder::stopped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopped").build()).build();

    private static final SdkField<Device> DEVICE_FIELD = SdkField.<Device> builder(MarshallingType.SDK_POJO).memberName("device")
            .getter(getter(RemoteAccessSession::device)).setter(setter(Builder::device)).constructor(Device::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("device").build()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceArn").getter(getter(RemoteAccessSession::instanceArn)).setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()).build();

    private static final SdkField<String> BILLING_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingMethod").getter(getter(RemoteAccessSession::billingMethodAsString))
            .setter(setter(Builder::billingMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingMethod").build()).build();

    private static final SdkField<DeviceMinutes> DEVICE_MINUTES_FIELD = SdkField
            .<DeviceMinutes> builder(MarshallingType.SDK_POJO).memberName("deviceMinutes")
            .getter(getter(RemoteAccessSession::deviceMinutes)).setter(setter(Builder::deviceMinutes))
            .constructor(DeviceMinutes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceMinutes").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(RemoteAccessSession::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<String> DEVICE_UDID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceUdid").getter(getter(RemoteAccessSession::deviceUdid)).setter(setter(Builder::deviceUdid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceUdid").build()).build();

    private static final SdkField<String> INTERACTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("interactionMode").getter(getter(RemoteAccessSession::interactionModeAsString))
            .setter(setter(Builder::interactionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interactionMode").build()).build();

    private static final SdkField<Boolean> SKIP_APP_RESIGN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("skipAppResign").getter(getter(RemoteAccessSession::skipAppResign))
            .setter(setter(Builder::skipAppResign))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipAppResign").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("vpcConfig").getter(getter(RemoteAccessSession::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<DeviceProxy> DEVICE_PROXY_FIELD = SdkField.<DeviceProxy> builder(MarshallingType.SDK_POJO)
            .memberName("deviceProxy").getter(getter(RemoteAccessSession::deviceProxy)).setter(setter(Builder::deviceProxy))
            .constructor(DeviceProxy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceProxy").build()).build();

    private static final SdkField<String> APP_UPLOAD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appUpload").getter(getter(RemoteAccessSession::appUpload)).setter(setter(Builder::appUpload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appUpload").build()).build();

    private static final SdkField<RemoteAccessEndpoints> ENDPOINTS_FIELD = SdkField
            .<RemoteAccessEndpoints> builder(MarshallingType.SDK_POJO).memberName("endpoints")
            .getter(getter(RemoteAccessSession::endpoints)).setter(setter(Builder::endpoints))
            .constructor(RemoteAccessEndpoints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            CREATED_FIELD, STATUS_FIELD, RESULT_FIELD, MESSAGE_FIELD, STARTED_FIELD, STOPPED_FIELD, DEVICE_FIELD,
            INSTANCE_ARN_FIELD, BILLING_METHOD_FIELD, DEVICE_MINUTES_FIELD, ENDPOINT_FIELD, DEVICE_UDID_FIELD,
            INTERACTION_MODE_FIELD, SKIP_APP_RESIGN_FIELD, VPC_CONFIG_FIELD, DEVICE_PROXY_FIELD, APP_UPLOAD_FIELD,
            ENDPOINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final Instant created;

    private final String status;

    private final String result;

    private final String message;

    private final Instant started;

    private final Instant stopped;

    private final Device device;

    private final String instanceArn;

    private final String billingMethod;

    private final DeviceMinutes deviceMinutes;

    private final String endpoint;

    private final String deviceUdid;

    private final String interactionMode;

    private final Boolean skipAppResign;

    private final VpcConfig vpcConfig;

    private final DeviceProxy deviceProxy;

    private final String appUpload;

    private final RemoteAccessEndpoints endpoints;

    private RemoteAccessSession(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.message = builder.message;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.device = builder.device;
        this.instanceArn = builder.instanceArn;
        this.billingMethod = builder.billingMethod;
        this.deviceMinutes = builder.deviceMinutes;
        this.endpoint = builder.endpoint;
        this.deviceUdid = builder.deviceUdid;
        this.interactionMode = builder.interactionMode;
        this.skipAppResign = builder.skipAppResign;
        this.vpcConfig = builder.vpcConfig;
        this.deviceProxy = builder.deviceProxy;
        this.appUpload = builder.appUpload;
        this.endpoints = builder.endpoints;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the remote access session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the remote access session.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the remote access session.
     * </p>
     * 
     * @return The name of the remote access session.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The date and time the remote access session was created.
     * </p>
     * 
     * @return The date and time the remote access session was created.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The status of the remote access session. Can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_CONCURRENCY.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_DEVICE.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULING.
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARING.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPING.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the remote access session. Can be any of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_CONCURRENCY.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_DEVICE.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULING.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARING.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPING.
     *         </p>
     *         </li>
     * @see ExecutionStatus
     */
    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the remote access session. Can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_CONCURRENCY.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_DEVICE.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULING.
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARING.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPING.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the remote access session. Can be any of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_CONCURRENCY.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_DEVICE.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULING.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARING.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPING.
     *         </p>
     *         </li>
     * @see ExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The result of the remote access session. Can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The result of the remote access session. Can be any of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED.
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public final ExecutionResult result() {
        return ExecutionResult.fromValue(result);
    }

    /**
     * <p>
     * The result of the remote access session. Can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The result of the remote access session. Can be any of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED.
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public final String resultAsString() {
        return result;
    }

    /**
     * <p>
     * A message about the remote access session.
     * </p>
     * 
     * @return A message about the remote access session.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The date and time the remote access session was started.
     * </p>
     * 
     * @return The date and time the remote access session was started.
     */
    public final Instant started() {
        return started;
    }

    /**
     * <p>
     * The date and time the remote access session was stopped.
     * </p>
     * 
     * @return The date and time the remote access session was stopped.
     */
    public final Instant stopped() {
        return stopped;
    }

    /**
     * <p>
     * The device (phone or tablet) used in the remote access session.
     * </p>
     * 
     * @return The device (phone or tablet) used in the remote access session.
     */
    public final Device device() {
        return device;
    }

    /**
     * <p>
     * The ARN of the instance.
     * </p>
     * 
     * @return The ARN of the instance.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The billing method of the remote access session. Possible values include <code>METERED</code> or
     * <code>UNMETERED</code>. For more information about metered devices, see <a
     * href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS Device
     * Farm terminology</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodAsString}.
     * </p>
     * 
     * @return The billing method of the remote access session. Possible values include <code>METERED</code> or
     *         <code>UNMETERED</code>. For more information about metered devices, see <a
     *         href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS
     *         Device Farm terminology</a>.
     * @see BillingMethod
     */
    public final BillingMethod billingMethod() {
        return BillingMethod.fromValue(billingMethod);
    }

    /**
     * <p>
     * The billing method of the remote access session. Possible values include <code>METERED</code> or
     * <code>UNMETERED</code>. For more information about metered devices, see <a
     * href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS Device
     * Farm terminology</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMethod}
     * will return {@link BillingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingMethodAsString}.
     * </p>
     * 
     * @return The billing method of the remote access session. Possible values include <code>METERED</code> or
     *         <code>UNMETERED</code>. For more information about metered devices, see <a
     *         href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS
     *         Device Farm terminology</a>.
     * @see BillingMethod
     */
    public final String billingMethodAsString() {
        return billingMethod;
    }

    /**
     * <p>
     * The number of minutes a device is used in a remote access session (including setup and teardown minutes).
     * </p>
     * 
     * @return The number of minutes a device is used in a remote access session (including setup and teardown minutes).
     */
    public final DeviceMinutes deviceMinutes() {
        return deviceMinutes;
    }

    /**
     * <p>
     * The endpoint for the remote access session. This field is deprecated, and is replaced by the new
     * <code>endpoints.interactiveEndpoint</code> field.
     * </p>
     * 
     * @return The endpoint for the remote access session. This field is deprecated, and is replaced by the new
     *         <code>endpoints.interactiveEndpoint</code> field.
     * @deprecated This field is deprecated, and is replaced by the new endpoints.interactiveEndpoint field.
     */
    @Deprecated
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * Unique device identifier for the remote device. Only returned if remote debugging is enabled for the remote
     * access session.
     * </p>
     * <p>
     * Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
     * supported</a>.
     * </p>
     * 
     * @return Unique device identifier for the remote device. Only returned if remote debugging is enabled for the
     *         remote access session.</p>
     *         <p>
     *         Remote debugging is <a
     *         href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>.
     */
    public final String deviceUdid() {
        return deviceUdid;
    }

    /**
     * <p>
     * The interaction mode of the remote access session. Changing the interactive mode of remote access sessions is no
     * longer available.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interactionMode}
     * will return {@link InteractionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interactionModeAsString}.
     * </p>
     * 
     * @return The interaction mode of the remote access session. Changing the interactive mode of remote access
     *         sessions is no longer available.
     * @see InteractionMode
     * @deprecated Changing the interactive mode of Remote Access sessions is no longer available.
     */
    @Deprecated
    public final InteractionMode interactionMode() {
        return InteractionMode.fromValue(interactionMode);
    }

    /**
     * <p>
     * The interaction mode of the remote access session. Changing the interactive mode of remote access sessions is no
     * longer available.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interactionMode}
     * will return {@link InteractionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interactionModeAsString}.
     * </p>
     * 
     * @return The interaction mode of the remote access session. Changing the interactive mode of remote access
     *         sessions is no longer available.
     * @see InteractionMode
     * @deprecated Changing the interactive mode of Remote Access sessions is no longer available.
     */
    @Deprecated
    public final String interactionModeAsString() {
        return interactionMode;
    }

    /**
     * <p>
     * When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public devices,
     * Device Farm always signs your apps again.
     * </p>
     * <p>
     * For more information about how Device Farm re-signs your apps, see <a
     * href="http://aws.amazon.com/device-farm/faqs/">Do you modify my app?</a> in the <i>AWS Device Farm FAQs</i>.
     * </p>
     * 
     * @return When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
     *         devices, Device Farm always signs your apps again.</p>
     *         <p>
     *         For more information about how Device Farm re-signs your apps, see <a
     *         href="http://aws.amazon.com/device-farm/faqs/">Do you modify my app?</a> in the <i>AWS Device Farm
     *         FAQs</i>.
     */
    public final Boolean skipAppResign() {
        return skipAppResign;
    }

    /**
     * <p>
     * The VPC security groups and subnets that are attached to a project.
     * </p>
     * 
     * @return The VPC security groups and subnets that are attached to a project.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The device proxy configured for the remote access session.
     * </p>
     * 
     * @return The device proxy configured for the remote access session.
     */
    public final DeviceProxy deviceProxy() {
        return deviceProxy;
    }

    /**
     * <p>
     * The ARN for the app to be installed onto your device.
     * </p>
     * 
     * @return The ARN for the app to be installed onto your device.
     */
    public final String appUpload() {
        return appUpload;
    }

    /**
     * Returns the value of the Endpoints property for this object.
     * 
     * @return The value of the Endpoints property for this object.
     */
    public final RemoteAccessEndpoints endpoints() {
        return endpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(started());
        hashCode = 31 * hashCode + Objects.hashCode(stopped());
        hashCode = 31 * hashCode + Objects.hashCode(device());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(billingMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(deviceUdid());
        hashCode = 31 * hashCode + Objects.hashCode(interactionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(skipAppResign());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(deviceProxy());
        hashCode = 31 * hashCode + Objects.hashCode(appUpload());
        hashCode = 31 * hashCode + Objects.hashCode(endpoints());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteAccessSession)) {
            return false;
        }
        RemoteAccessSession other = (RemoteAccessSession) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(created(), other.created()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(resultAsString(), other.resultAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(started(), other.started()) && Objects.equals(stopped(), other.stopped())
                && Objects.equals(device(), other.device()) && Objects.equals(instanceArn(), other.instanceArn())
                && Objects.equals(billingMethodAsString(), other.billingMethodAsString())
                && Objects.equals(deviceMinutes(), other.deviceMinutes()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(deviceUdid(), other.deviceUdid())
                && Objects.equals(interactionModeAsString(), other.interactionModeAsString())
                && Objects.equals(skipAppResign(), other.skipAppResign()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(deviceProxy(), other.deviceProxy()) && Objects.equals(appUpload(), other.appUpload())
                && Objects.equals(endpoints(), other.endpoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoteAccessSession").add("Arn", arn()).add("Name", name()).add("Created", created())
                .add("Status", statusAsString()).add("Result", resultAsString()).add("Message", message())
                .add("Started", started()).add("Stopped", stopped()).add("Device", device()).add("InstanceArn", instanceArn())
                .add("BillingMethod", billingMethodAsString()).add("DeviceMinutes", deviceMinutes()).add("Endpoint", endpoint())
                .add("DeviceUdid", deviceUdid()).add("InteractionMode", interactionModeAsString())
                .add("SkipAppResign", skipAppResign()).add("VpcConfig", vpcConfig()).add("DeviceProxy", deviceProxy())
                .add("AppUpload", appUpload()).add("Endpoints", endpoints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "result":
            return Optional.ofNullable(clazz.cast(resultAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "started":
            return Optional.ofNullable(clazz.cast(started()));
        case "stopped":
            return Optional.ofNullable(clazz.cast(stopped()));
        case "device":
            return Optional.ofNullable(clazz.cast(device()));
        case "instanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "billingMethod":
            return Optional.ofNullable(clazz.cast(billingMethodAsString()));
        case "deviceMinutes":
            return Optional.ofNullable(clazz.cast(deviceMinutes()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "deviceUdid":
            return Optional.ofNullable(clazz.cast(deviceUdid()));
        case "interactionMode":
            return Optional.ofNullable(clazz.cast(interactionModeAsString()));
        case "skipAppResign":
            return Optional.ofNullable(clazz.cast(skipAppResign()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "deviceProxy":
            return Optional.ofNullable(clazz.cast(deviceProxy()));
        case "appUpload":
            return Optional.ofNullable(clazz.cast(appUpload()));
        case "endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("created", CREATED_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("result", RESULT_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("started", STARTED_FIELD);
        map.put("stopped", STOPPED_FIELD);
        map.put("device", DEVICE_FIELD);
        map.put("instanceArn", INSTANCE_ARN_FIELD);
        map.put("billingMethod", BILLING_METHOD_FIELD);
        map.put("deviceMinutes", DEVICE_MINUTES_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("deviceUdid", DEVICE_UDID_FIELD);
        map.put("interactionMode", INTERACTION_MODE_FIELD);
        map.put("skipAppResign", SKIP_APP_RESIGN_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        map.put("deviceProxy", DEVICE_PROXY_FIELD);
        map.put("appUpload", APP_UPLOAD_FIELD);
        map.put("endpoints", ENDPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoteAccessSession, T> g) {
        return obj -> g.apply((RemoteAccessSession) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemoteAccessSession> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the remote access session.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the remote access session.
         * </p>
         * 
         * @param name
         *        The name of the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The date and time the remote access session was created.
         * </p>
         * 
         * @param created
         *        The date and time the remote access session was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The status of the remote access session. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the remote access session. Can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING.
         *        </p>
         *        </li>
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the remote access session. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the remote access session. Can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING.
         *        </p>
         *        </li>
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * The result of the remote access session. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The result of the remote access session. Can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(String result);

        /**
         * <p>
         * The result of the remote access session. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The result of the remote access session. Can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(ExecutionResult result);

        /**
         * <p>
         * A message about the remote access session.
         * </p>
         * 
         * @param message
         *        A message about the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The date and time the remote access session was started.
         * </p>
         * 
         * @param started
         *        The date and time the remote access session was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder started(Instant started);

        /**
         * <p>
         * The date and time the remote access session was stopped.
         * </p>
         * 
         * @param stopped
         *        The date and time the remote access session was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopped(Instant stopped);

        /**
         * <p>
         * The device (phone or tablet) used in the remote access session.
         * </p>
         * 
         * @param device
         *        The device (phone or tablet) used in the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(Device device);

        /**
         * <p>
         * The device (phone or tablet) used in the remote access session.
         * </p>
         * This is a convenience method that creates an instance of the {@link Device.Builder} avoiding the need to
         * create one manually via {@link Device#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Device.Builder#build()} is called immediately and its result is
         * passed to {@link #device(Device)}.
         * 
         * @param device
         *        a consumer that will call methods on {@link Device.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #device(Device)
         */
        default Builder device(Consumer<Device.Builder> device) {
            return device(Device.builder().applyMutation(device).build());
        }

        /**
         * <p>
         * The ARN of the instance.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The billing method of the remote access session. Possible values include <code>METERED</code> or
         * <code>UNMETERED</code>. For more information about metered devices, see <a
         * href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS
         * Device Farm terminology</a>.
         * </p>
         * 
         * @param billingMethod
         *        The billing method of the remote access session. Possible values include <code>METERED</code> or
         *        <code>UNMETERED</code>. For more information about metered devices, see <a
         *        href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology"
         *        >AWS Device Farm terminology</a>.
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(String billingMethod);

        /**
         * <p>
         * The billing method of the remote access session. Possible values include <code>METERED</code> or
         * <code>UNMETERED</code>. For more information about metered devices, see <a
         * href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology">AWS
         * Device Farm terminology</a>.
         * </p>
         * 
         * @param billingMethod
         *        The billing method of the remote access session. Possible values include <code>METERED</code> or
         *        <code>UNMETERED</code>. For more information about metered devices, see <a
         *        href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology"
         *        >AWS Device Farm terminology</a>.
         * @see BillingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMethod
         */
        Builder billingMethod(BillingMethod billingMethod);

        /**
         * <p>
         * The number of minutes a device is used in a remote access session (including setup and teardown minutes).
         * </p>
         * 
         * @param deviceMinutes
         *        The number of minutes a device is used in a remote access session (including setup and teardown
         *        minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMinutes(DeviceMinutes deviceMinutes);

        /**
         * <p>
         * The number of minutes a device is used in a remote access session (including setup and teardown minutes).
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceMinutes.Builder} avoiding the need
         * to create one manually via {@link DeviceMinutes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceMinutes.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceMinutes(DeviceMinutes)}.
         * 
         * @param deviceMinutes
         *        a consumer that will call methods on {@link DeviceMinutes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceMinutes(DeviceMinutes)
         */
        default Builder deviceMinutes(Consumer<DeviceMinutes.Builder> deviceMinutes) {
            return deviceMinutes(DeviceMinutes.builder().applyMutation(deviceMinutes).build());
        }

        /**
         * <p>
         * The endpoint for the remote access session. This field is deprecated, and is replaced by the new
         * <code>endpoints.interactiveEndpoint</code> field.
         * </p>
         * 
         * @param endpoint
         *        The endpoint for the remote access session. This field is deprecated, and is replaced by the new
         *        <code>endpoints.interactiveEndpoint</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This field is deprecated, and is replaced by the new endpoints.interactiveEndpoint field.
         */
        @Deprecated
        Builder endpoint(String endpoint);

        /**
         * <p>
         * Unique device identifier for the remote device. Only returned if remote debugging is enabled for the remote
         * access session.
         * </p>
         * <p>
         * Remote debugging is <a href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no
         * longer supported</a>.
         * </p>
         * 
         * @param deviceUdid
         *        Unique device identifier for the remote device. Only returned if remote debugging is enabled for the
         *        remote access session.</p>
         *        <p>
         *        Remote debugging is <a
         *        href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
         *        supported</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceUdid(String deviceUdid);

        /**
         * <p>
         * The interaction mode of the remote access session. Changing the interactive mode of remote access sessions is
         * no longer available.
         * </p>
         * 
         * @param interactionMode
         *        The interaction mode of the remote access session. Changing the interactive mode of remote access
         *        sessions is no longer available.
         * @see InteractionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InteractionMode
         * @deprecated Changing the interactive mode of Remote Access sessions is no longer available.
         */
        @Deprecated
        Builder interactionMode(String interactionMode);

        /**
         * <p>
         * The interaction mode of the remote access session. Changing the interactive mode of remote access sessions is
         * no longer available.
         * </p>
         * 
         * @param interactionMode
         *        The interaction mode of the remote access session. Changing the interactive mode of remote access
         *        sessions is no longer available.
         * @see InteractionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InteractionMode
         * @deprecated Changing the interactive mode of Remote Access sessions is no longer available.
         */
        @Deprecated
        Builder interactionMode(InteractionMode interactionMode);

        /**
         * <p>
         * When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
         * devices, Device Farm always signs your apps again.
         * </p>
         * <p>
         * For more information about how Device Farm re-signs your apps, see <a
         * href="http://aws.amazon.com/device-farm/faqs/">Do you modify my app?</a> in the <i>AWS Device Farm FAQs</i>.
         * </p>
         * 
         * @param skipAppResign
         *        When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For
         *        public devices, Device Farm always signs your apps again.</p>
         *        <p>
         *        For more information about how Device Farm re-signs your apps, see <a
         *        href="http://aws.amazon.com/device-farm/faqs/">Do you modify my app?</a> in the <i>AWS Device Farm
         *        FAQs</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipAppResign(Boolean skipAppResign);

        /**
         * <p>
         * The VPC security groups and subnets that are attached to a project.
         * </p>
         * 
         * @param vpcConfig
         *        The VPC security groups and subnets that are attached to a project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * The VPC security groups and subnets that are attached to a project.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The device proxy configured for the remote access session.
         * </p>
         * 
         * @param deviceProxy
         *        The device proxy configured for the remote access session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceProxy(DeviceProxy deviceProxy);

        /**
         * <p>
         * The device proxy configured for the remote access session.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceProxy.Builder} avoiding the need to
         * create one manually via {@link DeviceProxy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceProxy.Builder#build()} is called immediately and its result
         * is passed to {@link #deviceProxy(DeviceProxy)}.
         * 
         * @param deviceProxy
         *        a consumer that will call methods on {@link DeviceProxy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceProxy(DeviceProxy)
         */
        default Builder deviceProxy(Consumer<DeviceProxy.Builder> deviceProxy) {
            return deviceProxy(DeviceProxy.builder().applyMutation(deviceProxy).build());
        }

        /**
         * <p>
         * The ARN for the app to be installed onto your device.
         * </p>
         * 
         * @param appUpload
         *        The ARN for the app to be installed onto your device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appUpload(String appUpload);

        /**
         * Sets the value of the Endpoints property for this object.
         *
         * @param endpoints
         *        The new value for the Endpoints property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(RemoteAccessEndpoints endpoints);

        /**
         * Sets the value of the Endpoints property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RemoteAccessEndpoints.Builder} avoiding
         * the need to create one manually via {@link RemoteAccessEndpoints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RemoteAccessEndpoints.Builder#build()} is called immediately and
         * its result is passed to {@link #endpoints(RemoteAccessEndpoints)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on {@link RemoteAccessEndpoints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(RemoteAccessEndpoints)
         */
        default Builder endpoints(Consumer<RemoteAccessEndpoints.Builder> endpoints) {
            return endpoints(RemoteAccessEndpoints.builder().applyMutation(endpoints).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private Instant created;

        private String status;

        private String result;

        private String message;

        private Instant started;

        private Instant stopped;

        private Device device;

        private String instanceArn;

        private String billingMethod;

        private DeviceMinutes deviceMinutes;

        private String endpoint;

        private String deviceUdid;

        private String interactionMode;

        private Boolean skipAppResign;

        private VpcConfig vpcConfig;

        private DeviceProxy deviceProxy;

        private String appUpload;

        private RemoteAccessEndpoints endpoints;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteAccessSession model) {
            arn(model.arn);
            name(model.name);
            created(model.created);
            status(model.status);
            result(model.result);
            message(model.message);
            started(model.started);
            stopped(model.stopped);
            device(model.device);
            instanceArn(model.instanceArn);
            billingMethod(model.billingMethod);
            deviceMinutes(model.deviceMinutes);
            endpoint(model.endpoint);
            deviceUdid(model.deviceUdid);
            interactionMode(model.interactionMode);
            skipAppResign(model.skipAppResign);
            vpcConfig(model.vpcConfig);
            deviceProxy(model.deviceProxy);
            appUpload(model.appUpload);
            endpoints(model.endpoints);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getStarted() {
            return started;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final Instant getStopped() {
            return stopped;
        }

        public final void setStopped(Instant stopped) {
            this.stopped = stopped;
        }

        @Override
        public final Builder stopped(Instant stopped) {
            this.stopped = stopped;
            return this;
        }

        public final Device.Builder getDevice() {
            return device != null ? device.toBuilder() : null;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getBillingMethod() {
            return billingMethod;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod == null ? null : billingMethod.toString());
            return this;
        }

        public final DeviceMinutes.Builder getDeviceMinutes() {
            return deviceMinutes != null ? deviceMinutes.toBuilder() : null;
        }

        public final void setDeviceMinutes(DeviceMinutes.BuilderImpl deviceMinutes) {
            this.deviceMinutes = deviceMinutes != null ? deviceMinutes.build() : null;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        @Deprecated
        public final String getEndpoint() {
            return endpoint;
        }

        @Deprecated
        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        @Deprecated
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getDeviceUdid() {
            return deviceUdid;
        }

        public final void setDeviceUdid(String deviceUdid) {
            this.deviceUdid = deviceUdid;
        }

        @Override
        public final Builder deviceUdid(String deviceUdid) {
            this.deviceUdid = deviceUdid;
            return this;
        }

        @Deprecated
        public final String getInteractionMode() {
            return interactionMode;
        }

        @Deprecated
        public final void setInteractionMode(String interactionMode) {
            this.interactionMode = interactionMode;
        }

        @Override
        @Deprecated
        public final Builder interactionMode(String interactionMode) {
            this.interactionMode = interactionMode;
            return this;
        }

        @Override
        @Deprecated
        public final Builder interactionMode(InteractionMode interactionMode) {
            this.interactionMode(interactionMode == null ? null : interactionMode.toString());
            return this;
        }

        public final Boolean getSkipAppResign() {
            return skipAppResign;
        }

        public final void setSkipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
        }

        @Override
        public final Builder skipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final DeviceProxy.Builder getDeviceProxy() {
            return deviceProxy != null ? deviceProxy.toBuilder() : null;
        }

        public final void setDeviceProxy(DeviceProxy.BuilderImpl deviceProxy) {
            this.deviceProxy = deviceProxy != null ? deviceProxy.build() : null;
        }

        @Override
        public final Builder deviceProxy(DeviceProxy deviceProxy) {
            this.deviceProxy = deviceProxy;
            return this;
        }

        public final String getAppUpload() {
            return appUpload;
        }

        public final void setAppUpload(String appUpload) {
            this.appUpload = appUpload;
        }

        @Override
        public final Builder appUpload(String appUpload) {
            this.appUpload = appUpload;
            return this;
        }

        public final RemoteAccessEndpoints.Builder getEndpoints() {
            return endpoints != null ? endpoints.toBuilder() : null;
        }

        public final void setEndpoints(RemoteAccessEndpoints.BuilderImpl endpoints) {
            this.endpoints = endpoints != null ? endpoints.build() : null;
        }

        @Override
        public final Builder endpoints(RemoteAccessEndpoints endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        @Override
        public RemoteAccessSession build() {
            return new RemoteAccessSession(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
