/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server that describes the remote access session when AWS Device Farm stops the
 * session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopRemoteAccessSessionResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<StopRemoteAccessSessionResponse.Builder, StopRemoteAccessSessionResponse> {
    private static final SdkField<RemoteAccessSession> REMOTE_ACCESS_SESSION_FIELD = SdkField
            .<RemoteAccessSession> builder(MarshallingType.SDK_POJO).memberName("remoteAccessSession")
            .getter(getter(StopRemoteAccessSessionResponse::remoteAccessSession)).setter(setter(Builder::remoteAccessSession))
            .constructor(RemoteAccessSession::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccessSession").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOTE_ACCESS_SESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RemoteAccessSession remoteAccessSession;

    private StopRemoteAccessSessionResponse(BuilderImpl builder) {
        super(builder);
        this.remoteAccessSession = builder.remoteAccessSession;
    }

    /**
     * <p>
     * A container that represents the metadata from the service about the remote access session you are stopping.
     * </p>
     * 
     * @return A container that represents the metadata from the service about the remote access session you are
     *         stopping.
     */
    public final RemoteAccessSession remoteAccessSession() {
        return remoteAccessSession;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(remoteAccessSession());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopRemoteAccessSessionResponse)) {
            return false;
        }
        StopRemoteAccessSessionResponse other = (StopRemoteAccessSessionResponse) obj;
        return Objects.equals(remoteAccessSession(), other.remoteAccessSession());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopRemoteAccessSessionResponse").add("RemoteAccessSession", remoteAccessSession()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "remoteAccessSession":
            return Optional.ofNullable(clazz.cast(remoteAccessSession()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("remoteAccessSession", REMOTE_ACCESS_SESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopRemoteAccessSessionResponse, T> g) {
        return obj -> g.apply((StopRemoteAccessSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StopRemoteAccessSessionResponse> {
        /**
         * <p>
         * A container that represents the metadata from the service about the remote access session you are stopping.
         * </p>
         * 
         * @param remoteAccessSession
         *        A container that represents the metadata from the service about the remote access session you are
         *        stopping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessSession(RemoteAccessSession remoteAccessSession);

        /**
         * <p>
         * A container that represents the metadata from the service about the remote access session you are stopping.
         * </p>
         * This is a convenience method that creates an instance of the {@link RemoteAccessSession.Builder} avoiding the
         * need to create one manually via {@link RemoteAccessSession#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RemoteAccessSession.Builder#build()} is called immediately and
         * its result is passed to {@link #remoteAccessSession(RemoteAccessSession)}.
         * 
         * @param remoteAccessSession
         *        a consumer that will call methods on {@link RemoteAccessSession.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteAccessSession(RemoteAccessSession)
         */
        default Builder remoteAccessSession(Consumer<RemoteAccessSession.Builder> remoteAccessSession) {
            return remoteAccessSession(RemoteAccessSession.builder().applyMutation(remoteAccessSession).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private RemoteAccessSession remoteAccessSession;

        private BuilderImpl() {
        }

        private BuilderImpl(StopRemoteAccessSessionResponse model) {
            super(model);
            remoteAccessSession(model.remoteAccessSession);
        }

        public final RemoteAccessSession.Builder getRemoteAccessSession() {
            return remoteAccessSession != null ? remoteAccessSession.toBuilder() : null;
        }

        public final void setRemoteAccessSession(RemoteAccessSession.BuilderImpl remoteAccessSession) {
            this.remoteAccessSession = remoteAccessSession != null ? remoteAccessSession.build() : null;
        }

        @Override
        public final Builder remoteAccessSession(RemoteAccessSession remoteAccessSession) {
            this.remoteAccessSession = remoteAccessSession;
            return this;
        }

        @Override
        public StopRemoteAccessSessionResponse build() {
            return new StopRemoteAccessSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
