/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Selenium testing project. Projects are used to collect and collate sessions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestGridProject implements SdkPojo, Serializable, ToCopyableBuilder<TestGridProject.Builder, TestGridProject> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(TestGridProject::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TestGridProject::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(TestGridProject::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<TestGridVpcConfig> VPC_CONFIG_FIELD = SdkField
            .<TestGridVpcConfig> builder(MarshallingType.SDK_POJO).memberName("vpcConfig")
            .getter(getter(TestGridProject::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(TestGridVpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("created").getter(getter(TestGridProject::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, VPC_CONFIG_FIELD, CREATED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String description;

    private final TestGridVpcConfig vpcConfig;

    private final Instant created;

    private TestGridProject(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.vpcConfig = builder.vpcConfig;
        this.created = builder.created;
    }

    /**
     * <p>
     * The ARN for the project.
     * </p>
     * 
     * @return The ARN for the project.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A human-readable name for the project.
     * </p>
     * 
     * @return A human-readable name for the project.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A human-readable description for the project.
     * </p>
     * 
     * @return A human-readable description for the project.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The VPC security groups and subnets that are attached to a project.
     * </p>
     * 
     * @return The VPC security groups and subnets that are attached to a project.
     */
    public final TestGridVpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * When the project was created.
     * </p>
     * 
     * @return When the project was created.
     */
    public final Instant created() {
        return created;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestGridProject)) {
            return false;
        }
        TestGridProject other = (TestGridProject) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(created(), other.created());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestGridProject").add("Arn", arn()).add("Name", name()).add("Description", description())
                .add("VpcConfig", vpcConfig()).add("Created", created()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        map.put("created", CREATED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestGridProject, T> g) {
        return obj -> g.apply((TestGridProject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestGridProject> {
        /**
         * <p>
         * The ARN for the project.
         * </p>
         * 
         * @param arn
         *        The ARN for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A human-readable name for the project.
         * </p>
         * 
         * @param name
         *        A human-readable name for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A human-readable description for the project.
         * </p>
         * 
         * @param description
         *        A human-readable description for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The VPC security groups and subnets that are attached to a project.
         * </p>
         * 
         * @param vpcConfig
         *        The VPC security groups and subnets that are attached to a project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(TestGridVpcConfig vpcConfig);

        /**
         * <p>
         * The VPC security groups and subnets that are attached to a project.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestGridVpcConfig.Builder} avoiding the
         * need to create one manually via {@link TestGridVpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestGridVpcConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfig(TestGridVpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link TestGridVpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(TestGridVpcConfig)
         */
        default Builder vpcConfig(Consumer<TestGridVpcConfig.Builder> vpcConfig) {
            return vpcConfig(TestGridVpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * When the project was created.
         * </p>
         * 
         * @param created
         *        When the project was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private TestGridVpcConfig vpcConfig;

        private Instant created;

        private BuilderImpl() {
        }

        private BuilderImpl(TestGridProject model) {
            arn(model.arn);
            name(model.name);
            description(model.description);
            vpcConfig(model.vpcConfig);
            created(model.created);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TestGridVpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(TestGridVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(TestGridVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        @Override
        public TestGridProject build() {
            return new TestGridProject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
