/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to the schedule run operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleRunRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<ScheduleRunRequest.Builder, ScheduleRunRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScheduleRunRequest::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()).build();

    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScheduleRunRequest::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> DEVICE_POOL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScheduleRunRequest::devicePoolArn)).setter(setter(Builder::devicePoolArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devicePoolArn").build()).build();

    private static final SdkField<DeviceSelectionConfiguration> DEVICE_SELECTION_CONFIGURATION_FIELD = SdkField
            .<DeviceSelectionConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(ScheduleRunRequest::deviceSelectionConfiguration))
            .setter(setter(Builder::deviceSelectionConfiguration))
            .constructor(DeviceSelectionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceSelectionConfiguration")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScheduleRunRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ScheduleRunTest> TEST_FIELD = SdkField.<ScheduleRunTest> builder(MarshallingType.SDK_POJO)
            .getter(getter(ScheduleRunRequest::test)).setter(setter(Builder::test)).constructor(ScheduleRunTest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("test").build()).build();

    private static final SdkField<ScheduleRunConfiguration> CONFIGURATION_FIELD = SdkField
            .<ScheduleRunConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(ScheduleRunRequest::configuration))
            .setter(setter(Builder::configuration)).constructor(ScheduleRunConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<ExecutionConfiguration> EXECUTION_CONFIGURATION_FIELD = SdkField
            .<ExecutionConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(ScheduleRunRequest::executionConfiguration)).setter(setter(Builder::executionConfiguration))
            .constructor(ExecutionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            APP_ARN_FIELD, DEVICE_POOL_ARN_FIELD, DEVICE_SELECTION_CONFIGURATION_FIELD, NAME_FIELD, TEST_FIELD,
            CONFIGURATION_FIELD, EXECUTION_CONFIGURATION_FIELD));

    private final String projectArn;

    private final String appArn;

    private final String devicePoolArn;

    private final DeviceSelectionConfiguration deviceSelectionConfiguration;

    private final String name;

    private final ScheduleRunTest test;

    private final ScheduleRunConfiguration configuration;

    private final ExecutionConfiguration executionConfiguration;

    private ScheduleRunRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.appArn = builder.appArn;
        this.devicePoolArn = builder.devicePoolArn;
        this.deviceSelectionConfiguration = builder.deviceSelectionConfiguration;
        this.name = builder.name;
        this.test = builder.test;
        this.configuration = builder.configuration;
        this.executionConfiguration = builder.executionConfiguration;
    }

    /**
     * <p>
     * The ARN of the project for the run to be scheduled.
     * </p>
     * 
     * @return The ARN of the project for the run to be scheduled.
     */
    public String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * The ARN of the app to schedule a run.
     * </p>
     * 
     * @return The ARN of the app to schedule a run.
     */
    public String appArn() {
        return appArn;
    }

    /**
     * <p>
     * The ARN of the device pool for the run to be scheduled.
     * </p>
     * 
     * @return The ARN of the device pool for the run to be scheduled.
     */
    public String devicePoolArn() {
        return devicePoolArn;
    }

    /**
     * <p>
     * The filter criteria used to dynamically select a set of devices for a test run, as well as the maximum number of
     * devices to be included in the run.
     * </p>
     * <p>
     * Either <b> <code>devicePoolArn</code> </b> or <b> <code>deviceSelectionConfiguration</code> </b> is required in a
     * request.
     * </p>
     * 
     * @return The filter criteria used to dynamically select a set of devices for a test run, as well as the maximum
     *         number of devices to be included in the run.</p>
     *         <p>
     *         Either <b> <code>devicePoolArn</code> </b> or <b> <code>deviceSelectionConfiguration</code> </b> is
     *         required in a request.
     */
    public DeviceSelectionConfiguration deviceSelectionConfiguration() {
        return deviceSelectionConfiguration;
    }

    /**
     * <p>
     * The name for the run to be scheduled.
     * </p>
     * 
     * @return The name for the run to be scheduled.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Information about the test for the run to be scheduled.
     * </p>
     * 
     * @return Information about the test for the run to be scheduled.
     */
    public ScheduleRunTest test() {
        return test;
    }

    /**
     * <p>
     * Information about the settings for the run to be scheduled.
     * </p>
     * 
     * @return Information about the settings for the run to be scheduled.
     */
    public ScheduleRunConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * Specifies configuration information about a test run, such as the execution timeout (in minutes).
     * </p>
     * 
     * @return Specifies configuration information about a test run, such as the execution timeout (in minutes).
     */
    public ExecutionConfiguration executionConfiguration() {
        return executionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(devicePoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceSelectionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(test());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(executionConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunRequest)) {
            return false;
        }
        ScheduleRunRequest other = (ScheduleRunRequest) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(appArn(), other.appArn())
                && Objects.equals(devicePoolArn(), other.devicePoolArn())
                && Objects.equals(deviceSelectionConfiguration(), other.deviceSelectionConfiguration())
                && Objects.equals(name(), other.name()) && Objects.equals(test(), other.test())
                && Objects.equals(configuration(), other.configuration())
                && Objects.equals(executionConfiguration(), other.executionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ScheduleRunRequest").add("ProjectArn", projectArn()).add("AppArn", appArn())
                .add("DevicePoolArn", devicePoolArn()).add("DeviceSelectionConfiguration", deviceSelectionConfiguration())
                .add("Name", name()).add("Test", test()).add("Configuration", configuration())
                .add("ExecutionConfiguration", executionConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "devicePoolArn":
            return Optional.ofNullable(clazz.cast(devicePoolArn()));
        case "deviceSelectionConfiguration":
            return Optional.ofNullable(clazz.cast(deviceSelectionConfiguration()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "test":
            return Optional.ofNullable(clazz.cast(test()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "executionConfiguration":
            return Optional.ofNullable(clazz.cast(executionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleRunRequest, T> g) {
        return obj -> g.apply((ScheduleRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo, CopyableBuilder<Builder, ScheduleRunRequest> {
        /**
         * <p>
         * The ARN of the project for the run to be scheduled.
         * </p>
         * 
         * @param projectArn
         *        The ARN of the project for the run to be scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * The ARN of the app to schedule a run.
         * </p>
         * 
         * @param appArn
         *        The ARN of the app to schedule a run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The ARN of the device pool for the run to be scheduled.
         * </p>
         * 
         * @param devicePoolArn
         *        The ARN of the device pool for the run to be scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePoolArn(String devicePoolArn);

        /**
         * <p>
         * The filter criteria used to dynamically select a set of devices for a test run, as well as the maximum number
         * of devices to be included in the run.
         * </p>
         * <p>
         * Either <b> <code>devicePoolArn</code> </b> or <b> <code>deviceSelectionConfiguration</code> </b> is required
         * in a request.
         * </p>
         * 
         * @param deviceSelectionConfiguration
         *        The filter criteria used to dynamically select a set of devices for a test run, as well as the maximum
         *        number of devices to be included in the run.</p>
         *        <p>
         *        Either <b> <code>devicePoolArn</code> </b> or <b> <code>deviceSelectionConfiguration</code> </b> is
         *        required in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceSelectionConfiguration(DeviceSelectionConfiguration deviceSelectionConfiguration);

        /**
         * <p>
         * The filter criteria used to dynamically select a set of devices for a test run, as well as the maximum number
         * of devices to be included in the run.
         * </p>
         * <p>
         * Either <b> <code>devicePoolArn</code> </b> or <b> <code>deviceSelectionConfiguration</code> </b> is required
         * in a request.
         * </p>
         * This is a convenience that creates an instance of the {@link DeviceSelectionConfiguration.Builder} avoiding
         * the need to create one manually via {@link DeviceSelectionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceSelectionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceSelectionConfiguration(DeviceSelectionConfiguration)}.
         * 
         * @param deviceSelectionConfiguration
         *        a consumer that will call methods on {@link DeviceSelectionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceSelectionConfiguration(DeviceSelectionConfiguration)
         */
        default Builder deviceSelectionConfiguration(Consumer<DeviceSelectionConfiguration.Builder> deviceSelectionConfiguration) {
            return deviceSelectionConfiguration(DeviceSelectionConfiguration.builder()
                    .applyMutation(deviceSelectionConfiguration).build());
        }

        /**
         * <p>
         * The name for the run to be scheduled.
         * </p>
         * 
         * @param name
         *        The name for the run to be scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Information about the test for the run to be scheduled.
         * </p>
         * 
         * @param test
         *        Information about the test for the run to be scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder test(ScheduleRunTest test);

        /**
         * <p>
         * Information about the test for the run to be scheduled.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduleRunTest.Builder} avoiding the need to
         * create one manually via {@link ScheduleRunTest#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduleRunTest.Builder#build()} is called immediately and its
         * result is passed to {@link #test(ScheduleRunTest)}.
         * 
         * @param test
         *        a consumer that will call methods on {@link ScheduleRunTest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #test(ScheduleRunTest)
         */
        default Builder test(Consumer<ScheduleRunTest.Builder> test) {
            return test(ScheduleRunTest.builder().applyMutation(test).build());
        }

        /**
         * <p>
         * Information about the settings for the run to be scheduled.
         * </p>
         * 
         * @param configuration
         *        Information about the settings for the run to be scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ScheduleRunConfiguration configuration);

        /**
         * <p>
         * Information about the settings for the run to be scheduled.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduleRunConfiguration.Builder} avoiding the
         * need to create one manually via {@link ScheduleRunConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduleRunConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(ScheduleRunConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ScheduleRunConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ScheduleRunConfiguration)
         */
        default Builder configuration(Consumer<ScheduleRunConfiguration.Builder> configuration) {
            return configuration(ScheduleRunConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Specifies configuration information about a test run, such as the execution timeout (in minutes).
         * </p>
         * 
         * @param executionConfiguration
         *        Specifies configuration information about a test run, such as the execution timeout (in minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionConfiguration(ExecutionConfiguration executionConfiguration);

        /**
         * <p>
         * Specifies configuration information about a test run, such as the execution timeout (in minutes).
         * </p>
         * This is a convenience that creates an instance of the {@link ExecutionConfiguration.Builder} avoiding the
         * need to create one manually via {@link ExecutionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #executionConfiguration(ExecutionConfiguration)}.
         * 
         * @param executionConfiguration
         *        a consumer that will call methods on {@link ExecutionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionConfiguration(ExecutionConfiguration)
         */
        default Builder executionConfiguration(Consumer<ExecutionConfiguration.Builder> executionConfiguration) {
            return executionConfiguration(ExecutionConfiguration.builder().applyMutation(executionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String projectArn;

        private String appArn;

        private String devicePoolArn;

        private DeviceSelectionConfiguration deviceSelectionConfiguration;

        private String name;

        private ScheduleRunTest test;

        private ScheduleRunConfiguration configuration;

        private ExecutionConfiguration executionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunRequest model) {
            super(model);
            projectArn(model.projectArn);
            appArn(model.appArn);
            devicePoolArn(model.devicePoolArn);
            deviceSelectionConfiguration(model.deviceSelectionConfiguration);
            name(model.name);
            test(model.test);
            configuration(model.configuration);
            executionConfiguration(model.executionConfiguration);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getAppArn() {
            return appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        public final String getDevicePoolArn() {
            return devicePoolArn;
        }

        @Override
        public final Builder devicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
            return this;
        }

        public final void setDevicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
        }

        public final DeviceSelectionConfiguration.Builder getDeviceSelectionConfiguration() {
            return deviceSelectionConfiguration != null ? deviceSelectionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder deviceSelectionConfiguration(DeviceSelectionConfiguration deviceSelectionConfiguration) {
            this.deviceSelectionConfiguration = deviceSelectionConfiguration;
            return this;
        }

        public final void setDeviceSelectionConfiguration(DeviceSelectionConfiguration.BuilderImpl deviceSelectionConfiguration) {
            this.deviceSelectionConfiguration = deviceSelectionConfiguration != null ? deviceSelectionConfiguration.build()
                    : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ScheduleRunTest.Builder getTest() {
            return test != null ? test.toBuilder() : null;
        }

        @Override
        public final Builder test(ScheduleRunTest test) {
            this.test = test;
            return this;
        }

        public final void setTest(ScheduleRunTest.BuilderImpl test) {
            this.test = test != null ? test.build() : null;
        }

        public final ScheduleRunConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(ScheduleRunConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ScheduleRunConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final ExecutionConfiguration.Builder getExecutionConfiguration() {
            return executionConfiguration != null ? executionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder executionConfiguration(ExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
            return this;
        }

        public final void setExecutionConfiguration(ExecutionConfiguration.BuilderImpl executionConfiguration) {
            this.executionConfiguration = executionConfiguration != null ? executionConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ScheduleRunRequest build() {
            return new ScheduleRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
