/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the screen resolution of a device in height and width, expressed in pixels.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resolution implements SdkPojo, Serializable, ToCopyableBuilder<Resolution.Builder, Resolution> {
    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Resolution::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()).build();

    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Resolution::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WIDTH_FIELD, HEIGHT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer width;

    private final Integer height;

    private Resolution(BuilderImpl builder) {
        this.width = builder.width;
        this.height = builder.height;
    }

    /**
     * <p>
     * The screen resolution's width, expressed in pixels.
     * </p>
     * 
     * @return The screen resolution's width, expressed in pixels.
     */
    public Integer width() {
        return width;
    }

    /**
     * <p>
     * The screen resolution's height, expressed in pixels.
     * </p>
     * 
     * @return The screen resolution's height, expressed in pixels.
     */
    public Integer height() {
        return height;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(width());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resolution)) {
            return false;
        }
        Resolution other = (Resolution) obj;
        return Objects.equals(width(), other.width()) && Objects.equals(height(), other.height());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Resolution").add("Width", width()).add("Height", height()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "width":
            return Optional.ofNullable(clazz.cast(width()));
        case "height":
            return Optional.ofNullable(clazz.cast(height()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resolution, T> g) {
        return obj -> g.apply((Resolution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resolution> {
        /**
         * <p>
         * The screen resolution's width, expressed in pixels.
         * </p>
         * 
         * @param width
         *        The screen resolution's width, expressed in pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);

        /**
         * <p>
         * The screen resolution's height, expressed in pixels.
         * </p>
         * 
         * @param height
         *        The screen resolution's height, expressed in pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);
    }

    static final class BuilderImpl implements Builder {
        private Integer width;

        private Integer height;

        private BuilderImpl() {
        }

        private BuilderImpl(Resolution model) {
            width(model.width);
            height(model.height);
        }

        public final Integer getWidth() {
            return width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        public final Integer getHeight() {
            return height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public Resolution build() {
            return new Resolution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
