/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a condition that is evaluated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Test implements SdkPojo, Serializable, ToCopyableBuilder<Test.Builder, Test> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).getter(getter(Test::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Test::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Test::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Test::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Test::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Test::resultAsString)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<Instant> STARTED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Test::started)).setter(setter(Builder::started))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("started").build()).build();

    private static final SdkField<Instant> STOPPED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Test::stopped)).setter(setter(Builder::stopped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopped").build()).build();

    private static final SdkField<Counters> COUNTERS_FIELD = SdkField.<Counters> builder(MarshallingType.SDK_POJO)
            .getter(getter(Test::counters)).setter(setter(Builder::counters)).constructor(Counters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("counters").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Test::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<DeviceMinutes> DEVICE_MINUTES_FIELD = SdkField
            .<DeviceMinutes> builder(MarshallingType.SDK_POJO).getter(getter(Test::deviceMinutes))
            .setter(setter(Builder::deviceMinutes)).constructor(DeviceMinutes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceMinutes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            TYPE_FIELD, CREATED_FIELD, STATUS_FIELD, RESULT_FIELD, STARTED_FIELD, STOPPED_FIELD, COUNTERS_FIELD, MESSAGE_FIELD,
            DEVICE_MINUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String type;

    private final Instant created;

    private final String status;

    private final String result;

    private final Instant started;

    private final Instant stopped;

    private final Counters counters;

    private final String message;

    private final DeviceMinutes deviceMinutes;

    private Test(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.counters = builder.counters;
        this.message = builder.message;
        this.deviceMinutes = builder.deviceMinutes;
    }

    /**
     * <p>
     * The test's ARN.
     * </p>
     * 
     * @return The test's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The test's name.
     * </p>
     * 
     * @return The test's name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The test's type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ: The built-in fuzz type.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     * capturing screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON: The Appium Python type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE: The Appium Node.js type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY: The Appium Ruby type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON: The Appium Python type for web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE: The Appium Node.js type for web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH: The Calabash type.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION: The Instrumentation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION: The uiautomation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR: The uiautomator type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST: The Xcode test type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI: The Xcode UI test type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The test's type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ: The built-in fuzz type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON: The Appium Python type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_NODE: The Appium Node.js type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_RUBY: The Appium Ruby type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON: The Appium Python type for web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_NODE: The Appium Node.js type for web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_RUBY: The Appium Ruby type for web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH: The Calabash type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION: The Instrumentation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION: The uiautomation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR: The uiautomator type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST: The Xcode test type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI: The Xcode UI test type.
     *         </p>
     *         </li>
     * @see TestType
     */
    public TestType type() {
        return TestType.fromValue(type);
    }

    /**
     * <p>
     * The test's type.
     * </p>
     * <p>
     * Must be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ: The built-in fuzz type.
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     * capturing screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON: The Appium Python type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE: The Appium Node.js type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY: The Appium Ruby type.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON: The Appium Python type for web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE: The Appium Node.js type for web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH: The Calabash type.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION: The Instrumentation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION: The uiautomation type.
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR: The uiautomator type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST: The Xcode test type.
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI: The Xcode UI test type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The test's type.</p>
     *         <p>
     *         Must be one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ: The built-in fuzz type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON: The Appium Python type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_NODE: The Appium Node.js type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_RUBY: The Appium Ruby type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON: The Appium Python type for web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_NODE: The Appium Node.js type for web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_RUBY: The Appium Ruby type for web apps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH: The Calabash type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION: The Instrumentation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION: The uiautomation type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR: The uiautomator type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST: The Xcode test type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI: The Xcode UI test type.
     *         </p>
     *         </li>
     * @see TestType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * When the test was created.
     * </p>
     * 
     * @return When the test was created.
     */
    public Instant created() {
        return created;
    }

    /**
     * <p>
     * The test's status.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_CONCURRENCY: A pending concurrency status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_DEVICE: A pending device status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING: A processing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULING: A scheduling status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARING: A preparing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING: A running status.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED: A completed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPING: A stopping status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The test's status.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_CONCURRENCY: A pending concurrency status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_DEVICE: A pending device status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING: A processing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULING: A scheduling status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARING: A preparing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING: A running status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED: A completed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPING: A stopping status.
     *         </p>
     *         </li>
     * @see ExecutionStatus
     */
    public ExecutionStatus status() {
        return ExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The test's status.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_CONCURRENCY: A pending concurrency status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_DEVICE: A pending device status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING: A processing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULING: A scheduling status.
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARING: A preparing status.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING: A running status.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED: A completed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPING: A stopping status.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The test's status.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_CONCURRENCY: A pending concurrency status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_DEVICE: A pending device status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING: A processing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULING: A scheduling status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARING: A preparing status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING: A running status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED: A completed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPING: A stopping status.
     *         </p>
     *         </li>
     * @see ExecutionStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The test's result.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED: A passing condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED: A warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: A failed condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED: A skipped condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED: An error condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED: A stopped condition.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The test's result.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED: A passing condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED: A warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: A failed condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED: A skipped condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED: An error condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED: A stopped condition.
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public ExecutionResult result() {
        return ExecutionResult.fromValue(result);
    }

    /**
     * <p>
     * The test's result.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING: A pending condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED: A passing condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED: A warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED: A failed condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED: A skipped condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED: An error condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED: A stopped condition.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The test's result.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING: A pending condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED: A passing condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED: A warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED: A failed condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED: A skipped condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED: An error condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED: A stopped condition.
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public String resultAsString() {
        return result;
    }

    /**
     * <p>
     * The test's start time.
     * </p>
     * 
     * @return The test's start time.
     */
    public Instant started() {
        return started;
    }

    /**
     * <p>
     * The test's stop time.
     * </p>
     * 
     * @return The test's stop time.
     */
    public Instant stopped() {
        return stopped;
    }

    /**
     * <p>
     * The test's result counters.
     * </p>
     * 
     * @return The test's result counters.
     */
    public Counters counters() {
        return counters;
    }

    /**
     * <p>
     * A message about the test's result.
     * </p>
     * 
     * @return A message about the test's result.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * Represents the total (metered or unmetered) minutes used by the test.
     * </p>
     * 
     * @return Represents the total (metered or unmetered) minutes used by the test.
     */
    public DeviceMinutes deviceMinutes() {
        return deviceMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(started());
        hashCode = 31 * hashCode + Objects.hashCode(stopped());
        hashCode = 31 * hashCode + Objects.hashCode(counters());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(deviceMinutes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Test)) {
            return false;
        }
        Test other = (Test) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(created(), other.created())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(resultAsString(), other.resultAsString()) && Objects.equals(started(), other.started())
                && Objects.equals(stopped(), other.stopped()) && Objects.equals(counters(), other.counters())
                && Objects.equals(message(), other.message()) && Objects.equals(deviceMinutes(), other.deviceMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Test").add("Arn", arn()).add("Name", name()).add("Type", typeAsString())
                .add("Created", created()).add("Status", statusAsString()).add("Result", resultAsString())
                .add("Started", started()).add("Stopped", stopped()).add("Counters", counters()).add("Message", message())
                .add("DeviceMinutes", deviceMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "result":
            return Optional.ofNullable(clazz.cast(resultAsString()));
        case "started":
            return Optional.ofNullable(clazz.cast(started()));
        case "stopped":
            return Optional.ofNullable(clazz.cast(stopped()));
        case "counters":
            return Optional.ofNullable(clazz.cast(counters()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "deviceMinutes":
            return Optional.ofNullable(clazz.cast(deviceMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Test, T> g) {
        return obj -> g.apply((Test) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Test> {
        /**
         * <p>
         * The test's ARN.
         * </p>
         * 
         * @param arn
         *        The test's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The test's name.
         * </p>
         * 
         * @param name
         *        The test's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The test's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ: The built-in fuzz type.
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON: The Appium Python type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_NODE: The Appium Node.js type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_RUBY: The Appium Ruby type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON: The Appium Python type for web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_NODE: The Appium Node.js type for web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH: The Calabash type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION: The Instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION: The uiautomation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR: The uiautomator type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST: The Xcode test type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI: The Xcode UI test type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The test's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ: The built-in fuzz type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it
         *        and capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON: The Appium Python type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_NODE: The Appium Node.js type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_RUBY: The Appium Ruby type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON: The Appium Python type for web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_NODE: The Appium Node.js type for web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_RUBY: The Appium Ruby type for web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH: The Calabash type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION: The Instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION: The uiautomation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR: The uiautomator type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST: The Xcode test type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI: The Xcode UI test type.
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(String type);

        /**
         * <p>
         * The test's type.
         * </p>
         * <p>
         * Must be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ: The built-in fuzz type.
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON: The Appium Python type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_NODE: The Appium Node.js type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_RUBY: The Appium Ruby type.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON: The Appium Python type for web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_NODE: The Appium Node.js type for web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH: The Calabash type.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION: The Instrumentation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION: The uiautomation type.
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR: The uiautomator type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST: The Xcode test type.
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI: The Xcode UI test type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The test's type.</p>
         *        <p>
         *        Must be one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ: The built-in fuzz type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting with it
         *        and capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON: The Appium Python type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_NODE: The Appium Node.js type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_RUBY: The Appium Ruby type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON: The Appium Python type for web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_NODE: The Appium Node.js type for web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_RUBY: The Appium Ruby type for web apps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH: The Calabash type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION: The Instrumentation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION: The uiautomation type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR: The uiautomator type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST: The Xcode test type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI: The Xcode UI test type.
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(TestType type);

        /**
         * <p>
         * When the test was created.
         * </p>
         * 
         * @param created
         *        When the test was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The test's status.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY: A pending concurrency status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE: A pending device status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING: A scheduling status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING: A preparing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING: A running status.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED: A completed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING: A stopping status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The test's status.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY: A pending concurrency status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE: A pending device status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING: A scheduling status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING: A preparing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING: A running status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED: A completed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING: A stopping status.
         *        </p>
         *        </li>
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The test's status.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY: A pending concurrency status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE: A pending device status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING: A processing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING: A scheduling status.
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING: A preparing status.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING: A running status.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED: A completed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING: A stopping status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The test's status.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY: A pending concurrency status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE: A pending device status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING: A processing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING: A scheduling status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING: A preparing status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING: A running status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED: A completed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING: A stopping status.
         *        </p>
         *        </li>
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * The test's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The test's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(String result);

        /**
         * <p>
         * The test's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING: A pending condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED: A passing condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED: A warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED: A failed condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED: A skipped condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED: An error condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED: A stopped condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The test's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING: A pending condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED: A passing condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED: A warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED: A failed condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED: A skipped condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED: An error condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED: A stopped condition.
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(ExecutionResult result);

        /**
         * <p>
         * The test's start time.
         * </p>
         * 
         * @param started
         *        The test's start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder started(Instant started);

        /**
         * <p>
         * The test's stop time.
         * </p>
         * 
         * @param stopped
         *        The test's stop time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopped(Instant stopped);

        /**
         * <p>
         * The test's result counters.
         * </p>
         * 
         * @param counters
         *        The test's result counters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder counters(Counters counters);

        /**
         * <p>
         * The test's result counters.
         * </p>
         * This is a convenience that creates an instance of the {@link Counters.Builder} avoiding the need to create
         * one manually via {@link Counters#builder()}.
         *
         * When the {@link Consumer} completes, {@link Counters.Builder#build()} is called immediately and its result is
         * passed to {@link #counters(Counters)}.
         * 
         * @param counters
         *        a consumer that will call methods on {@link Counters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #counters(Counters)
         */
        default Builder counters(Consumer<Counters.Builder> counters) {
            return counters(Counters.builder().applyMutation(counters).build());
        }

        /**
         * <p>
         * A message about the test's result.
         * </p>
         * 
         * @param message
         *        A message about the test's result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * Represents the total (metered or unmetered) minutes used by the test.
         * </p>
         * 
         * @param deviceMinutes
         *        Represents the total (metered or unmetered) minutes used by the test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMinutes(DeviceMinutes deviceMinutes);

        /**
         * <p>
         * Represents the total (metered or unmetered) minutes used by the test.
         * </p>
         * This is a convenience that creates an instance of the {@link DeviceMinutes.Builder} avoiding the need to
         * create one manually via {@link DeviceMinutes#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceMinutes.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceMinutes(DeviceMinutes)}.
         * 
         * @param deviceMinutes
         *        a consumer that will call methods on {@link DeviceMinutes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceMinutes(DeviceMinutes)
         */
        default Builder deviceMinutes(Consumer<DeviceMinutes.Builder> deviceMinutes) {
            return deviceMinutes(DeviceMinutes.builder().applyMutation(deviceMinutes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private Instant created;

        private String status;

        private String result;

        private Instant started;

        private Instant stopped;

        private Counters counters;

        private String message;

        private DeviceMinutes deviceMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(Test model) {
            arn(model.arn);
            name(model.name);
            type(model.type);
            created(model.created);
            status(model.status);
            result(model.result);
            started(model.started);
            stopped(model.stopped);
            counters(model.counters);
            message(model.message);
            deviceMinutes(model.deviceMinutes);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getCreated() {
            return created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getResultAsString() {
            return result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final Instant getStarted() {
            return started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        public final Instant getStopped() {
            return stopped;
        }

        @Override
        public final Builder stopped(Instant stopped) {
            this.stopped = stopped;
            return this;
        }

        public final void setStopped(Instant stopped) {
            this.stopped = stopped;
        }

        public final Counters.Builder getCounters() {
            return counters != null ? counters.toBuilder() : null;
        }

        @Override
        public final Builder counters(Counters counters) {
            this.counters = counters;
            return this;
        }

        public final void setCounters(Counters.BuilderImpl counters) {
            this.counters = counters != null ? counters.build() : null;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final DeviceMinutes.Builder getDeviceMinutes() {
            return deviceMinutes != null ? deviceMinutes.toBuilder() : null;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        public final void setDeviceMinutes(DeviceMinutes.BuilderImpl deviceMinutes) {
            this.deviceMinutes = deviceMinutes != null ? deviceMinutes.build() : null;
        }

        @Override
        public Test build() {
            return new Test(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
