/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum TestType {
    BUILTIN_FUZZ("BUILTIN_FUZZ"),

    BUILTIN_EXPLORER("BUILTIN_EXPLORER"),

    WEB_PERFORMANCE_PROFILE("WEB_PERFORMANCE_PROFILE"),

    APPIUM_JAVA_JUNIT("APPIUM_JAVA_JUNIT"),

    APPIUM_JAVA_TESTNG("APPIUM_JAVA_TESTNG"),

    APPIUM_PYTHON("APPIUM_PYTHON"),

    APPIUM_NODE("APPIUM_NODE"),

    APPIUM_RUBY("APPIUM_RUBY"),

    APPIUM_WEB_JAVA_JUNIT("APPIUM_WEB_JAVA_JUNIT"),

    APPIUM_WEB_JAVA_TESTNG("APPIUM_WEB_JAVA_TESTNG"),

    APPIUM_WEB_PYTHON("APPIUM_WEB_PYTHON"),

    APPIUM_WEB_NODE("APPIUM_WEB_NODE"),

    APPIUM_WEB_RUBY("APPIUM_WEB_RUBY"),

    CALABASH("CALABASH"),

    INSTRUMENTATION("INSTRUMENTATION"),

    UIAUTOMATION("UIAUTOMATION"),

    UIAUTOMATOR("UIAUTOMATOR"),

    XCTEST("XCTEST"),

    XCTEST_UI("XCTEST_UI"),

    REMOTE_ACCESS_RECORD("REMOTE_ACCESS_RECORD"),

    REMOTE_ACCESS_REPLAY("REMOTE_ACCESS_REPLAY"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TestType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return TestType corresponding to the value
     */
    public static TestType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TestType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link TestType}s
     */
    public static Set<TestType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
