/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the result of a get run request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRunResponse extends DeviceFarmResponse implements ToCopyableBuilder<GetRunResponse.Builder, GetRunResponse> {
    private static final SdkField<Run> RUN_FIELD = SdkField.<Run> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetRunResponse::run)).setter(setter(Builder::run)).constructor(Run::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("run").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_FIELD));

    private final Run run;

    private GetRunResponse(BuilderImpl builder) {
        super(builder);
        this.run = builder.run;
    }

    /**
     * <p>
     * The run you wish to get results from.
     * </p>
     * 
     * @return The run you wish to get results from.
     */
    public Run run() {
        return run;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(run());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRunResponse)) {
            return false;
        }
        GetRunResponse other = (GetRunResponse) obj;
        return Objects.equals(run(), other.run());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetRunResponse").add("Run", run()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "run":
            return Optional.ofNullable(clazz.cast(run()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRunResponse, T> g) {
        return obj -> g.apply((GetRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRunResponse> {
        /**
         * <p>
         * The run you wish to get results from.
         * </p>
         * 
         * @param run
         *        The run you wish to get results from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder run(Run run);

        /**
         * <p>
         * The run you wish to get results from.
         * </p>
         * This is a convenience that creates an instance of the {@link Run.Builder} avoiding the need to create one
         * manually via {@link Run#builder()}.
         *
         * When the {@link Consumer} completes, {@link Run.Builder#build()} is called immediately and its result is
         * passed to {@link #run(Run)}.
         * 
         * @param run
         *        a consumer that will call methods on {@link Run.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #run(Run)
         */
        default Builder run(Consumer<Run.Builder> run) {
            return run(Run.builder().applyMutation(run).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private Run run;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRunResponse model) {
            super(model);
            run(model.run);
        }

        public final Run.Builder getRun() {
            return run != null ? run.toBuilder() : null;
        }

        @Override
        public final Builder run(Run run) {
            this.run = run;
            return this;
        }

        public final void setRun(Run.BuilderImpl run) {
            this.run = run != null ? run.build() : null;
        }

        @Override
        public GetRunResponse build() {
            return new GetRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
