/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DirectConnectGateway
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DirectConnectGateway> {
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directConnectGatewayId").getter(DirectConnectGateway.getter(DirectConnectGateway::directConnectGatewayId)).setter(DirectConnectGateway.setter(Builder::directConnectGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build()}).build();
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directConnectGatewayName").getter(DirectConnectGateway.getter(DirectConnectGateway::directConnectGatewayName)).setter(DirectConnectGateway.setter(Builder::directConnectGatewayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayName").build()}).build();
    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("amazonSideAsn").getter(DirectConnectGateway.getter(DirectConnectGateway::amazonSideAsn)).setter(DirectConnectGateway.setter(Builder::amazonSideAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonSideAsn").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccount").getter(DirectConnectGateway.getter(DirectConnectGateway::ownerAccount)).setter(DirectConnectGateway.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()}).build();
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directConnectGatewayState").getter(DirectConnectGateway.getter(DirectConnectGateway::directConnectGatewayStateAsString)).setter(DirectConnectGateway.setter(Builder::directConnectGatewayState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayState").build()}).build();
    private static final SdkField<String> STATE_CHANGE_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateChangeError").getter(DirectConnectGateway.getter(DirectConnectGateway::stateChangeError)).setter(DirectConnectGateway.setter(Builder::stateChangeError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateChangeError").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECT_CONNECT_GATEWAY_ID_FIELD, DIRECT_CONNECT_GATEWAY_NAME_FIELD, AMAZON_SIDE_ASN_FIELD, OWNER_ACCOUNT_FIELD, DIRECT_CONNECT_GATEWAY_STATE_FIELD, STATE_CHANGE_ERROR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String directConnectGatewayId;
    private final String directConnectGatewayName;
    private final Long amazonSideAsn;
    private final String ownerAccount;
    private final String directConnectGatewayState;
    private final String stateChangeError;

    private DirectConnectGateway(BuilderImpl builder) {
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.directConnectGatewayName = builder.directConnectGatewayName;
        this.amazonSideAsn = builder.amazonSideAsn;
        this.ownerAccount = builder.ownerAccount;
        this.directConnectGatewayState = builder.directConnectGatewayState;
        this.stateChangeError = builder.stateChangeError;
    }

    public String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public String directConnectGatewayName() {
        return this.directConnectGatewayName;
    }

    public Long amazonSideAsn() {
        return this.amazonSideAsn;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public DirectConnectGatewayState directConnectGatewayState() {
        return DirectConnectGatewayState.fromValue(this.directConnectGatewayState);
    }

    public String directConnectGatewayStateAsString() {
        return this.directConnectGatewayState;
    }

    public String stateChangeError() {
        return this.stateChangeError;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeError());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectConnectGateway)) {
            return false;
        }
        DirectConnectGateway other = (DirectConnectGateway)obj;
        return Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && Objects.equals(this.directConnectGatewayName(), other.directConnectGatewayName()) && Objects.equals(this.amazonSideAsn(), other.amazonSideAsn()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.directConnectGatewayStateAsString(), other.directConnectGatewayStateAsString()) && Objects.equals(this.stateChangeError(), other.stateChangeError());
    }

    public String toString() {
        return ToString.builder((String)"DirectConnectGateway").add("DirectConnectGatewayId", (Object)this.directConnectGatewayId()).add("DirectConnectGatewayName", (Object)this.directConnectGatewayName()).add("AmazonSideAsn", (Object)this.amazonSideAsn()).add("OwnerAccount", (Object)this.ownerAccount()).add("DirectConnectGatewayState", (Object)this.directConnectGatewayStateAsString()).add("StateChangeError", (Object)this.stateChangeError()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayId": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayId()));
            }
            case "directConnectGatewayName": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayName()));
            }
            case "amazonSideAsn": {
                return Optional.ofNullable(clazz.cast(this.amazonSideAsn()));
            }
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "directConnectGatewayState": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayStateAsString()));
            }
            case "stateChangeError": {
                return Optional.ofNullable(clazz.cast(this.stateChangeError()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectConnectGateway, T> g) {
        return obj -> g.apply((DirectConnectGateway)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directConnectGatewayId;
        private String directConnectGatewayName;
        private Long amazonSideAsn;
        private String ownerAccount;
        private String directConnectGatewayState;
        private String stateChangeError;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectConnectGateway model) {
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.directConnectGatewayName(model.directConnectGatewayName);
            this.amazonSideAsn(model.amazonSideAsn);
            this.ownerAccount(model.ownerAccount);
            this.directConnectGatewayState(model.directConnectGatewayState);
            this.stateChangeError(model.stateChangeError);
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        public final String getDirectConnectGatewayName() {
            return this.directConnectGatewayName;
        }

        @Override
        public final Builder directConnectGatewayName(String directConnectGatewayName) {
            this.directConnectGatewayName = directConnectGatewayName;
            return this;
        }

        public final void setDirectConnectGatewayName(String directConnectGatewayName) {
            this.directConnectGatewayName = directConnectGatewayName;
        }

        public final Long getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final String getDirectConnectGatewayState() {
            return this.directConnectGatewayState;
        }

        @Override
        public final Builder directConnectGatewayState(String directConnectGatewayState) {
            this.directConnectGatewayState = directConnectGatewayState;
            return this;
        }

        @Override
        public final Builder directConnectGatewayState(DirectConnectGatewayState directConnectGatewayState) {
            this.directConnectGatewayState(directConnectGatewayState == null ? null : directConnectGatewayState.toString());
            return this;
        }

        public final void setDirectConnectGatewayState(String directConnectGatewayState) {
            this.directConnectGatewayState = directConnectGatewayState;
        }

        public final String getStateChangeError() {
            return this.stateChangeError;
        }

        @Override
        public final Builder stateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
            return this;
        }

        public final void setStateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
        }

        public DirectConnectGateway build() {
            return new DirectConnectGateway(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DirectConnectGateway> {
        public Builder directConnectGatewayId(String var1);

        public Builder directConnectGatewayName(String var1);

        public Builder amazonSideAsn(Long var1);

        public Builder ownerAccount(String var1);

        public Builder directConnectGatewayState(String var1);

        public Builder directConnectGatewayState(DirectConnectGatewayState var1);

        public Builder stateChangeError(String var1);
    }
}

