/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an AWS Direct Connect connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateHostedConnectionResponse extends DirectConnectResponse implements
        ToCopyableBuilder<AssociateHostedConnectionResponse.Builder, AssociateHostedConnectionResponse> {
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerAccount").getter(getter(AssociateHostedConnectionResponse::ownerAccount))
            .setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()).build();

    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionId").getter(getter(AssociateHostedConnectionResponse::connectionId))
            .setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionName").getter(getter(AssociateHostedConnectionResponse::connectionName))
            .setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionName").build()).build();

    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionState").getter(getter(AssociateHostedConnectionResponse::connectionStateAsString))
            .setter(setter(Builder::connectionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionState").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(AssociateHostedConnectionResponse::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(AssociateHostedConnectionResponse::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> BANDWIDTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bandwidth").getter(getter(AssociateHostedConnectionResponse::bandwidth))
            .setter(setter(Builder::bandwidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidth").build()).build();

    private static final SdkField<Integer> VLAN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("vlan")
            .getter(getter(AssociateHostedConnectionResponse::vlan)).setter(setter(Builder::vlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlan").build()).build();

    private static final SdkField<String> PARTNER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("partnerName").getter(getter(AssociateHostedConnectionResponse::partnerName))
            .setter(setter(Builder::partnerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnerName").build()).build();

    private static final SdkField<Instant> LOA_ISSUE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("loaIssueTime").getter(getter(AssociateHostedConnectionResponse::loaIssueTime))
            .setter(setter(Builder::loaIssueTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loaIssueTime").build()).build();

    private static final SdkField<String> LAG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("lagId")
            .getter(getter(AssociateHostedConnectionResponse::lagId)).setter(setter(Builder::lagId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagId").build()).build();

    private static final SdkField<String> AWS_DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsDevice").getter(getter(AssociateHostedConnectionResponse::awsDevice))
            .setter(setter(Builder::awsDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDevice").build()).build();

    private static final SdkField<Boolean> JUMBO_FRAME_CAPABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("jumboFrameCapable").getter(getter(AssociateHostedConnectionResponse::jumboFrameCapable))
            .setter(setter(Builder::jumboFrameCapable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jumboFrameCapable").build()).build();

    private static final SdkField<String> AWS_DEVICE_V2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsDeviceV2").getter(getter(AssociateHostedConnectionResponse::awsDeviceV2))
            .setter(setter(Builder::awsDeviceV2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDeviceV2").build()).build();

    private static final SdkField<String> HAS_LOGICAL_REDUNDANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hasLogicalRedundancy").getter(getter(AssociateHostedConnectionResponse::hasLogicalRedundancyAsString))
            .setter(setter(Builder::hasLogicalRedundancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasLogicalRedundancy").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(AssociateHostedConnectionResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerName").getter(getter(AssociateHostedConnectionResponse::providerName))
            .setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()).build();

    private static final SdkField<Boolean> MAC_SEC_CAPABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("macSecCapable").getter(getter(AssociateHostedConnectionResponse::macSecCapable))
            .setter(setter(Builder::macSecCapable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macSecCapable").build()).build();

    private static final SdkField<String> PORT_ENCRYPTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portEncryptionStatus").getter(getter(AssociateHostedConnectionResponse::portEncryptionStatus))
            .setter(setter(Builder::portEncryptionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portEncryptionStatus").build())
            .build();

    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionMode").getter(getter(AssociateHostedConnectionResponse::encryptionMode))
            .setter(setter(Builder::encryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionMode").build()).build();

    private static final SdkField<List<MacSecKey>> MAC_SEC_KEYS_FIELD = SdkField
            .<List<MacSecKey>> builder(MarshallingType.LIST)
            .memberName("macSecKeys")
            .getter(getter(AssociateHostedConnectionResponse::macSecKeys))
            .setter(setter(Builder::macSecKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macSecKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MacSecKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(MacSecKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ACCOUNT_FIELD,
            CONNECTION_ID_FIELD, CONNECTION_NAME_FIELD, CONNECTION_STATE_FIELD, REGION_FIELD, LOCATION_FIELD, BANDWIDTH_FIELD,
            VLAN_FIELD, PARTNER_NAME_FIELD, LOA_ISSUE_TIME_FIELD, LAG_ID_FIELD, AWS_DEVICE_FIELD, JUMBO_FRAME_CAPABLE_FIELD,
            AWS_DEVICE_V2_FIELD, HAS_LOGICAL_REDUNDANCY_FIELD, TAGS_FIELD, PROVIDER_NAME_FIELD, MAC_SEC_CAPABLE_FIELD,
            PORT_ENCRYPTION_STATUS_FIELD, ENCRYPTION_MODE_FIELD, MAC_SEC_KEYS_FIELD));

    private final String ownerAccount;

    private final String connectionId;

    private final String connectionName;

    private final String connectionState;

    private final String region;

    private final String location;

    private final String bandwidth;

    private final Integer vlan;

    private final String partnerName;

    private final Instant loaIssueTime;

    private final String lagId;

    private final String awsDevice;

    private final Boolean jumboFrameCapable;

    private final String awsDeviceV2;

    private final String hasLogicalRedundancy;

    private final List<Tag> tags;

    private final String providerName;

    private final Boolean macSecCapable;

    private final String portEncryptionStatus;

    private final String encryptionMode;

    private final List<MacSecKey> macSecKeys;

    private AssociateHostedConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.ownerAccount = builder.ownerAccount;
        this.connectionId = builder.connectionId;
        this.connectionName = builder.connectionName;
        this.connectionState = builder.connectionState;
        this.region = builder.region;
        this.location = builder.location;
        this.bandwidth = builder.bandwidth;
        this.vlan = builder.vlan;
        this.partnerName = builder.partnerName;
        this.loaIssueTime = builder.loaIssueTime;
        this.lagId = builder.lagId;
        this.awsDevice = builder.awsDevice;
        this.jumboFrameCapable = builder.jumboFrameCapable;
        this.awsDeviceV2 = builder.awsDeviceV2;
        this.hasLogicalRedundancy = builder.hasLogicalRedundancy;
        this.tags = builder.tags;
        this.providerName = builder.providerName;
        this.macSecCapable = builder.macSecCapable;
        this.portEncryptionStatus = builder.portEncryptionStatus;
        this.encryptionMode = builder.encryptionMode;
        this.macSecKeys = builder.macSecKeys;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the connection.
     * </p>
     * 
     * @return The ID of the AWS account that owns the connection.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * The ID of the connection.
     * </p>
     * 
     * @return The ID of the connection.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The name of the connection.
     * </p>
     * 
     * @return The name of the connection.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * <p>
     * The state of the connection. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection
     * stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state
     * until the Letter of Authorization (LOA) is sent to the customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: The connection has been approved and is being initialized.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code>: The network link is up and the connection is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>down</code>: The network link is down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: The connection is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: The connection has been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code>
     * state if it is deleted by the customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown</code>: The state of the connection is not available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link ConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The state of the connection. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The
     *         connection stays in the ordering state until the owner of the hosted connection confirms or declines the
     *         connection order.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requested</code>: The initial state of a standard connection. The connection stays in the requested
     *         state until the Letter of Authorization (LOA) is sent to the customer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: The connection has been approved and is being initialized.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code>: The network link is up and the connection is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>down</code>: The network link is down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: The connection is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: The connection has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the
     *         <code>rejected</code> state if it is deleted by the customer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown</code>: The state of the connection is not available.
     *         </p>
     *         </li>
     * @see ConnectionState
     */
    public final ConnectionState connectionState() {
        return ConnectionState.fromValue(connectionState);
    }

    /**
     * <p>
     * The state of the connection. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The connection
     * stays in the ordering state until the owner of the hosted connection confirms or declines the connection order.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requested</code>: The initial state of a standard connection. The connection stays in the requested state
     * until the Letter of Authorization (LOA) is sent to the customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: The connection has been approved and is being initialized.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code>: The network link is up and the connection is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>down</code>: The network link is down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: The connection is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: The connection has been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the <code>rejected</code>
     * state if it is deleted by the customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown</code>: The state of the connection is not available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link ConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The state of the connection. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The
     *         connection stays in the ordering state until the owner of the hosted connection confirms or declines the
     *         connection order.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requested</code>: The initial state of a standard connection. The connection stays in the requested
     *         state until the Letter of Authorization (LOA) is sent to the customer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: The connection has been approved and is being initialized.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code>: The network link is up and the connection is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>down</code>: The network link is down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: The connection is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: The connection has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the
     *         <code>rejected</code> state if it is deleted by the customer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown</code>: The state of the connection is not available.
     *         </p>
     *         </li>
     * @see ConnectionState
     */
    public final String connectionStateAsString() {
        return connectionState;
    }

    /**
     * <p>
     * The AWS Region where the connection is located.
     * </p>
     * 
     * @return The AWS Region where the connection is located.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The location of the connection.
     * </p>
     * 
     * @return The location of the connection.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The bandwidth of the connection.
     * </p>
     * 
     * @return The bandwidth of the connection.
     */
    public final String bandwidth() {
        return bandwidth;
    }

    /**
     * <p>
     * The ID of the VLAN.
     * </p>
     * 
     * @return The ID of the VLAN.
     */
    public final Integer vlan() {
        return vlan;
    }

    /**
     * <p>
     * The name of the AWS Direct Connect service provider associated with the connection.
     * </p>
     * 
     * @return The name of the AWS Direct Connect service provider associated with the connection.
     */
    public final String partnerName() {
        return partnerName;
    }

    /**
     * <p>
     * The time of the most recent call to <a>DescribeLoa</a> for this connection.
     * </p>
     * 
     * @return The time of the most recent call to <a>DescribeLoa</a> for this connection.
     */
    public final Instant loaIssueTime() {
        return loaIssueTime;
    }

    /**
     * <p>
     * The ID of the LAG.
     * </p>
     * 
     * @return The ID of the LAG.
     */
    public final String lagId() {
        return lagId;
    }

    /**
     * <p>
     * The Direct Connect endpoint on which the physical connection terminates.
     * </p>
     * 
     * @return The Direct Connect endpoint on which the physical connection terminates.
     */
    public final String awsDevice() {
        return awsDevice;
    }

    /**
     * <p>
     * Indicates whether jumbo frames (9001 MTU) are supported.
     * </p>
     * 
     * @return Indicates whether jumbo frames (9001 MTU) are supported.
     */
    public final Boolean jumboFrameCapable() {
        return jumboFrameCapable;
    }

    /**
     * <p>
     * The Direct Connect endpoint on which the physical connection terminates.
     * </p>
     * 
     * @return The Direct Connect endpoint on which the physical connection terminates.
     */
    public final String awsDeviceV2() {
        return awsDeviceV2;
    }

    /**
     * <p>
     * Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hasLogicalRedundancy} will return {@link HasLogicalRedundancy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #hasLogicalRedundancyAsString}.
     * </p>
     * 
     * @return Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
     * @see HasLogicalRedundancy
     */
    public final HasLogicalRedundancy hasLogicalRedundancy() {
        return HasLogicalRedundancy.fromValue(hasLogicalRedundancy);
    }

    /**
     * <p>
     * Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hasLogicalRedundancy} will return {@link HasLogicalRedundancy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #hasLogicalRedundancyAsString}.
     * </p>
     * 
     * @return Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
     * @see HasLogicalRedundancy
     */
    public final String hasLogicalRedundancyAsString() {
        return hasLogicalRedundancy;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags associated with the connection.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the service provider associated with the connection.
     * </p>
     * 
     * @return The name of the service provider associated with the connection.
     */
    public final String providerName() {
        return providerName;
    }

    /**
     * <p>
     * Indicates whether the connection supports MAC Security (MACsec).
     * </p>
     * 
     * @return Indicates whether the connection supports MAC Security (MACsec).
     */
    public final Boolean macSecCapable() {
        return macSecCapable;
    }

    /**
     * <p>
     * The MAC Security (MACsec) port link status of the connection.
     * </p>
     * <p>
     * The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or
     * <code>Encryption Down</code>.
     * </p>
     * 
     * @return The MAC Security (MACsec) port link status of the connection.</p>
     *         <p>
     *         The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name,
     *         or <code>Encryption Down</code>.
     */
    public final String portEncryptionStatus() {
        return portEncryptionStatus;
    }

    /**
     * <p>
     * The MAC Security (MACsec) connection encryption mode.
     * </p>
     * <p>
     * The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.
     * </p>
     * 
     * @return The MAC Security (MACsec) connection encryption mode.</p>
     *         <p>
     *         The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.
     */
    public final String encryptionMode() {
        return encryptionMode;
    }

    /**
     * Returns true if the MacSecKeys property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMacSecKeys() {
        return macSecKeys != null && !(macSecKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The MAC Security (MACsec) security keys associated with the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMacSecKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The MAC Security (MACsec) security keys associated with the connection.
     */
    public final List<MacSecKey> macSecKeys() {
        return macSecKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(vlan());
        hashCode = 31 * hashCode + Objects.hashCode(partnerName());
        hashCode = 31 * hashCode + Objects.hashCode(loaIssueTime());
        hashCode = 31 * hashCode + Objects.hashCode(lagId());
        hashCode = 31 * hashCode + Objects.hashCode(awsDevice());
        hashCode = 31 * hashCode + Objects.hashCode(jumboFrameCapable());
        hashCode = 31 * hashCode + Objects.hashCode(awsDeviceV2());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogicalRedundancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(macSecCapable());
        hashCode = 31 * hashCode + Objects.hashCode(portEncryptionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionMode());
        hashCode = 31 * hashCode + Objects.hashCode(hasMacSecKeys() ? macSecKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateHostedConnectionResponse)) {
            return false;
        }
        AssociateHostedConnectionResponse other = (AssociateHostedConnectionResponse) obj;
        return Objects.equals(ownerAccount(), other.ownerAccount()) && Objects.equals(connectionId(), other.connectionId())
                && Objects.equals(connectionName(), other.connectionName())
                && Objects.equals(connectionStateAsString(), other.connectionStateAsString())
                && Objects.equals(region(), other.region()) && Objects.equals(location(), other.location())
                && Objects.equals(bandwidth(), other.bandwidth()) && Objects.equals(vlan(), other.vlan())
                && Objects.equals(partnerName(), other.partnerName()) && Objects.equals(loaIssueTime(), other.loaIssueTime())
                && Objects.equals(lagId(), other.lagId()) && Objects.equals(awsDevice(), other.awsDevice())
                && Objects.equals(jumboFrameCapable(), other.jumboFrameCapable())
                && Objects.equals(awsDeviceV2(), other.awsDeviceV2())
                && Objects.equals(hasLogicalRedundancyAsString(), other.hasLogicalRedundancyAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(providerName(), other.providerName()) && Objects.equals(macSecCapable(), other.macSecCapable())
                && Objects.equals(portEncryptionStatus(), other.portEncryptionStatus())
                && Objects.equals(encryptionMode(), other.encryptionMode()) && hasMacSecKeys() == other.hasMacSecKeys()
                && Objects.equals(macSecKeys(), other.macSecKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateHostedConnectionResponse").add("OwnerAccount", ownerAccount())
                .add("ConnectionId", connectionId()).add("ConnectionName", connectionName())
                .add("ConnectionState", connectionStateAsString()).add("Region", region()).add("Location", location())
                .add("Bandwidth", bandwidth()).add("Vlan", vlan()).add("PartnerName", partnerName())
                .add("LoaIssueTime", loaIssueTime()).add("LagId", lagId()).add("AwsDevice", awsDevice())
                .add("JumboFrameCapable", jumboFrameCapable()).add("AwsDeviceV2", awsDeviceV2())
                .add("HasLogicalRedundancy", hasLogicalRedundancyAsString()).add("Tags", hasTags() ? tags() : null)
                .add("ProviderName", providerName()).add("MacSecCapable", macSecCapable())
                .add("PortEncryptionStatus", portEncryptionStatus()).add("EncryptionMode", encryptionMode())
                .add("MacSecKeys", hasMacSecKeys() ? macSecKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ownerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "connectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "connectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "connectionState":
            return Optional.ofNullable(clazz.cast(connectionStateAsString()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "bandwidth":
            return Optional.ofNullable(clazz.cast(bandwidth()));
        case "vlan":
            return Optional.ofNullable(clazz.cast(vlan()));
        case "partnerName":
            return Optional.ofNullable(clazz.cast(partnerName()));
        case "loaIssueTime":
            return Optional.ofNullable(clazz.cast(loaIssueTime()));
        case "lagId":
            return Optional.ofNullable(clazz.cast(lagId()));
        case "awsDevice":
            return Optional.ofNullable(clazz.cast(awsDevice()));
        case "jumboFrameCapable":
            return Optional.ofNullable(clazz.cast(jumboFrameCapable()));
        case "awsDeviceV2":
            return Optional.ofNullable(clazz.cast(awsDeviceV2()));
        case "hasLogicalRedundancy":
            return Optional.ofNullable(clazz.cast(hasLogicalRedundancyAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "providerName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "macSecCapable":
            return Optional.ofNullable(clazz.cast(macSecCapable()));
        case "portEncryptionStatus":
            return Optional.ofNullable(clazz.cast(portEncryptionStatus()));
        case "encryptionMode":
            return Optional.ofNullable(clazz.cast(encryptionMode()));
        case "macSecKeys":
            return Optional.ofNullable(clazz.cast(macSecKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateHostedConnectionResponse, T> g) {
        return obj -> g.apply((AssociateHostedConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateHostedConnectionResponse> {
        /**
         * <p>
         * The ID of the AWS account that owns the connection.
         * </p>
         * 
         * @param ownerAccount
         *        The ID of the AWS account that owns the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * The ID of the connection.
         * </p>
         * 
         * @param connectionId
         *        The ID of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The name of the connection.
         * </p>
         * 
         * @param connectionName
         *        The name of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * The state of the connection. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The
         * connection stays in the ordering state until the owner of the hosted connection confirms or declines the
         * connection order.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requested</code>: The initial state of a standard connection. The connection stays in the requested
         * state until the Letter of Authorization (LOA) is sent to the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: The connection has been approved and is being initialized.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code>: The network link is up and the connection is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>down</code>: The network link is down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: The connection is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: The connection has been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the
         * <code>rejected</code> state if it is deleted by the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown</code>: The state of the connection is not available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param connectionState
         *        The state of the connection. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The
         *        connection stays in the ordering state until the owner of the hosted connection confirms or declines
         *        the connection order.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requested</code>: The initial state of a standard connection. The connection stays in the
         *        requested state until the Letter of Authorization (LOA) is sent to the customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: The connection has been approved and is being initialized.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code>: The network link is up and the connection is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>down</code>: The network link is down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: The connection is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: The connection has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the
         *        <code>rejected</code> state if it is deleted by the customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown</code>: The state of the connection is not available.
         *        </p>
         *        </li>
         * @see ConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionState
         */
        Builder connectionState(String connectionState);

        /**
         * <p>
         * The state of the connection. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The
         * connection stays in the ordering state until the owner of the hosted connection confirms or declines the
         * connection order.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requested</code>: The initial state of a standard connection. The connection stays in the requested
         * state until the Letter of Authorization (LOA) is sent to the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: The connection has been approved and is being initialized.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code>: The network link is up and the connection is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>down</code>: The network link is down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: The connection is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: The connection has been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the
         * <code>rejected</code> state if it is deleted by the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown</code>: The state of the connection is not available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param connectionState
         *        The state of the connection. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ordering</code>: The initial state of a hosted connection provisioned on an interconnect. The
         *        connection stays in the ordering state until the owner of the hosted connection confirms or declines
         *        the connection order.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requested</code>: The initial state of a standard connection. The connection stays in the
         *        requested state until the Letter of Authorization (LOA) is sent to the customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: The connection has been approved and is being initialized.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code>: The network link is up and the connection is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>down</code>: The network link is down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: The connection is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: The connection has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rejected</code>: A hosted connection in the <code>ordering</code> state enters the
         *        <code>rejected</code> state if it is deleted by the customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown</code>: The state of the connection is not available.
         *        </p>
         *        </li>
         * @see ConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionState
         */
        Builder connectionState(ConnectionState connectionState);

        /**
         * <p>
         * The AWS Region where the connection is located.
         * </p>
         * 
         * @param region
         *        The AWS Region where the connection is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The location of the connection.
         * </p>
         * 
         * @param location
         *        The location of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The bandwidth of the connection.
         * </p>
         * 
         * @param bandwidth
         *        The bandwidth of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandwidth(String bandwidth);

        /**
         * <p>
         * The ID of the VLAN.
         * </p>
         * 
         * @param vlan
         *        The ID of the VLAN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vlan(Integer vlan);

        /**
         * <p>
         * The name of the AWS Direct Connect service provider associated with the connection.
         * </p>
         * 
         * @param partnerName
         *        The name of the AWS Direct Connect service provider associated with the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerName(String partnerName);

        /**
         * <p>
         * The time of the most recent call to <a>DescribeLoa</a> for this connection.
         * </p>
         * 
         * @param loaIssueTime
         *        The time of the most recent call to <a>DescribeLoa</a> for this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loaIssueTime(Instant loaIssueTime);

        /**
         * <p>
         * The ID of the LAG.
         * </p>
         * 
         * @param lagId
         *        The ID of the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lagId(String lagId);

        /**
         * <p>
         * The Direct Connect endpoint on which the physical connection terminates.
         * </p>
         * 
         * @param awsDevice
         *        The Direct Connect endpoint on which the physical connection terminates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsDevice(String awsDevice);

        /**
         * <p>
         * Indicates whether jumbo frames (9001 MTU) are supported.
         * </p>
         * 
         * @param jumboFrameCapable
         *        Indicates whether jumbo frames (9001 MTU) are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jumboFrameCapable(Boolean jumboFrameCapable);

        /**
         * <p>
         * The Direct Connect endpoint on which the physical connection terminates.
         * </p>
         * 
         * @param awsDeviceV2
         *        The Direct Connect endpoint on which the physical connection terminates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsDeviceV2(String awsDeviceV2);

        /**
         * <p>
         * Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
         * </p>
         * 
         * @param hasLogicalRedundancy
         *        Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
         * @see HasLogicalRedundancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HasLogicalRedundancy
         */
        Builder hasLogicalRedundancy(String hasLogicalRedundancy);

        /**
         * <p>
         * Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
         * </p>
         * 
         * @param hasLogicalRedundancy
         *        Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
         * @see HasLogicalRedundancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HasLogicalRedundancy
         */
        Builder hasLogicalRedundancy(HasLogicalRedundancy hasLogicalRedundancy);

        /**
         * <p>
         * The tags associated with the connection.
         * </p>
         * 
         * @param tags
         *        The tags associated with the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the connection.
         * </p>
         * 
         * @param tags
         *        The tags associated with the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the connection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The name of the service provider associated with the connection.
         * </p>
         * 
         * @param providerName
         *        The name of the service provider associated with the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * Indicates whether the connection supports MAC Security (MACsec).
         * </p>
         * 
         * @param macSecCapable
         *        Indicates whether the connection supports MAC Security (MACsec).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macSecCapable(Boolean macSecCapable);

        /**
         * <p>
         * The MAC Security (MACsec) port link status of the connection.
         * </p>
         * <p>
         * The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key Name, or
         * <code>Encryption Down</code>.
         * </p>
         * 
         * @param portEncryptionStatus
         *        The MAC Security (MACsec) port link status of the connection.</p>
         *        <p>
         *        The valid values are <code>Encryption Up</code>, which means that there is an active Connection Key
         *        Name, or <code>Encryption Down</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portEncryptionStatus(String portEncryptionStatus);

        /**
         * <p>
         * The MAC Security (MACsec) connection encryption mode.
         * </p>
         * <p>
         * The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.
         * </p>
         * 
         * @param encryptionMode
         *        The MAC Security (MACsec) connection encryption mode.</p>
         *        <p>
         *        The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and
         *        <code>must_encrypt</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionMode(String encryptionMode);

        /**
         * <p>
         * The MAC Security (MACsec) security keys associated with the connection.
         * </p>
         * 
         * @param macSecKeys
         *        The MAC Security (MACsec) security keys associated with the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macSecKeys(Collection<MacSecKey> macSecKeys);

        /**
         * <p>
         * The MAC Security (MACsec) security keys associated with the connection.
         * </p>
         * 
         * @param macSecKeys
         *        The MAC Security (MACsec) security keys associated with the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macSecKeys(MacSecKey... macSecKeys);

        /**
         * <p>
         * The MAC Security (MACsec) security keys associated with the connection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MacSecKey>.Builder} avoiding the need to
         * create one manually via {@link List<MacSecKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MacSecKey>.Builder#build()} is called immediately and its
         * result is passed to {@link #macSecKeys(List<MacSecKey>)}.
         * 
         * @param macSecKeys
         *        a consumer that will call methods on {@link List<MacSecKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #macSecKeys(List<MacSecKey>)
         */
        Builder macSecKeys(Consumer<MacSecKey.Builder>... macSecKeys);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private String ownerAccount;

        private String connectionId;

        private String connectionName;

        private String connectionState;

        private String region;

        private String location;

        private String bandwidth;

        private Integer vlan;

        private String partnerName;

        private Instant loaIssueTime;

        private String lagId;

        private String awsDevice;

        private Boolean jumboFrameCapable;

        private String awsDeviceV2;

        private String hasLogicalRedundancy;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String providerName;

        private Boolean macSecCapable;

        private String portEncryptionStatus;

        private String encryptionMode;

        private List<MacSecKey> macSecKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateHostedConnectionResponse model) {
            super(model);
            ownerAccount(model.ownerAccount);
            connectionId(model.connectionId);
            connectionName(model.connectionName);
            connectionState(model.connectionState);
            region(model.region);
            location(model.location);
            bandwidth(model.bandwidth);
            vlan(model.vlan);
            partnerName(model.partnerName);
            loaIssueTime(model.loaIssueTime);
            lagId(model.lagId);
            awsDevice(model.awsDevice);
            jumboFrameCapable(model.jumboFrameCapable);
            awsDeviceV2(model.awsDeviceV2);
            hasLogicalRedundancy(model.hasLogicalRedundancy);
            tags(model.tags);
            providerName(model.providerName);
            macSecCapable(model.macSecCapable);
            portEncryptionStatus(model.portEncryptionStatus);
            encryptionMode(model.encryptionMode);
            macSecKeys(model.macSecKeys);
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final String getConnectionId() {
            return connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getConnectionName() {
            return connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        public final String getConnectionState() {
            return connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(ConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getBandwidth() {
            return bandwidth;
        }

        @Override
        public final Builder bandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        public final Integer getVlan() {
            return vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        public final String getPartnerName() {
            return partnerName;
        }

        @Override
        public final Builder partnerName(String partnerName) {
            this.partnerName = partnerName;
            return this;
        }

        public final void setPartnerName(String partnerName) {
            this.partnerName = partnerName;
        }

        public final Instant getLoaIssueTime() {
            return loaIssueTime;
        }

        @Override
        public final Builder loaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
            return this;
        }

        public final void setLoaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
        }

        public final String getLagId() {
            return lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        public final String getAwsDevice() {
            return awsDevice;
        }

        @Override
        public final Builder awsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
            return this;
        }

        public final void setAwsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
        }

        public final Boolean getJumboFrameCapable() {
            return jumboFrameCapable;
        }

        @Override
        public final Builder jumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
            return this;
        }

        public final void setJumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
        }

        public final String getAwsDeviceV2() {
            return awsDeviceV2;
        }

        @Override
        public final Builder awsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
            return this;
        }

        public final void setAwsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
        }

        public final String getHasLogicalRedundancy() {
            return hasLogicalRedundancy;
        }

        @Override
        public final Builder hasLogicalRedundancy(String hasLogicalRedundancy) {
            this.hasLogicalRedundancy = hasLogicalRedundancy;
            return this;
        }

        @Override
        public final Builder hasLogicalRedundancy(HasLogicalRedundancy hasLogicalRedundancy) {
            this.hasLogicalRedundancy(hasLogicalRedundancy == null ? null : hasLogicalRedundancy.toString());
            return this;
        }

        public final void setHasLogicalRedundancy(String hasLogicalRedundancy) {
            this.hasLogicalRedundancy = hasLogicalRedundancy;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getProviderName() {
            return providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final Boolean getMacSecCapable() {
            return macSecCapable;
        }

        @Override
        public final Builder macSecCapable(Boolean macSecCapable) {
            this.macSecCapable = macSecCapable;
            return this;
        }

        public final void setMacSecCapable(Boolean macSecCapable) {
            this.macSecCapable = macSecCapable;
        }

        public final String getPortEncryptionStatus() {
            return portEncryptionStatus;
        }

        @Override
        public final Builder portEncryptionStatus(String portEncryptionStatus) {
            this.portEncryptionStatus = portEncryptionStatus;
            return this;
        }

        public final void setPortEncryptionStatus(String portEncryptionStatus) {
            this.portEncryptionStatus = portEncryptionStatus;
        }

        public final String getEncryptionMode() {
            return encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        public final List<MacSecKey.Builder> getMacSecKeys() {
            List<MacSecKey.Builder> result = MacSecKeyListCopier.copyToBuilder(this.macSecKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder macSecKeys(Collection<MacSecKey> macSecKeys) {
            this.macSecKeys = MacSecKeyListCopier.copy(macSecKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macSecKeys(MacSecKey... macSecKeys) {
            macSecKeys(Arrays.asList(macSecKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macSecKeys(Consumer<MacSecKey.Builder>... macSecKeys) {
            macSecKeys(Stream.of(macSecKeys).map(c -> MacSecKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMacSecKeys(Collection<MacSecKey.BuilderImpl> macSecKeys) {
            this.macSecKeys = MacSecKeyListCopier.copyFromBuilder(macSecKeys);
        }

        @Override
        public AssociateHostedConnectionResponse build() {
            return new AssociateHostedConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
