/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLagRequest extends DirectConnectRequest implements
        ToCopyableBuilder<UpdateLagRequest.Builder, UpdateLagRequest> {
    private static final SdkField<String> LAG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("lagId")
            .getter(getter(UpdateLagRequest::lagId)).setter(setter(Builder::lagId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagId").build()).build();

    private static final SdkField<String> LAG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lagName").getter(getter(UpdateLagRequest::lagName)).setter(setter(Builder::lagName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagName").build()).build();

    private static final SdkField<Integer> MINIMUM_LINKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minimumLinks").getter(getter(UpdateLagRequest::minimumLinks)).setter(setter(Builder::minimumLinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLinks").build()).build();

    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionMode").getter(getter(UpdateLagRequest::encryptionMode))
            .setter(setter(Builder::encryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAG_ID_FIELD, LAG_NAME_FIELD,
            MINIMUM_LINKS_FIELD, ENCRYPTION_MODE_FIELD));

    private final String lagId;

    private final String lagName;

    private final Integer minimumLinks;

    private final String encryptionMode;

    private UpdateLagRequest(BuilderImpl builder) {
        super(builder);
        this.lagId = builder.lagId;
        this.lagName = builder.lagName;
        this.minimumLinks = builder.minimumLinks;
        this.encryptionMode = builder.encryptionMode;
    }

    /**
     * <p>
     * The ID of the LAG.
     * </p>
     * 
     * @return The ID of the LAG.
     */
    public final String lagId() {
        return lagId;
    }

    /**
     * <p>
     * The name of the LAG.
     * </p>
     * 
     * @return The name of the LAG.
     */
    public final String lagName() {
        return lagName;
    }

    /**
     * <p>
     * The minimum number of physical connections that must be operational for the LAG itself to be operational.
     * </p>
     * 
     * @return The minimum number of physical connections that must be operational for the LAG itself to be operational.
     */
    public final Integer minimumLinks() {
        return minimumLinks;
    }

    /**
     * <p>
     * The LAG MAC Security (MACsec) encryption mode.
     * </p>
     * <p>
     * AWS applies the value to all connections which are part of the LAG.
     * </p>
     * 
     * @return The LAG MAC Security (MACsec) encryption mode.</p>
     *         <p>
     *         AWS applies the value to all connections which are part of the LAG.
     */
    public final String encryptionMode() {
        return encryptionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lagId());
        hashCode = 31 * hashCode + Objects.hashCode(lagName());
        hashCode = 31 * hashCode + Objects.hashCode(minimumLinks());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLagRequest)) {
            return false;
        }
        UpdateLagRequest other = (UpdateLagRequest) obj;
        return Objects.equals(lagId(), other.lagId()) && Objects.equals(lagName(), other.lagName())
                && Objects.equals(minimumLinks(), other.minimumLinks())
                && Objects.equals(encryptionMode(), other.encryptionMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLagRequest").add("LagId", lagId()).add("LagName", lagName())
                .add("MinimumLinks", minimumLinks()).add("EncryptionMode", encryptionMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lagId":
            return Optional.ofNullable(clazz.cast(lagId()));
        case "lagName":
            return Optional.ofNullable(clazz.cast(lagName()));
        case "minimumLinks":
            return Optional.ofNullable(clazz.cast(minimumLinks()));
        case "encryptionMode":
            return Optional.ofNullable(clazz.cast(encryptionMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLagRequest, T> g) {
        return obj -> g.apply((UpdateLagRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLagRequest> {
        /**
         * <p>
         * The ID of the LAG.
         * </p>
         * 
         * @param lagId
         *        The ID of the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lagId(String lagId);

        /**
         * <p>
         * The name of the LAG.
         * </p>
         * 
         * @param lagName
         *        The name of the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lagName(String lagName);

        /**
         * <p>
         * The minimum number of physical connections that must be operational for the LAG itself to be operational.
         * </p>
         * 
         * @param minimumLinks
         *        The minimum number of physical connections that must be operational for the LAG itself to be
         *        operational.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumLinks(Integer minimumLinks);

        /**
         * <p>
         * The LAG MAC Security (MACsec) encryption mode.
         * </p>
         * <p>
         * AWS applies the value to all connections which are part of the LAG.
         * </p>
         * 
         * @param encryptionMode
         *        The LAG MAC Security (MACsec) encryption mode.</p>
         *        <p>
         *        AWS applies the value to all connections which are part of the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionMode(String encryptionMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String lagId;

        private String lagName;

        private Integer minimumLinks;

        private String encryptionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLagRequest model) {
            super(model);
            lagId(model.lagId);
            lagName(model.lagName);
            minimumLinks(model.minimumLinks);
            encryptionMode(model.encryptionMode);
        }

        public final String getLagId() {
            return lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        public final String getLagName() {
            return lagName;
        }

        @Override
        public final Builder lagName(String lagName) {
            this.lagName = lagName;
            return this;
        }

        public final void setLagName(String lagName) {
            this.lagName = lagName;
        }

        public final Integer getMinimumLinks() {
            return minimumLinks;
        }

        @Override
        public final Builder minimumLinks(Integer minimumLinks) {
            this.minimumLinks = minimumLinks;
            return this;
        }

        public final void setMinimumLinks(Integer minimumLinks) {
            this.minimumLinks = minimumLinks;
        }

        public final String getEncryptionMode() {
            return encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLagRequest build() {
            return new UpdateLagRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
