/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest;
import software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse;
import software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest;
import software.amazon.awssdk.services.directconnect.model.CreateBgpPeerResponse;
import software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.CreateConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationResponse;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse;
import software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest;
import software.amazon.awssdk.services.directconnect.model.CreateInterconnectResponse;
import software.amazon.awssdk.services.directconnect.model.CreateLagRequest;
import software.amazon.awssdk.services.directconnect.model.CreateLagResponse;
import software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteLagRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteLagResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeLocationsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse;
import software.amazon.awssdk.services.directconnect.model.DirectConnectClientException;
import software.amazon.awssdk.services.directconnect.model.DirectConnectException;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.DirectConnectServerException;
import software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest;
import software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagResponse;
import software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyRequest;
import software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyResponse;
import software.amazon.awssdk.services.directconnect.model.DuplicateTagKeysException;
import software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest;
import software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse;
import software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest;
import software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestResponse;
import software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestRequest;
import software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestResponse;
import software.amazon.awssdk.services.directconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.directconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.directconnect.model.TooManyTagsException;
import software.amazon.awssdk.services.directconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.directconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateLagRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateLagResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesResponse;
import software.amazon.awssdk.services.directconnect.transform.AcceptDirectConnectGatewayAssociationProposalRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocateHostedConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocatePrivateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocatePublicVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocateTransitVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateConnectionWithLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateHostedConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateMacSecKeyRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmPrivateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmPublicVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmTransitVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateBgpPeerRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateDirectConnectGatewayAssociationProposalRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateDirectConnectGatewayAssociationRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateDirectConnectGatewayRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateInterconnectRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreatePrivateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreatePublicVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateTransitVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteBgpPeerRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteDirectConnectGatewayAssociationProposalRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteDirectConnectGatewayAssociationRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteDirectConnectGatewayRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteInterconnectRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeConnectionsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewayAssociationProposalsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewayAssociationsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewayAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewaysRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeHostedConnectionsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeInterconnectsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeLagsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeLoaRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeLocationsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeVirtualGatewaysRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeVirtualInterfacesRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DisassociateConnectionFromLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DisassociateMacSecKeyRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ListVirtualInterfaceTestHistoryRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.StartBgpFailoverTestRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.StopBgpFailoverTestRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateDirectConnectGatewayAssociationRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateVirtualInterfaceAttributesRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link DirectConnectClient}.
 *
 * @see DirectConnectClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultDirectConnectClient implements DirectConnectClient {
    private static final Logger log = Logger.loggerFor(DefaultDirectConnectClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDirectConnectClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Accepts a proposal request to attach a virtual private gateway or transit gateway to a Direct Connect gateway.
     * </p>
     *
     * @param acceptDirectConnectGatewayAssociationProposalRequest
     * @return Result of the AcceptDirectConnectGatewayAssociationProposal operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AcceptDirectConnectGatewayAssociationProposal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AcceptDirectConnectGatewayAssociationProposal"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AcceptDirectConnectGatewayAssociationProposalResponse acceptDirectConnectGatewayAssociationProposal(
            AcceptDirectConnectGatewayAssociationProposalRequest acceptDirectConnectGatewayAssociationProposalRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AcceptDirectConnectGatewayAssociationProposalResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, AcceptDirectConnectGatewayAssociationProposalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptDirectConnectGatewayAssociationProposalRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptDirectConnectGatewayAssociationProposal");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptDirectConnectGatewayAssociationProposalRequest, AcceptDirectConnectGatewayAssociationProposalResponse>()
                            .withOperationName("AcceptDirectConnectGatewayAssociationProposal")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(acceptDirectConnectGatewayAssociationProposalRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptDirectConnectGatewayAssociationProposalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects.
     * </p>
     * <p>
     * Allocates a VLAN number and a specified amount of capacity (bandwidth) for use by a hosted connection on the
     * specified interconnect or LAG of interconnects. Amazon Web Services polices the hosted connection for the
     * specified capacity and the Direct Connect Partner must also police the hosted connection for the specified
     * capacity.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note>
     *
     * @param allocateHostedConnectionRequest
     * @return Result of the AllocateHostedConnection operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AllocateHostedConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateHostedConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AllocateHostedConnectionResponse allocateHostedConnection(
            AllocateHostedConnectionRequest allocateHostedConnectionRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AllocateHostedConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AllocateHostedConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, allocateHostedConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllocateHostedConnection");

            return clientHandler
                    .execute(new ClientExecutionParams<AllocateHostedConnectionRequest, AllocateHostedConnectionResponse>()
                            .withOperationName("AllocateHostedConnection").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(allocateHostedConnectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AllocateHostedConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provisions a private virtual interface to be owned by the specified account.
     * </p>
     * <p>
     * Virtual interfaces created using this action must be confirmed by the owner using
     * <a>ConfirmPrivateVirtualInterface</a>. Until then, the virtual interface is in the <code>Confirming</code> state
     * and is not available to handle traffic.
     * </p>
     *
     * @param allocatePrivateVirtualInterfaceRequest
     * @return Result of the AllocatePrivateVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AllocatePrivateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePrivateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AllocatePrivateVirtualInterfaceResponse allocatePrivateVirtualInterface(
            AllocatePrivateVirtualInterfaceRequest allocatePrivateVirtualInterfaceRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AllocatePrivateVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AllocatePrivateVirtualInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                allocatePrivateVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllocatePrivateVirtualInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<AllocatePrivateVirtualInterfaceRequest, AllocatePrivateVirtualInterfaceResponse>()
                            .withOperationName("AllocatePrivateVirtualInterface").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(allocatePrivateVirtualInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AllocatePrivateVirtualInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provisions a public virtual interface to be owned by the specified account.
     * </p>
     * <p>
     * The owner of a connection calls this function to provision a public virtual interface to be owned by the
     * specified account.
     * </p>
     * <p>
     * Virtual interfaces created using this function must be confirmed by the owner using
     * <a>ConfirmPublicVirtualInterface</a>. Until this step has been completed, the virtual interface is in the
     * <code>confirming</code> state and is not available to handle traffic.
     * </p>
     * <p>
     * When creating an IPv6 public virtual interface, omit the Amazon address and customer address. IPv6 addresses are
     * automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     * </p>
     *
     * @param allocatePublicVirtualInterfaceRequest
     * @return Result of the AllocatePublicVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AllocatePublicVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePublicVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AllocatePublicVirtualInterfaceResponse allocatePublicVirtualInterface(
            AllocatePublicVirtualInterfaceRequest allocatePublicVirtualInterfaceRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AllocatePublicVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AllocatePublicVirtualInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                allocatePublicVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllocatePublicVirtualInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<AllocatePublicVirtualInterfaceRequest, AllocatePublicVirtualInterfaceResponse>()
                            .withOperationName("AllocatePublicVirtualInterface").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(allocatePublicVirtualInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AllocatePublicVirtualInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provisions a transit virtual interface to be owned by the specified account. Use this type of interface to
     * connect a transit gateway to your Direct Connect gateway.
     * </p>
     * <p>
     * The owner of a connection provisions a transit virtual interface to be owned by the specified account.
     * </p>
     * <p>
     * After you create a transit virtual interface, it must be confirmed by the owner using
     * <a>ConfirmTransitVirtualInterface</a>. Until this step has been completed, the transit virtual interface is in
     * the <code>requested</code> state and is not available to handle traffic.
     * </p>
     *
     * @param allocateTransitVirtualInterfaceRequest
     * @return Result of the AllocateTransitVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AllocateTransitVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateTransitVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AllocateTransitVirtualInterfaceResponse allocateTransitVirtualInterface(
            AllocateTransitVirtualInterfaceRequest allocateTransitVirtualInterfaceRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AllocateTransitVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AllocateTransitVirtualInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                allocateTransitVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllocateTransitVirtualInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<AllocateTransitVirtualInterfaceRequest, AllocateTransitVirtualInterfaceResponse>()
                            .withOperationName("AllocateTransitVirtualInterface").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(allocateTransitVirtualInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AllocateTransitVirtualInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates an existing connection with a link aggregation group (LAG). The connection is interrupted and
     * re-established as a member of the LAG (connectivity to Amazon Web Services is interrupted). The connection must
     * be hosted on the same Direct Connect endpoint as the LAG, and its bandwidth must match the bandwidth for the LAG.
     * You can re-associate a connection that's currently associated with a different LAG; however, if removing the
     * connection would cause the original LAG to fall below its setting for minimum number of operational connections,
     * the request fails.
     * </p>
     * <p>
     * Any virtual interfaces that are directly associated with the connection are automatically re-associated with the
     * LAG. If the connection was originally associated with a different LAG, the virtual interfaces remain associated
     * with the original LAG.
     * </p>
     * <p>
     * For interconnects, any hosted connections are automatically re-associated with the LAG. If the interconnect was
     * originally associated with a different LAG, the hosted connections remain associated with the original LAG.
     * </p>
     *
     * @param associateConnectionWithLagRequest
     * @return Result of the AssociateConnectionWithLag operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AssociateConnectionWithLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateConnectionWithLag"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateConnectionWithLagResponse associateConnectionWithLag(
            AssociateConnectionWithLagRequest associateConnectionWithLagRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateConnectionWithLagResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateConnectionWithLagResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateConnectionWithLagRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateConnectionWithLag");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateConnectionWithLagRequest, AssociateConnectionWithLagResponse>()
                            .withOperationName("AssociateConnectionWithLag").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateConnectionWithLagRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateConnectionWithLagRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a hosted connection and its virtual interfaces with a link aggregation group (LAG) or interconnect. If
     * the target interconnect or LAG has an existing hosted connection with a conflicting VLAN number or IP address,
     * the operation fails. This action temporarily interrupts the hosted connection's connectivity to Amazon Web
     * Services as it is being migrated.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note>
     *
     * @param associateHostedConnectionRequest
     * @return Result of the AssociateHostedConnection operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AssociateHostedConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateHostedConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateHostedConnectionResponse associateHostedConnection(
            AssociateHostedConnectionRequest associateHostedConnectionRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateHostedConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateHostedConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateHostedConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateHostedConnection");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateHostedConnectionRequest, AssociateHostedConnectionResponse>()
                            .withOperationName("AssociateHostedConnection").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateHostedConnectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateHostedConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a MAC Security (MACsec) Connection Key Name (CKN)/ Connectivity Association Key (CAK) pair with an
     * Direct Connect dedicated connection.
     * </p>
     * <p>
     * You must supply either the <code>secretARN,</code> or the CKN/CAK (<code>ckn</code> and <code>cak</code>) pair in
     * the request.
     * </p>
     * <p>
     * For information about MAC Security (MACsec) key considerations, see <a href=
     * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-key-consideration"
     * >MACsec pre-shared CKN/CAK key considerations </a> in the <i>Direct Connect User Guide</i>.
     * </p>
     *
     * @param associateMacSecKeyRequest
     * @return Result of the AssociateMacSecKey operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AssociateMacSecKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateMacSecKey"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateMacSecKeyResponse associateMacSecKey(AssociateMacSecKeyRequest associateMacSecKeyRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateMacSecKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateMacSecKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateMacSecKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateMacSecKey");

            return clientHandler.execute(new ClientExecutionParams<AssociateMacSecKeyRequest, AssociateMacSecKeyResponse>()
                    .withOperationName("AssociateMacSecKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(associateMacSecKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateMacSecKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a virtual interface with a specified link aggregation group (LAG) or connection. Connectivity to
     * Amazon Web Services is temporarily interrupted as the virtual interface is being migrated. If the target
     * connection or LAG has an associated virtual interface with a conflicting VLAN number or a conflicting IP address,
     * the operation fails.
     * </p>
     * <p>
     * Virtual interfaces associated with a hosted connection cannot be associated with a LAG; hosted connections must
     * be migrated along with their virtual interfaces using <a>AssociateHostedConnection</a>.
     * </p>
     * <p>
     * To reassociate a virtual interface to a new connection or LAG, the requester must own either the virtual
     * interface itself or the connection to which the virtual interface is currently associated. Additionally, the
     * requester must own the connection or LAG for the association.
     * </p>
     *
     * @param associateVirtualInterfaceRequest
     * @return Result of the AssociateVirtualInterface operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.AssociateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateVirtualInterfaceResponse associateVirtualInterface(
            AssociateVirtualInterfaceRequest associateVirtualInterfaceRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateVirtualInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateVirtualInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateVirtualInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateVirtualInterfaceRequest, AssociateVirtualInterfaceResponse>()
                            .withOperationName("AssociateVirtualInterface").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateVirtualInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateVirtualInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Confirms the creation of the specified hosted connection on an interconnect.
     * </p>
     * <p>
     * Upon creation, the hosted connection is initially in the <code>Ordering</code> state, and remains in this state
     * until the owner confirms creation of the hosted connection.
     * </p>
     *
     * @param confirmConnectionRequest
     * @return Result of the ConfirmConnection operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ConfirmConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ConfirmConnectionResponse confirmConnection(ConfirmConnectionRequest confirmConnectionRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ConfirmConnectionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ConfirmConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmConnection");

            return clientHandler.execute(new ClientExecutionParams<ConfirmConnectionRequest, ConfirmConnectionResponse>()
                    .withOperationName("ConfirmConnection").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(confirmConnectionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ConfirmConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accepts ownership of a private virtual interface created by another account.
     * </p>
     * <p>
     * After the virtual interface owner makes this call, the virtual interface is created and attached to the specified
     * virtual private gateway or Direct Connect gateway, and is made available to handle traffic.
     * </p>
     *
     * @param confirmPrivateVirtualInterfaceRequest
     * @return Result of the ConfirmPrivateVirtualInterface operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ConfirmPrivateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPrivateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ConfirmPrivateVirtualInterfaceResponse confirmPrivateVirtualInterface(
            ConfirmPrivateVirtualInterfaceRequest confirmPrivateVirtualInterfaceRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ConfirmPrivateVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ConfirmPrivateVirtualInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                confirmPrivateVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmPrivateVirtualInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<ConfirmPrivateVirtualInterfaceRequest, ConfirmPrivateVirtualInterfaceResponse>()
                            .withOperationName("ConfirmPrivateVirtualInterface").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(confirmPrivateVirtualInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ConfirmPrivateVirtualInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accepts ownership of a public virtual interface created by another account.
     * </p>
     * <p>
     * After the virtual interface owner makes this call, the specified virtual interface is created and made available
     * to handle traffic.
     * </p>
     *
     * @param confirmPublicVirtualInterfaceRequest
     * @return Result of the ConfirmPublicVirtualInterface operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ConfirmPublicVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPublicVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ConfirmPublicVirtualInterfaceResponse confirmPublicVirtualInterface(
            ConfirmPublicVirtualInterfaceRequest confirmPublicVirtualInterfaceRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ConfirmPublicVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ConfirmPublicVirtualInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                confirmPublicVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmPublicVirtualInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<ConfirmPublicVirtualInterfaceRequest, ConfirmPublicVirtualInterfaceResponse>()
                            .withOperationName("ConfirmPublicVirtualInterface").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(confirmPublicVirtualInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ConfirmPublicVirtualInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accepts ownership of a transit virtual interface created by another account.
     * </p>
     * <p>
     * After the owner of the transit virtual interface makes this call, the specified transit virtual interface is
     * created and made available to handle traffic.
     * </p>
     *
     * @param confirmTransitVirtualInterfaceRequest
     * @return Result of the ConfirmTransitVirtualInterface operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ConfirmTransitVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmTransitVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ConfirmTransitVirtualInterfaceResponse confirmTransitVirtualInterface(
            ConfirmTransitVirtualInterfaceRequest confirmTransitVirtualInterfaceRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ConfirmTransitVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ConfirmTransitVirtualInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                confirmTransitVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmTransitVirtualInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<ConfirmTransitVirtualInterfaceRequest, ConfirmTransitVirtualInterfaceResponse>()
                            .withOperationName("ConfirmTransitVirtualInterface").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(confirmTransitVirtualInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ConfirmTransitVirtualInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a BGP peer on the specified virtual interface.
     * </p>
     * <p>
     * You must create a BGP peer for the corresponding address family (IPv4/IPv6) in order to access Amazon Web
     * Services resources that also use that address family.
     * </p>
     * <p>
     * If logical redundancy is not supported by the connection, interconnect, or LAG, the BGP peer cannot be in the
     * same address family as an existing BGP peer on the virtual interface.
     * </p>
     * <p>
     * When creating a IPv6 BGP peer, omit the Amazon address and customer address. IPv6 addresses are automatically
     * assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     * </p>
     * <p>
     * For a public virtual interface, the Autonomous System Number (ASN) must be private or already on the allow list
     * for the virtual interface.
     * </p>
     *
     * @param createBgpPeerRequest
     * @return Result of the CreateBGPPeer operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateBGPPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateBGPPeer" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateBgpPeerResponse createBGPPeer(CreateBgpPeerRequest createBgpPeerRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBgpPeerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBgpPeerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBgpPeerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBGPPeer");

            return clientHandler.execute(new ClientExecutionParams<CreateBgpPeerRequest, CreateBgpPeerResponse>()
                    .withOperationName("CreateBGPPeer").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createBgpPeerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBgpPeerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a connection between a customer network and a specific Direct Connect location.
     * </p>
     * <p>
     * A connection links your internal network to an Direct Connect location over a standard Ethernet fiber-optic
     * cable. One end of the cable is connected to your router, the other to an Direct Connect router.
     * </p>
     * <p>
     * To find the locations for your Region, use <a>DescribeLocations</a>.
     * </p>
     * <p>
     * You can automatically add the new connection to a link aggregation group (LAG) by specifying a LAG ID in the
     * request. This ensures that the new connection is allocated on the same Direct Connect endpoint that hosts the
     * specified LAG. If there are no available ports on the endpoint, the request fails and no connection is created.
     * </p>
     *
     * @param createConnectionRequest
     * @return Result of the CreateConnection operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateConnectionResponse createConnection(CreateConnectionRequest createConnectionRequest)
            throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConnectionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConnection");

            return clientHandler.execute(new ClientExecutionParams<CreateConnectionRequest, CreateConnectionResponse>()
                    .withOperationName("CreateConnection").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createConnectionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Direct Connect gateway, which is an intermediate object that enables you to connect a set of virtual
     * interfaces and virtual private gateways. A Direct Connect gateway is global and visible in any Region after it is
     * created. The virtual interfaces and virtual private gateways that are connected through a Direct Connect gateway
     * can be in different Regions. This enables you to connect to a VPC in any Region, regardless of the Region in
     * which the virtual interfaces are located, and pass traffic between them.
     * </p>
     *
     * @param createDirectConnectGatewayRequest
     * @return Result of the CreateDirectConnectGateway operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateDirectConnectGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDirectConnectGatewayResponse createDirectConnectGateway(
            CreateDirectConnectGatewayRequest createDirectConnectGatewayRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDirectConnectGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDirectConnectGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDirectConnectGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDirectConnectGateway");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDirectConnectGatewayRequest, CreateDirectConnectGatewayResponse>()
                            .withOperationName("CreateDirectConnectGateway").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createDirectConnectGatewayRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDirectConnectGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an association between a Direct Connect gateway and a virtual private gateway. The virtual private
     * gateway must be attached to a VPC and must not be associated with another Direct Connect gateway.
     * </p>
     *
     * @param createDirectConnectGatewayAssociationRequest
     * @return Result of the CreateDirectConnectGatewayAssociation operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateDirectConnectGatewayAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDirectConnectGatewayAssociationResponse createDirectConnectGatewayAssociation(
            CreateDirectConnectGatewayAssociationRequest createDirectConnectGatewayAssociationRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDirectConnectGatewayAssociationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, CreateDirectConnectGatewayAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDirectConnectGatewayAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDirectConnectGatewayAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDirectConnectGatewayAssociationRequest, CreateDirectConnectGatewayAssociationResponse>()
                            .withOperationName("CreateDirectConnectGatewayAssociation").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDirectConnectGatewayAssociationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDirectConnectGatewayAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a proposal to associate the specified virtual private gateway or transit gateway with the specified
     * Direct Connect gateway.
     * </p>
     * <p>
     * You can associate a Direct Connect gateway and virtual private gateway or transit gateway that is owned by any
     * account.
     * </p>
     *
     * @param createDirectConnectGatewayAssociationProposalRequest
     * @return Result of the CreateDirectConnectGatewayAssociationProposal operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateDirectConnectGatewayAssociationProposal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociationProposal"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDirectConnectGatewayAssociationProposalResponse createDirectConnectGatewayAssociationProposal(
            CreateDirectConnectGatewayAssociationProposalRequest createDirectConnectGatewayAssociationProposalRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDirectConnectGatewayAssociationProposalResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, CreateDirectConnectGatewayAssociationProposalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDirectConnectGatewayAssociationProposalRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDirectConnectGatewayAssociationProposal");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDirectConnectGatewayAssociationProposalRequest, CreateDirectConnectGatewayAssociationProposalResponse>()
                            .withOperationName("CreateDirectConnectGatewayAssociationProposal")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDirectConnectGatewayAssociationProposalRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDirectConnectGatewayAssociationProposalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an interconnect between an Direct Connect Partner's network and a specific Direct Connect location.
     * </p>
     * <p>
     * An interconnect is a connection that is capable of hosting other connections. The Direct Connect Partner can use
     * an interconnect to provide Direct Connect hosted connections to customers through their own network services.
     * Like a standard connection, an interconnect links the partner's network to an Direct Connect location over a
     * standard Ethernet fiber-optic cable. One end is connected to the partner's router, the other to an Direct Connect
     * router.
     * </p>
     * <p>
     * You can automatically add the new interconnect to a link aggregation group (LAG) by specifying a LAG ID in the
     * request. This ensures that the new interconnect is allocated on the same Direct Connect endpoint that hosts the
     * specified LAG. If there are no available ports on the endpoint, the request fails and no interconnect is created.
     * </p>
     * <p>
     * For each end customer, the Direct Connect Partner provisions a connection on their interconnect by calling
     * <a>AllocateHostedConnection</a>. The end customer can then connect to Amazon Web Services resources by creating a
     * virtual interface on their connection, using the VLAN assigned to them by the Direct Connect Partner.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note>
     *
     * @param createInterconnectRequest
     * @return Result of the CreateInterconnect operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateInterconnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateInterconnect"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateInterconnectResponse createInterconnect(CreateInterconnectRequest createInterconnectRequest)
            throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException,
            AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateInterconnectResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateInterconnectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInterconnectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInterconnect");

            return clientHandler.execute(new ClientExecutionParams<CreateInterconnectRequest, CreateInterconnectResponse>()
                    .withOperationName("CreateInterconnect").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createInterconnectRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateInterconnectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a link aggregation group (LAG) with the specified number of bundled physical dedicated connections
     * between the customer network and a specific Direct Connect location. A LAG is a logical interface that uses the
     * Link Aggregation Control Protocol (LACP) to aggregate multiple interfaces, enabling you to treat them as a single
     * interface.
     * </p>
     * <p>
     * All connections in a LAG must use the same bandwidth (either 1Gbps or 10Gbps) and must terminate at the same
     * Direct Connect endpoint.
     * </p>
     * <p>
     * You can have up to 10 dedicated connections per LAG. Regardless of this limit, if you request more connections
     * for the LAG than Direct Connect can allocate on a single endpoint, no LAG is created.
     * </p>
     * <p>
     * You can specify an existing physical dedicated connection or interconnect to include in the LAG (which counts
     * towards the total number of connections). Doing so interrupts the current physical dedicated connection, and
     * re-establishes them as a member of the LAG. The LAG will be created on the same Direct Connect endpoint to which
     * the dedicated connection terminates. Any virtual interfaces associated with the dedicated connection are
     * automatically disassociated and re-associated with the LAG. The connection ID does not change.
     * </p>
     * <p>
     * If the account used to create a LAG is a registered Direct Connect Partner, the LAG is automatically enabled to
     * host sub-connections. For a LAG owned by a partner, any associated virtual interfaces cannot be directly
     * configured.
     * </p>
     *
     * @param createLagRequest
     * @return Result of the CreateLag operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateLag" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateLagResponse createLag(CreateLagRequest createLagRequest) throws DuplicateTagKeysException, TooManyTagsException,
            DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateLagResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateLagResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLagRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLag");

            return clientHandler.execute(new ClientExecutionParams<CreateLagRequest, CreateLagResponse>()
                    .withOperationName("CreateLag").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createLagRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateLagRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a private virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A
     * private virtual interface can be connected to either a Direct Connect gateway or a Virtual Private Gateway (VGW).
     * Connecting the private virtual interface to a Direct Connect gateway enables the possibility for connecting to
     * multiple VPCs, including VPCs in different Regions. Connecting the private virtual interface to a VGW only
     * provides access to a single VPC within the same Region.
     * </p>
     * <p>
     * Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical
     * connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity
     * for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection
     * supports jumbo frames, call <a>DescribeConnections</a>. To check whether your virtual interface supports jumbo
     * frames, call <a>DescribeVirtualInterfaces</a>.
     * </p>
     *
     * @param createPrivateVirtualInterfaceRequest
     * @return Result of the CreatePrivateVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreatePrivateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePrivateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePrivateVirtualInterfaceResponse createPrivateVirtualInterface(
            CreatePrivateVirtualInterfaceRequest createPrivateVirtualInterfaceRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePrivateVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePrivateVirtualInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createPrivateVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePrivateVirtualInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<CreatePrivateVirtualInterfaceRequest, CreatePrivateVirtualInterfaceResponse>()
                            .withOperationName("CreatePrivateVirtualInterface").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createPrivateVirtualInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreatePrivateVirtualInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a public virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A
     * public virtual interface supports sending traffic to public services of Amazon Web Services such as Amazon S3.
     * </p>
     * <p>
     * When creating an IPv6 public virtual interface (<code>addressFamily</code> is <code>ipv6</code>), leave the
     * <code>customer</code> and <code>amazon</code> address fields blank to use auto-assigned IPv6 space. Custom IPv6
     * addresses are not supported.
     * </p>
     *
     * @param createPublicVirtualInterfaceRequest
     * @return Result of the CreatePublicVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreatePublicVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePublicVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePublicVirtualInterfaceResponse createPublicVirtualInterface(
            CreatePublicVirtualInterfaceRequest createPublicVirtualInterfaceRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePublicVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePublicVirtualInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPublicVirtualInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePublicVirtualInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<CreatePublicVirtualInterfaceRequest, CreatePublicVirtualInterfaceResponse>()
                            .withOperationName("CreatePublicVirtualInterface").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createPublicVirtualInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreatePublicVirtualInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a transit virtual interface. A transit virtual interface should be used to access one or more transit
     * gateways associated with Direct Connect gateways. A transit virtual interface enables the connection of multiple
     * VPCs attached to a transit gateway to a Direct Connect gateway.
     * </p>
     * <important>
     * <p>
     * If you associate your transit gateway with one or more Direct Connect gateways, the Autonomous System Number
     * (ASN) used by the transit gateway and the Direct Connect gateway must be different. For example, if you use the
     * default ASN 64512 for both your the transit gateway and Direct Connect gateway, the association request fails.
     * </p>
     * </important>
     * <p>
     * Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause an update to the underlying physical
     * connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity
     * for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection
     * supports jumbo frames, call <a>DescribeConnections</a>. To check whether your virtual interface supports jumbo
     * frames, call <a>DescribeVirtualInterfaces</a>.
     * </p>
     *
     * @param createTransitVirtualInterfaceRequest
     * @return Result of the CreateTransitVirtualInterface operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.CreateTransitVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateTransitVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTransitVirtualInterfaceResponse createTransitVirtualInterface(
            CreateTransitVirtualInterfaceRequest createTransitVirtualInterfaceRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTransitVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTransitVirtualInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitVirtualInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTransitVirtualInterfaceRequest, CreateTransitVirtualInterfaceResponse>()
                            .withOperationName("CreateTransitVirtualInterface").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createTransitVirtualInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTransitVirtualInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified BGP peer on the specified virtual interface with the specified customer address and ASN.
     * </p>
     * <p>
     * You cannot delete the last BGP peer from a virtual interface.
     * </p>
     *
     * @param deleteBgpPeerRequest
     * @return Result of the DeleteBGPPeer operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteBGPPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteBGPPeer" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteBgpPeerResponse deleteBGPPeer(DeleteBgpPeerRequest deleteBgpPeerRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBgpPeerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBgpPeerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBgpPeerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBGPPeer");

            return clientHandler.execute(new ClientExecutionParams<DeleteBgpPeerRequest, DeleteBgpPeerResponse>()
                    .withOperationName("DeleteBGPPeer").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteBgpPeerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBgpPeerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified connection.
     * </p>
     * <p>
     * Deleting a connection only stops the Direct Connect port hour and data transfer charges. If you are partnering
     * with any third parties to connect with the Direct Connect location, you must cancel your service with them
     * separately.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConnectionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConnection");

            return clientHandler.execute(new ClientExecutionParams<DeleteConnectionRequest, DeleteConnectionResponse>()
                    .withOperationName("DeleteConnection").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteConnectionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified Direct Connect gateway. You must first delete all virtual interfaces that are attached to
     * the Direct Connect gateway and disassociate all virtual private gateways associated with the Direct Connect
     * gateway.
     * </p>
     *
     * @param deleteDirectConnectGatewayRequest
     * @return Result of the DeleteDirectConnectGateway operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteDirectConnectGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDirectConnectGatewayResponse deleteDirectConnectGateway(
            DeleteDirectConnectGatewayRequest deleteDirectConnectGatewayRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDirectConnectGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDirectConnectGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDirectConnectGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDirectConnectGateway");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDirectConnectGatewayRequest, DeleteDirectConnectGatewayResponse>()
                            .withOperationName("DeleteDirectConnectGateway").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteDirectConnectGatewayRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDirectConnectGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the association between the specified Direct Connect gateway and virtual private gateway.
     * </p>
     * <p>
     * We recommend that you specify the <code>associationID</code> to delete the association. Alternatively, if you own
     * virtual gateway and a Direct Connect gateway association, you can specify the <code>virtualGatewayId</code> and
     * <code>directConnectGatewayId</code> to delete an association.
     * </p>
     *
     * @param deleteDirectConnectGatewayAssociationRequest
     * @return Result of the DeleteDirectConnectGatewayAssociation operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteDirectConnectGatewayAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDirectConnectGatewayAssociationResponse deleteDirectConnectGatewayAssociation(
            DeleteDirectConnectGatewayAssociationRequest deleteDirectConnectGatewayAssociationRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDirectConnectGatewayAssociationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeleteDirectConnectGatewayAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDirectConnectGatewayAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDirectConnectGatewayAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDirectConnectGatewayAssociationRequest, DeleteDirectConnectGatewayAssociationResponse>()
                            .withOperationName("DeleteDirectConnectGatewayAssociation").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDirectConnectGatewayAssociationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDirectConnectGatewayAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the association proposal request between the specified Direct Connect gateway and virtual private gateway
     * or transit gateway.
     * </p>
     *
     * @param deleteDirectConnectGatewayAssociationProposalRequest
     * @return Result of the DeleteDirectConnectGatewayAssociationProposal operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteDirectConnectGatewayAssociationProposal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociationProposal"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDirectConnectGatewayAssociationProposalResponse deleteDirectConnectGatewayAssociationProposal(
            DeleteDirectConnectGatewayAssociationProposalRequest deleteDirectConnectGatewayAssociationProposalRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDirectConnectGatewayAssociationProposalResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeleteDirectConnectGatewayAssociationProposalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDirectConnectGatewayAssociationProposalRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDirectConnectGatewayAssociationProposal");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDirectConnectGatewayAssociationProposalRequest, DeleteDirectConnectGatewayAssociationProposalResponse>()
                            .withOperationName("DeleteDirectConnectGatewayAssociationProposal")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDirectConnectGatewayAssociationProposalRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDirectConnectGatewayAssociationProposalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified interconnect.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note>
     *
     * @param deleteInterconnectRequest
     * @return Result of the DeleteInterconnect operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteInterconnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnect"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteInterconnectResponse deleteInterconnect(DeleteInterconnectRequest deleteInterconnectRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteInterconnectResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteInterconnectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInterconnectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInterconnect");

            return clientHandler.execute(new ClientExecutionParams<DeleteInterconnectRequest, DeleteInterconnectResponse>()
                    .withOperationName("DeleteInterconnect").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteInterconnectRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteInterconnectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified link aggregation group (LAG). You cannot delete a LAG if it has active virtual interfaces
     * or hosted connections.
     * </p>
     *
     * @param deleteLagRequest
     * @return Result of the DeleteLag operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteLag" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteLagResponse deleteLag(DeleteLagRequest deleteLagRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLagResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteLagResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLagRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLag");

            return clientHandler.execute(new ClientExecutionParams<DeleteLagRequest, DeleteLagResponse>()
                    .withOperationName("DeleteLag").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteLagRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteLagRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a virtual interface.
     * </p>
     *
     * @param deleteVirtualInterfaceRequest
     * @return Result of the DeleteVirtualInterface operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DeleteVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteVirtualInterfaceResponse deleteVirtualInterface(DeleteVirtualInterfaceRequest deleteVirtualInterfaceRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteVirtualInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVirtualInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVirtualInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVirtualInterfaceRequest, DeleteVirtualInterfaceResponse>()
                            .withOperationName("DeleteVirtualInterface").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteVirtualInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteVirtualInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays the specified connection or all connections in this Region.
     * </p>
     *
     * @param describeConnectionsRequest
     * @return Result of the DescribeConnections operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnections"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConnectionsResponse describeConnections(DescribeConnectionsRequest describeConnectionsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConnectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConnectionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConnectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConnections");

            return clientHandler.execute(new ClientExecutionParams<DescribeConnectionsRequest, DescribeConnectionsResponse>()
                    .withOperationName("DescribeConnections").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeConnectionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeConnectionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes one or more association proposals for connection between a virtual private gateway or transit gateway
     * and a Direct Connect gateway.
     * </p>
     *
     * @param describeDirectConnectGatewayAssociationProposalsRequest
     * @return Result of the DescribeDirectConnectGatewayAssociationProposals operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeDirectConnectGatewayAssociationProposals
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociationProposals"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDirectConnectGatewayAssociationProposalsResponse describeDirectConnectGatewayAssociationProposals(
            DescribeDirectConnectGatewayAssociationProposalsRequest describeDirectConnectGatewayAssociationProposalsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDirectConnectGatewayAssociationProposalsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeDirectConnectGatewayAssociationProposalsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDirectConnectGatewayAssociationProposalsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDirectConnectGatewayAssociationProposals");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDirectConnectGatewayAssociationProposalsRequest, DescribeDirectConnectGatewayAssociationProposalsResponse>()
                            .withOperationName("DescribeDirectConnectGatewayAssociationProposals")
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeDirectConnectGatewayAssociationProposalsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new DescribeDirectConnectGatewayAssociationProposalsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the associations between your Direct Connect gateways and virtual private gateways and transit gateways.
     * You must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A Direct Connect gateway
     * </p>
     * <p>
     * The response contains all virtual private gateways and transit gateways associated with the Direct Connect
     * gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A virtual private gateway
     * </p>
     * <p>
     * The response contains the Direct Connect gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A transit gateway
     * </p>
     * <p>
     * The response contains the Direct Connect gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Direct Connect gateway and a virtual private gateway
     * </p>
     * <p>
     * The response contains the association between the Direct Connect gateway and virtual private gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Direct Connect gateway and a transit gateway
     * </p>
     * <p>
     * The response contains the association between the Direct Connect gateway and transit gateway.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeDirectConnectGatewayAssociationsRequest
     * @return Result of the DescribeDirectConnectGatewayAssociations operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeDirectConnectGatewayAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDirectConnectGatewayAssociationsResponse describeDirectConnectGatewayAssociations(
            DescribeDirectConnectGatewayAssociationsRequest describeDirectConnectGatewayAssociationsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDirectConnectGatewayAssociationsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeDirectConnectGatewayAssociationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDirectConnectGatewayAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDirectConnectGatewayAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDirectConnectGatewayAssociationsRequest, DescribeDirectConnectGatewayAssociationsResponse>()
                            .withOperationName("DescribeDirectConnectGatewayAssociations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeDirectConnectGatewayAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDirectConnectGatewayAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the attachments between your Direct Connect gateways and virtual interfaces. You must specify a Direct
     * Connect gateway, a virtual interface, or both. If you specify a Direct Connect gateway, the response contains all
     * virtual interfaces attached to the Direct Connect gateway. If you specify a virtual interface, the response
     * contains all Direct Connect gateways attached to the virtual interface. If you specify both, the response
     * contains the attachment between the Direct Connect gateway and the virtual interface.
     * </p>
     *
     * @param describeDirectConnectGatewayAttachmentsRequest
     * @return Result of the DescribeDirectConnectGatewayAttachments operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeDirectConnectGatewayAttachments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDirectConnectGatewayAttachmentsResponse describeDirectConnectGatewayAttachments(
            DescribeDirectConnectGatewayAttachmentsRequest describeDirectConnectGatewayAttachmentsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDirectConnectGatewayAttachmentsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeDirectConnectGatewayAttachmentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDirectConnectGatewayAttachmentsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDirectConnectGatewayAttachments");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDirectConnectGatewayAttachmentsRequest, DescribeDirectConnectGatewayAttachmentsResponse>()
                            .withOperationName("DescribeDirectConnectGatewayAttachments").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeDirectConnectGatewayAttachmentsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDirectConnectGatewayAttachmentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all your Direct Connect gateways or only the specified Direct Connect gateway. Deleted Direct Connect
     * gateways are not returned.
     * </p>
     *
     * @param describeDirectConnectGatewaysRequest
     * @return Result of the DescribeDirectConnectGateways operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeDirectConnectGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGateways"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDirectConnectGatewaysResponse describeDirectConnectGateways(
            DescribeDirectConnectGatewaysRequest describeDirectConnectGatewaysRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDirectConnectGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDirectConnectGatewaysResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDirectConnectGatewaysRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDirectConnectGateways");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDirectConnectGatewaysRequest, DescribeDirectConnectGatewaysResponse>()
                            .withOperationName("DescribeDirectConnectGateways").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDirectConnectGatewaysRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDirectConnectGatewaysRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the hosted connections that have been provisioned on the specified interconnect or link aggregation group
     * (LAG).
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note>
     *
     * @param describeHostedConnectionsRequest
     * @return Result of the DescribeHostedConnections operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeHostedConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeHostedConnections"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeHostedConnectionsResponse describeHostedConnections(
            DescribeHostedConnectionsRequest describeHostedConnectionsRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeHostedConnectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeHostedConnectionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeHostedConnectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeHostedConnections");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeHostedConnectionsRequest, DescribeHostedConnectionsResponse>()
                            .withOperationName("DescribeHostedConnections").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeHostedConnectionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeHostedConnectionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the interconnects owned by the account or only the specified interconnect.
     * </p>
     *
     * @param describeInterconnectsRequest
     * @return Result of the DescribeInterconnects operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeInterconnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnects"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInterconnectsResponse describeInterconnects(DescribeInterconnectsRequest describeInterconnectsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeInterconnectsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeInterconnectsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInterconnectsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInterconnects");

            return clientHandler.execute(new ClientExecutionParams<DescribeInterconnectsRequest, DescribeInterconnectsResponse>()
                    .withOperationName("DescribeInterconnects").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeInterconnectsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeInterconnectsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes all your link aggregation groups (LAG) or the specified LAG.
     * </p>
     *
     * @param describeLagsRequest
     * @return Result of the DescribeLags operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeLags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLags" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeLagsResponse describeLags(DescribeLagsRequest describeLagsRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeLagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeLagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLags");

            return clientHandler.execute(new ClientExecutionParams<DescribeLagsRequest, DescribeLagsResponse>()
                    .withOperationName("DescribeLags").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeLagsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeLagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the LOA-CFA for a connection, interconnect, or link aggregation group (LAG).
     * </p>
     * <p>
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when
     * establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see <a
     * href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html">Requesting Cross Connects at
     * Direct Connect Locations</a> in the <i>Direct Connect User Guide</i>.
     * </p>
     *
     * @param describeLoaRequest
     * @return Result of the DescribeLoa operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeLoa
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLoa" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeLoaResponse describeLoa(DescribeLoaRequest describeLoaRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeLoaResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeLoaResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLoaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLoa");

            return clientHandler.execute(new ClientExecutionParams<DescribeLoaRequest, DescribeLoaResponse>()
                    .withOperationName("DescribeLoa").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeLoaRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeLoaRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the Direct Connect locations in the current Region. These are the locations that can be selected when
     * calling <a>CreateConnection</a> or <a>CreateInterconnect</a>.
     * </p>
     *
     * @param describeLocationsRequest
     * @return Result of the DescribeLocations operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLocations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeLocationsResponse describeLocations(DescribeLocationsRequest describeLocationsRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeLocationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeLocationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLocationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLocations");

            return clientHandler.execute(new ClientExecutionParams<DescribeLocationsRequest, DescribeLocationsResponse>()
                    .withOperationName("DescribeLocations").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeLocationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeLocationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the tags associated with the specified Direct Connect resources.
     * </p>
     *
     * @param describeTagsRequest
     * @return Result of the DescribeTags operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeTags" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTags");

            return clientHandler.execute(new ClientExecutionParams<DescribeTagsRequest, DescribeTagsResponse>()
                    .withOperationName("DescribeTags").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeTagsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the virtual private gateways owned by the account.
     * </p>
     * <p>
     * You can create one or more Direct Connect private virtual interfaces linked to a virtual private gateway.
     * </p>
     *
     * @param describeVirtualGatewaysRequest
     * @return Result of the DescribeVirtualGateways operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeVirtualGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualGateways"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeVirtualGatewaysResponse describeVirtualGateways(DescribeVirtualGatewaysRequest describeVirtualGatewaysRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeVirtualGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeVirtualGatewaysResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeVirtualGatewaysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeVirtualGateways");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeVirtualGatewaysRequest, DescribeVirtualGatewaysResponse>()
                            .withOperationName("DescribeVirtualGateways").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeVirtualGatewaysRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeVirtualGatewaysRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays all virtual interfaces for an account. Virtual interfaces deleted fewer than 15 minutes before you make
     * the request are also returned. If you specify a connection ID, only the virtual interfaces associated with the
     * connection are returned. If you specify a virtual interface ID, then only a single virtual interface is returned.
     * </p>
     * <p>
     * A virtual interface (VLAN) transmits the traffic between the Direct Connect location and the customer network.
     * </p>
     *
     * @param describeVirtualInterfacesRequest
     * @return Result of the DescribeVirtualInterfaces operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DescribeVirtualInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeVirtualInterfacesResponse describeVirtualInterfaces(
            DescribeVirtualInterfacesRequest describeVirtualInterfacesRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeVirtualInterfacesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeVirtualInterfacesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeVirtualInterfacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeVirtualInterfaces");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeVirtualInterfacesRequest, DescribeVirtualInterfacesResponse>()
                            .withOperationName("DescribeVirtualInterfaces").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeVirtualInterfacesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeVirtualInterfacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a connection from a link aggregation group (LAG). The connection is interrupted and re-established
     * as a standalone connection (the connection is not deleted; to delete the connection, use the
     * <a>DeleteConnection</a> request). If the LAG has associated virtual interfaces or hosted connections, they remain
     * associated with the LAG. A disassociated connection owned by an Direct Connect Partner is automatically converted
     * to an interconnect.
     * </p>
     * <p>
     * If disassociating the connection would cause the LAG to fall below its setting for minimum number of operational
     * connections, the request fails, except when it's the last member of the LAG. If all connections are
     * disassociated, the LAG continues to exist as an empty LAG with no physical connections.
     * </p>
     *
     * @param disassociateConnectionFromLagRequest
     * @return Result of the DisassociateConnectionFromLag operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DisassociateConnectionFromLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DisassociateConnectionFromLag"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateConnectionFromLagResponse disassociateConnectionFromLag(
            DisassociateConnectionFromLagRequest disassociateConnectionFromLagRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateConnectionFromLagResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateConnectionFromLagResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateConnectionFromLagRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateConnectionFromLag");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateConnectionFromLagRequest, DisassociateConnectionFromLagResponse>()
                            .withOperationName("DisassociateConnectionFromLag").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociateConnectionFromLagRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateConnectionFromLagRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the association between a MAC Security (MACsec) security key and an Direct Connect dedicated connection.
     * </p>
     *
     * @param disassociateMacSecKeyRequest
     * @return Result of the DisassociateMacSecKey operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.DisassociateMacSecKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DisassociateMacSecKey"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateMacSecKeyResponse disassociateMacSecKey(DisassociateMacSecKeyRequest disassociateMacSecKeyRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateMacSecKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateMacSecKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMacSecKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMacSecKey");

            return clientHandler.execute(new ClientExecutionParams<DisassociateMacSecKeyRequest, DisassociateMacSecKeyResponse>()
                    .withOperationName("DisassociateMacSecKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(disassociateMacSecKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisassociateMacSecKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the virtual interface failover test history.
     * </p>
     *
     * @param listVirtualInterfaceTestHistoryRequest
     * @return Result of the ListVirtualInterfaceTestHistory operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.ListVirtualInterfaceTestHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ListVirtualInterfaceTestHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListVirtualInterfaceTestHistoryResponse listVirtualInterfaceTestHistory(
            ListVirtualInterfaceTestHistoryRequest listVirtualInterfaceTestHistoryRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVirtualInterfaceTestHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListVirtualInterfaceTestHistoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listVirtualInterfaceTestHistoryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVirtualInterfaceTestHistory");

            return clientHandler
                    .execute(new ClientExecutionParams<ListVirtualInterfaceTestHistoryRequest, ListVirtualInterfaceTestHistoryResponse>()
                            .withOperationName("ListVirtualInterfaceTestHistory").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listVirtualInterfaceTestHistoryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListVirtualInterfaceTestHistoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts the virtual interface failover test that verifies your configuration meets your resiliency requirements by
     * placing the BGP peering session in the DOWN state. You can then send traffic to verify that there are no outages.
     * </p>
     * <p>
     * You can run the test on public, private, transit, and hosted virtual interfaces.
     * </p>
     * <p>
     * You can use <a
     * href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ListVirtualInterfaceTestHistory.html"
     * >ListVirtualInterfaceTestHistory</a> to view the virtual interface test history.
     * </p>
     * <p>
     * If you need to stop the test before the test interval completes, use <a
     * href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_StopBgpFailoverTest.html"
     * >StopBgpFailoverTest</a>.
     * </p>
     *
     * @param startBgpFailoverTestRequest
     * @return Result of the StartBgpFailoverTest operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.StartBgpFailoverTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/StartBgpFailoverTest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartBgpFailoverTestResponse startBgpFailoverTest(StartBgpFailoverTestRequest startBgpFailoverTestRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartBgpFailoverTestResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartBgpFailoverTestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startBgpFailoverTestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartBgpFailoverTest");

            return clientHandler.execute(new ClientExecutionParams<StartBgpFailoverTestRequest, StartBgpFailoverTestResponse>()
                    .withOperationName("StartBgpFailoverTest").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startBgpFailoverTestRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartBgpFailoverTestRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops the virtual interface failover test.
     * </p>
     *
     * @param stopBgpFailoverTestRequest
     * @return Result of the StopBgpFailoverTest operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.StopBgpFailoverTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/StopBgpFailoverTest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopBgpFailoverTestResponse stopBgpFailoverTest(StopBgpFailoverTestRequest stopBgpFailoverTestRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopBgpFailoverTestResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopBgpFailoverTestResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopBgpFailoverTestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopBgpFailoverTest");

            return clientHandler.execute(new ClientExecutionParams<StopBgpFailoverTestRequest, StopBgpFailoverTestResponse>()
                    .withOperationName("StopBgpFailoverTest").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(stopBgpFailoverTestRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopBgpFailoverTestRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds the specified tags to the specified Direct Connect resource. Each resource can have a maximum of 50 tags.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the
     * resource, this action updates its value.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You have reached the limit on the number of tags that can be assigned.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws DuplicateTagKeysException,
            TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException,
            SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes one or more tags from the specified Direct Connect resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the Direct Connect dedicated connection configuration.
     * </p>
     * <p>
     * You can update the following parameters for a connection:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The connection name
     * </p>
     * </li>
     * <li>
     * <p>
     * The connection's MAC Security (MACsec) encryption mode.
     * </p>
     * </li>
     * </ul>
     *
     * @param updateConnectionRequest
     * @return Result of the UpdateConnection operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UpdateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateConnectionResponse updateConnection(UpdateConnectionRequest updateConnectionRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateConnectionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConnection");

            return clientHandler.execute(new ClientExecutionParams<UpdateConnectionRequest, UpdateConnectionResponse>()
                    .withOperationName("UpdateConnection").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateConnectionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified attributes of the Direct Connect gateway association.
     * </p>
     * <p>
     * Add or remove prefixes from the association.
     * </p>
     *
     * @param updateDirectConnectGatewayAssociationRequest
     * @return Result of the UpdateDirectConnectGatewayAssociation operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UpdateDirectConnectGatewayAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateDirectConnectGatewayAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDirectConnectGatewayAssociationResponse updateDirectConnectGatewayAssociation(
            UpdateDirectConnectGatewayAssociationRequest updateDirectConnectGatewayAssociationRequest)
            throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException,
            DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDirectConnectGatewayAssociationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, UpdateDirectConnectGatewayAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateDirectConnectGatewayAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDirectConnectGatewayAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDirectConnectGatewayAssociationRequest, UpdateDirectConnectGatewayAssociationResponse>()
                            .withOperationName("UpdateDirectConnectGatewayAssociation").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateDirectConnectGatewayAssociationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDirectConnectGatewayAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the attributes of the specified link aggregation group (LAG).
     * </p>
     * <p>
     * You can update the following LAG attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The name of the LAG.
     * </p>
     * </li>
     * <li>
     * <p>
     * The value for the minimum number of connections that must be operational for the LAG itself to be operational.
     * </p>
     * </li>
     * <li>
     * <p>
     * The LAG's MACsec encryption mode.
     * </p>
     * <p>
     * Amazon Web Services assigns this value to each connection which is part of the LAG.
     * </p>
     * </li>
     * <li>
     * <p>
     * The tags
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you adjust the threshold value for the minimum number of operational connections, ensure that the new value
     * does not cause the LAG to fall below the threshold and become non-operational.
     * </p>
     * </note>
     *
     * @param updateLagRequest
     * @return Result of the UpdateLag operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UpdateLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateLag" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateLagResponse updateLag(UpdateLagRequest updateLagRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateLagResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateLagResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLagRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLag");

            return clientHandler.execute(new ClientExecutionParams<UpdateLagRequest, UpdateLagResponse>()
                    .withOperationName("UpdateLag").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateLagRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateLagRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified attributes of the specified virtual private interface.
     * </p>
     * <p>
     * Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical
     * connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity
     * for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection
     * supports jumbo frames, call <a>DescribeConnections</a>. To check whether your virtual q interface supports jumbo
     * frames, call <a>DescribeVirtualInterfaces</a>.
     * </p>
     *
     * @param updateVirtualInterfaceAttributesRequest
     * @return Result of the UpdateVirtualInterfaceAttributes operation returned by the service.
     * @throws DirectConnectServerException
     *         A server-side error occurred.
     * @throws DirectConnectClientException
     *         One or more parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectConnectClient.UpdateVirtualInterfaceAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateVirtualInterfaceAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateVirtualInterfaceAttributesResponse updateVirtualInterfaceAttributes(
            UpdateVirtualInterfaceAttributesRequest updateVirtualInterfaceAttributesRequest) throws DirectConnectServerException,
            DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateVirtualInterfaceAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateVirtualInterfaceAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateVirtualInterfaceAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVirtualInterfaceAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateVirtualInterfaceAttributesRequest, UpdateVirtualInterfaceAttributesResponse>()
                            .withOperationName("UpdateVirtualInterfaceAttributes").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateVirtualInterfaceAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateVirtualInterfaceAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(DirectConnectException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateTagKeysException")
                                .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectConnectServerException")
                                .exceptionBuilderSupplier(DirectConnectServerException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectConnectClientException")
                                .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends DirectConnectRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
