/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Letter of Authorization - Connecting Facility Assignment (LOA-CFA) for a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLoaResponse extends DirectConnectResponse implements
        ToCopyableBuilder<DescribeLoaResponse.Builder, DescribeLoaResponse> {
    private static final SdkField<SdkBytes> LOA_CONTENT_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("loaContent").getter(getter(DescribeLoaResponse::loaContent)).setter(setter(Builder::loaContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loaContent").build()).build();

    private static final SdkField<String> LOA_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("loaContentType").getter(getter(DescribeLoaResponse::loaContentTypeAsString))
            .setter(setter(Builder::loaContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loaContentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOA_CONTENT_FIELD,
            LOA_CONTENT_TYPE_FIELD));

    private final SdkBytes loaContent;

    private final String loaContentType;

    private DescribeLoaResponse(BuilderImpl builder) {
        super(builder);
        this.loaContent = builder.loaContent;
        this.loaContentType = builder.loaContentType;
    }

    /**
     * <p>
     * The binary contents of the LOA-CFA document.
     * </p>
     * 
     * @return The binary contents of the LOA-CFA document.
     */
    public final SdkBytes loaContent() {
        return loaContent;
    }

    /**
     * <p>
     * The standard media type for the LOA-CFA document. The only supported value is application/pdf.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #loaContentType}
     * will return {@link LoaContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #loaContentTypeAsString}.
     * </p>
     * 
     * @return The standard media type for the LOA-CFA document. The only supported value is application/pdf.
     * @see LoaContentType
     */
    public final LoaContentType loaContentType() {
        return LoaContentType.fromValue(loaContentType);
    }

    /**
     * <p>
     * The standard media type for the LOA-CFA document. The only supported value is application/pdf.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #loaContentType}
     * will return {@link LoaContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #loaContentTypeAsString}.
     * </p>
     * 
     * @return The standard media type for the LOA-CFA document. The only supported value is application/pdf.
     * @see LoaContentType
     */
    public final String loaContentTypeAsString() {
        return loaContentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loaContent());
        hashCode = 31 * hashCode + Objects.hashCode(loaContentTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoaResponse)) {
            return false;
        }
        DescribeLoaResponse other = (DescribeLoaResponse) obj;
        return Objects.equals(loaContent(), other.loaContent())
                && Objects.equals(loaContentTypeAsString(), other.loaContentTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLoaResponse").add("LoaContent", loaContent())
                .add("LoaContentType", loaContentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loaContent":
            return Optional.ofNullable(clazz.cast(loaContent()));
        case "loaContentType":
            return Optional.ofNullable(clazz.cast(loaContentTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoaResponse, T> g) {
        return obj -> g.apply((DescribeLoaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLoaResponse> {
        /**
         * <p>
         * The binary contents of the LOA-CFA document.
         * </p>
         * 
         * @param loaContent
         *        The binary contents of the LOA-CFA document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loaContent(SdkBytes loaContent);

        /**
         * <p>
         * The standard media type for the LOA-CFA document. The only supported value is application/pdf.
         * </p>
         * 
         * @param loaContentType
         *        The standard media type for the LOA-CFA document. The only supported value is application/pdf.
         * @see LoaContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoaContentType
         */
        Builder loaContentType(String loaContentType);

        /**
         * <p>
         * The standard media type for the LOA-CFA document. The only supported value is application/pdf.
         * </p>
         * 
         * @param loaContentType
         *        The standard media type for the LOA-CFA document. The only supported value is application/pdf.
         * @see LoaContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoaContentType
         */
        Builder loaContentType(LoaContentType loaContentType);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private SdkBytes loaContent;

        private String loaContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoaResponse model) {
            super(model);
            loaContent(model.loaContent);
            loaContentType(model.loaContentType);
        }

        public final ByteBuffer getLoaContent() {
            return loaContent == null ? null : loaContent.asByteBuffer();
        }

        @Override
        public final Builder loaContent(SdkBytes loaContent) {
            this.loaContent = loaContent;
            return this;
        }

        public final void setLoaContent(ByteBuffer loaContent) {
            loaContent(loaContent == null ? null : SdkBytes.fromByteBuffer(loaContent));
        }

        public final String getLoaContentType() {
            return loaContentType;
        }

        @Override
        public final Builder loaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
            return this;
        }

        @Override
        public final Builder loaContentType(LoaContentType loaContentType) {
            this.loaContentType(loaContentType == null ? null : loaContentType.toString());
            return this;
        }

        public final void setLoaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
        }

        @Override
        public DescribeLoaResponse build() {
            return new DescribeLoaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
