/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfirmCustomerAgreementRequest extends DirectConnectRequest implements
        ToCopyableBuilder<ConfirmCustomerAgreementRequest.Builder, ConfirmCustomerAgreementRequest> {
    private static final SdkField<String> AGREEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agreementName").getter(getter(ConfirmCustomerAgreementRequest::agreementName))
            .setter(setter(Builder::agreementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGREEMENT_NAME_FIELD));

    private final String agreementName;

    private ConfirmCustomerAgreementRequest(BuilderImpl builder) {
        super(builder);
        this.agreementName = builder.agreementName;
    }

    /**
     * <p>
     * The name of the customer agreement.
     * </p>
     * 
     * @return The name of the customer agreement.
     */
    public final String agreementName() {
        return agreementName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agreementName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmCustomerAgreementRequest)) {
            return false;
        }
        ConfirmCustomerAgreementRequest other = (ConfirmCustomerAgreementRequest) obj;
        return Objects.equals(agreementName(), other.agreementName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfirmCustomerAgreementRequest").add("AgreementName", agreementName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agreementName":
            return Optional.ofNullable(clazz.cast(agreementName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfirmCustomerAgreementRequest, T> g) {
        return obj -> g.apply((ConfirmCustomerAgreementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ConfirmCustomerAgreementRequest> {
        /**
         * <p>
         * The name of the customer agreement.
         * </p>
         * 
         * @param agreementName
         *        The name of the customer agreement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementName(String agreementName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String agreementName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmCustomerAgreementRequest model) {
            super(model);
            agreementName(model.agreementName);
        }

        public final String getAgreementName() {
            return agreementName;
        }

        public final void setAgreementName(String agreementName) {
            this.agreementName = agreementName;
        }

        @Override
        @Transient
        public final Builder agreementName(String agreementName) {
            this.agreementName = agreementName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfirmCustomerAgreementRequest build() {
            return new ConfirmCustomerAgreementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
