/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectionRequest extends DirectConnectRequest implements
        ToCopyableBuilder<CreateConnectionRequest.Builder, CreateConnectionRequest> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(CreateConnectionRequest::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> BANDWIDTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bandwidth").getter(getter(CreateConnectionRequest::bandwidth)).setter(setter(Builder::bandwidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidth").build()).build();

    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionName").getter(getter(CreateConnectionRequest::connectionName))
            .setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionName").build()).build();

    private static final SdkField<String> LAG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("lagId")
            .getter(getter(CreateConnectionRequest::lagId)).setter(setter(Builder::lagId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateConnectionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerName").getter(getter(CreateConnectionRequest::providerName))
            .setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()).build();

    private static final SdkField<Boolean> REQUEST_MAC_SEC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("requestMACSec").getter(getter(CreateConnectionRequest::requestMACSec))
            .setter(setter(Builder::requestMACSec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMACSec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD,
            BANDWIDTH_FIELD, CONNECTION_NAME_FIELD, LAG_ID_FIELD, TAGS_FIELD, PROVIDER_NAME_FIELD, REQUEST_MAC_SEC_FIELD));

    private final String location;

    private final String bandwidth;

    private final String connectionName;

    private final String lagId;

    private final List<Tag> tags;

    private final String providerName;

    private final Boolean requestMACSec;

    private CreateConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.location = builder.location;
        this.bandwidth = builder.bandwidth;
        this.connectionName = builder.connectionName;
        this.lagId = builder.lagId;
        this.tags = builder.tags;
        this.providerName = builder.providerName;
        this.requestMACSec = builder.requestMACSec;
    }

    /**
     * <p>
     * The location of the connection.
     * </p>
     * 
     * @return The location of the connection.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The bandwidth of the connection.
     * </p>
     * 
     * @return The bandwidth of the connection.
     */
    public final String bandwidth() {
        return bandwidth;
    }

    /**
     * <p>
     * The name of the connection.
     * </p>
     * 
     * @return The name of the connection.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * <p>
     * The ID of the LAG.
     * </p>
     * 
     * @return The ID of the LAG.
     */
    public final String lagId() {
        return lagId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to associate with the lag.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to associate with the lag.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the service provider associated with the requested connection.
     * </p>
     * 
     * @return The name of the service provider associated with the requested connection.
     */
    public final String providerName() {
        return providerName;
    }

    /**
     * <p>
     * Indicates whether you want the connection to support MAC Security (MACsec).
     * </p>
     * <p>
     * MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec)
     * prerequisties, see <a href=
     * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites"
     * >MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.
     * </p>
     * 
     * @return Indicates whether you want the connection to support MAC Security (MACsec).</p>
     *         <p>
     *         MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security
     *         (MACsec) prerequisties, see <a href=
     *         "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites"
     *         >MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.
     */
    public final Boolean requestMACSec() {
        return requestMACSec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(lagId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(requestMACSec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionRequest)) {
            return false;
        }
        CreateConnectionRequest other = (CreateConnectionRequest) obj;
        return Objects.equals(location(), other.location()) && Objects.equals(bandwidth(), other.bandwidth())
                && Objects.equals(connectionName(), other.connectionName()) && Objects.equals(lagId(), other.lagId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(providerName(), other.providerName()) && Objects.equals(requestMACSec(), other.requestMACSec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectionRequest").add("Location", location()).add("Bandwidth", bandwidth())
                .add("ConnectionName", connectionName()).add("LagId", lagId()).add("Tags", hasTags() ? tags() : null)
                .add("ProviderName", providerName()).add("RequestMACSec", requestMACSec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "bandwidth":
            return Optional.ofNullable(clazz.cast(bandwidth()));
        case "connectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "lagId":
            return Optional.ofNullable(clazz.cast(lagId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "providerName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "requestMACSec":
            return Optional.ofNullable(clazz.cast(requestMACSec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionRequest, T> g) {
        return obj -> g.apply((CreateConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateConnectionRequest> {
        /**
         * <p>
         * The location of the connection.
         * </p>
         * 
         * @param location
         *        The location of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The bandwidth of the connection.
         * </p>
         * 
         * @param bandwidth
         *        The bandwidth of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandwidth(String bandwidth);

        /**
         * <p>
         * The name of the connection.
         * </p>
         * 
         * @param connectionName
         *        The name of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * The ID of the LAG.
         * </p>
         * 
         * @param lagId
         *        The ID of the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lagId(String lagId);

        /**
         * <p>
         * The tags to associate with the lag.
         * </p>
         * 
         * @param tags
         *        The tags to associate with the lag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to associate with the lag.
         * </p>
         * 
         * @param tags
         *        The tags to associate with the lag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to associate with the lag.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The name of the service provider associated with the requested connection.
         * </p>
         * 
         * @param providerName
         *        The name of the service provider associated with the requested connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * Indicates whether you want the connection to support MAC Security (MACsec).
         * </p>
         * <p>
         * MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security (MACsec)
         * prerequisties, see <a href=
         * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites"
         * >MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.
         * </p>
         * 
         * @param requestMACSec
         *        Indicates whether you want the connection to support MAC Security (MACsec).</p>
         *        <p>
         *        MAC Security (MACsec) is only available on dedicated connections. For information about MAC Security
         *        (MACsec) prerequisties, see <a href=
         *        "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites"
         *        >MACsec prerequisties</a> in the <i>Direct Connect User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestMACSec(Boolean requestMACSec);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String location;

        private String bandwidth;

        private String connectionName;

        private String lagId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String providerName;

        private Boolean requestMACSec;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionRequest model) {
            super(model);
            location(model.location);
            bandwidth(model.bandwidth);
            connectionName(model.connectionName);
            lagId(model.lagId);
            tags(model.tags);
            providerName(model.providerName);
            requestMACSec(model.requestMACSec);
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        @Transient
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getBandwidth() {
            return bandwidth;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        @Override
        @Transient
        public final Builder bandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        @Transient
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getLagId() {
            return lagId;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        @Override
        @Transient
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProviderName() {
            return providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        @Transient
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final Boolean getRequestMACSec() {
            return requestMACSec;
        }

        public final void setRequestMACSec(Boolean requestMACSec) {
            this.requestMACSec = requestMACSec;
        }

        @Override
        @Transient
        public final Builder requestMACSec(Boolean requestMACSec) {
            this.requestMACSec = requestMACSec;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectionRequest build() {
            return new CreateConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
