/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The name and status of a customer agreement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerAgreement implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerAgreement.Builder, CustomerAgreement> {
    private static final SdkField<String> AGREEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agreementName").getter(getter(CustomerAgreement::agreementName)).setter(setter(Builder::agreementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CustomerAgreement::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGREEMENT_NAME_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agreementName;

    private final String status;

    private CustomerAgreement(BuilderImpl builder) {
        this.agreementName = builder.agreementName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the agreement.
     * </p>
     * 
     * @return The name of the agreement.
     */
    public final String agreementName() {
        return agreementName;
    }

    /**
     * <p>
     * The status of the customer agreement. This will be either <code>signed</code> or <code>unsigned</code>
     * </p>
     * 
     * @return The status of the customer agreement. This will be either <code>signed</code> or <code>unsigned</code>
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agreementName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerAgreement)) {
            return false;
        }
        CustomerAgreement other = (CustomerAgreement) obj;
        return Objects.equals(agreementName(), other.agreementName()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerAgreement").add("AgreementName", agreementName()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agreementName":
            return Optional.ofNullable(clazz.cast(agreementName()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerAgreement, T> g) {
        return obj -> g.apply((CustomerAgreement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerAgreement> {
        /**
         * <p>
         * The name of the agreement.
         * </p>
         * 
         * @param agreementName
         *        The name of the agreement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementName(String agreementName);

        /**
         * <p>
         * The status of the customer agreement. This will be either <code>signed</code> or <code>unsigned</code>
         * </p>
         * 
         * @param status
         *        The status of the customer agreement. This will be either <code>signed</code> or <code>unsigned</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String agreementName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerAgreement model) {
            agreementName(model.agreementName);
            status(model.status);
        }

        public final String getAgreementName() {
            return agreementName;
        }

        public final void setAgreementName(String agreementName) {
            this.agreementName = agreementName;
        }

        @Override
        @Transient
        public final Builder agreementName(String agreementName) {
            this.agreementName = agreementName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public CustomerAgreement build() {
            return new CustomerAgreement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
