/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBgpPeerRequest extends DirectConnectRequest implements
        ToCopyableBuilder<DeleteBgpPeerRequest.Builder, DeleteBgpPeerRequest> {
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceId").getter(getter(DeleteBgpPeerRequest::virtualInterfaceId))
            .setter(setter(Builder::virtualInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build())
            .build();

    private static final SdkField<Integer> ASN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("asn")
            .getter(getter(DeleteBgpPeerRequest::asn)).setter(setter(Builder::asn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asn").build()).build();

    private static final SdkField<String> CUSTOMER_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerAddress").getter(getter(DeleteBgpPeerRequest::customerAddress))
            .setter(setter(Builder::customerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAddress").build()).build();

    private static final SdkField<String> BGP_PEER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bgpPeerId").getter(getter(DeleteBgpPeerRequest::bgpPeerId)).setter(setter(Builder::bgpPeerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bgpPeerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_ID_FIELD,
            ASN_FIELD, CUSTOMER_ADDRESS_FIELD, BGP_PEER_ID_FIELD));

    private final String virtualInterfaceId;

    private final Integer asn;

    private final String customerAddress;

    private final String bgpPeerId;

    private DeleteBgpPeerRequest(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.asn = builder.asn;
        this.customerAddress = builder.customerAddress;
        this.bgpPeerId = builder.bgpPeerId;
    }

    /**
     * <p>
     * The ID of the virtual interface.
     * </p>
     * 
     * @return The ID of the virtual interface.
     */
    public final String virtualInterfaceId() {
        return virtualInterfaceId;
    }

    /**
     * <p>
     * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     * </p>
     * 
     * @return The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    public final Integer asn() {
        return asn;
    }

    /**
     * <p>
     * The IP address assigned to the customer interface.
     * </p>
     * 
     * @return The IP address assigned to the customer interface.
     */
    public final String customerAddress() {
        return customerAddress;
    }

    /**
     * <p>
     * The ID of the BGP peer.
     * </p>
     * 
     * @return The ID of the BGP peer.
     */
    public final String bgpPeerId() {
        return bgpPeerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(asn());
        hashCode = 31 * hashCode + Objects.hashCode(customerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(bgpPeerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBgpPeerRequest)) {
            return false;
        }
        DeleteBgpPeerRequest other = (DeleteBgpPeerRequest) obj;
        return Objects.equals(virtualInterfaceId(), other.virtualInterfaceId()) && Objects.equals(asn(), other.asn())
                && Objects.equals(customerAddress(), other.customerAddress()) && Objects.equals(bgpPeerId(), other.bgpPeerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBgpPeerRequest").add("VirtualInterfaceId", virtualInterfaceId()).add("Asn", asn())
                .add("CustomerAddress", customerAddress()).add("BgpPeerId", bgpPeerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualInterfaceId":
            return Optional.ofNullable(clazz.cast(virtualInterfaceId()));
        case "asn":
            return Optional.ofNullable(clazz.cast(asn()));
        case "customerAddress":
            return Optional.ofNullable(clazz.cast(customerAddress()));
        case "bgpPeerId":
            return Optional.ofNullable(clazz.cast(bgpPeerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteBgpPeerRequest, T> g) {
        return obj -> g.apply((DeleteBgpPeerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBgpPeerRequest> {
        /**
         * <p>
         * The ID of the virtual interface.
         * </p>
         * 
         * @param virtualInterfaceId
         *        The ID of the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceId(String virtualInterfaceId);

        /**
         * <p>
         * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
         * </p>
         * 
         * @param asn
         *        The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asn(Integer asn);

        /**
         * <p>
         * The IP address assigned to the customer interface.
         * </p>
         * 
         * @param customerAddress
         *        The IP address assigned to the customer interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerAddress(String customerAddress);

        /**
         * <p>
         * The ID of the BGP peer.
         * </p>
         * 
         * @param bgpPeerId
         *        The ID of the BGP peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpPeerId(String bgpPeerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String virtualInterfaceId;

        private Integer asn;

        private String customerAddress;

        private String bgpPeerId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBgpPeerRequest model) {
            super(model);
            virtualInterfaceId(model.virtualInterfaceId);
            asn(model.asn);
            customerAddress(model.customerAddress);
            bgpPeerId(model.bgpPeerId);
        }

        public final String getVirtualInterfaceId() {
            return virtualInterfaceId;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        @Transient
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final Integer getAsn() {
            return asn;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        @Override
        @Transient
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final String getCustomerAddress() {
            return customerAddress;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        @Override
        @Transient
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final String getBgpPeerId() {
            return bgpPeerId;
        }

        public final void setBgpPeerId(String bgpPeerId) {
            this.bgpPeerId = bgpPeerId;
        }

        @Override
        @Transient
        public final Builder bgpPeerId(String bgpPeerId) {
            this.bgpPeerId = bgpPeerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBgpPeerRequest build() {
            return new DeleteBgpPeerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
