/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLoaRequest extends DirectConnectRequest implements
        ToCopyableBuilder<DescribeLoaRequest.Builder, DescribeLoaRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionId").getter(getter(DescribeLoaRequest::connectionId)).setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerName").getter(getter(DescribeLoaRequest::providerName)).setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()).build();

    private static final SdkField<String> LOA_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("loaContentType").getter(getter(DescribeLoaRequest::loaContentTypeAsString))
            .setter(setter(Builder::loaContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loaContentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD,
            PROVIDER_NAME_FIELD, LOA_CONTENT_TYPE_FIELD));

    private final String connectionId;

    private final String providerName;

    private final String loaContentType;

    private DescribeLoaRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.providerName = builder.providerName;
        this.loaContentType = builder.loaContentType;
    }

    /**
     * <p>
     * The ID of a connection, LAG, or interconnect.
     * </p>
     * 
     * @return The ID of a connection, LAG, or interconnect.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The name of the service provider who establishes connectivity on your behalf. If you specify this parameter, the
     * LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.
     * </p>
     * 
     * @return The name of the service provider who establishes connectivity on your behalf. If you specify this
     *         parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the cross
     *         connect.
     */
    public final String providerName() {
        return providerName;
    }

    /**
     * <p>
     * The standard media type for the LOA-CFA document. The only supported value is application/pdf.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #loaContentType}
     * will return {@link LoaContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #loaContentTypeAsString}.
     * </p>
     * 
     * @return The standard media type for the LOA-CFA document. The only supported value is application/pdf.
     * @see LoaContentType
     */
    public final LoaContentType loaContentType() {
        return LoaContentType.fromValue(loaContentType);
    }

    /**
     * <p>
     * The standard media type for the LOA-CFA document. The only supported value is application/pdf.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #loaContentType}
     * will return {@link LoaContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #loaContentTypeAsString}.
     * </p>
     * 
     * @return The standard media type for the LOA-CFA document. The only supported value is application/pdf.
     * @see LoaContentType
     */
    public final String loaContentTypeAsString() {
        return loaContentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(loaContentTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoaRequest)) {
            return false;
        }
        DescribeLoaRequest other = (DescribeLoaRequest) obj;
        return Objects.equals(connectionId(), other.connectionId()) && Objects.equals(providerName(), other.providerName())
                && Objects.equals(loaContentTypeAsString(), other.loaContentTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLoaRequest").add("ConnectionId", connectionId()).add("ProviderName", providerName())
                .add("LoaContentType", loaContentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "providerName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "loaContentType":
            return Optional.ofNullable(clazz.cast(loaContentTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoaRequest, T> g) {
        return obj -> g.apply((DescribeLoaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLoaRequest> {
        /**
         * <p>
         * The ID of a connection, LAG, or interconnect.
         * </p>
         * 
         * @param connectionId
         *        The ID of a connection, LAG, or interconnect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The name of the service provider who establishes connectivity on your behalf. If you specify this parameter,
         * the LOA-CFA lists the provider name alongside your company name as the requester of the cross connect.
         * </p>
         * 
         * @param providerName
         *        The name of the service provider who establishes connectivity on your behalf. If you specify this
         *        parameter, the LOA-CFA lists the provider name alongside your company name as the requester of the
         *        cross connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The standard media type for the LOA-CFA document. The only supported value is application/pdf.
         * </p>
         * 
         * @param loaContentType
         *        The standard media type for the LOA-CFA document. The only supported value is application/pdf.
         * @see LoaContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoaContentType
         */
        Builder loaContentType(String loaContentType);

        /**
         * <p>
         * The standard media type for the LOA-CFA document. The only supported value is application/pdf.
         * </p>
         * 
         * @param loaContentType
         *        The standard media type for the LOA-CFA document. The only supported value is application/pdf.
         * @see LoaContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoaContentType
         */
        Builder loaContentType(LoaContentType loaContentType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String connectionId;

        private String providerName;

        private String loaContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoaRequest model) {
            super(model);
            connectionId(model.connectionId);
            providerName(model.providerName);
            loaContentType(model.loaContentType);
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        @Transient
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getProviderName() {
            return providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        @Transient
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final String getLoaContentType() {
            return loaContentType;
        }

        public final void setLoaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
        }

        @Override
        @Transient
        public final Builder loaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
            return this;
        }

        @Override
        @Transient
        public final Builder loaContentType(LoaContentType loaContentType) {
            this.loaContentType(loaContentType == null ? null : loaContentType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLoaRequest build() {
            return new DescribeLoaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
