/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details about a virtual interface's router.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRouterConfigurationRequest extends DirectConnectRequest implements
        ToCopyableBuilder<DescribeRouterConfigurationRequest.Builder, DescribeRouterConfigurationRequest> {
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceId").getter(getter(DescribeRouterConfigurationRequest::virtualInterfaceId))
            .setter(setter(Builder::virtualInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build())
            .build();

    private static final SdkField<String> ROUTER_TYPE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("routerTypeIdentifier").getter(getter(DescribeRouterConfigurationRequest::routerTypeIdentifier))
            .setter(setter(Builder::routerTypeIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerTypeIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_ID_FIELD,
            ROUTER_TYPE_IDENTIFIER_FIELD));

    private final String virtualInterfaceId;

    private final String routerTypeIdentifier;

    private DescribeRouterConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.routerTypeIdentifier = builder.routerTypeIdentifier;
    }

    /**
     * <p>
     * The ID of the virtual interface.
     * </p>
     * 
     * @return The ID of the virtual interface.
     */
    public final String virtualInterfaceId() {
        return virtualInterfaceId;
    }

    /**
     * <p>
     * Identifies the router by a combination of vendor, platform, and software version. For example,
     * <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.
     * </p>
     * 
     * @return Identifies the router by a combination of vendor, platform, and software version. For example,
     *         <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.
     */
    public final String routerTypeIdentifier() {
        return routerTypeIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(routerTypeIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouterConfigurationRequest)) {
            return false;
        }
        DescribeRouterConfigurationRequest other = (DescribeRouterConfigurationRequest) obj;
        return Objects.equals(virtualInterfaceId(), other.virtualInterfaceId())
                && Objects.equals(routerTypeIdentifier(), other.routerTypeIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRouterConfigurationRequest").add("VirtualInterfaceId", virtualInterfaceId())
                .add("RouterTypeIdentifier", routerTypeIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualInterfaceId":
            return Optional.ofNullable(clazz.cast(virtualInterfaceId()));
        case "routerTypeIdentifier":
            return Optional.ofNullable(clazz.cast(routerTypeIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRouterConfigurationRequest, T> g) {
        return obj -> g.apply((DescribeRouterConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRouterConfigurationRequest> {
        /**
         * <p>
         * The ID of the virtual interface.
         * </p>
         * 
         * @param virtualInterfaceId
         *        The ID of the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceId(String virtualInterfaceId);

        /**
         * <p>
         * Identifies the router by a combination of vendor, platform, and software version. For example,
         * <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.
         * </p>
         * 
         * @param routerTypeIdentifier
         *        Identifies the router by a combination of vendor, platform, and software version. For example,
         *        <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routerTypeIdentifier(String routerTypeIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String virtualInterfaceId;

        private String routerTypeIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouterConfigurationRequest model) {
            super(model);
            virtualInterfaceId(model.virtualInterfaceId);
            routerTypeIdentifier(model.routerTypeIdentifier);
        }

        public final String getVirtualInterfaceId() {
            return virtualInterfaceId;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        @Transient
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final String getRouterTypeIdentifier() {
            return routerTypeIdentifier;
        }

        public final void setRouterTypeIdentifier(String routerTypeIdentifier) {
            this.routerTypeIdentifier = routerTypeIdentifier;
        }

        @Override
        @Transient
        public final Builder routerTypeIdentifier(String routerTypeIdentifier) {
            this.routerTypeIdentifier = routerTypeIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRouterConfigurationRequest build() {
            return new DescribeRouterConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
