/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateMacSecKeyRequest extends DirectConnectRequest implements
        ToCopyableBuilder<DisassociateMacSecKeyRequest.Builder, DisassociateMacSecKeyRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionId").getter(getter(DisassociateMacSecKeyRequest::connectionId))
            .setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretARN").getter(getter(DisassociateMacSecKeyRequest::secretARN)).setter(setter(Builder::secretARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD,
            SECRET_ARN_FIELD));

    private final String connectionId;

    private final String secretARN;

    private DisassociateMacSecKeyRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.secretARN = builder.secretARN;
    }

    /**
     * <p>
     * The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).
     * </p>
     * <p>
     * You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.
     * </p>
     * 
     * @return The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
     *         <p>
     *         You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.
     * </p>
     * <p>
     * You can use <a>DescribeConnections</a> to retrieve the ARN of the MAC Security (MACsec) secret key.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.</p>
     *         <p>
     *         You can use <a>DescribeConnections</a> to retrieve the ARN of the MAC Security (MACsec) secret key.
     */
    public final String secretARN() {
        return secretARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(secretARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateMacSecKeyRequest)) {
            return false;
        }
        DisassociateMacSecKeyRequest other = (DisassociateMacSecKeyRequest) obj;
        return Objects.equals(connectionId(), other.connectionId()) && Objects.equals(secretARN(), other.secretARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateMacSecKeyRequest").add("ConnectionId", connectionId()).add("SecretARN", secretARN())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "secretARN":
            return Optional.ofNullable(clazz.cast(secretARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateMacSecKeyRequest, T> g) {
        return obj -> g.apply((DisassociateMacSecKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateMacSecKeyRequest> {
        /**
         * <p>
         * The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).
         * </p>
         * <p>
         * You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.
         * </p>
         * 
         * @param connectionId
         *        The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).</p>
         *        <p>
         *        You can use <a>DescribeConnections</a> or <a>DescribeLags</a> to retrieve connection ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.
         * </p>
         * <p>
         * You can use <a>DescribeConnections</a> to retrieve the ARN of the MAC Security (MACsec) secret key.
         * </p>
         * 
         * @param secretARN
         *        The Amazon Resource Name (ARN) of the MAC Security (MACsec) secret key.</p>
         *        <p>
         *        You can use <a>DescribeConnections</a> to retrieve the ARN of the MAC Security (MACsec) secret key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretARN(String secretARN);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String connectionId;

        private String secretARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateMacSecKeyRequest model) {
            super(model);
            connectionId(model.connectionId);
            secretARN(model.secretARN);
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        @Transient
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getSecretARN() {
            return secretARN;
        }

        public final void setSecretARN(String secretARN) {
            this.secretARN = secretARN;
        }

        @Override
        @Transient
        public final Builder secretARN(String secretARN) {
            this.secretARN = secretARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateMacSecKeyRequest build() {
            return new DisassociateMacSecKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
