/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the virtual router.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouterType implements SdkPojo, Serializable, ToCopyableBuilder<RouterType.Builder, RouterType> {
    private static final SdkField<String> VENDOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vendor")
            .getter(getter(RouterType::vendor)).setter(setter(Builder::vendor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendor").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(RouterType::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> SOFTWARE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("software").getter(getter(RouterType::software)).setter(setter(Builder::software))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("software").build()).build();

    private static final SdkField<String> XSLT_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("xsltTemplateName").getter(getter(RouterType::xsltTemplateName))
            .setter(setter(Builder::xsltTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xsltTemplateName").build()).build();

    private static final SdkField<String> XSLT_TEMPLATE_NAME_FOR_MAC_SEC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("xsltTemplateNameForMacSec")
            .getter(getter(RouterType::xsltTemplateNameForMacSec)).setter(setter(Builder::xsltTemplateNameForMacSec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xsltTemplateNameForMacSec").build())
            .build();

    private static final SdkField<String> ROUTER_TYPE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("routerTypeIdentifier").getter(getter(RouterType::routerTypeIdentifier))
            .setter(setter(Builder::routerTypeIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerTypeIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VENDOR_FIELD, PLATFORM_FIELD,
            SOFTWARE_FIELD, XSLT_TEMPLATE_NAME_FIELD, XSLT_TEMPLATE_NAME_FOR_MAC_SEC_FIELD, ROUTER_TYPE_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vendor;

    private final String platform;

    private final String software;

    private final String xsltTemplateName;

    private final String xsltTemplateNameForMacSec;

    private final String routerTypeIdentifier;

    private RouterType(BuilderImpl builder) {
        this.vendor = builder.vendor;
        this.platform = builder.platform;
        this.software = builder.software;
        this.xsltTemplateName = builder.xsltTemplateName;
        this.xsltTemplateNameForMacSec = builder.xsltTemplateNameForMacSec;
        this.routerTypeIdentifier = builder.routerTypeIdentifier;
    }

    /**
     * <p>
     * The vendor for the virtual interface's router.
     * </p>
     * 
     * @return The vendor for the virtual interface's router.
     */
    public final String vendor() {
        return vendor;
    }

    /**
     * <p>
     * The virtual interface router platform.
     * </p>
     * 
     * @return The virtual interface router platform.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The router software.
     * </p>
     * 
     * @return The router software.
     */
    public final String software() {
        return software;
    }

    /**
     * <p>
     * The template for the virtual interface's router.
     * </p>
     * 
     * @return The template for the virtual interface's router.
     */
    public final String xsltTemplateName() {
        return xsltTemplateName;
    }

    /**
     * <p>
     * The MAC Security (MACsec) template for the virtual interface's router.
     * </p>
     * 
     * @return The MAC Security (MACsec) template for the virtual interface's router.
     */
    public final String xsltTemplateNameForMacSec() {
        return xsltTemplateNameForMacSec;
    }

    /**
     * <p>
     * Identifies the router by a combination of vendor, platform, and software version. For example,
     * <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.
     * </p>
     * 
     * @return Identifies the router by a combination of vendor, platform, and software version. For example,
     *         <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.
     */
    public final String routerTypeIdentifier() {
        return routerTypeIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vendor());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(software());
        hashCode = 31 * hashCode + Objects.hashCode(xsltTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(xsltTemplateNameForMacSec());
        hashCode = 31 * hashCode + Objects.hashCode(routerTypeIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterType)) {
            return false;
        }
        RouterType other = (RouterType) obj;
        return Objects.equals(vendor(), other.vendor()) && Objects.equals(platform(), other.platform())
                && Objects.equals(software(), other.software()) && Objects.equals(xsltTemplateName(), other.xsltTemplateName())
                && Objects.equals(xsltTemplateNameForMacSec(), other.xsltTemplateNameForMacSec())
                && Objects.equals(routerTypeIdentifier(), other.routerTypeIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouterType").add("Vendor", vendor()).add("Platform", platform()).add("Software", software())
                .add("XsltTemplateName", xsltTemplateName()).add("XsltTemplateNameForMacSec", xsltTemplateNameForMacSec())
                .add("RouterTypeIdentifier", routerTypeIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vendor":
            return Optional.ofNullable(clazz.cast(vendor()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "software":
            return Optional.ofNullable(clazz.cast(software()));
        case "xsltTemplateName":
            return Optional.ofNullable(clazz.cast(xsltTemplateName()));
        case "xsltTemplateNameForMacSec":
            return Optional.ofNullable(clazz.cast(xsltTemplateNameForMacSec()));
        case "routerTypeIdentifier":
            return Optional.ofNullable(clazz.cast(routerTypeIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouterType, T> g) {
        return obj -> g.apply((RouterType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouterType> {
        /**
         * <p>
         * The vendor for the virtual interface's router.
         * </p>
         * 
         * @param vendor
         *        The vendor for the virtual interface's router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendor(String vendor);

        /**
         * <p>
         * The virtual interface router platform.
         * </p>
         * 
         * @param platform
         *        The virtual interface router platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The router software.
         * </p>
         * 
         * @param software
         *        The router software.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder software(String software);

        /**
         * <p>
         * The template for the virtual interface's router.
         * </p>
         * 
         * @param xsltTemplateName
         *        The template for the virtual interface's router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xsltTemplateName(String xsltTemplateName);

        /**
         * <p>
         * The MAC Security (MACsec) template for the virtual interface's router.
         * </p>
         * 
         * @param xsltTemplateNameForMacSec
         *        The MAC Security (MACsec) template for the virtual interface's router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xsltTemplateNameForMacSec(String xsltTemplateNameForMacSec);

        /**
         * <p>
         * Identifies the router by a combination of vendor, platform, and software version. For example,
         * <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.
         * </p>
         * 
         * @param routerTypeIdentifier
         *        Identifies the router by a combination of vendor, platform, and software version. For example,
         *        <code>CiscoSystemsInc-2900SeriesRouters-IOS124</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routerTypeIdentifier(String routerTypeIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String vendor;

        private String platform;

        private String software;

        private String xsltTemplateName;

        private String xsltTemplateNameForMacSec;

        private String routerTypeIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RouterType model) {
            vendor(model.vendor);
            platform(model.platform);
            software(model.software);
            xsltTemplateName(model.xsltTemplateName);
            xsltTemplateNameForMacSec(model.xsltTemplateNameForMacSec);
            routerTypeIdentifier(model.routerTypeIdentifier);
        }

        public final String getVendor() {
            return vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        @Transient
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getSoftware() {
            return software;
        }

        public final void setSoftware(String software) {
            this.software = software;
        }

        @Override
        @Transient
        public final Builder software(String software) {
            this.software = software;
            return this;
        }

        public final String getXsltTemplateName() {
            return xsltTemplateName;
        }

        public final void setXsltTemplateName(String xsltTemplateName) {
            this.xsltTemplateName = xsltTemplateName;
        }

        @Override
        @Transient
        public final Builder xsltTemplateName(String xsltTemplateName) {
            this.xsltTemplateName = xsltTemplateName;
            return this;
        }

        public final String getXsltTemplateNameForMacSec() {
            return xsltTemplateNameForMacSec;
        }

        public final void setXsltTemplateNameForMacSec(String xsltTemplateNameForMacSec) {
            this.xsltTemplateNameForMacSec = xsltTemplateNameForMacSec;
        }

        @Override
        @Transient
        public final Builder xsltTemplateNameForMacSec(String xsltTemplateNameForMacSec) {
            this.xsltTemplateNameForMacSec = xsltTemplateNameForMacSec;
            return this;
        }

        public final String getRouterTypeIdentifier() {
            return routerTypeIdentifier;
        }

        public final void setRouterTypeIdentifier(String routerTypeIdentifier) {
            this.routerTypeIdentifier = routerTypeIdentifier;
        }

        @Override
        @Transient
        public final Builder routerTypeIdentifier(String routerTypeIdentifier) {
            this.routerTypeIdentifier = routerTypeIdentifier;
            return this;
        }

        @Override
        public RouterType build() {
            return new RouterType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
