/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a link aggregation group (LAG).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLagResponse extends DirectConnectResponse implements
        ToCopyableBuilder<UpdateLagResponse.Builder, UpdateLagResponse> {
    private static final SdkField<String> CONNECTIONS_BANDWIDTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionsBandwidth").getter(getter(UpdateLagResponse::connectionsBandwidth))
            .setter(setter(Builder::connectionsBandwidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionsBandwidth").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_CONNECTIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfConnections").getter(getter(UpdateLagResponse::numberOfConnections))
            .setter(setter(Builder::numberOfConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfConnections").build())
            .build();

    private static final SdkField<String> LAG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("lagId")
            .getter(getter(UpdateLagResponse::lagId)).setter(setter(Builder::lagId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagId").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerAccount").getter(getter(UpdateLagResponse::ownerAccount)).setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()).build();

    private static final SdkField<String> LAG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lagName").getter(getter(UpdateLagResponse::lagName)).setter(setter(Builder::lagName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagName").build()).build();

    private static final SdkField<String> LAG_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lagState").getter(getter(UpdateLagResponse::lagStateAsString)).setter(setter(Builder::lagState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagState").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(UpdateLagResponse::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(UpdateLagResponse::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<Integer> MINIMUM_LINKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minimumLinks").getter(getter(UpdateLagResponse::minimumLinks)).setter(setter(Builder::minimumLinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLinks").build()).build();

    private static final SdkField<String> AWS_DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsDevice").getter(getter(UpdateLagResponse::awsDevice)).setter(setter(Builder::awsDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDevice").build()).build();

    private static final SdkField<String> AWS_DEVICE_V2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsDeviceV2").getter(getter(UpdateLagResponse::awsDeviceV2)).setter(setter(Builder::awsDeviceV2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDeviceV2").build()).build();

    private static final SdkField<String> AWS_LOGICAL_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsLogicalDeviceId").getter(getter(UpdateLagResponse::awsLogicalDeviceId))
            .setter(setter(Builder::awsLogicalDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLogicalDeviceId").build())
            .build();

    private static final SdkField<List<Connection>> CONNECTIONS_FIELD = SdkField
            .<List<Connection>> builder(MarshallingType.LIST)
            .memberName("connections")
            .getter(getter(UpdateLagResponse::connections))
            .setter(setter(Builder::connections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Connection> builder(MarshallingType.SDK_POJO)
                                            .constructor(Connection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALLOWS_HOSTED_CONNECTIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowsHostedConnections").getter(getter(UpdateLagResponse::allowsHostedConnections))
            .setter(setter(Builder::allowsHostedConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowsHostedConnections").build())
            .build();

    private static final SdkField<Boolean> JUMBO_FRAME_CAPABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("jumboFrameCapable").getter(getter(UpdateLagResponse::jumboFrameCapable))
            .setter(setter(Builder::jumboFrameCapable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jumboFrameCapable").build()).build();

    private static final SdkField<String> HAS_LOGICAL_REDUNDANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hasLogicalRedundancy").getter(getter(UpdateLagResponse::hasLogicalRedundancyAsString))
            .setter(setter(Builder::hasLogicalRedundancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasLogicalRedundancy").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(UpdateLagResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerName").getter(getter(UpdateLagResponse::providerName)).setter(setter(Builder::providerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()).build();

    private static final SdkField<Boolean> MAC_SEC_CAPABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("macSecCapable").getter(getter(UpdateLagResponse::macSecCapable)).setter(setter(Builder::macSecCapable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macSecCapable").build()).build();

    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionMode").getter(getter(UpdateLagResponse::encryptionMode))
            .setter(setter(Builder::encryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionMode").build()).build();

    private static final SdkField<List<MacSecKey>> MAC_SEC_KEYS_FIELD = SdkField
            .<List<MacSecKey>> builder(MarshallingType.LIST)
            .memberName("macSecKeys")
            .getter(getter(UpdateLagResponse::macSecKeys))
            .setter(setter(Builder::macSecKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macSecKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MacSecKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(MacSecKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTIONS_BANDWIDTH_FIELD,
            NUMBER_OF_CONNECTIONS_FIELD, LAG_ID_FIELD, OWNER_ACCOUNT_FIELD, LAG_NAME_FIELD, LAG_STATE_FIELD, LOCATION_FIELD,
            REGION_FIELD, MINIMUM_LINKS_FIELD, AWS_DEVICE_FIELD, AWS_DEVICE_V2_FIELD, AWS_LOGICAL_DEVICE_ID_FIELD,
            CONNECTIONS_FIELD, ALLOWS_HOSTED_CONNECTIONS_FIELD, JUMBO_FRAME_CAPABLE_FIELD, HAS_LOGICAL_REDUNDANCY_FIELD,
            TAGS_FIELD, PROVIDER_NAME_FIELD, MAC_SEC_CAPABLE_FIELD, ENCRYPTION_MODE_FIELD, MAC_SEC_KEYS_FIELD));

    private final String connectionsBandwidth;

    private final Integer numberOfConnections;

    private final String lagId;

    private final String ownerAccount;

    private final String lagName;

    private final String lagState;

    private final String location;

    private final String region;

    private final Integer minimumLinks;

    private final String awsDevice;

    private final String awsDeviceV2;

    private final String awsLogicalDeviceId;

    private final List<Connection> connections;

    private final Boolean allowsHostedConnections;

    private final Boolean jumboFrameCapable;

    private final String hasLogicalRedundancy;

    private final List<Tag> tags;

    private final String providerName;

    private final Boolean macSecCapable;

    private final String encryptionMode;

    private final List<MacSecKey> macSecKeys;

    private UpdateLagResponse(BuilderImpl builder) {
        super(builder);
        this.connectionsBandwidth = builder.connectionsBandwidth;
        this.numberOfConnections = builder.numberOfConnections;
        this.lagId = builder.lagId;
        this.ownerAccount = builder.ownerAccount;
        this.lagName = builder.lagName;
        this.lagState = builder.lagState;
        this.location = builder.location;
        this.region = builder.region;
        this.minimumLinks = builder.minimumLinks;
        this.awsDevice = builder.awsDevice;
        this.awsDeviceV2 = builder.awsDeviceV2;
        this.awsLogicalDeviceId = builder.awsLogicalDeviceId;
        this.connections = builder.connections;
        this.allowsHostedConnections = builder.allowsHostedConnections;
        this.jumboFrameCapable = builder.jumboFrameCapable;
        this.hasLogicalRedundancy = builder.hasLogicalRedundancy;
        this.tags = builder.tags;
        this.providerName = builder.providerName;
        this.macSecCapable = builder.macSecCapable;
        this.encryptionMode = builder.encryptionMode;
        this.macSecKeys = builder.macSecKeys;
    }

    /**
     * <p>
     * The individual bandwidth of the physical connections bundled by the LAG. The possible values are 1Gbps and
     * 10Gbps.
     * </p>
     * 
     * @return The individual bandwidth of the physical connections bundled by the LAG. The possible values are 1Gbps
     *         and 10Gbps.
     */
    public final String connectionsBandwidth() {
        return connectionsBandwidth;
    }

    /**
     * <p>
     * The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.
     * </p>
     * 
     * @return The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.
     */
    public final Integer numberOfConnections() {
        return numberOfConnections;
    }

    /**
     * <p>
     * The ID of the LAG.
     * </p>
     * 
     * @return The ID of the LAG.
     */
    public final String lagId() {
        return lagId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the LAG.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the LAG.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * The name of the LAG.
     * </p>
     * 
     * @return The name of the LAG.
     */
    public final String lagName() {
        return lagName;
    }

    /**
     * <p>
     * The state of the LAG. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>requested</code>: The initial state of a LAG. The LAG stays in the requested state until the Letter of
     * Authorization (LOA) is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: The LAG has been approved and is being initialized.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code>: The network link is established and the LAG is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>down</code>: The network link is down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: The LAG is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: The LAG is deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown</code>: The state of the LAG is not available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lagState} will
     * return {@link LagState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lagStateAsString}.
     * </p>
     * 
     * @return The state of the LAG. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>requested</code>: The initial state of a LAG. The LAG stays in the requested state until the Letter
     *         of Authorization (LOA) is available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: The LAG has been approved and is being initialized.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code>: The network link is established and the LAG is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>down</code>: The network link is down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: The LAG is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: The LAG is deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown</code>: The state of the LAG is not available.
     *         </p>
     *         </li>
     * @see LagState
     */
    public final LagState lagState() {
        return LagState.fromValue(lagState);
    }

    /**
     * <p>
     * The state of the LAG. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>requested</code>: The initial state of a LAG. The LAG stays in the requested state until the Letter of
     * Authorization (LOA) is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: The LAG has been approved and is being initialized.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code>: The network link is established and the LAG is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>down</code>: The network link is down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: The LAG is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: The LAG is deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown</code>: The state of the LAG is not available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lagState} will
     * return {@link LagState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lagStateAsString}.
     * </p>
     * 
     * @return The state of the LAG. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>requested</code>: The initial state of a LAG. The LAG stays in the requested state until the Letter
     *         of Authorization (LOA) is available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: The LAG has been approved and is being initialized.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code>: The network link is established and the LAG is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>down</code>: The network link is down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: The LAG is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: The LAG is deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown</code>: The state of the LAG is not available.
     *         </p>
     *         </li>
     * @see LagState
     */
    public final String lagStateAsString() {
        return lagState;
    }

    /**
     * <p>
     * The location of the LAG.
     * </p>
     * 
     * @return The location of the LAG.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the connection is located.
     * </p>
     * 
     * @return The Amazon Web Services Region where the connection is located.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The minimum number of physical dedicated connections that must be operational for the LAG itself to be
     * operational.
     * </p>
     * 
     * @return The minimum number of physical dedicated connections that must be operational for the LAG itself to be
     *         operational.
     */
    public final Integer minimumLinks() {
        return minimumLinks;
    }

    /**
     * <p>
     * The Direct Connect endpoint that hosts the LAG.
     * </p>
     * 
     * @return The Direct Connect endpoint that hosts the LAG.
     */
    public final String awsDevice() {
        return awsDevice;
    }

    /**
     * <p>
     * The Direct Connect endpoint that hosts the LAG.
     * </p>
     * 
     * @return The Direct Connect endpoint that hosts the LAG.
     */
    public final String awsDeviceV2() {
        return awsDeviceV2;
    }

    /**
     * <p>
     * The Direct Connect endpoint that terminates the logical connection. This device might be different than the
     * device that terminates the physical connection.
     * </p>
     * 
     * @return The Direct Connect endpoint that terminates the logical connection. This device might be different than
     *         the device that terminates the physical connection.
     */
    public final String awsLogicalDeviceId() {
        return awsLogicalDeviceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Connections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnections() {
        return connections != null && !(connections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The connections bundled by the LAG.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnections} method.
     * </p>
     * 
     * @return The connections bundled by the LAG.
     */
    public final List<Connection> connections() {
        return connections;
    }

    /**
     * <p>
     * Indicates whether the LAG can host other connections.
     * </p>
     * 
     * @return Indicates whether the LAG can host other connections.
     */
    public final Boolean allowsHostedConnections() {
        return allowsHostedConnections;
    }

    /**
     * <p>
     * Indicates whether jumbo frames (9001 MTU) are supported.
     * </p>
     * 
     * @return Indicates whether jumbo frames (9001 MTU) are supported.
     */
    public final Boolean jumboFrameCapable() {
        return jumboFrameCapable;
    }

    /**
     * <p>
     * Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hasLogicalRedundancy} will return {@link HasLogicalRedundancy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #hasLogicalRedundancyAsString}.
     * </p>
     * 
     * @return Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).
     * @see HasLogicalRedundancy
     */
    public final HasLogicalRedundancy hasLogicalRedundancy() {
        return HasLogicalRedundancy.fromValue(hasLogicalRedundancy);
    }

    /**
     * <p>
     * Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hasLogicalRedundancy} will return {@link HasLogicalRedundancy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #hasLogicalRedundancyAsString}.
     * </p>
     * 
     * @return Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).
     * @see HasLogicalRedundancy
     */
    public final String hasLogicalRedundancyAsString() {
        return hasLogicalRedundancy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the LAG.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the LAG.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the service provider associated with the LAG.
     * </p>
     * 
     * @return The name of the service provider associated with the LAG.
     */
    public final String providerName() {
        return providerName;
    }

    /**
     * <p>
     * Indicates whether the LAG supports MAC Security (MACsec).
     * </p>
     * 
     * @return Indicates whether the LAG supports MAC Security (MACsec).
     */
    public final Boolean macSecCapable() {
        return macSecCapable;
    }

    /**
     * <p>
     * The LAG MAC Security (MACsec) encryption mode.
     * </p>
     * <p>
     * The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.
     * </p>
     * 
     * @return The LAG MAC Security (MACsec) encryption mode.</p>
     *         <p>
     *         The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.
     */
    public final String encryptionMode() {
        return encryptionMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the MacSecKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMacSecKeys() {
        return macSecKeys != null && !(macSecKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The MAC Security (MACsec) security keys associated with the LAG.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMacSecKeys} method.
     * </p>
     * 
     * @return The MAC Security (MACsec) security keys associated with the LAG.
     */
    public final List<MacSecKey> macSecKeys() {
        return macSecKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionsBandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfConnections());
        hashCode = 31 * hashCode + Objects.hashCode(lagId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(lagName());
        hashCode = 31 * hashCode + Objects.hashCode(lagStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(minimumLinks());
        hashCode = 31 * hashCode + Objects.hashCode(awsDevice());
        hashCode = 31 * hashCode + Objects.hashCode(awsDeviceV2());
        hashCode = 31 * hashCode + Objects.hashCode(awsLogicalDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnections() ? connections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowsHostedConnections());
        hashCode = 31 * hashCode + Objects.hashCode(jumboFrameCapable());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogicalRedundancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(macSecCapable());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionMode());
        hashCode = 31 * hashCode + Objects.hashCode(hasMacSecKeys() ? macSecKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLagResponse)) {
            return false;
        }
        UpdateLagResponse other = (UpdateLagResponse) obj;
        return Objects.equals(connectionsBandwidth(), other.connectionsBandwidth())
                && Objects.equals(numberOfConnections(), other.numberOfConnections()) && Objects.equals(lagId(), other.lagId())
                && Objects.equals(ownerAccount(), other.ownerAccount()) && Objects.equals(lagName(), other.lagName())
                && Objects.equals(lagStateAsString(), other.lagStateAsString()) && Objects.equals(location(), other.location())
                && Objects.equals(region(), other.region()) && Objects.equals(minimumLinks(), other.minimumLinks())
                && Objects.equals(awsDevice(), other.awsDevice()) && Objects.equals(awsDeviceV2(), other.awsDeviceV2())
                && Objects.equals(awsLogicalDeviceId(), other.awsLogicalDeviceId()) && hasConnections() == other.hasConnections()
                && Objects.equals(connections(), other.connections())
                && Objects.equals(allowsHostedConnections(), other.allowsHostedConnections())
                && Objects.equals(jumboFrameCapable(), other.jumboFrameCapable())
                && Objects.equals(hasLogicalRedundancyAsString(), other.hasLogicalRedundancyAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(providerName(), other.providerName()) && Objects.equals(macSecCapable(), other.macSecCapable())
                && Objects.equals(encryptionMode(), other.encryptionMode()) && hasMacSecKeys() == other.hasMacSecKeys()
                && Objects.equals(macSecKeys(), other.macSecKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLagResponse").add("ConnectionsBandwidth", connectionsBandwidth())
                .add("NumberOfConnections", numberOfConnections()).add("LagId", lagId()).add("OwnerAccount", ownerAccount())
                .add("LagName", lagName()).add("LagState", lagStateAsString()).add("Location", location())
                .add("Region", region()).add("MinimumLinks", minimumLinks()).add("AwsDevice", awsDevice())
                .add("AwsDeviceV2", awsDeviceV2()).add("AwsLogicalDeviceId", awsLogicalDeviceId())
                .add("Connections", hasConnections() ? connections() : null)
                .add("AllowsHostedConnections", allowsHostedConnections()).add("JumboFrameCapable", jumboFrameCapable())
                .add("HasLogicalRedundancy", hasLogicalRedundancyAsString()).add("Tags", hasTags() ? tags() : null)
                .add("ProviderName", providerName()).add("MacSecCapable", macSecCapable())
                .add("EncryptionMode", encryptionMode()).add("MacSecKeys", hasMacSecKeys() ? macSecKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionsBandwidth":
            return Optional.ofNullable(clazz.cast(connectionsBandwidth()));
        case "numberOfConnections":
            return Optional.ofNullable(clazz.cast(numberOfConnections()));
        case "lagId":
            return Optional.ofNullable(clazz.cast(lagId()));
        case "ownerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "lagName":
            return Optional.ofNullable(clazz.cast(lagName()));
        case "lagState":
            return Optional.ofNullable(clazz.cast(lagStateAsString()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "minimumLinks":
            return Optional.ofNullable(clazz.cast(minimumLinks()));
        case "awsDevice":
            return Optional.ofNullable(clazz.cast(awsDevice()));
        case "awsDeviceV2":
            return Optional.ofNullable(clazz.cast(awsDeviceV2()));
        case "awsLogicalDeviceId":
            return Optional.ofNullable(clazz.cast(awsLogicalDeviceId()));
        case "connections":
            return Optional.ofNullable(clazz.cast(connections()));
        case "allowsHostedConnections":
            return Optional.ofNullable(clazz.cast(allowsHostedConnections()));
        case "jumboFrameCapable":
            return Optional.ofNullable(clazz.cast(jumboFrameCapable()));
        case "hasLogicalRedundancy":
            return Optional.ofNullable(clazz.cast(hasLogicalRedundancyAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "providerName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "macSecCapable":
            return Optional.ofNullable(clazz.cast(macSecCapable()));
        case "encryptionMode":
            return Optional.ofNullable(clazz.cast(encryptionMode()));
        case "macSecKeys":
            return Optional.ofNullable(clazz.cast(macSecKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLagResponse, T> g) {
        return obj -> g.apply((UpdateLagResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLagResponse> {
        /**
         * <p>
         * The individual bandwidth of the physical connections bundled by the LAG. The possible values are 1Gbps and
         * 10Gbps.
         * </p>
         * 
         * @param connectionsBandwidth
         *        The individual bandwidth of the physical connections bundled by the LAG. The possible values are 1Gbps
         *        and 10Gbps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionsBandwidth(String connectionsBandwidth);

        /**
         * <p>
         * The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.
         * </p>
         * 
         * @param numberOfConnections
         *        The number of physical dedicated connections bundled by the LAG, up to a maximum of 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfConnections(Integer numberOfConnections);

        /**
         * <p>
         * The ID of the LAG.
         * </p>
         * 
         * @param lagId
         *        The ID of the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lagId(String lagId);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the LAG.
         * </p>
         * 
         * @param ownerAccount
         *        The ID of the Amazon Web Services account that owns the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * The name of the LAG.
         * </p>
         * 
         * @param lagName
         *        The name of the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lagName(String lagName);

        /**
         * <p>
         * The state of the LAG. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>requested</code>: The initial state of a LAG. The LAG stays in the requested state until the Letter of
         * Authorization (LOA) is available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: The LAG has been approved and is being initialized.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code>: The network link is established and the LAG is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>down</code>: The network link is down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: The LAG is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: The LAG is deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown</code>: The state of the LAG is not available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lagState
         *        The state of the LAG. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>requested</code>: The initial state of a LAG. The LAG stays in the requested state until the
         *        Letter of Authorization (LOA) is available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: The LAG has been approved and is being initialized.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code>: The network link is established and the LAG is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>down</code>: The network link is down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: The LAG is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: The LAG is deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown</code>: The state of the LAG is not available.
         *        </p>
         *        </li>
         * @see LagState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LagState
         */
        Builder lagState(String lagState);

        /**
         * <p>
         * The state of the LAG. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>requested</code>: The initial state of a LAG. The LAG stays in the requested state until the Letter of
         * Authorization (LOA) is available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: The LAG has been approved and is being initialized.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code>: The network link is established and the LAG is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>down</code>: The network link is down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: The LAG is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: The LAG is deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown</code>: The state of the LAG is not available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lagState
         *        The state of the LAG. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>requested</code>: The initial state of a LAG. The LAG stays in the requested state until the
         *        Letter of Authorization (LOA) is available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: The LAG has been approved and is being initialized.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code>: The network link is established and the LAG is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>down</code>: The network link is down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: The LAG is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: The LAG is deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown</code>: The state of the LAG is not available.
         *        </p>
         *        </li>
         * @see LagState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LagState
         */
        Builder lagState(LagState lagState);

        /**
         * <p>
         * The location of the LAG.
         * </p>
         * 
         * @param location
         *        The location of the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The Amazon Web Services Region where the connection is located.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region where the connection is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The minimum number of physical dedicated connections that must be operational for the LAG itself to be
         * operational.
         * </p>
         * 
         * @param minimumLinks
         *        The minimum number of physical dedicated connections that must be operational for the LAG itself to be
         *        operational.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumLinks(Integer minimumLinks);

        /**
         * <p>
         * The Direct Connect endpoint that hosts the LAG.
         * </p>
         * 
         * @param awsDevice
         *        The Direct Connect endpoint that hosts the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsDevice(String awsDevice);

        /**
         * <p>
         * The Direct Connect endpoint that hosts the LAG.
         * </p>
         * 
         * @param awsDeviceV2
         *        The Direct Connect endpoint that hosts the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsDeviceV2(String awsDeviceV2);

        /**
         * <p>
         * The Direct Connect endpoint that terminates the logical connection. This device might be different than the
         * device that terminates the physical connection.
         * </p>
         * 
         * @param awsLogicalDeviceId
         *        The Direct Connect endpoint that terminates the logical connection. This device might be different
         *        than the device that terminates the physical connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLogicalDeviceId(String awsLogicalDeviceId);

        /**
         * <p>
         * The connections bundled by the LAG.
         * </p>
         * 
         * @param connections
         *        The connections bundled by the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connections(Collection<Connection> connections);

        /**
         * <p>
         * The connections bundled by the LAG.
         * </p>
         * 
         * @param connections
         *        The connections bundled by the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connections(Connection... connections);

        /**
         * <p>
         * The connections bundled by the LAG.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Connection>.Builder} avoiding the need to
         * create one manually via {@link List<Connection>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Connection>.Builder#build()} is called immediately and its
         * result is passed to {@link #connections(List<Connection>)}.
         * 
         * @param connections
         *        a consumer that will call methods on {@link List<Connection>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connections(List<Connection>)
         */
        Builder connections(Consumer<Connection.Builder>... connections);

        /**
         * <p>
         * Indicates whether the LAG can host other connections.
         * </p>
         * 
         * @param allowsHostedConnections
         *        Indicates whether the LAG can host other connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowsHostedConnections(Boolean allowsHostedConnections);

        /**
         * <p>
         * Indicates whether jumbo frames (9001 MTU) are supported.
         * </p>
         * 
         * @param jumboFrameCapable
         *        Indicates whether jumbo frames (9001 MTU) are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jumboFrameCapable(Boolean jumboFrameCapable);

        /**
         * <p>
         * Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).
         * </p>
         * 
         * @param hasLogicalRedundancy
         *        Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).
         * @see HasLogicalRedundancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HasLogicalRedundancy
         */
        Builder hasLogicalRedundancy(String hasLogicalRedundancy);

        /**
         * <p>
         * Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).
         * </p>
         * 
         * @param hasLogicalRedundancy
         *        Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).
         * @see HasLogicalRedundancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HasLogicalRedundancy
         */
        Builder hasLogicalRedundancy(HasLogicalRedundancy hasLogicalRedundancy);

        /**
         * <p>
         * The tags associated with the LAG.
         * </p>
         * 
         * @param tags
         *        The tags associated with the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the LAG.
         * </p>
         * 
         * @param tags
         *        The tags associated with the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the LAG.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The name of the service provider associated with the LAG.
         * </p>
         * 
         * @param providerName
         *        The name of the service provider associated with the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * Indicates whether the LAG supports MAC Security (MACsec).
         * </p>
         * 
         * @param macSecCapable
         *        Indicates whether the LAG supports MAC Security (MACsec).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macSecCapable(Boolean macSecCapable);

        /**
         * <p>
         * The LAG MAC Security (MACsec) encryption mode.
         * </p>
         * <p>
         * The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and <code>must_encrypt</code>.
         * </p>
         * 
         * @param encryptionMode
         *        The LAG MAC Security (MACsec) encryption mode.</p>
         *        <p>
         *        The valid values are <code>no_encrypt</code>, <code>should_encrypt</code>, and
         *        <code>must_encrypt</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionMode(String encryptionMode);

        /**
         * <p>
         * The MAC Security (MACsec) security keys associated with the LAG.
         * </p>
         * 
         * @param macSecKeys
         *        The MAC Security (MACsec) security keys associated with the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macSecKeys(Collection<MacSecKey> macSecKeys);

        /**
         * <p>
         * The MAC Security (MACsec) security keys associated with the LAG.
         * </p>
         * 
         * @param macSecKeys
         *        The MAC Security (MACsec) security keys associated with the LAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macSecKeys(MacSecKey... macSecKeys);

        /**
         * <p>
         * The MAC Security (MACsec) security keys associated with the LAG.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MacSecKey>.Builder} avoiding the need to
         * create one manually via {@link List<MacSecKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MacSecKey>.Builder#build()} is called immediately and its
         * result is passed to {@link #macSecKeys(List<MacSecKey>)}.
         * 
         * @param macSecKeys
         *        a consumer that will call methods on {@link List<MacSecKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #macSecKeys(List<MacSecKey>)
         */
        Builder macSecKeys(Consumer<MacSecKey.Builder>... macSecKeys);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private String connectionsBandwidth;

        private Integer numberOfConnections;

        private String lagId;

        private String ownerAccount;

        private String lagName;

        private String lagState;

        private String location;

        private String region;

        private Integer minimumLinks;

        private String awsDevice;

        private String awsDeviceV2;

        private String awsLogicalDeviceId;

        private List<Connection> connections = DefaultSdkAutoConstructList.getInstance();

        private Boolean allowsHostedConnections;

        private Boolean jumboFrameCapable;

        private String hasLogicalRedundancy;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String providerName;

        private Boolean macSecCapable;

        private String encryptionMode;

        private List<MacSecKey> macSecKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLagResponse model) {
            super(model);
            connectionsBandwidth(model.connectionsBandwidth);
            numberOfConnections(model.numberOfConnections);
            lagId(model.lagId);
            ownerAccount(model.ownerAccount);
            lagName(model.lagName);
            lagState(model.lagState);
            location(model.location);
            region(model.region);
            minimumLinks(model.minimumLinks);
            awsDevice(model.awsDevice);
            awsDeviceV2(model.awsDeviceV2);
            awsLogicalDeviceId(model.awsLogicalDeviceId);
            connections(model.connections);
            allowsHostedConnections(model.allowsHostedConnections);
            jumboFrameCapable(model.jumboFrameCapable);
            hasLogicalRedundancy(model.hasLogicalRedundancy);
            tags(model.tags);
            providerName(model.providerName);
            macSecCapable(model.macSecCapable);
            encryptionMode(model.encryptionMode);
            macSecKeys(model.macSecKeys);
        }

        public final String getConnectionsBandwidth() {
            return connectionsBandwidth;
        }

        public final void setConnectionsBandwidth(String connectionsBandwidth) {
            this.connectionsBandwidth = connectionsBandwidth;
        }

        @Override
        @Transient
        public final Builder connectionsBandwidth(String connectionsBandwidth) {
            this.connectionsBandwidth = connectionsBandwidth;
            return this;
        }

        public final Integer getNumberOfConnections() {
            return numberOfConnections;
        }

        public final void setNumberOfConnections(Integer numberOfConnections) {
            this.numberOfConnections = numberOfConnections;
        }

        @Override
        @Transient
        public final Builder numberOfConnections(Integer numberOfConnections) {
            this.numberOfConnections = numberOfConnections;
            return this;
        }

        public final String getLagId() {
            return lagId;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        @Override
        @Transient
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        @Transient
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getLagName() {
            return lagName;
        }

        public final void setLagName(String lagName) {
            this.lagName = lagName;
        }

        @Override
        @Transient
        public final Builder lagName(String lagName) {
            this.lagName = lagName;
            return this;
        }

        public final String getLagState() {
            return lagState;
        }

        public final void setLagState(String lagState) {
            this.lagState = lagState;
        }

        @Override
        @Transient
        public final Builder lagState(String lagState) {
            this.lagState = lagState;
            return this;
        }

        @Override
        @Transient
        public final Builder lagState(LagState lagState) {
            this.lagState(lagState == null ? null : lagState.toString());
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        @Transient
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Integer getMinimumLinks() {
            return minimumLinks;
        }

        public final void setMinimumLinks(Integer minimumLinks) {
            this.minimumLinks = minimumLinks;
        }

        @Override
        @Transient
        public final Builder minimumLinks(Integer minimumLinks) {
            this.minimumLinks = minimumLinks;
            return this;
        }

        public final String getAwsDevice() {
            return awsDevice;
        }

        public final void setAwsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
        }

        @Override
        @Transient
        public final Builder awsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
            return this;
        }

        public final String getAwsDeviceV2() {
            return awsDeviceV2;
        }

        public final void setAwsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
        }

        @Override
        @Transient
        public final Builder awsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
            return this;
        }

        public final String getAwsLogicalDeviceId() {
            return awsLogicalDeviceId;
        }

        public final void setAwsLogicalDeviceId(String awsLogicalDeviceId) {
            this.awsLogicalDeviceId = awsLogicalDeviceId;
        }

        @Override
        @Transient
        public final Builder awsLogicalDeviceId(String awsLogicalDeviceId) {
            this.awsLogicalDeviceId = awsLogicalDeviceId;
            return this;
        }

        public final List<Connection.Builder> getConnections() {
            List<Connection.Builder> result = ConnectionListCopier.copyToBuilder(this.connections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnections(Collection<Connection.BuilderImpl> connections) {
            this.connections = ConnectionListCopier.copyFromBuilder(connections);
        }

        @Override
        @Transient
        public final Builder connections(Collection<Connection> connections) {
            this.connections = ConnectionListCopier.copy(connections);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder connections(Connection... connections) {
            connections(Arrays.asList(connections));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder connections(Consumer<Connection.Builder>... connections) {
            connections(Stream.of(connections).map(c -> Connection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAllowsHostedConnections() {
            return allowsHostedConnections;
        }

        public final void setAllowsHostedConnections(Boolean allowsHostedConnections) {
            this.allowsHostedConnections = allowsHostedConnections;
        }

        @Override
        @Transient
        public final Builder allowsHostedConnections(Boolean allowsHostedConnections) {
            this.allowsHostedConnections = allowsHostedConnections;
            return this;
        }

        public final Boolean getJumboFrameCapable() {
            return jumboFrameCapable;
        }

        public final void setJumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
        }

        @Override
        @Transient
        public final Builder jumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
            return this;
        }

        public final String getHasLogicalRedundancy() {
            return hasLogicalRedundancy;
        }

        public final void setHasLogicalRedundancy(String hasLogicalRedundancy) {
            this.hasLogicalRedundancy = hasLogicalRedundancy;
        }

        @Override
        @Transient
        public final Builder hasLogicalRedundancy(String hasLogicalRedundancy) {
            this.hasLogicalRedundancy = hasLogicalRedundancy;
            return this;
        }

        @Override
        @Transient
        public final Builder hasLogicalRedundancy(HasLogicalRedundancy hasLogicalRedundancy) {
            this.hasLogicalRedundancy(hasLogicalRedundancy == null ? null : hasLogicalRedundancy.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProviderName() {
            return providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        @Transient
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final Boolean getMacSecCapable() {
            return macSecCapable;
        }

        public final void setMacSecCapable(Boolean macSecCapable) {
            this.macSecCapable = macSecCapable;
        }

        @Override
        @Transient
        public final Builder macSecCapable(Boolean macSecCapable) {
            this.macSecCapable = macSecCapable;
            return this;
        }

        public final String getEncryptionMode() {
            return encryptionMode;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        @Override
        @Transient
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        public final List<MacSecKey.Builder> getMacSecKeys() {
            List<MacSecKey.Builder> result = MacSecKeyListCopier.copyToBuilder(this.macSecKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMacSecKeys(Collection<MacSecKey.BuilderImpl> macSecKeys) {
            this.macSecKeys = MacSecKeyListCopier.copyFromBuilder(macSecKeys);
        }

        @Override
        @Transient
        public final Builder macSecKeys(Collection<MacSecKey> macSecKeys) {
            this.macSecKeys = MacSecKeyListCopier.copy(macSecKeys);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder macSecKeys(MacSecKey... macSecKeys) {
            macSecKeys(Arrays.asList(macSecKeys));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder macSecKeys(Consumer<MacSecKey.Builder>... macSecKeys) {
            macSecKeys(Stream.of(macSecKeys).map(c -> MacSecKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateLagResponse build() {
            return new UpdateLagResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
