/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the virtual interface failover test.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualInterfaceTestHistory implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualInterfaceTestHistory.Builder, VirtualInterfaceTestHistory> {
    private static final SdkField<String> TEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("testId")
            .getter(getter(VirtualInterfaceTestHistory::testId)).setter(setter(Builder::testId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testId").build()).build();

    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceId").getter(getter(VirtualInterfaceTestHistory::virtualInterfaceId))
            .setter(setter(Builder::virtualInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build())
            .build();

    private static final SdkField<List<String>> BGP_PEERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("bgpPeers")
            .getter(getter(VirtualInterfaceTestHistory::bgpPeers))
            .setter(setter(Builder::bgpPeers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bgpPeers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(VirtualInterfaceTestHistory::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerAccount").getter(getter(VirtualInterfaceTestHistory::ownerAccount))
            .setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()).build();

    private static final SdkField<Integer> TEST_DURATION_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("testDurationInMinutes").getter(getter(VirtualInterfaceTestHistory::testDurationInMinutes))
            .setter(setter(Builder::testDurationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testDurationInMinutes").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(VirtualInterfaceTestHistory::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(VirtualInterfaceTestHistory::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_ID_FIELD,
            VIRTUAL_INTERFACE_ID_FIELD, BGP_PEERS_FIELD, STATUS_FIELD, OWNER_ACCOUNT_FIELD, TEST_DURATION_IN_MINUTES_FIELD,
            START_TIME_FIELD, END_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String testId;

    private final String virtualInterfaceId;

    private final List<String> bgpPeers;

    private final String status;

    private final String ownerAccount;

    private final Integer testDurationInMinutes;

    private final Instant startTime;

    private final Instant endTime;

    private VirtualInterfaceTestHistory(BuilderImpl builder) {
        this.testId = builder.testId;
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.bgpPeers = builder.bgpPeers;
        this.status = builder.status;
        this.ownerAccount = builder.ownerAccount;
        this.testDurationInMinutes = builder.testDurationInMinutes;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The ID of the virtual interface failover test.
     * </p>
     * 
     * @return The ID of the virtual interface failover test.
     */
    public final String testId() {
        return testId;
    }

    /**
     * <p>
     * The ID of the tested virtual interface.
     * </p>
     * 
     * @return The ID of the tested virtual interface.
     */
    public final String virtualInterfaceId() {
        return virtualInterfaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the BgpPeers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBgpPeers() {
        return bgpPeers != null && !(bgpPeers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The BGP peers that were put in the DOWN state as part of the virtual interface failover test.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBgpPeers} method.
     * </p>
     * 
     * @return The BGP peers that were put in the DOWN state as part of the virtual interface failover test.
     */
    public final List<String> bgpPeers() {
        return bgpPeers;
    }

    /**
     * <p>
     * The status of the virtual interface failover test.
     * </p>
     * 
     * @return The status of the virtual interface failover test.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The owner ID of the tested virtual interface.
     * </p>
     * 
     * @return The owner ID of the tested virtual interface.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * The time that the virtual interface failover test ran in minutes.
     * </p>
     * 
     * @return The time that the virtual interface failover test ran in minutes.
     */
    public final Integer testDurationInMinutes() {
        return testDurationInMinutes;
    }

    /**
     * <p>
     * The time that the virtual interface moves to the DOWN state.
     * </p>
     * 
     * @return The time that the virtual interface moves to the DOWN state.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time that the virtual interface moves out of the DOWN state.
     * </p>
     * 
     * @return The time that the virtual interface moves out of the DOWN state.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(testId());
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasBgpPeers() ? bgpPeers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(testDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualInterfaceTestHistory)) {
            return false;
        }
        VirtualInterfaceTestHistory other = (VirtualInterfaceTestHistory) obj;
        return Objects.equals(testId(), other.testId()) && Objects.equals(virtualInterfaceId(), other.virtualInterfaceId())
                && hasBgpPeers() == other.hasBgpPeers() && Objects.equals(bgpPeers(), other.bgpPeers())
                && Objects.equals(status(), other.status()) && Objects.equals(ownerAccount(), other.ownerAccount())
                && Objects.equals(testDurationInMinutes(), other.testDurationInMinutes())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualInterfaceTestHistory").add("TestId", testId())
                .add("VirtualInterfaceId", virtualInterfaceId()).add("BgpPeers", hasBgpPeers() ? bgpPeers() : null)
                .add("Status", status()).add("OwnerAccount", ownerAccount())
                .add("TestDurationInMinutes", testDurationInMinutes()).add("StartTime", startTime()).add("EndTime", endTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testId":
            return Optional.ofNullable(clazz.cast(testId()));
        case "virtualInterfaceId":
            return Optional.ofNullable(clazz.cast(virtualInterfaceId()));
        case "bgpPeers":
            return Optional.ofNullable(clazz.cast(bgpPeers()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "ownerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "testDurationInMinutes":
            return Optional.ofNullable(clazz.cast(testDurationInMinutes()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualInterfaceTestHistory, T> g) {
        return obj -> g.apply((VirtualInterfaceTestHistory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualInterfaceTestHistory> {
        /**
         * <p>
         * The ID of the virtual interface failover test.
         * </p>
         * 
         * @param testId
         *        The ID of the virtual interface failover test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testId(String testId);

        /**
         * <p>
         * The ID of the tested virtual interface.
         * </p>
         * 
         * @param virtualInterfaceId
         *        The ID of the tested virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceId(String virtualInterfaceId);

        /**
         * <p>
         * The BGP peers that were put in the DOWN state as part of the virtual interface failover test.
         * </p>
         * 
         * @param bgpPeers
         *        The BGP peers that were put in the DOWN state as part of the virtual interface failover test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpPeers(Collection<String> bgpPeers);

        /**
         * <p>
         * The BGP peers that were put in the DOWN state as part of the virtual interface failover test.
         * </p>
         * 
         * @param bgpPeers
         *        The BGP peers that were put in the DOWN state as part of the virtual interface failover test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpPeers(String... bgpPeers);

        /**
         * <p>
         * The status of the virtual interface failover test.
         * </p>
         * 
         * @param status
         *        The status of the virtual interface failover test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The owner ID of the tested virtual interface.
         * </p>
         * 
         * @param ownerAccount
         *        The owner ID of the tested virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * The time that the virtual interface failover test ran in minutes.
         * </p>
         * 
         * @param testDurationInMinutes
         *        The time that the virtual interface failover test ran in minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testDurationInMinutes(Integer testDurationInMinutes);

        /**
         * <p>
         * The time that the virtual interface moves to the DOWN state.
         * </p>
         * 
         * @param startTime
         *        The time that the virtual interface moves to the DOWN state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time that the virtual interface moves out of the DOWN state.
         * </p>
         * 
         * @param endTime
         *        The time that the virtual interface moves out of the DOWN state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String testId;

        private String virtualInterfaceId;

        private List<String> bgpPeers = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String ownerAccount;

        private Integer testDurationInMinutes;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualInterfaceTestHistory model) {
            testId(model.testId);
            virtualInterfaceId(model.virtualInterfaceId);
            bgpPeers(model.bgpPeers);
            status(model.status);
            ownerAccount(model.ownerAccount);
            testDurationInMinutes(model.testDurationInMinutes);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getTestId() {
            return testId;
        }

        public final void setTestId(String testId) {
            this.testId = testId;
        }

        @Override
        @Transient
        public final Builder testId(String testId) {
            this.testId = testId;
            return this;
        }

        public final String getVirtualInterfaceId() {
            return virtualInterfaceId;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        @Transient
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final Collection<String> getBgpPeers() {
            if (bgpPeers instanceof SdkAutoConstructList) {
                return null;
            }
            return bgpPeers;
        }

        public final void setBgpPeers(Collection<String> bgpPeers) {
            this.bgpPeers = BGPPeerIdListCopier.copy(bgpPeers);
        }

        @Override
        @Transient
        public final Builder bgpPeers(Collection<String> bgpPeers) {
            this.bgpPeers = BGPPeerIdListCopier.copy(bgpPeers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bgpPeers(String... bgpPeers) {
            bgpPeers(Arrays.asList(bgpPeers));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        @Transient
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final Integer getTestDurationInMinutes() {
            return testDurationInMinutes;
        }

        public final void setTestDurationInMinutes(Integer testDurationInMinutes) {
            this.testDurationInMinutes = testDurationInMinutes;
        }

        @Override
        @Transient
        public final Builder testDurationInMinutes(Integer testDurationInMinutes) {
            this.testDurationInMinutes = testDurationInMinutes;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public VirtualInterfaceTestHistory build() {
            return new VirtualInterfaceTestHistory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
