/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllocateTransitVirtualInterfaceRequest extends DirectConnectRequest implements
        ToCopyableBuilder<AllocateTransitVirtualInterfaceRequest.Builder, AllocateTransitVirtualInterfaceRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionId").getter(getter(AllocateTransitVirtualInterfaceRequest::connectionId))
            .setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerAccount").getter(getter(AllocateTransitVirtualInterfaceRequest::ownerAccount))
            .setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()).build();

    private static final SdkField<NewTransitVirtualInterfaceAllocation> NEW_TRANSIT_VIRTUAL_INTERFACE_ALLOCATION_FIELD = SdkField
            .<NewTransitVirtualInterfaceAllocation> builder(MarshallingType.SDK_POJO)
            .memberName("newTransitVirtualInterfaceAllocation")
            .getter(getter(AllocateTransitVirtualInterfaceRequest::newTransitVirtualInterfaceAllocation))
            .setter(setter(Builder::newTransitVirtualInterfaceAllocation))
            .constructor(NewTransitVirtualInterfaceAllocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("newTransitVirtualInterfaceAllocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD,
            OWNER_ACCOUNT_FIELD, NEW_TRANSIT_VIRTUAL_INTERFACE_ALLOCATION_FIELD));

    private final String connectionId;

    private final String ownerAccount;

    private final NewTransitVirtualInterfaceAllocation newTransitVirtualInterfaceAllocation;

    private AllocateTransitVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.ownerAccount = builder.ownerAccount;
        this.newTransitVirtualInterfaceAllocation = builder.newTransitVirtualInterfaceAllocation;
    }

    /**
     * <p>
     * The ID of the connection on which the transit virtual interface is provisioned.
     * </p>
     * 
     * @return The ID of the connection on which the transit virtual interface is provisioned.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the transit virtual interface.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the transit virtual interface.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * Information about the transit virtual interface.
     * </p>
     * 
     * @return Information about the transit virtual interface.
     */
    public final NewTransitVirtualInterfaceAllocation newTransitVirtualInterfaceAllocation() {
        return newTransitVirtualInterfaceAllocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(newTransitVirtualInterfaceAllocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateTransitVirtualInterfaceRequest)) {
            return false;
        }
        AllocateTransitVirtualInterfaceRequest other = (AllocateTransitVirtualInterfaceRequest) obj;
        return Objects.equals(connectionId(), other.connectionId()) && Objects.equals(ownerAccount(), other.ownerAccount())
                && Objects.equals(newTransitVirtualInterfaceAllocation(), other.newTransitVirtualInterfaceAllocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AllocateTransitVirtualInterfaceRequest").add("ConnectionId", connectionId())
                .add("OwnerAccount", ownerAccount())
                .add("NewTransitVirtualInterfaceAllocation", newTransitVirtualInterfaceAllocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "ownerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "newTransitVirtualInterfaceAllocation":
            return Optional.ofNullable(clazz.cast(newTransitVirtualInterfaceAllocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllocateTransitVirtualInterfaceRequest, T> g) {
        return obj -> g.apply((AllocateTransitVirtualInterfaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AllocateTransitVirtualInterfaceRequest> {
        /**
         * <p>
         * The ID of the connection on which the transit virtual interface is provisioned.
         * </p>
         * 
         * @param connectionId
         *        The ID of the connection on which the transit virtual interface is provisioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the transit virtual interface.
         * </p>
         * 
         * @param ownerAccount
         *        The ID of the Amazon Web Services account that owns the transit virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * Information about the transit virtual interface.
         * </p>
         * 
         * @param newTransitVirtualInterfaceAllocation
         *        Information about the transit virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newTransitVirtualInterfaceAllocation(NewTransitVirtualInterfaceAllocation newTransitVirtualInterfaceAllocation);

        /**
         * <p>
         * Information about the transit virtual interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link NewTransitVirtualInterfaceAllocation.Builder} avoiding the need to create one manually via
         * {@link NewTransitVirtualInterfaceAllocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NewTransitVirtualInterfaceAllocation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #newTransitVirtualInterfaceAllocation(NewTransitVirtualInterfaceAllocation)}.
         * 
         * @param newTransitVirtualInterfaceAllocation
         *        a consumer that will call methods on {@link NewTransitVirtualInterfaceAllocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newTransitVirtualInterfaceAllocation(NewTransitVirtualInterfaceAllocation)
         */
        default Builder newTransitVirtualInterfaceAllocation(
                Consumer<NewTransitVirtualInterfaceAllocation.Builder> newTransitVirtualInterfaceAllocation) {
            return newTransitVirtualInterfaceAllocation(NewTransitVirtualInterfaceAllocation.builder()
                    .applyMutation(newTransitVirtualInterfaceAllocation).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String connectionId;

        private String ownerAccount;

        private NewTransitVirtualInterfaceAllocation newTransitVirtualInterfaceAllocation;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateTransitVirtualInterfaceRequest model) {
            super(model);
            connectionId(model.connectionId);
            ownerAccount(model.ownerAccount);
            newTransitVirtualInterfaceAllocation(model.newTransitVirtualInterfaceAllocation);
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final NewTransitVirtualInterfaceAllocation.Builder getNewTransitVirtualInterfaceAllocation() {
            return newTransitVirtualInterfaceAllocation != null ? newTransitVirtualInterfaceAllocation.toBuilder() : null;
        }

        public final void setNewTransitVirtualInterfaceAllocation(
                NewTransitVirtualInterfaceAllocation.BuilderImpl newTransitVirtualInterfaceAllocation) {
            this.newTransitVirtualInterfaceAllocation = newTransitVirtualInterfaceAllocation != null ? newTransitVirtualInterfaceAllocation
                    .build() : null;
        }

        @Override
        public final Builder newTransitVirtualInterfaceAllocation(
                NewTransitVirtualInterfaceAllocation newTransitVirtualInterfaceAllocation) {
            this.newTransitVirtualInterfaceAllocation = newTransitVirtualInterfaceAllocation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocateTransitVirtualInterfaceRequest build() {
            return new AllocateTransitVirtualInterfaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
