/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllocateTransitVirtualInterfaceResponse extends DirectConnectResponse implements
        ToCopyableBuilder<AllocateTransitVirtualInterfaceResponse.Builder, AllocateTransitVirtualInterfaceResponse> {
    private static final SdkField<VirtualInterface> VIRTUAL_INTERFACE_FIELD = SdkField
            .<VirtualInterface> builder(MarshallingType.SDK_POJO).memberName("virtualInterface")
            .getter(getter(AllocateTransitVirtualInterfaceResponse::virtualInterface)).setter(setter(Builder::virtualInterface))
            .constructor(VirtualInterface::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterface").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_FIELD));

    private final VirtualInterface virtualInterface;

    private AllocateTransitVirtualInterfaceResponse(BuilderImpl builder) {
        super(builder);
        this.virtualInterface = builder.virtualInterface;
    }

    /**
     * Returns the value of the VirtualInterface property for this object.
     * 
     * @return The value of the VirtualInterface property for this object.
     */
    public final VirtualInterface virtualInterface() {
        return virtualInterface;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterface());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateTransitVirtualInterfaceResponse)) {
            return false;
        }
        AllocateTransitVirtualInterfaceResponse other = (AllocateTransitVirtualInterfaceResponse) obj;
        return Objects.equals(virtualInterface(), other.virtualInterface());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AllocateTransitVirtualInterfaceResponse").add("VirtualInterface", virtualInterface()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualInterface":
            return Optional.ofNullable(clazz.cast(virtualInterface()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllocateTransitVirtualInterfaceResponse, T> g) {
        return obj -> g.apply((AllocateTransitVirtualInterfaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AllocateTransitVirtualInterfaceResponse> {
        /**
         * Sets the value of the VirtualInterface property for this object.
         *
         * @param virtualInterface
         *        The new value for the VirtualInterface property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterface(VirtualInterface virtualInterface);

        /**
         * Sets the value of the VirtualInterface property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VirtualInterface.Builder} avoiding the
         * need to create one manually via {@link VirtualInterface#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualInterface.Builder#build()} is called immediately and its
         * result is passed to {@link #virtualInterface(VirtualInterface)}.
         * 
         * @param virtualInterface
         *        a consumer that will call methods on {@link VirtualInterface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualInterface(VirtualInterface)
         */
        default Builder virtualInterface(Consumer<VirtualInterface.Builder> virtualInterface) {
            return virtualInterface(VirtualInterface.builder().applyMutation(virtualInterface).build());
        }
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private VirtualInterface virtualInterface;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateTransitVirtualInterfaceResponse model) {
            super(model);
            virtualInterface(model.virtualInterface);
        }

        public final VirtualInterface.Builder getVirtualInterface() {
            return virtualInterface != null ? virtualInterface.toBuilder() : null;
        }

        public final void setVirtualInterface(VirtualInterface.BuilderImpl virtualInterface) {
            this.virtualInterface = virtualInterface != null ? virtualInterface.build() : null;
        }

        @Override
        public final Builder virtualInterface(VirtualInterface virtualInterface) {
            this.virtualInterface = virtualInterface;
            return this;
        }

        @Override
        public AllocateTransitVirtualInterfaceResponse build() {
            return new AllocateTransitVirtualInterfaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
