/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePrivateVirtualInterfaceRequest extends DirectConnectRequest implements
        ToCopyableBuilder<CreatePrivateVirtualInterfaceRequest.Builder, CreatePrivateVirtualInterfaceRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionId").getter(getter(CreatePrivateVirtualInterfaceRequest::connectionId))
            .setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<NewPrivateVirtualInterface> NEW_PRIVATE_VIRTUAL_INTERFACE_FIELD = SdkField
            .<NewPrivateVirtualInterface> builder(MarshallingType.SDK_POJO)
            .memberName("newPrivateVirtualInterface")
            .getter(getter(CreatePrivateVirtualInterfaceRequest::newPrivateVirtualInterface))
            .setter(setter(Builder::newPrivateVirtualInterface))
            .constructor(NewPrivateVirtualInterface::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newPrivateVirtualInterface").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD,
            NEW_PRIVATE_VIRTUAL_INTERFACE_FIELD));

    private final String connectionId;

    private final NewPrivateVirtualInterface newPrivateVirtualInterface;

    private CreatePrivateVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.newPrivateVirtualInterface = builder.newPrivateVirtualInterface;
    }

    /**
     * <p>
     * The ID of the connection.
     * </p>
     * 
     * @return The ID of the connection.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * Information about the private virtual interface.
     * </p>
     * 
     * @return Information about the private virtual interface.
     */
    public final NewPrivateVirtualInterface newPrivateVirtualInterface() {
        return newPrivateVirtualInterface;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(newPrivateVirtualInterface());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePrivateVirtualInterfaceRequest)) {
            return false;
        }
        CreatePrivateVirtualInterfaceRequest other = (CreatePrivateVirtualInterfaceRequest) obj;
        return Objects.equals(connectionId(), other.connectionId())
                && Objects.equals(newPrivateVirtualInterface(), other.newPrivateVirtualInterface());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePrivateVirtualInterfaceRequest").add("ConnectionId", connectionId())
                .add("NewPrivateVirtualInterface", newPrivateVirtualInterface()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "newPrivateVirtualInterface":
            return Optional.ofNullable(clazz.cast(newPrivateVirtualInterface()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePrivateVirtualInterfaceRequest, T> g) {
        return obj -> g.apply((CreatePrivateVirtualInterfaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePrivateVirtualInterfaceRequest> {
        /**
         * <p>
         * The ID of the connection.
         * </p>
         * 
         * @param connectionId
         *        The ID of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * Information about the private virtual interface.
         * </p>
         * 
         * @param newPrivateVirtualInterface
         *        Information about the private virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newPrivateVirtualInterface(NewPrivateVirtualInterface newPrivateVirtualInterface);

        /**
         * <p>
         * Information about the private virtual interface.
         * </p>
         * This is a convenience method that creates an instance of the {@link NewPrivateVirtualInterface.Builder}
         * avoiding the need to create one manually via {@link NewPrivateVirtualInterface#builder()}.
         *
         * When the {@link Consumer} completes, {@link NewPrivateVirtualInterface.Builder#build()} is called immediately
         * and its result is passed to {@link #newPrivateVirtualInterface(NewPrivateVirtualInterface)}.
         * 
         * @param newPrivateVirtualInterface
         *        a consumer that will call methods on {@link NewPrivateVirtualInterface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newPrivateVirtualInterface(NewPrivateVirtualInterface)
         */
        default Builder newPrivateVirtualInterface(Consumer<NewPrivateVirtualInterface.Builder> newPrivateVirtualInterface) {
            return newPrivateVirtualInterface(NewPrivateVirtualInterface.builder().applyMutation(newPrivateVirtualInterface)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String connectionId;

        private NewPrivateVirtualInterface newPrivateVirtualInterface;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePrivateVirtualInterfaceRequest model) {
            super(model);
            connectionId(model.connectionId);
            newPrivateVirtualInterface(model.newPrivateVirtualInterface);
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final NewPrivateVirtualInterface.Builder getNewPrivateVirtualInterface() {
            return newPrivateVirtualInterface != null ? newPrivateVirtualInterface.toBuilder() : null;
        }

        public final void setNewPrivateVirtualInterface(NewPrivateVirtualInterface.BuilderImpl newPrivateVirtualInterface) {
            this.newPrivateVirtualInterface = newPrivateVirtualInterface != null ? newPrivateVirtualInterface.build() : null;
        }

        @Override
        public final Builder newPrivateVirtualInterface(NewPrivateVirtualInterface newPrivateVirtualInterface) {
            this.newPrivateVirtualInterface = newPrivateVirtualInterface;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePrivateVirtualInterfaceRequest build() {
            return new CreatePrivateVirtualInterfaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
