/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDirectConnectGatewayAssociationsResponse extends DirectConnectResponse
        implements
        ToCopyableBuilder<DescribeDirectConnectGatewayAssociationsResponse.Builder, DescribeDirectConnectGatewayAssociationsResponse> {
    private static final SdkField<List<DirectConnectGatewayAssociation>> DIRECT_CONNECT_GATEWAY_ASSOCIATIONS_FIELD = SdkField
            .<List<DirectConnectGatewayAssociation>> builder(MarshallingType.LIST)
            .memberName("directConnectGatewayAssociations")
            .getter(getter(DescribeDirectConnectGatewayAssociationsResponse::directConnectGatewayAssociations))
            .setter(setter(Builder::directConnectGatewayAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayAssociations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DirectConnectGatewayAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(DirectConnectGatewayAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeDirectConnectGatewayAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DIRECT_CONNECT_GATEWAY_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<DirectConnectGatewayAssociation> directConnectGatewayAssociations;

    private final String nextToken;

    private DescribeDirectConnectGatewayAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayAssociations = builder.directConnectGatewayAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DirectConnectGatewayAssociations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDirectConnectGatewayAssociations() {
        return directConnectGatewayAssociations != null && !(directConnectGatewayAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDirectConnectGatewayAssociations}
     * method.
     * </p>
     * 
     * @return Information about the associations.
     */
    public final List<DirectConnectGatewayAssociation> directConnectGatewayAssociations() {
        return directConnectGatewayAssociations;
    }

    /**
     * <p>
     * The token to retrieve the next page.
     * </p>
     * 
     * @return The token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDirectConnectGatewayAssociations() ? directConnectGatewayAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectConnectGatewayAssociationsResponse)) {
            return false;
        }
        DescribeDirectConnectGatewayAssociationsResponse other = (DescribeDirectConnectGatewayAssociationsResponse) obj;
        return hasDirectConnectGatewayAssociations() == other.hasDirectConnectGatewayAssociations()
                && Objects.equals(directConnectGatewayAssociations(), other.directConnectGatewayAssociations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeDirectConnectGatewayAssociationsResponse")
                .add("DirectConnectGatewayAssociations",
                        hasDirectConnectGatewayAssociations() ? directConnectGatewayAssociations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "directConnectGatewayAssociations":
            return Optional.ofNullable(clazz.cast(directConnectGatewayAssociations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectConnectGatewayAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeDirectConnectGatewayAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDirectConnectGatewayAssociationsResponse> {
        /**
         * <p>
         * Information about the associations.
         * </p>
         * 
         * @param directConnectGatewayAssociations
         *        Information about the associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayAssociations(Collection<DirectConnectGatewayAssociation> directConnectGatewayAssociations);

        /**
         * <p>
         * Information about the associations.
         * </p>
         * 
         * @param directConnectGatewayAssociations
         *        Information about the associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayAssociations(DirectConnectGatewayAssociation... directConnectGatewayAssociations);

        /**
         * <p>
         * Information about the associations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #directConnectGatewayAssociations(List<DirectConnectGatewayAssociation>)}.
         * 
         * @param directConnectGatewayAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directConnectGatewayAssociations(java.util.Collection<DirectConnectGatewayAssociation>)
         */
        Builder directConnectGatewayAssociations(
                Consumer<DirectConnectGatewayAssociation.Builder>... directConnectGatewayAssociations);

        /**
         * <p>
         * The token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private List<DirectConnectGatewayAssociation> directConnectGatewayAssociations = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectConnectGatewayAssociationsResponse model) {
            super(model);
            directConnectGatewayAssociations(model.directConnectGatewayAssociations);
            nextToken(model.nextToken);
        }

        public final List<DirectConnectGatewayAssociation.Builder> getDirectConnectGatewayAssociations() {
            List<DirectConnectGatewayAssociation.Builder> result = DirectConnectGatewayAssociationListCopier
                    .copyToBuilder(this.directConnectGatewayAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDirectConnectGatewayAssociations(
                Collection<DirectConnectGatewayAssociation.BuilderImpl> directConnectGatewayAssociations) {
            this.directConnectGatewayAssociations = DirectConnectGatewayAssociationListCopier
                    .copyFromBuilder(directConnectGatewayAssociations);
        }

        @Override
        public final Builder directConnectGatewayAssociations(
                Collection<DirectConnectGatewayAssociation> directConnectGatewayAssociations) {
            this.directConnectGatewayAssociations = DirectConnectGatewayAssociationListCopier
                    .copy(directConnectGatewayAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGatewayAssociations(DirectConnectGatewayAssociation... directConnectGatewayAssociations) {
            directConnectGatewayAssociations(Arrays.asList(directConnectGatewayAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGatewayAssociations(
                Consumer<DirectConnectGatewayAssociation.Builder>... directConnectGatewayAssociations) {
            directConnectGatewayAssociations(Stream.of(directConnectGatewayAssociations)
                    .map(c -> DirectConnectGatewayAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDirectConnectGatewayAssociationsResponse build() {
            return new DescribeDirectConnectGatewayAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
