/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDirectConnectGatewayAssociationResponse extends DirectConnectResponse implements
        ToCopyableBuilder<UpdateDirectConnectGatewayAssociationResponse.Builder, UpdateDirectConnectGatewayAssociationResponse> {
    private static final SdkField<DirectConnectGatewayAssociation> DIRECT_CONNECT_GATEWAY_ASSOCIATION_FIELD = SdkField
            .<DirectConnectGatewayAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("directConnectGatewayAssociation")
            .getter(getter(UpdateDirectConnectGatewayAssociationResponse::directConnectGatewayAssociation))
            .setter(setter(Builder::directConnectGatewayAssociation))
            .constructor(DirectConnectGatewayAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayAssociation")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DIRECT_CONNECT_GATEWAY_ASSOCIATION_FIELD));

    private final DirectConnectGatewayAssociation directConnectGatewayAssociation;

    private UpdateDirectConnectGatewayAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayAssociation = builder.directConnectGatewayAssociation;
    }

    /**
     * <p>
     * Information about an association between a Direct Connect gateway and a virtual private gateway or transit
     * gateway.
     * </p>
     * 
     * @return Information about an association between a Direct Connect gateway and a virtual private gateway or
     *         transit gateway.
     */
    public final DirectConnectGatewayAssociation directConnectGatewayAssociation() {
        return directConnectGatewayAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGatewayAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDirectConnectGatewayAssociationResponse)) {
            return false;
        }
        UpdateDirectConnectGatewayAssociationResponse other = (UpdateDirectConnectGatewayAssociationResponse) obj;
        return Objects.equals(directConnectGatewayAssociation(), other.directConnectGatewayAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDirectConnectGatewayAssociationResponse")
                .add("DirectConnectGatewayAssociation", directConnectGatewayAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "directConnectGatewayAssociation":
            return Optional.ofNullable(clazz.cast(directConnectGatewayAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDirectConnectGatewayAssociationResponse, T> g) {
        return obj -> g.apply((UpdateDirectConnectGatewayAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDirectConnectGatewayAssociationResponse> {
        /**
         * <p>
         * Information about an association between a Direct Connect gateway and a virtual private gateway or transit
         * gateway.
         * </p>
         * 
         * @param directConnectGatewayAssociation
         *        Information about an association between a Direct Connect gateway and a virtual private gateway or
         *        transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayAssociation(DirectConnectGatewayAssociation directConnectGatewayAssociation);

        /**
         * <p>
         * Information about an association between a Direct Connect gateway and a virtual private gateway or transit
         * gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link DirectConnectGatewayAssociation.Builder}
         * avoiding the need to create one manually via {@link DirectConnectGatewayAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectConnectGatewayAssociation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #directConnectGatewayAssociation(DirectConnectGatewayAssociation)}.
         * 
         * @param directConnectGatewayAssociation
         *        a consumer that will call methods on {@link DirectConnectGatewayAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directConnectGatewayAssociation(DirectConnectGatewayAssociation)
         */
        default Builder directConnectGatewayAssociation(
                Consumer<DirectConnectGatewayAssociation.Builder> directConnectGatewayAssociation) {
            return directConnectGatewayAssociation(DirectConnectGatewayAssociation.builder()
                    .applyMutation(directConnectGatewayAssociation).build());
        }
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private DirectConnectGatewayAssociation directConnectGatewayAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDirectConnectGatewayAssociationResponse model) {
            super(model);
            directConnectGatewayAssociation(model.directConnectGatewayAssociation);
        }

        public final DirectConnectGatewayAssociation.Builder getDirectConnectGatewayAssociation() {
            return directConnectGatewayAssociation != null ? directConnectGatewayAssociation.toBuilder() : null;
        }

        public final void setDirectConnectGatewayAssociation(
                DirectConnectGatewayAssociation.BuilderImpl directConnectGatewayAssociation) {
            this.directConnectGatewayAssociation = directConnectGatewayAssociation != null ? directConnectGatewayAssociation
                    .build() : null;
        }

        @Override
        public final Builder directConnectGatewayAssociation(DirectConnectGatewayAssociation directConnectGatewayAssociation) {
            this.directConnectGatewayAssociation = directConnectGatewayAssociation;
            return this;
        }

        @Override
        public UpdateDirectConnectGatewayAssociationResponse build() {
            return new UpdateDirectConnectGatewayAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
