/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentState;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachmentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DirectConnectGatewayAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DirectConnectGatewayAttachment> {
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("directConnectGatewayId").getter(DirectConnectGatewayAttachment.getter(DirectConnectGatewayAttachment::directConnectGatewayId)).setter(DirectConnectGatewayAttachment.setter(Builder::directConnectGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build()}).build();
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceId").getter(DirectConnectGatewayAttachment.getter(DirectConnectGatewayAttachment::virtualInterfaceId)).setter(DirectConnectGatewayAttachment.setter(Builder::virtualInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build()}).build();
    private static final SdkField<String> VIRTUAL_INTERFACE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceRegion").getter(DirectConnectGatewayAttachment.getter(DirectConnectGatewayAttachment::virtualInterfaceRegion)).setter(DirectConnectGatewayAttachment.setter(Builder::virtualInterfaceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceRegion").build()}).build();
    private static final SdkField<String> VIRTUAL_INTERFACE_OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceOwnerAccount").getter(DirectConnectGatewayAttachment.getter(DirectConnectGatewayAttachment::virtualInterfaceOwnerAccount)).setter(DirectConnectGatewayAttachment.setter(Builder::virtualInterfaceOwnerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceOwnerAccount").build()}).build();
    private static final SdkField<String> ATTACHMENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attachmentState").getter(DirectConnectGatewayAttachment.getter(DirectConnectGatewayAttachment::attachmentStateAsString)).setter(DirectConnectGatewayAttachment.setter(Builder::attachmentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentState").build()}).build();
    private static final SdkField<String> ATTACHMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attachmentType").getter(DirectConnectGatewayAttachment.getter(DirectConnectGatewayAttachment::attachmentTypeAsString)).setter(DirectConnectGatewayAttachment.setter(Builder::attachmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentType").build()}).build();
    private static final SdkField<String> STATE_CHANGE_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateChangeError").getter(DirectConnectGatewayAttachment.getter(DirectConnectGatewayAttachment::stateChangeError)).setter(DirectConnectGatewayAttachment.setter(Builder::stateChangeError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateChangeError").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECT_CONNECT_GATEWAY_ID_FIELD, VIRTUAL_INTERFACE_ID_FIELD, VIRTUAL_INTERFACE_REGION_FIELD, VIRTUAL_INTERFACE_OWNER_ACCOUNT_FIELD, ATTACHMENT_STATE_FIELD, ATTACHMENT_TYPE_FIELD, STATE_CHANGE_ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("directConnectGatewayId", DIRECT_CONNECT_GATEWAY_ID_FIELD);
            this.put("virtualInterfaceId", VIRTUAL_INTERFACE_ID_FIELD);
            this.put("virtualInterfaceRegion", VIRTUAL_INTERFACE_REGION_FIELD);
            this.put("virtualInterfaceOwnerAccount", VIRTUAL_INTERFACE_OWNER_ACCOUNT_FIELD);
            this.put("attachmentState", ATTACHMENT_STATE_FIELD);
            this.put("attachmentType", ATTACHMENT_TYPE_FIELD);
            this.put("stateChangeError", STATE_CHANGE_ERROR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String directConnectGatewayId;
    private final String virtualInterfaceId;
    private final String virtualInterfaceRegion;
    private final String virtualInterfaceOwnerAccount;
    private final String attachmentState;
    private final String attachmentType;
    private final String stateChangeError;

    private DirectConnectGatewayAttachment(BuilderImpl builder) {
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.virtualInterfaceRegion = builder.virtualInterfaceRegion;
        this.virtualInterfaceOwnerAccount = builder.virtualInterfaceOwnerAccount;
        this.attachmentState = builder.attachmentState;
        this.attachmentType = builder.attachmentType;
        this.stateChangeError = builder.stateChangeError;
    }

    public final String directConnectGatewayId() {
        return this.directConnectGatewayId;
    }

    public final String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public final String virtualInterfaceRegion() {
        return this.virtualInterfaceRegion;
    }

    public final String virtualInterfaceOwnerAccount() {
        return this.virtualInterfaceOwnerAccount;
    }

    public final DirectConnectGatewayAttachmentState attachmentState() {
        return DirectConnectGatewayAttachmentState.fromValue(this.attachmentState);
    }

    public final String attachmentStateAsString() {
        return this.attachmentState;
    }

    public final DirectConnectGatewayAttachmentType attachmentType() {
        return DirectConnectGatewayAttachmentType.fromValue(this.attachmentType);
    }

    public final String attachmentTypeAsString() {
        return this.attachmentType;
    }

    public final String stateChangeError() {
        return this.stateChangeError;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeError());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectConnectGatewayAttachment)) {
            return false;
        }
        DirectConnectGatewayAttachment other = (DirectConnectGatewayAttachment)obj;
        return Objects.equals(this.directConnectGatewayId(), other.directConnectGatewayId()) && Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && Objects.equals(this.virtualInterfaceRegion(), other.virtualInterfaceRegion()) && Objects.equals(this.virtualInterfaceOwnerAccount(), other.virtualInterfaceOwnerAccount()) && Objects.equals(this.attachmentStateAsString(), other.attachmentStateAsString()) && Objects.equals(this.attachmentTypeAsString(), other.attachmentTypeAsString()) && Objects.equals(this.stateChangeError(), other.stateChangeError());
    }

    public final String toString() {
        return ToString.builder((String)"DirectConnectGatewayAttachment").add("DirectConnectGatewayId", (Object)this.directConnectGatewayId()).add("VirtualInterfaceId", (Object)this.virtualInterfaceId()).add("VirtualInterfaceRegion", (Object)this.virtualInterfaceRegion()).add("VirtualInterfaceOwnerAccount", (Object)this.virtualInterfaceOwnerAccount()).add("AttachmentState", (Object)this.attachmentStateAsString()).add("AttachmentType", (Object)this.attachmentTypeAsString()).add("StateChangeError", (Object)this.stateChangeError()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayId": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayId()));
            }
            case "virtualInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceId()));
            }
            case "virtualInterfaceRegion": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceRegion()));
            }
            case "virtualInterfaceOwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceOwnerAccount()));
            }
            case "attachmentState": {
                return Optional.ofNullable(clazz.cast(this.attachmentStateAsString()));
            }
            case "attachmentType": {
                return Optional.ofNullable(clazz.cast(this.attachmentTypeAsString()));
            }
            case "stateChangeError": {
                return Optional.ofNullable(clazz.cast(this.stateChangeError()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DirectConnectGatewayAttachment, T> g) {
        return obj -> g.apply((DirectConnectGatewayAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directConnectGatewayId;
        private String virtualInterfaceId;
        private String virtualInterfaceRegion;
        private String virtualInterfaceOwnerAccount;
        private String attachmentState;
        private String attachmentType;
        private String stateChangeError;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectConnectGatewayAttachment model) {
            this.directConnectGatewayId(model.directConnectGatewayId);
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.virtualInterfaceRegion(model.virtualInterfaceRegion);
            this.virtualInterfaceOwnerAccount(model.virtualInterfaceOwnerAccount);
            this.attachmentState(model.attachmentState);
            this.attachmentType(model.attachmentType);
            this.stateChangeError(model.stateChangeError);
        }

        public final String getDirectConnectGatewayId() {
            return this.directConnectGatewayId;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final String getVirtualInterfaceRegion() {
            return this.virtualInterfaceRegion;
        }

        public final void setVirtualInterfaceRegion(String virtualInterfaceRegion) {
            this.virtualInterfaceRegion = virtualInterfaceRegion;
        }

        @Override
        public final Builder virtualInterfaceRegion(String virtualInterfaceRegion) {
            this.virtualInterfaceRegion = virtualInterfaceRegion;
            return this;
        }

        public final String getVirtualInterfaceOwnerAccount() {
            return this.virtualInterfaceOwnerAccount;
        }

        public final void setVirtualInterfaceOwnerAccount(String virtualInterfaceOwnerAccount) {
            this.virtualInterfaceOwnerAccount = virtualInterfaceOwnerAccount;
        }

        @Override
        public final Builder virtualInterfaceOwnerAccount(String virtualInterfaceOwnerAccount) {
            this.virtualInterfaceOwnerAccount = virtualInterfaceOwnerAccount;
            return this;
        }

        public final String getAttachmentState() {
            return this.attachmentState;
        }

        public final void setAttachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
        }

        @Override
        public final Builder attachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
            return this;
        }

        @Override
        public final Builder attachmentState(DirectConnectGatewayAttachmentState attachmentState) {
            this.attachmentState(attachmentState == null ? null : attachmentState.toString());
            return this;
        }

        public final String getAttachmentType() {
            return this.attachmentType;
        }

        public final void setAttachmentType(String attachmentType) {
            this.attachmentType = attachmentType;
        }

        @Override
        public final Builder attachmentType(String attachmentType) {
            this.attachmentType = attachmentType;
            return this;
        }

        @Override
        public final Builder attachmentType(DirectConnectGatewayAttachmentType attachmentType) {
            this.attachmentType(attachmentType == null ? null : attachmentType.toString());
            return this;
        }

        public final String getStateChangeError() {
            return this.stateChangeError;
        }

        public final void setStateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
        }

        @Override
        public final Builder stateChangeError(String stateChangeError) {
            this.stateChangeError = stateChangeError;
            return this;
        }

        public DirectConnectGatewayAttachment build() {
            return new DirectConnectGatewayAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DirectConnectGatewayAttachment> {
        public Builder directConnectGatewayId(String var1);

        public Builder virtualInterfaceId(String var1);

        public Builder virtualInterfaceRegion(String var1);

        public Builder virtualInterfaceOwnerAccount(String var1);

        public Builder attachmentState(String var1);

        public Builder attachmentState(DirectConnectGatewayAttachmentState var1);

        public Builder attachmentType(String var1);

        public Builder attachmentType(DirectConnectGatewayAttachmentType var1);

        public Builder stateChangeError(String var1);
    }
}

