/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateMacSecKeyResponse extends DirectConnectResponse implements
        ToCopyableBuilder<AssociateMacSecKeyResponse.Builder, AssociateMacSecKeyResponse> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionId").getter(getter(AssociateMacSecKeyResponse::connectionId))
            .setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<List<MacSecKey>> MAC_SEC_KEYS_FIELD = SdkField
            .<List<MacSecKey>> builder(MarshallingType.LIST)
            .memberName("macSecKeys")
            .getter(getter(AssociateMacSecKeyResponse::macSecKeys))
            .setter(setter(Builder::macSecKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macSecKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MacSecKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(MacSecKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD,
            MAC_SEC_KEYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectionId;

    private final List<MacSecKey> macSecKeys;

    private AssociateMacSecKeyResponse(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.macSecKeys = builder.macSecKeys;
    }

    /**
     * <p>
     * The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).
     * </p>
     * 
     * @return The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the MacSecKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMacSecKeys() {
        return macSecKeys != null && !(macSecKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The MAC Security (MACsec) security keys associated with the dedicated connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMacSecKeys} method.
     * </p>
     * 
     * @return The MAC Security (MACsec) security keys associated with the dedicated connection.
     */
    public final List<MacSecKey> macSecKeys() {
        return macSecKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMacSecKeys() ? macSecKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateMacSecKeyResponse)) {
            return false;
        }
        AssociateMacSecKeyResponse other = (AssociateMacSecKeyResponse) obj;
        return Objects.equals(connectionId(), other.connectionId()) && hasMacSecKeys() == other.hasMacSecKeys()
                && Objects.equals(macSecKeys(), other.macSecKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateMacSecKeyResponse").add("ConnectionId", connectionId())
                .add("MacSecKeys", hasMacSecKeys() ? macSecKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "macSecKeys":
            return Optional.ofNullable(clazz.cast(macSecKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectionId", CONNECTION_ID_FIELD);
        map.put("macSecKeys", MAC_SEC_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateMacSecKeyResponse, T> g) {
        return obj -> g.apply((AssociateMacSecKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, AssociateMacSecKeyResponse> {
        /**
         * <p>
         * The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).
         * </p>
         * 
         * @param connectionId
         *        The ID of the dedicated connection (dxcon-xxxx), or the ID of the LAG (dxlag-xxxx).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The MAC Security (MACsec) security keys associated with the dedicated connection.
         * </p>
         * 
         * @param macSecKeys
         *        The MAC Security (MACsec) security keys associated with the dedicated connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macSecKeys(Collection<MacSecKey> macSecKeys);

        /**
         * <p>
         * The MAC Security (MACsec) security keys associated with the dedicated connection.
         * </p>
         * 
         * @param macSecKeys
         *        The MAC Security (MACsec) security keys associated with the dedicated connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macSecKeys(MacSecKey... macSecKeys);

        /**
         * <p>
         * The MAC Security (MACsec) security keys associated with the dedicated connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directconnect.model.MacSecKey.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.directconnect.model.MacSecKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directconnect.model.MacSecKey.Builder#build()} is called immediately
         * and its result is passed to {@link #macSecKeys(List<MacSecKey>)}.
         * 
         * @param macSecKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directconnect.model.MacSecKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #macSecKeys(java.util.Collection<MacSecKey>)
         */
        Builder macSecKeys(Consumer<MacSecKey.Builder>... macSecKeys);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private String connectionId;

        private List<MacSecKey> macSecKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateMacSecKeyResponse model) {
            super(model);
            connectionId(model.connectionId);
            macSecKeys(model.macSecKeys);
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final List<MacSecKey.Builder> getMacSecKeys() {
            List<MacSecKey.Builder> result = MacSecKeyListCopier.copyToBuilder(this.macSecKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMacSecKeys(Collection<MacSecKey.BuilderImpl> macSecKeys) {
            this.macSecKeys = MacSecKeyListCopier.copyFromBuilder(macSecKeys);
        }

        @Override
        public final Builder macSecKeys(Collection<MacSecKey> macSecKeys) {
            this.macSecKeys = MacSecKeyListCopier.copy(macSecKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macSecKeys(MacSecKey... macSecKeys) {
            macSecKeys(Arrays.asList(macSecKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macSecKeys(Consumer<MacSecKey.Builder>... macSecKeys) {
            macSecKeys(Stream.of(macSecKeys).map(c -> MacSecKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssociateMacSecKeyResponse build() {
            return new AssociateMacSecKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
