/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVirtualGatewaysResponse extends DirectConnectResponse implements
        ToCopyableBuilder<DescribeVirtualGatewaysResponse.Builder, DescribeVirtualGatewaysResponse> {
    private static final SdkField<List<VirtualGateway>> VIRTUAL_GATEWAYS_FIELD = SdkField
            .<List<VirtualGateway>> builder(MarshallingType.LIST)
            .memberName("virtualGateways")
            .getter(getter(DescribeVirtualGatewaysResponse::virtualGateways))
            .setter(setter(Builder::virtualGateways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGateways").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VirtualGateway> builder(MarshallingType.SDK_POJO)
                                            .constructor(VirtualGateway::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_GATEWAYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<VirtualGateway> virtualGateways;

    private DescribeVirtualGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.virtualGateways = builder.virtualGateways;
    }

    /**
     * For responses, this returns true if the service returned a value for the VirtualGateways property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVirtualGateways() {
        return virtualGateways != null && !(virtualGateways instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The virtual private gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVirtualGateways} method.
     * </p>
     * 
     * @return The virtual private gateways.
     */
    public final List<VirtualGateway> virtualGateways() {
        return virtualGateways;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVirtualGateways() ? virtualGateways() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVirtualGatewaysResponse)) {
            return false;
        }
        DescribeVirtualGatewaysResponse other = (DescribeVirtualGatewaysResponse) obj;
        return hasVirtualGateways() == other.hasVirtualGateways() && Objects.equals(virtualGateways(), other.virtualGateways());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVirtualGatewaysResponse")
                .add("VirtualGateways", hasVirtualGateways() ? virtualGateways() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualGateways":
            return Optional.ofNullable(clazz.cast(virtualGateways()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("virtualGateways", VIRTUAL_GATEWAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVirtualGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeVirtualGatewaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVirtualGatewaysResponse> {
        /**
         * <p>
         * The virtual private gateways.
         * </p>
         * 
         * @param virtualGateways
         *        The virtual private gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGateways(Collection<VirtualGateway> virtualGateways);

        /**
         * <p>
         * The virtual private gateways.
         * </p>
         * 
         * @param virtualGateways
         *        The virtual private gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGateways(VirtualGateway... virtualGateways);

        /**
         * <p>
         * The virtual private gateways.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directconnect.model.VirtualGateway.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.directconnect.model.VirtualGateway#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directconnect.model.VirtualGateway.Builder#build()} is called
         * immediately and its result is passed to {@link #virtualGateways(List<VirtualGateway>)}.
         * 
         * @param virtualGateways
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directconnect.model.VirtualGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualGateways(java.util.Collection<VirtualGateway>)
         */
        Builder virtualGateways(Consumer<VirtualGateway.Builder>... virtualGateways);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private List<VirtualGateway> virtualGateways = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVirtualGatewaysResponse model) {
            super(model);
            virtualGateways(model.virtualGateways);
        }

        public final List<VirtualGateway.Builder> getVirtualGateways() {
            List<VirtualGateway.Builder> result = VirtualGatewayListCopier.copyToBuilder(this.virtualGateways);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVirtualGateways(Collection<VirtualGateway.BuilderImpl> virtualGateways) {
            this.virtualGateways = VirtualGatewayListCopier.copyFromBuilder(virtualGateways);
        }

        @Override
        public final Builder virtualGateways(Collection<VirtualGateway> virtualGateways) {
            this.virtualGateways = VirtualGatewayListCopier.copy(virtualGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualGateways(VirtualGateway... virtualGateways) {
            virtualGateways(Arrays.asList(virtualGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualGateways(Consumer<VirtualGateway.Builder>... virtualGateways) {
            virtualGateways(Stream.of(virtualGateways).map(c -> VirtualGateway.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeVirtualGatewaysResponse build() {
            return new DescribeVirtualGatewaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
