/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Direct Connect location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Location implements SdkPojo, Serializable, ToCopyableBuilder<Location.Builder, Location> {
    private static final SdkField<String> LOCATION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("locationCode").getter(getter(Location::locationCode)).setter(setter(Builder::locationCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationCode").build()).build();

    private static final SdkField<String> LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("locationName").getter(getter(Location::locationName)).setter(setter(Builder::locationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationName").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(Location::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<List<String>> AVAILABLE_PORT_SPEEDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("availablePortSpeeds")
            .getter(getter(Location::availablePortSpeeds))
            .setter(setter(Builder::availablePortSpeeds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availablePortSpeeds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AVAILABLE_PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("availableProviders")
            .getter(getter(Location::availableProviders))
            .setter(setter(Builder::availableProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AVAILABLE_MAC_SEC_PORT_SPEEDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("availableMacSecPortSpeeds")
            .getter(getter(Location::availableMacSecPortSpeeds))
            .setter(setter(Builder::availableMacSecPortSpeeds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableMacSecPortSpeeds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_CODE_FIELD,
            LOCATION_NAME_FIELD, REGION_FIELD, AVAILABLE_PORT_SPEEDS_FIELD, AVAILABLE_PROVIDERS_FIELD,
            AVAILABLE_MAC_SEC_PORT_SPEEDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String locationCode;

    private final String locationName;

    private final String region;

    private final List<String> availablePortSpeeds;

    private final List<String> availableProviders;

    private final List<String> availableMacSecPortSpeeds;

    private Location(BuilderImpl builder) {
        this.locationCode = builder.locationCode;
        this.locationName = builder.locationName;
        this.region = builder.region;
        this.availablePortSpeeds = builder.availablePortSpeeds;
        this.availableProviders = builder.availableProviders;
        this.availableMacSecPortSpeeds = builder.availableMacSecPortSpeeds;
    }

    /**
     * <p>
     * The code for the location.
     * </p>
     * 
     * @return The code for the location.
     */
    public final String locationCode() {
        return locationCode;
    }

    /**
     * <p>
     * The name of the location. This includes the name of the colocation partner and the physical site of the building.
     * </p>
     * 
     * @return The name of the location. This includes the name of the colocation partner and the physical site of the
     *         building.
     */
    public final String locationName() {
        return locationName;
    }

    /**
     * <p>
     * The Amazon Web Services Region for the location.
     * </p>
     * 
     * @return The Amazon Web Services Region for the location.
     */
    public final String region() {
        return region;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailablePortSpeeds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailablePortSpeeds() {
        return availablePortSpeeds != null && !(availablePortSpeeds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The available port speeds for the location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailablePortSpeeds} method.
     * </p>
     * 
     * @return The available port speeds for the location.
     */
    public final List<String> availablePortSpeeds() {
        return availablePortSpeeds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailableProviders property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailableProviders() {
        return availableProviders != null && !(availableProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the service provider for the location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailableProviders} method.
     * </p>
     * 
     * @return The name of the service provider for the location.
     */
    public final List<String> availableProviders() {
        return availableProviders;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailableMacSecPortSpeeds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAvailableMacSecPortSpeeds() {
        return availableMacSecPortSpeeds != null && !(availableMacSecPortSpeeds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The available MAC Security (MACsec) port speeds for the location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailableMacSecPortSpeeds} method.
     * </p>
     * 
     * @return The available MAC Security (MACsec) port speeds for the location.
     */
    public final List<String> availableMacSecPortSpeeds() {
        return availableMacSecPortSpeeds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(locationCode());
        hashCode = 31 * hashCode + Objects.hashCode(locationName());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailablePortSpeeds() ? availablePortSpeeds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailableProviders() ? availableProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailableMacSecPortSpeeds() ? availableMacSecPortSpeeds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location) obj;
        return Objects.equals(locationCode(), other.locationCode()) && Objects.equals(locationName(), other.locationName())
                && Objects.equals(region(), other.region()) && hasAvailablePortSpeeds() == other.hasAvailablePortSpeeds()
                && Objects.equals(availablePortSpeeds(), other.availablePortSpeeds())
                && hasAvailableProviders() == other.hasAvailableProviders()
                && Objects.equals(availableProviders(), other.availableProviders())
                && hasAvailableMacSecPortSpeeds() == other.hasAvailableMacSecPortSpeeds()
                && Objects.equals(availableMacSecPortSpeeds(), other.availableMacSecPortSpeeds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Location").add("LocationCode", locationCode()).add("LocationName", locationName())
                .add("Region", region()).add("AvailablePortSpeeds", hasAvailablePortSpeeds() ? availablePortSpeeds() : null)
                .add("AvailableProviders", hasAvailableProviders() ? availableProviders() : null)
                .add("AvailableMacSecPortSpeeds", hasAvailableMacSecPortSpeeds() ? availableMacSecPortSpeeds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "locationCode":
            return Optional.ofNullable(clazz.cast(locationCode()));
        case "locationName":
            return Optional.ofNullable(clazz.cast(locationName()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "availablePortSpeeds":
            return Optional.ofNullable(clazz.cast(availablePortSpeeds()));
        case "availableProviders":
            return Optional.ofNullable(clazz.cast(availableProviders()));
        case "availableMacSecPortSpeeds":
            return Optional.ofNullable(clazz.cast(availableMacSecPortSpeeds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("locationCode", LOCATION_CODE_FIELD);
        map.put("locationName", LOCATION_NAME_FIELD);
        map.put("region", REGION_FIELD);
        map.put("availablePortSpeeds", AVAILABLE_PORT_SPEEDS_FIELD);
        map.put("availableProviders", AVAILABLE_PROVIDERS_FIELD);
        map.put("availableMacSecPortSpeeds", AVAILABLE_MAC_SEC_PORT_SPEEDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Location, T> g) {
        return obj -> g.apply((Location) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Location> {
        /**
         * <p>
         * The code for the location.
         * </p>
         * 
         * @param locationCode
         *        The code for the location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationCode(String locationCode);

        /**
         * <p>
         * The name of the location. This includes the name of the colocation partner and the physical site of the
         * building.
         * </p>
         * 
         * @param locationName
         *        The name of the location. This includes the name of the colocation partner and the physical site of
         *        the building.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationName(String locationName);

        /**
         * <p>
         * The Amazon Web Services Region for the location.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region for the location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The available port speeds for the location.
         * </p>
         * 
         * @param availablePortSpeeds
         *        The available port speeds for the location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availablePortSpeeds(Collection<String> availablePortSpeeds);

        /**
         * <p>
         * The available port speeds for the location.
         * </p>
         * 
         * @param availablePortSpeeds
         *        The available port speeds for the location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availablePortSpeeds(String... availablePortSpeeds);

        /**
         * <p>
         * The name of the service provider for the location.
         * </p>
         * 
         * @param availableProviders
         *        The name of the service provider for the location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableProviders(Collection<String> availableProviders);

        /**
         * <p>
         * The name of the service provider for the location.
         * </p>
         * 
         * @param availableProviders
         *        The name of the service provider for the location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableProviders(String... availableProviders);

        /**
         * <p>
         * The available MAC Security (MACsec) port speeds for the location.
         * </p>
         * 
         * @param availableMacSecPortSpeeds
         *        The available MAC Security (MACsec) port speeds for the location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableMacSecPortSpeeds(Collection<String> availableMacSecPortSpeeds);

        /**
         * <p>
         * The available MAC Security (MACsec) port speeds for the location.
         * </p>
         * 
         * @param availableMacSecPortSpeeds
         *        The available MAC Security (MACsec) port speeds for the location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableMacSecPortSpeeds(String... availableMacSecPortSpeeds);
    }

    static final class BuilderImpl implements Builder {
        private String locationCode;

        private String locationName;

        private String region;

        private List<String> availablePortSpeeds = DefaultSdkAutoConstructList.getInstance();

        private List<String> availableProviders = DefaultSdkAutoConstructList.getInstance();

        private List<String> availableMacSecPortSpeeds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Location model) {
            locationCode(model.locationCode);
            locationName(model.locationName);
            region(model.region);
            availablePortSpeeds(model.availablePortSpeeds);
            availableProviders(model.availableProviders);
            availableMacSecPortSpeeds(model.availableMacSecPortSpeeds);
        }

        public final String getLocationCode() {
            return locationCode;
        }

        public final void setLocationCode(String locationCode) {
            this.locationCode = locationCode;
        }

        @Override
        public final Builder locationCode(String locationCode) {
            this.locationCode = locationCode;
            return this;
        }

        public final String getLocationName() {
            return locationName;
        }

        public final void setLocationName(String locationName) {
            this.locationName = locationName;
        }

        @Override
        public final Builder locationName(String locationName) {
            this.locationName = locationName;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Collection<String> getAvailablePortSpeeds() {
            if (availablePortSpeeds instanceof SdkAutoConstructList) {
                return null;
            }
            return availablePortSpeeds;
        }

        public final void setAvailablePortSpeeds(Collection<String> availablePortSpeeds) {
            this.availablePortSpeeds = AvailablePortSpeedsCopier.copy(availablePortSpeeds);
        }

        @Override
        public final Builder availablePortSpeeds(Collection<String> availablePortSpeeds) {
            this.availablePortSpeeds = AvailablePortSpeedsCopier.copy(availablePortSpeeds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availablePortSpeeds(String... availablePortSpeeds) {
            availablePortSpeeds(Arrays.asList(availablePortSpeeds));
            return this;
        }

        public final Collection<String> getAvailableProviders() {
            if (availableProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return availableProviders;
        }

        public final void setAvailableProviders(Collection<String> availableProviders) {
            this.availableProviders = ProviderListCopier.copy(availableProviders);
        }

        @Override
        public final Builder availableProviders(Collection<String> availableProviders) {
            this.availableProviders = ProviderListCopier.copy(availableProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableProviders(String... availableProviders) {
            availableProviders(Arrays.asList(availableProviders));
            return this;
        }

        public final Collection<String> getAvailableMacSecPortSpeeds() {
            if (availableMacSecPortSpeeds instanceof SdkAutoConstructList) {
                return null;
            }
            return availableMacSecPortSpeeds;
        }

        public final void setAvailableMacSecPortSpeeds(Collection<String> availableMacSecPortSpeeds) {
            this.availableMacSecPortSpeeds = AvailableMacSecPortSpeedsCopier.copy(availableMacSecPortSpeeds);
        }

        @Override
        public final Builder availableMacSecPortSpeeds(Collection<String> availableMacSecPortSpeeds) {
            this.availableMacSecPortSpeeds = AvailableMacSecPortSpeedsCopier.copy(availableMacSecPortSpeeds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableMacSecPortSpeeds(String... availableMacSecPortSpeeds) {
            availableMacSecPortSpeeds(Arrays.asList(availableMacSecPortSpeeds));
            return this;
        }

        @Override
        public Location build() {
            return new Location(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
