/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartBgpFailoverTestResponse extends DirectConnectResponse implements
        ToCopyableBuilder<StartBgpFailoverTestResponse.Builder, StartBgpFailoverTestResponse> {
    private static final SdkField<VirtualInterfaceTestHistory> VIRTUAL_INTERFACE_TEST_FIELD = SdkField
            .<VirtualInterfaceTestHistory> builder(MarshallingType.SDK_POJO).memberName("virtualInterfaceTest")
            .getter(getter(StartBgpFailoverTestResponse::virtualInterfaceTest)).setter(setter(Builder::virtualInterfaceTest))
            .constructor(VirtualInterfaceTestHistory::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceTest").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_TEST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VirtualInterfaceTestHistory virtualInterfaceTest;

    private StartBgpFailoverTestResponse(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceTest = builder.virtualInterfaceTest;
    }

    /**
     * <p>
     * Information about the virtual interface failover test.
     * </p>
     * 
     * @return Information about the virtual interface failover test.
     */
    public final VirtualInterfaceTestHistory virtualInterfaceTest() {
        return virtualInterfaceTest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceTest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBgpFailoverTestResponse)) {
            return false;
        }
        StartBgpFailoverTestResponse other = (StartBgpFailoverTestResponse) obj;
        return Objects.equals(virtualInterfaceTest(), other.virtualInterfaceTest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartBgpFailoverTestResponse").add("VirtualInterfaceTest", virtualInterfaceTest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualInterfaceTest":
            return Optional.ofNullable(clazz.cast(virtualInterfaceTest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("virtualInterfaceTest", VIRTUAL_INTERFACE_TEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartBgpFailoverTestResponse, T> g) {
        return obj -> g.apply((StartBgpFailoverTestResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartBgpFailoverTestResponse> {
        /**
         * <p>
         * Information about the virtual interface failover test.
         * </p>
         * 
         * @param virtualInterfaceTest
         *        Information about the virtual interface failover test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceTest(VirtualInterfaceTestHistory virtualInterfaceTest);

        /**
         * <p>
         * Information about the virtual interface failover test.
         * </p>
         * This is a convenience method that creates an instance of the {@link VirtualInterfaceTestHistory.Builder}
         * avoiding the need to create one manually via {@link VirtualInterfaceTestHistory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VirtualInterfaceTestHistory.Builder#build()} is called
         * immediately and its result is passed to {@link #virtualInterfaceTest(VirtualInterfaceTestHistory)}.
         * 
         * @param virtualInterfaceTest
         *        a consumer that will call methods on {@link VirtualInterfaceTestHistory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualInterfaceTest(VirtualInterfaceTestHistory)
         */
        default Builder virtualInterfaceTest(Consumer<VirtualInterfaceTestHistory.Builder> virtualInterfaceTest) {
            return virtualInterfaceTest(VirtualInterfaceTestHistory.builder().applyMutation(virtualInterfaceTest).build());
        }
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private VirtualInterfaceTestHistory virtualInterfaceTest;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBgpFailoverTestResponse model) {
            super(model);
            virtualInterfaceTest(model.virtualInterfaceTest);
        }

        public final VirtualInterfaceTestHistory.Builder getVirtualInterfaceTest() {
            return virtualInterfaceTest != null ? virtualInterfaceTest.toBuilder() : null;
        }

        public final void setVirtualInterfaceTest(VirtualInterfaceTestHistory.BuilderImpl virtualInterfaceTest) {
            this.virtualInterfaceTest = virtualInterfaceTest != null ? virtualInterfaceTest.build() : null;
        }

        @Override
        public final Builder virtualInterfaceTest(VirtualInterfaceTestHistory virtualInterfaceTest) {
            this.virtualInterfaceTest = virtualInterfaceTest;
            return this;
        }

        @Override
        public StartBgpFailoverTestResponse build() {
            return new StartBgpFailoverTestResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
