/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.InterconnectState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteInterconnectResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DeleteInterconnectResponse> {
    private static final SdkField<String> INTERCONNECT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interconnectState").getter(DeleteInterconnectResponse.getter(DeleteInterconnectResponse::interconnectStateAsString)).setter(DeleteInterconnectResponse.setter(Builder::interconnectState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interconnectState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERCONNECT_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteInterconnectResponse.memberNameToFieldInitializer();
    private final String interconnectState;

    private DeleteInterconnectResponse(BuilderImpl builder) {
        super(builder);
        this.interconnectState = builder.interconnectState;
    }

    public final InterconnectState interconnectState() {
        return InterconnectState.fromValue(this.interconnectState);
    }

    public final String interconnectStateAsString() {
        return this.interconnectState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInterconnectResponse)) {
            return false;
        }
        DeleteInterconnectResponse other = (DeleteInterconnectResponse)((Object)obj);
        return Objects.equals(this.interconnectStateAsString(), other.interconnectStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteInterconnectResponse").add("InterconnectState", (Object)this.interconnectStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interconnectState": {
                return Optional.ofNullable(clazz.cast(this.interconnectStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("interconnectState", INTERCONNECT_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteInterconnectResponse, T> g) {
        return obj -> g.apply((DeleteInterconnectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private String interconnectState;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInterconnectResponse model) {
            super(model);
            this.interconnectState(model.interconnectState);
        }

        public final String getInterconnectState() {
            return this.interconnectState;
        }

        public final void setInterconnectState(String interconnectState) {
            this.interconnectState = interconnectState;
        }

        @Override
        public final Builder interconnectState(String interconnectState) {
            this.interconnectState = interconnectState;
            return this;
        }

        @Override
        public final Builder interconnectState(InterconnectState interconnectState) {
            this.interconnectState(interconnectState == null ? null : interconnectState.toString());
            return this;
        }

        @Override
        public DeleteInterconnectResponse build() {
            return new DeleteInterconnectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteInterconnectResponse> {
        public Builder interconnectState(String var1);

        public Builder interconnectState(InterconnectState var1);
    }
}

