/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.RouterType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRouterConfigurationResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeRouterConfigurationResponse> {
    private static final SdkField<String> CUSTOMER_ROUTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerRouterConfig").getter(DescribeRouterConfigurationResponse.getter(DescribeRouterConfigurationResponse::customerRouterConfig)).setter(DescribeRouterConfigurationResponse.setter(Builder::customerRouterConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerRouterConfig").build()}).build();
    private static final SdkField<RouterType> ROUTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("router").getter(DescribeRouterConfigurationResponse.getter(DescribeRouterConfigurationResponse::router)).setter(DescribeRouterConfigurationResponse.setter(Builder::router)).constructor(RouterType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("router").build()}).build();
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceId").getter(DescribeRouterConfigurationResponse.getter(DescribeRouterConfigurationResponse::virtualInterfaceId)).setter(DescribeRouterConfigurationResponse.setter(Builder::virtualInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build()}).build();
    private static final SdkField<String> VIRTUAL_INTERFACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceName").getter(DescribeRouterConfigurationResponse.getter(DescribeRouterConfigurationResponse::virtualInterfaceName)).setter(DescribeRouterConfigurationResponse.setter(Builder::virtualInterfaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_ROUTER_CONFIG_FIELD, ROUTER_FIELD, VIRTUAL_INTERFACE_ID_FIELD, VIRTUAL_INTERFACE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRouterConfigurationResponse.memberNameToFieldInitializer();
    private final String customerRouterConfig;
    private final RouterType router;
    private final String virtualInterfaceId;
    private final String virtualInterfaceName;

    private DescribeRouterConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.customerRouterConfig = builder.customerRouterConfig;
        this.router = builder.router;
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.virtualInterfaceName = builder.virtualInterfaceName;
    }

    public final String customerRouterConfig() {
        return this.customerRouterConfig;
    }

    public final RouterType router() {
        return this.router;
    }

    public final String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public final String virtualInterfaceName() {
        return this.virtualInterfaceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.customerRouterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.router());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouterConfigurationResponse)) {
            return false;
        }
        DescribeRouterConfigurationResponse other = (DescribeRouterConfigurationResponse)((Object)obj);
        return Objects.equals(this.customerRouterConfig(), other.customerRouterConfig()) && Objects.equals(this.router(), other.router()) && Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && Objects.equals(this.virtualInterfaceName(), other.virtualInterfaceName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRouterConfigurationResponse").add("CustomerRouterConfig", (Object)this.customerRouterConfig()).add("Router", (Object)this.router()).add("VirtualInterfaceId", (Object)this.virtualInterfaceId()).add("VirtualInterfaceName", (Object)this.virtualInterfaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customerRouterConfig": {
                return Optional.ofNullable(clazz.cast(this.customerRouterConfig()));
            }
            case "router": {
                return Optional.ofNullable(clazz.cast(this.router()));
            }
            case "virtualInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceId()));
            }
            case "virtualInterfaceName": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerRouterConfig", CUSTOMER_ROUTER_CONFIG_FIELD);
        map.put("router", ROUTER_FIELD);
        map.put("virtualInterfaceId", VIRTUAL_INTERFACE_ID_FIELD);
        map.put("virtualInterfaceName", VIRTUAL_INTERFACE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRouterConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeRouterConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private String customerRouterConfig;
        private RouterType router;
        private String virtualInterfaceId;
        private String virtualInterfaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouterConfigurationResponse model) {
            super(model);
            this.customerRouterConfig(model.customerRouterConfig);
            this.router(model.router);
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.virtualInterfaceName(model.virtualInterfaceName);
        }

        public final String getCustomerRouterConfig() {
            return this.customerRouterConfig;
        }

        public final void setCustomerRouterConfig(String customerRouterConfig) {
            this.customerRouterConfig = customerRouterConfig;
        }

        @Override
        public final Builder customerRouterConfig(String customerRouterConfig) {
            this.customerRouterConfig = customerRouterConfig;
            return this;
        }

        public final RouterType.Builder getRouter() {
            return this.router != null ? this.router.toBuilder() : null;
        }

        public final void setRouter(RouterType.BuilderImpl router) {
            this.router = router != null ? router.build() : null;
        }

        @Override
        public final Builder router(RouterType router) {
            this.router = router;
            return this;
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final String getVirtualInterfaceName() {
            return this.virtualInterfaceName;
        }

        public final void setVirtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
        }

        @Override
        public final Builder virtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
            return this;
        }

        @Override
        public DescribeRouterConfigurationResponse build() {
            return new DescribeRouterConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRouterConfigurationResponse> {
        public Builder customerRouterConfig(String var1);

        public Builder router(RouterType var1);

        default public Builder router(Consumer<RouterType.Builder> router) {
            return this.router((RouterType)((RouterType.Builder)RouterType.builder().applyMutation(router)).build());
        }

        public Builder virtualInterfaceId(String var1);

        public Builder virtualInterfaceName(String var1);
    }
}

