/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.directconnect.DirectConnectClient;
import software.amazon.awssdk.services.directconnect.DirectConnectServiceClientConfiguration;
import software.amazon.awssdk.services.directconnect.internal.DirectConnectServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest;
import software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse;
import software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest;
import software.amazon.awssdk.services.directconnect.model.CreateBgpPeerResponse;
import software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.CreateConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationResponse;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse;
import software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest;
import software.amazon.awssdk.services.directconnect.model.CreateInterconnectResponse;
import software.amazon.awssdk.services.directconnect.model.CreateLagRequest;
import software.amazon.awssdk.services.directconnect.model.CreateLagResponse;
import software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteLagRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteLagResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeCustomerMetadataRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeCustomerMetadataResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeLocationsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse;
import software.amazon.awssdk.services.directconnect.model.DirectConnectClientException;
import software.amazon.awssdk.services.directconnect.model.DirectConnectException;
import software.amazon.awssdk.services.directconnect.model.DirectConnectServerException;
import software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest;
import software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagResponse;
import software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyRequest;
import software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyResponse;
import software.amazon.awssdk.services.directconnect.model.DuplicateTagKeysException;
import software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest;
import software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse;
import software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest;
import software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestResponse;
import software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestRequest;
import software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestResponse;
import software.amazon.awssdk.services.directconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.directconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.directconnect.model.TooManyTagsException;
import software.amazon.awssdk.services.directconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.directconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateLagRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateLagResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesResponse;
import software.amazon.awssdk.services.directconnect.transform.AcceptDirectConnectGatewayAssociationProposalRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocateHostedConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocatePrivateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocatePublicVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocateTransitVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateConnectionWithLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateHostedConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateMacSecKeyRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmCustomerAgreementRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmPrivateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmPublicVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmTransitVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateBgpPeerRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateDirectConnectGatewayAssociationProposalRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateDirectConnectGatewayAssociationRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateDirectConnectGatewayRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateInterconnectRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreatePrivateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreatePublicVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateTransitVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteBgpPeerRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteDirectConnectGatewayAssociationProposalRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteDirectConnectGatewayAssociationRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteDirectConnectGatewayRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteInterconnectRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeConnectionsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeCustomerMetadataRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewayAssociationProposalsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewayAssociationsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewayAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewaysRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeHostedConnectionsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeInterconnectsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeLagsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeLoaRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeLocationsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeRouterConfigurationRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeVirtualGatewaysRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeVirtualInterfacesRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DisassociateConnectionFromLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DisassociateMacSecKeyRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ListVirtualInterfaceTestHistoryRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.StartBgpFailoverTestRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.StopBgpFailoverTestRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateDirectConnectGatewayAssociationRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateDirectConnectGatewayRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateVirtualInterfaceAttributesRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultDirectConnectClient
implements DirectConnectClient {
    private static final Logger log = Logger.loggerFor(DefaultDirectConnectClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDirectConnectClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Direct_Connect#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptDirectConnectGatewayAssociationProposalResponse acceptDirectConnectGatewayAssociationProposal(AcceptDirectConnectGatewayAssociationProposalRequest acceptDirectConnectGatewayAssociationProposalRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptDirectConnectGatewayAssociationProposalResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acceptDirectConnectGatewayAssociationProposalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, acceptDirectConnectGatewayAssociationProposalRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptDirectConnectGatewayAssociationProposal");
            AcceptDirectConnectGatewayAssociationProposalResponse acceptDirectConnectGatewayAssociationProposalResponse = (AcceptDirectConnectGatewayAssociationProposalResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptDirectConnectGatewayAssociationProposal").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)acceptDirectConnectGatewayAssociationProposalRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcceptDirectConnectGatewayAssociationProposalRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptDirectConnectGatewayAssociationProposalResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$acceptDirectConnectGatewayAssociationProposal$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocateHostedConnectionResponse allocateHostedConnection(AllocateHostedConnectionRequest allocateHostedConnectionRequest) throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AllocateHostedConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)allocateHostedConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, allocateHostedConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AllocateHostedConnection");
            AllocateHostedConnectionResponse allocateHostedConnectionResponse = (AllocateHostedConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AllocateHostedConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)allocateHostedConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AllocateHostedConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return allocateHostedConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$allocateHostedConnection$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocatePrivateVirtualInterfaceResponse allocatePrivateVirtualInterface(AllocatePrivateVirtualInterfaceRequest allocatePrivateVirtualInterfaceRequest) throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AllocatePrivateVirtualInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)allocatePrivateVirtualInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, allocatePrivateVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AllocatePrivateVirtualInterface");
            AllocatePrivateVirtualInterfaceResponse allocatePrivateVirtualInterfaceResponse = (AllocatePrivateVirtualInterfaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AllocatePrivateVirtualInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)allocatePrivateVirtualInterfaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AllocatePrivateVirtualInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return allocatePrivateVirtualInterfaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$allocatePrivateVirtualInterface$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocatePublicVirtualInterfaceResponse allocatePublicVirtualInterface(AllocatePublicVirtualInterfaceRequest allocatePublicVirtualInterfaceRequest) throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AllocatePublicVirtualInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)allocatePublicVirtualInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, allocatePublicVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AllocatePublicVirtualInterface");
            AllocatePublicVirtualInterfaceResponse allocatePublicVirtualInterfaceResponse = (AllocatePublicVirtualInterfaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AllocatePublicVirtualInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)allocatePublicVirtualInterfaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AllocatePublicVirtualInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return allocatePublicVirtualInterfaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$allocatePublicVirtualInterface$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocateTransitVirtualInterfaceResponse allocateTransitVirtualInterface(AllocateTransitVirtualInterfaceRequest allocateTransitVirtualInterfaceRequest) throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AllocateTransitVirtualInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)allocateTransitVirtualInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, allocateTransitVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AllocateTransitVirtualInterface");
            AllocateTransitVirtualInterfaceResponse allocateTransitVirtualInterfaceResponse = (AllocateTransitVirtualInterfaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AllocateTransitVirtualInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)allocateTransitVirtualInterfaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AllocateTransitVirtualInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return allocateTransitVirtualInterfaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$allocateTransitVirtualInterface$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateConnectionWithLagResponse associateConnectionWithLag(AssociateConnectionWithLagRequest associateConnectionWithLagRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateConnectionWithLagResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateConnectionWithLagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, associateConnectionWithLagRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateConnectionWithLag");
            AssociateConnectionWithLagResponse associateConnectionWithLagResponse = (AssociateConnectionWithLagResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateConnectionWithLag").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateConnectionWithLagRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateConnectionWithLagRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateConnectionWithLagResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$associateConnectionWithLag$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateHostedConnectionResponse associateHostedConnection(AssociateHostedConnectionRequest associateHostedConnectionRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateHostedConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateHostedConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, associateHostedConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateHostedConnection");
            AssociateHostedConnectionResponse associateHostedConnectionResponse = (AssociateHostedConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateHostedConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateHostedConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateHostedConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateHostedConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$associateHostedConnection$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateMacSecKeyResponse associateMacSecKey(AssociateMacSecKeyRequest associateMacSecKeyRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateMacSecKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateMacSecKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, associateMacSecKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateMacSecKey");
            AssociateMacSecKeyResponse associateMacSecKeyResponse = (AssociateMacSecKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateMacSecKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateMacSecKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateMacSecKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateMacSecKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$associateMacSecKey$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateVirtualInterfaceResponse associateVirtualInterface(AssociateVirtualInterfaceRequest associateVirtualInterfaceRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateVirtualInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateVirtualInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, associateVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateVirtualInterface");
            AssociateVirtualInterfaceResponse associateVirtualInterfaceResponse = (AssociateVirtualInterfaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateVirtualInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateVirtualInterfaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateVirtualInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateVirtualInterfaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$associateVirtualInterface$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmConnectionResponse confirmConnection(ConfirmConnectionRequest confirmConnectionRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConfirmConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)confirmConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, confirmConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConfirmConnection");
            ConfirmConnectionResponse confirmConnectionResponse = (ConfirmConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfirmConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)confirmConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ConfirmConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return confirmConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$confirmConnection$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmCustomerAgreementResponse confirmCustomerAgreement(ConfirmCustomerAgreementRequest confirmCustomerAgreementRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConfirmCustomerAgreementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)confirmCustomerAgreementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, confirmCustomerAgreementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConfirmCustomerAgreement");
            ConfirmCustomerAgreementResponse confirmCustomerAgreementResponse = (ConfirmCustomerAgreementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfirmCustomerAgreement").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)confirmCustomerAgreementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ConfirmCustomerAgreementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return confirmCustomerAgreementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$confirmCustomerAgreement$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmPrivateVirtualInterfaceResponse confirmPrivateVirtualInterface(ConfirmPrivateVirtualInterfaceRequest confirmPrivateVirtualInterfaceRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConfirmPrivateVirtualInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)confirmPrivateVirtualInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, confirmPrivateVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConfirmPrivateVirtualInterface");
            ConfirmPrivateVirtualInterfaceResponse confirmPrivateVirtualInterfaceResponse = (ConfirmPrivateVirtualInterfaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfirmPrivateVirtualInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)confirmPrivateVirtualInterfaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ConfirmPrivateVirtualInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return confirmPrivateVirtualInterfaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$confirmPrivateVirtualInterface$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmPublicVirtualInterfaceResponse confirmPublicVirtualInterface(ConfirmPublicVirtualInterfaceRequest confirmPublicVirtualInterfaceRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConfirmPublicVirtualInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)confirmPublicVirtualInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, confirmPublicVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConfirmPublicVirtualInterface");
            ConfirmPublicVirtualInterfaceResponse confirmPublicVirtualInterfaceResponse = (ConfirmPublicVirtualInterfaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfirmPublicVirtualInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)confirmPublicVirtualInterfaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ConfirmPublicVirtualInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return confirmPublicVirtualInterfaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$confirmPublicVirtualInterface$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmTransitVirtualInterfaceResponse confirmTransitVirtualInterface(ConfirmTransitVirtualInterfaceRequest confirmTransitVirtualInterfaceRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ConfirmTransitVirtualInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)confirmTransitVirtualInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, confirmTransitVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ConfirmTransitVirtualInterface");
            ConfirmTransitVirtualInterfaceResponse confirmTransitVirtualInterfaceResponse = (ConfirmTransitVirtualInterfaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ConfirmTransitVirtualInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)confirmTransitVirtualInterfaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ConfirmTransitVirtualInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return confirmTransitVirtualInterfaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$confirmTransitVirtualInterface$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBgpPeerResponse createBGPPeer(CreateBgpPeerRequest createBgpPeerRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBgpPeerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBgpPeerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, createBgpPeerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBGPPeer");
            CreateBgpPeerResponse createBgpPeerResponse = (CreateBgpPeerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBGPPeer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBgpPeerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBgpPeerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBgpPeerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$createBGPPeer$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConnectionResponse createConnection(CreateConnectionRequest createConnectionRequest) throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, createConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConnection");
            CreateConnectionResponse createConnectionResponse = (CreateConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$createConnection$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDirectConnectGatewayResponse createDirectConnectGateway(CreateDirectConnectGatewayRequest createDirectConnectGatewayRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDirectConnectGatewayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDirectConnectGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, createDirectConnectGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDirectConnectGateway");
            CreateDirectConnectGatewayResponse createDirectConnectGatewayResponse = (CreateDirectConnectGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDirectConnectGateway").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDirectConnectGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDirectConnectGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDirectConnectGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$createDirectConnectGateway$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDirectConnectGatewayAssociationResponse createDirectConnectGatewayAssociation(CreateDirectConnectGatewayAssociationRequest createDirectConnectGatewayAssociationRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDirectConnectGatewayAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDirectConnectGatewayAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, createDirectConnectGatewayAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDirectConnectGatewayAssociation");
            CreateDirectConnectGatewayAssociationResponse createDirectConnectGatewayAssociationResponse = (CreateDirectConnectGatewayAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDirectConnectGatewayAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDirectConnectGatewayAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDirectConnectGatewayAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDirectConnectGatewayAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$createDirectConnectGatewayAssociation$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDirectConnectGatewayAssociationProposalResponse createDirectConnectGatewayAssociationProposal(CreateDirectConnectGatewayAssociationProposalRequest createDirectConnectGatewayAssociationProposalRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDirectConnectGatewayAssociationProposalResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDirectConnectGatewayAssociationProposalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, createDirectConnectGatewayAssociationProposalRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDirectConnectGatewayAssociationProposal");
            CreateDirectConnectGatewayAssociationProposalResponse createDirectConnectGatewayAssociationProposalResponse = (CreateDirectConnectGatewayAssociationProposalResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDirectConnectGatewayAssociationProposal").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDirectConnectGatewayAssociationProposalRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDirectConnectGatewayAssociationProposalRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDirectConnectGatewayAssociationProposalResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$createDirectConnectGatewayAssociationProposal$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateInterconnectResponse createInterconnect(CreateInterconnectRequest createInterconnectRequest) throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInterconnectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createInterconnectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, createInterconnectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInterconnect");
            CreateInterconnectResponse createInterconnectResponse = (CreateInterconnectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInterconnect").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createInterconnectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateInterconnectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createInterconnectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$createInterconnect$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLagResponse createLag(CreateLagRequest createLagRequest) throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLagResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, createLagRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLag");
            CreateLagResponse createLagResponse = (CreateLagResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLag").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createLagRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLagRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLagResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$createLag$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePrivateVirtualInterfaceResponse createPrivateVirtualInterface(CreatePrivateVirtualInterfaceRequest createPrivateVirtualInterfaceRequest) throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePrivateVirtualInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPrivateVirtualInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, createPrivateVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePrivateVirtualInterface");
            CreatePrivateVirtualInterfaceResponse createPrivateVirtualInterfaceResponse = (CreatePrivateVirtualInterfaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePrivateVirtualInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPrivateVirtualInterfaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePrivateVirtualInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPrivateVirtualInterfaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$createPrivateVirtualInterface$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePublicVirtualInterfaceResponse createPublicVirtualInterface(CreatePublicVirtualInterfaceRequest createPublicVirtualInterfaceRequest) throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePublicVirtualInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPublicVirtualInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, createPublicVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePublicVirtualInterface");
            CreatePublicVirtualInterfaceResponse createPublicVirtualInterfaceResponse = (CreatePublicVirtualInterfaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePublicVirtualInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPublicVirtualInterfaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePublicVirtualInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPublicVirtualInterfaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$createPublicVirtualInterface$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTransitVirtualInterfaceResponse createTransitVirtualInterface(CreateTransitVirtualInterfaceRequest createTransitVirtualInterfaceRequest) throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTransitVirtualInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTransitVirtualInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, createTransitVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTransitVirtualInterface");
            CreateTransitVirtualInterfaceResponse createTransitVirtualInterfaceResponse = (CreateTransitVirtualInterfaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTransitVirtualInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTransitVirtualInterfaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTransitVirtualInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTransitVirtualInterfaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$createTransitVirtualInterface$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBgpPeerResponse deleteBGPPeer(DeleteBgpPeerRequest deleteBgpPeerRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBgpPeerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBgpPeerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, deleteBgpPeerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBGPPeer");
            DeleteBgpPeerResponse deleteBgpPeerResponse = (DeleteBgpPeerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBGPPeer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBgpPeerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBgpPeerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBgpPeerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$deleteBGPPeer$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, deleteConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConnection");
            DeleteConnectionResponse deleteConnectionResponse = (DeleteConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$deleteConnection$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDirectConnectGatewayResponse deleteDirectConnectGateway(DeleteDirectConnectGatewayRequest deleteDirectConnectGatewayRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDirectConnectGatewayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDirectConnectGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, deleteDirectConnectGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDirectConnectGateway");
            DeleteDirectConnectGatewayResponse deleteDirectConnectGatewayResponse = (DeleteDirectConnectGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDirectConnectGateway").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDirectConnectGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDirectConnectGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDirectConnectGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$deleteDirectConnectGateway$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDirectConnectGatewayAssociationResponse deleteDirectConnectGatewayAssociation(DeleteDirectConnectGatewayAssociationRequest deleteDirectConnectGatewayAssociationRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDirectConnectGatewayAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDirectConnectGatewayAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, deleteDirectConnectGatewayAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDirectConnectGatewayAssociation");
            DeleteDirectConnectGatewayAssociationResponse deleteDirectConnectGatewayAssociationResponse = (DeleteDirectConnectGatewayAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDirectConnectGatewayAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDirectConnectGatewayAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDirectConnectGatewayAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDirectConnectGatewayAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$deleteDirectConnectGatewayAssociation$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDirectConnectGatewayAssociationProposalResponse deleteDirectConnectGatewayAssociationProposal(DeleteDirectConnectGatewayAssociationProposalRequest deleteDirectConnectGatewayAssociationProposalRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDirectConnectGatewayAssociationProposalResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDirectConnectGatewayAssociationProposalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, deleteDirectConnectGatewayAssociationProposalRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDirectConnectGatewayAssociationProposal");
            DeleteDirectConnectGatewayAssociationProposalResponse deleteDirectConnectGatewayAssociationProposalResponse = (DeleteDirectConnectGatewayAssociationProposalResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDirectConnectGatewayAssociationProposal").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDirectConnectGatewayAssociationProposalRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDirectConnectGatewayAssociationProposalRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDirectConnectGatewayAssociationProposalResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$deleteDirectConnectGatewayAssociationProposal$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInterconnectResponse deleteInterconnect(DeleteInterconnectRequest deleteInterconnectRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInterconnectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteInterconnectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, deleteInterconnectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInterconnect");
            DeleteInterconnectResponse deleteInterconnectResponse = (DeleteInterconnectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInterconnect").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteInterconnectRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteInterconnectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteInterconnectResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$deleteInterconnect$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLagResponse deleteLag(DeleteLagRequest deleteLagRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLagResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, deleteLagRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLag");
            DeleteLagResponse deleteLagResponse = (DeleteLagResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLag").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteLagRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLagRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLagResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$deleteLag$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVirtualInterfaceResponse deleteVirtualInterface(DeleteVirtualInterfaceRequest deleteVirtualInterfaceRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVirtualInterfaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteVirtualInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, deleteVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVirtualInterface");
            DeleteVirtualInterfaceResponse deleteVirtualInterfaceResponse = (DeleteVirtualInterfaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVirtualInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteVirtualInterfaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVirtualInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVirtualInterfaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$deleteVirtualInterface$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectionsResponse describeConnections(DescribeConnectionsRequest describeConnectionsRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConnectionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, describeConnectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnections");
            DescribeConnectionsResponse describeConnectionsResponse = (DescribeConnectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnections").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConnectionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConnectionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$describeConnections$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCustomerMetadataResponse describeCustomerMetadata(DescribeCustomerMetadataRequest describeCustomerMetadataRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCustomerMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCustomerMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, describeCustomerMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCustomerMetadata");
            DescribeCustomerMetadataResponse describeCustomerMetadataResponse = (DescribeCustomerMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCustomerMetadata").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeCustomerMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCustomerMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCustomerMetadataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$describeCustomerMetadata$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDirectConnectGatewayAssociationProposalsResponse describeDirectConnectGatewayAssociationProposals(DescribeDirectConnectGatewayAssociationProposalsRequest describeDirectConnectGatewayAssociationProposalsRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDirectConnectGatewayAssociationProposalsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDirectConnectGatewayAssociationProposalsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, describeDirectConnectGatewayAssociationProposalsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDirectConnectGatewayAssociationProposals");
            DescribeDirectConnectGatewayAssociationProposalsResponse describeDirectConnectGatewayAssociationProposalsResponse = (DescribeDirectConnectGatewayAssociationProposalsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDirectConnectGatewayAssociationProposals").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDirectConnectGatewayAssociationProposalsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDirectConnectGatewayAssociationProposalsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDirectConnectGatewayAssociationProposalsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$describeDirectConnectGatewayAssociationProposals$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDirectConnectGatewayAssociationsResponse describeDirectConnectGatewayAssociations(DescribeDirectConnectGatewayAssociationsRequest describeDirectConnectGatewayAssociationsRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDirectConnectGatewayAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDirectConnectGatewayAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, describeDirectConnectGatewayAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDirectConnectGatewayAssociations");
            DescribeDirectConnectGatewayAssociationsResponse describeDirectConnectGatewayAssociationsResponse = (DescribeDirectConnectGatewayAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDirectConnectGatewayAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDirectConnectGatewayAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDirectConnectGatewayAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDirectConnectGatewayAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$describeDirectConnectGatewayAssociations$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDirectConnectGatewayAttachmentsResponse describeDirectConnectGatewayAttachments(DescribeDirectConnectGatewayAttachmentsRequest describeDirectConnectGatewayAttachmentsRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDirectConnectGatewayAttachmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDirectConnectGatewayAttachmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, describeDirectConnectGatewayAttachmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDirectConnectGatewayAttachments");
            DescribeDirectConnectGatewayAttachmentsResponse describeDirectConnectGatewayAttachmentsResponse = (DescribeDirectConnectGatewayAttachmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDirectConnectGatewayAttachments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDirectConnectGatewayAttachmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDirectConnectGatewayAttachmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDirectConnectGatewayAttachmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$describeDirectConnectGatewayAttachments$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDirectConnectGatewaysResponse describeDirectConnectGateways(DescribeDirectConnectGatewaysRequest describeDirectConnectGatewaysRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDirectConnectGatewaysResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDirectConnectGatewaysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, describeDirectConnectGatewaysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDirectConnectGateways");
            DescribeDirectConnectGatewaysResponse describeDirectConnectGatewaysResponse = (DescribeDirectConnectGatewaysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDirectConnectGateways").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDirectConnectGatewaysRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDirectConnectGatewaysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDirectConnectGatewaysResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$describeDirectConnectGateways$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeHostedConnectionsResponse describeHostedConnections(DescribeHostedConnectionsRequest describeHostedConnectionsRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeHostedConnectionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeHostedConnectionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, describeHostedConnectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeHostedConnections");
            DescribeHostedConnectionsResponse describeHostedConnectionsResponse = (DescribeHostedConnectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHostedConnections").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeHostedConnectionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeHostedConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeHostedConnectionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$describeHostedConnections$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInterconnectsResponse describeInterconnects(DescribeInterconnectsRequest describeInterconnectsRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInterconnectsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeInterconnectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, describeInterconnectsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInterconnects");
            DescribeInterconnectsResponse describeInterconnectsResponse = (DescribeInterconnectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInterconnects").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeInterconnectsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeInterconnectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeInterconnectsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$describeInterconnects$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLagsResponse describeLags(DescribeLagsRequest describeLagsRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, describeLagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLags");
            DescribeLagsResponse describeLagsResponse = (DescribeLagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeLagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$describeLags$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoaResponse describeLoa(DescribeLoaRequest describeLoaRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLoaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLoaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, describeLoaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoa");
            DescribeLoaResponse describeLoaResponse = (DescribeLoaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoa").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeLoaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLoaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLoaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$describeLoa$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLocationsResponse describeLocations(DescribeLocationsRequest describeLocationsRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLocationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLocationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, describeLocationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLocations");
            DescribeLocationsResponse describeLocationsResponse = (DescribeLocationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLocations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeLocationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLocationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLocationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$describeLocations$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRouterConfigurationResponse describeRouterConfiguration(DescribeRouterConfigurationRequest describeRouterConfigurationRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRouterConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRouterConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, describeRouterConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRouterConfiguration");
            DescribeRouterConfigurationResponse describeRouterConfigurationResponse = (DescribeRouterConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRouterConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRouterConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRouterConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRouterConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$describeRouterConfiguration$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, describeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTags");
            DescribeTagsResponse describeTagsResponse = (DescribeTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$describeTags$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualGatewaysResponse describeVirtualGateways(DescribeVirtualGatewaysRequest describeVirtualGatewaysRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVirtualGatewaysResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeVirtualGatewaysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, describeVirtualGatewaysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVirtualGateways");
            DescribeVirtualGatewaysResponse describeVirtualGatewaysResponse = (DescribeVirtualGatewaysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVirtualGateways").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeVirtualGatewaysRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVirtualGatewaysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVirtualGatewaysResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$describeVirtualGateways$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualInterfacesResponse describeVirtualInterfaces(DescribeVirtualInterfacesRequest describeVirtualInterfacesRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVirtualInterfacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeVirtualInterfacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, describeVirtualInterfacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVirtualInterfaces");
            DescribeVirtualInterfacesResponse describeVirtualInterfacesResponse = (DescribeVirtualInterfacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVirtualInterfaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeVirtualInterfacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVirtualInterfacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVirtualInterfacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$describeVirtualInterfaces$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateConnectionFromLagResponse disassociateConnectionFromLag(DisassociateConnectionFromLagRequest disassociateConnectionFromLagRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateConnectionFromLagResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateConnectionFromLagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, disassociateConnectionFromLagRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateConnectionFromLag");
            DisassociateConnectionFromLagResponse disassociateConnectionFromLagResponse = (DisassociateConnectionFromLagResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateConnectionFromLag").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateConnectionFromLagRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateConnectionFromLagRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateConnectionFromLagResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$disassociateConnectionFromLag$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateMacSecKeyResponse disassociateMacSecKey(DisassociateMacSecKeyRequest disassociateMacSecKeyRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateMacSecKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateMacSecKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, disassociateMacSecKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateMacSecKey");
            DisassociateMacSecKeyResponse disassociateMacSecKeyResponse = (DisassociateMacSecKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateMacSecKey").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateMacSecKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateMacSecKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateMacSecKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$disassociateMacSecKey$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVirtualInterfaceTestHistoryResponse listVirtualInterfaceTestHistory(ListVirtualInterfaceTestHistoryRequest listVirtualInterfaceTestHistoryRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVirtualInterfaceTestHistoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVirtualInterfaceTestHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, listVirtualInterfaceTestHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVirtualInterfaceTestHistory");
            ListVirtualInterfaceTestHistoryResponse listVirtualInterfaceTestHistoryResponse = (ListVirtualInterfaceTestHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVirtualInterfaceTestHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listVirtualInterfaceTestHistoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVirtualInterfaceTestHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVirtualInterfaceTestHistoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$listVirtualInterfaceTestHistory$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartBgpFailoverTestResponse startBgpFailoverTest(StartBgpFailoverTestRequest startBgpFailoverTestRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartBgpFailoverTestResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startBgpFailoverTestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, startBgpFailoverTestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartBgpFailoverTest");
            StartBgpFailoverTestResponse startBgpFailoverTestResponse = (StartBgpFailoverTestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartBgpFailoverTest").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startBgpFailoverTestRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartBgpFailoverTestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startBgpFailoverTestResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$startBgpFailoverTest$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopBgpFailoverTestResponse stopBgpFailoverTest(StopBgpFailoverTestRequest stopBgpFailoverTestRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopBgpFailoverTestResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopBgpFailoverTestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, stopBgpFailoverTestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopBgpFailoverTest");
            StopBgpFailoverTestResponse stopBgpFailoverTestResponse = (StopBgpFailoverTestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopBgpFailoverTest").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopBgpFailoverTestRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopBgpFailoverTestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopBgpFailoverTestResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$stopBgpFailoverTest$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws DuplicateTagKeysException, TooManyTagsException, DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$tagResource$105((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$untagResource$107((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConnectionResponse updateConnection(UpdateConnectionRequest updateConnectionRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, updateConnectionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConnection");
            UpdateConnectionResponse updateConnectionResponse = (UpdateConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConnection").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateConnectionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConnectionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$updateConnection$109((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDirectConnectGatewayResponse updateDirectConnectGateway(UpdateDirectConnectGatewayRequest updateDirectConnectGatewayRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDirectConnectGatewayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDirectConnectGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, updateDirectConnectGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDirectConnectGateway");
            UpdateDirectConnectGatewayResponse updateDirectConnectGatewayResponse = (UpdateDirectConnectGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDirectConnectGateway").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDirectConnectGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDirectConnectGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDirectConnectGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$updateDirectConnectGateway$111((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDirectConnectGatewayAssociationResponse updateDirectConnectGatewayAssociation(UpdateDirectConnectGatewayAssociationRequest updateDirectConnectGatewayAssociationRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDirectConnectGatewayAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDirectConnectGatewayAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, updateDirectConnectGatewayAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDirectConnectGatewayAssociation");
            UpdateDirectConnectGatewayAssociationResponse updateDirectConnectGatewayAssociationResponse = (UpdateDirectConnectGatewayAssociationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDirectConnectGatewayAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDirectConnectGatewayAssociationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDirectConnectGatewayAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDirectConnectGatewayAssociationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$updateDirectConnectGatewayAssociation$113((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLagResponse updateLag(UpdateLagRequest updateLagRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLagResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, updateLagRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLag");
            UpdateLagResponse updateLagResponse = (UpdateLagResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLag").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateLagRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLagRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLagResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$updateLag$115((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVirtualInterfaceAttributesResponse updateVirtualInterfaceAttributes(UpdateVirtualInterfaceAttributesRequest updateVirtualInterfaceAttributesRequest) throws DirectConnectServerException, DirectConnectClientException, AwsServiceException, SdkClientException, DirectConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVirtualInterfaceAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "DirectConnectServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                }
                case "DirectConnectClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateVirtualInterfaceAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDirectConnectClient.resolveMetricPublishers(clientConfiguration, updateVirtualInterfaceAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVirtualInterfaceAttributes");
            UpdateVirtualInterfaceAttributesResponse updateVirtualInterfaceAttributesResponse = (UpdateVirtualInterfaceAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVirtualInterfaceAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateVirtualInterfaceAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVirtualInterfaceAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVirtualInterfaceAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDirectConnectClient.lambda$updateVirtualInterfaceAttributes$117((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "directconnect";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        DirectConnectServiceClientConfigurationBuilder serviceConfigBuilder = new DirectConnectServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DirectConnectException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final DirectConnectServiceClientConfiguration serviceClientConfiguration() {
        return new DirectConnectServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateVirtualInterfaceAttributes$117(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLag$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDirectConnectGatewayAssociation$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDirectConnectGateway$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConnection$109(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopBgpFailoverTest$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startBgpFailoverTest$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVirtualInterfaceTestHistory$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateMacSecKey$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateConnectionFromLag$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVirtualInterfaces$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVirtualGateways$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTags$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRouterConfiguration$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLocations$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLoa$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLags$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInterconnects$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeHostedConnections$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDirectConnectGateways$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDirectConnectGatewayAttachments$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDirectConnectGatewayAssociations$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDirectConnectGatewayAssociationProposals$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCustomerMetadata$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnections$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVirtualInterface$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLag$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInterconnect$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDirectConnectGatewayAssociationProposal$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDirectConnectGatewayAssociation$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDirectConnectGateway$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConnection$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBGPPeer$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTransitVirtualInterface$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPublicVirtualInterface$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPrivateVirtualInterface$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLag$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInterconnect$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDirectConnectGatewayAssociationProposal$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDirectConnectGatewayAssociation$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDirectConnectGateway$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConnection$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBGPPeer$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$confirmTransitVirtualInterface$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$confirmPublicVirtualInterface$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$confirmPrivateVirtualInterface$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$confirmCustomerAgreement$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$confirmConnection$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateVirtualInterface$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateMacSecKey$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateHostedConnection$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateConnectionWithLag$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$allocateTransitVirtualInterface$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$allocatePublicVirtualInterface$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$allocatePrivateVirtualInterface$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$allocateHostedConnection$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptDirectConnectGatewayAssociationProposal$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

