/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.directconnect.internal.DirectConnectServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.directconnect.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest;
import software.amazon.awssdk.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalResponse;
import software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.AllocateHostedConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AllocatePrivateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AllocatePublicVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AllocateTransitVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateConnectionWithLagResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateHostedConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateMacSecKeyResponse;
import software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.AssociateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmCustomerAgreementResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmPrivateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmPublicVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.ConfirmTransitVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.CreateBgpPeerRequest;
import software.amazon.awssdk.services.directconnect.model.CreateBgpPeerResponse;
import software.amazon.awssdk.services.directconnect.model.CreateConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.CreateConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalResponse;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayAssociationResponse;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayRequest;
import software.amazon.awssdk.services.directconnect.model.CreateDirectConnectGatewayResponse;
import software.amazon.awssdk.services.directconnect.model.CreateInterconnectRequest;
import software.amazon.awssdk.services.directconnect.model.CreateInterconnectResponse;
import software.amazon.awssdk.services.directconnect.model.CreateLagRequest;
import software.amazon.awssdk.services.directconnect.model.CreateLagResponse;
import software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.CreatePrivateVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.CreatePublicVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.CreateTransitVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteBgpPeerResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayAssociationResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteDirectConnectGatewayResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteInterconnectRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteInterconnectResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteLagRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteLagResponse;
import software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceRequest;
import software.amazon.awssdk.services.directconnect.model.DeleteVirtualInterfaceResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeConnectionsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeCustomerMetadataRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeCustomerMetadataResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAssociationsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeDirectConnectGatewaysResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeHostedConnectionsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeInterconnectsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeLagsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeLagsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeLoaRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeLoaResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeLocationsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeLocationsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeRouterConfigurationResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeTagsRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeTagsResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualGatewaysResponse;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesRequest;
import software.amazon.awssdk.services.directconnect.model.DescribeVirtualInterfacesResponse;
import software.amazon.awssdk.services.directconnect.model.DirectConnectClientException;
import software.amazon.awssdk.services.directconnect.model.DirectConnectException;
import software.amazon.awssdk.services.directconnect.model.DirectConnectServerException;
import software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagRequest;
import software.amazon.awssdk.services.directconnect.model.DisassociateConnectionFromLagResponse;
import software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyRequest;
import software.amazon.awssdk.services.directconnect.model.DisassociateMacSecKeyResponse;
import software.amazon.awssdk.services.directconnect.model.DuplicateTagKeysException;
import software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest;
import software.amazon.awssdk.services.directconnect.model.ListVirtualInterfaceTestHistoryResponse;
import software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestRequest;
import software.amazon.awssdk.services.directconnect.model.StartBgpFailoverTestResponse;
import software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestRequest;
import software.amazon.awssdk.services.directconnect.model.StopBgpFailoverTestResponse;
import software.amazon.awssdk.services.directconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.directconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.directconnect.model.TooManyTagsException;
import software.amazon.awssdk.services.directconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.directconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateConnectionRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateConnectionResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayAssociationResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateDirectConnectGatewayResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateLagRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateLagResponse;
import software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest;
import software.amazon.awssdk.services.directconnect.model.UpdateVirtualInterfaceAttributesResponse;
import software.amazon.awssdk.services.directconnect.transform.AcceptDirectConnectGatewayAssociationProposalRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocateHostedConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocatePrivateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocatePublicVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AllocateTransitVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateConnectionWithLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateHostedConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateMacSecKeyRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.AssociateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmCustomerAgreementRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmPrivateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmPublicVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ConfirmTransitVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateBgpPeerRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateDirectConnectGatewayAssociationProposalRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateDirectConnectGatewayAssociationRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateDirectConnectGatewayRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateInterconnectRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreatePrivateVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreatePublicVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.CreateTransitVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteBgpPeerRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteDirectConnectGatewayAssociationProposalRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteDirectConnectGatewayAssociationRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteDirectConnectGatewayRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteInterconnectRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DeleteVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeConnectionsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeCustomerMetadataRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewayAssociationProposalsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewayAssociationsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewayAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeDirectConnectGatewaysRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeHostedConnectionsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeInterconnectsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeLagsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeLoaRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeLocationsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeRouterConfigurationRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeVirtualGatewaysRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DescribeVirtualInterfacesRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DisassociateConnectionFromLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.DisassociateMacSecKeyRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.ListVirtualInterfaceTestHistoryRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.StartBgpFailoverTestRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.StopBgpFailoverTestRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateConnectionRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateDirectConnectGatewayAssociationRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateDirectConnectGatewayRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateLagRequestMarshaller;
import software.amazon.awssdk.services.directconnect.transform.UpdateVirtualInterfaceAttributesRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link DirectConnectAsyncClient}.
 *
 * @see DirectConnectAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultDirectConnectAsyncClient implements DirectConnectAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultDirectConnectAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDirectConnectAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Direct_Connect" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Accepts a proposal request to attach a virtual private gateway or transit gateway to a Direct Connect gateway.
     * </p>
     *
     * @param acceptDirectConnectGatewayAssociationProposalRequest
     * @return A Java Future containing the result of the AcceptDirectConnectGatewayAssociationProposal operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.AcceptDirectConnectGatewayAssociationProposal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AcceptDirectConnectGatewayAssociationProposal"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptDirectConnectGatewayAssociationProposalResponse> acceptDirectConnectGatewayAssociationProposal(
            AcceptDirectConnectGatewayAssociationProposalRequest acceptDirectConnectGatewayAssociationProposalRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                acceptDirectConnectGatewayAssociationProposalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptDirectConnectGatewayAssociationProposalRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptDirectConnectGatewayAssociationProposal");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptDirectConnectGatewayAssociationProposalResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AcceptDirectConnectGatewayAssociationProposalResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AcceptDirectConnectGatewayAssociationProposalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptDirectConnectGatewayAssociationProposalRequest, AcceptDirectConnectGatewayAssociationProposalResponse>()
                            .withOperationName("AcceptDirectConnectGatewayAssociationProposal")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptDirectConnectGatewayAssociationProposalRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptDirectConnectGatewayAssociationProposalRequest));
            CompletableFuture<AcceptDirectConnectGatewayAssociationProposalResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects.
     * </p>
     * <p>
     * Allocates a VLAN number and a specified amount of capacity (bandwidth) for use by a hosted connection on the
     * specified interconnect or LAG of interconnects. Amazon Web Services polices the hosted connection for the
     * specified capacity and the Direct Connect Partner must also police the hosted connection for the specified
     * capacity.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note>
     *
     * @param allocateHostedConnectionRequest
     * @return A Java Future containing the result of the AllocateHostedConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>TooManyTagsException You have reached the limit on the number of tags that can be assigned.</li>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.AllocateHostedConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateHostedConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AllocateHostedConnectionResponse> allocateHostedConnection(
            AllocateHostedConnectionRequest allocateHostedConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(allocateHostedConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, allocateHostedConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllocateHostedConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AllocateHostedConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AllocateHostedConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AllocateHostedConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AllocateHostedConnectionRequest, AllocateHostedConnectionResponse>()
                            .withOperationName("AllocateHostedConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AllocateHostedConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(allocateHostedConnectionRequest));
            CompletableFuture<AllocateHostedConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provisions a private virtual interface to be owned by the specified Amazon Web Services account.
     * </p>
     * <p>
     * Virtual interfaces created using this action must be confirmed by the owner using
     * <a>ConfirmPrivateVirtualInterface</a>. Until then, the virtual interface is in the <code>Confirming</code> state
     * and is not available to handle traffic.
     * </p>
     *
     * @param allocatePrivateVirtualInterfaceRequest
     * @return A Java Future containing the result of the AllocatePrivateVirtualInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>TooManyTagsException You have reached the limit on the number of tags that can be assigned.</li>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.AllocatePrivateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePrivateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AllocatePrivateVirtualInterfaceResponse> allocatePrivateVirtualInterface(
            AllocatePrivateVirtualInterfaceRequest allocatePrivateVirtualInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(allocatePrivateVirtualInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                allocatePrivateVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllocatePrivateVirtualInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AllocatePrivateVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AllocatePrivateVirtualInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AllocatePrivateVirtualInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AllocatePrivateVirtualInterfaceRequest, AllocatePrivateVirtualInterfaceResponse>()
                            .withOperationName("AllocatePrivateVirtualInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AllocatePrivateVirtualInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(allocatePrivateVirtualInterfaceRequest));
            CompletableFuture<AllocatePrivateVirtualInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provisions a public virtual interface to be owned by the specified Amazon Web Services account.
     * </p>
     * <p>
     * The owner of a connection calls this function to provision a public virtual interface to be owned by the
     * specified Amazon Web Services account.
     * </p>
     * <p>
     * Virtual interfaces created using this function must be confirmed by the owner using
     * <a>ConfirmPublicVirtualInterface</a>. Until this step has been completed, the virtual interface is in the
     * <code>confirming</code> state and is not available to handle traffic.
     * </p>
     * <p>
     * When creating an IPv6 public virtual interface, omit the Amazon address and customer address. IPv6 addresses are
     * automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     * </p>
     *
     * @param allocatePublicVirtualInterfaceRequest
     * @return A Java Future containing the result of the AllocatePublicVirtualInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>TooManyTagsException You have reached the limit on the number of tags that can be assigned.</li>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.AllocatePublicVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePublicVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AllocatePublicVirtualInterfaceResponse> allocatePublicVirtualInterface(
            AllocatePublicVirtualInterfaceRequest allocatePublicVirtualInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(allocatePublicVirtualInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                allocatePublicVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllocatePublicVirtualInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AllocatePublicVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AllocatePublicVirtualInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AllocatePublicVirtualInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AllocatePublicVirtualInterfaceRequest, AllocatePublicVirtualInterfaceResponse>()
                            .withOperationName("AllocatePublicVirtualInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AllocatePublicVirtualInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(allocatePublicVirtualInterfaceRequest));
            CompletableFuture<AllocatePublicVirtualInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provisions a transit virtual interface to be owned by the specified Amazon Web Services account. Use this type of
     * interface to connect a transit gateway to your Direct Connect gateway.
     * </p>
     * <p>
     * The owner of a connection provisions a transit virtual interface to be owned by the specified Amazon Web Services
     * account.
     * </p>
     * <p>
     * After you create a transit virtual interface, it must be confirmed by the owner using
     * <a>ConfirmTransitVirtualInterface</a>. Until this step has been completed, the transit virtual interface is in
     * the <code>requested</code> state and is not available to handle traffic.
     * </p>
     *
     * @param allocateTransitVirtualInterfaceRequest
     * @return A Java Future containing the result of the AllocateTransitVirtualInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>TooManyTagsException You have reached the limit on the number of tags that can be assigned.</li>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.AllocateTransitVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateTransitVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AllocateTransitVirtualInterfaceResponse> allocateTransitVirtualInterface(
            AllocateTransitVirtualInterfaceRequest allocateTransitVirtualInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(allocateTransitVirtualInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                allocateTransitVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllocateTransitVirtualInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AllocateTransitVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AllocateTransitVirtualInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AllocateTransitVirtualInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AllocateTransitVirtualInterfaceRequest, AllocateTransitVirtualInterfaceResponse>()
                            .withOperationName("AllocateTransitVirtualInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AllocateTransitVirtualInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(allocateTransitVirtualInterfaceRequest));
            CompletableFuture<AllocateTransitVirtualInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates an existing connection with a link aggregation group (LAG). The connection is interrupted and
     * re-established as a member of the LAG (connectivity to Amazon Web Services is interrupted). The connection must
     * be hosted on the same Direct Connect endpoint as the LAG, and its bandwidth must match the bandwidth for the LAG.
     * You can re-associate a connection that's currently associated with a different LAG; however, if removing the
     * connection would cause the original LAG to fall below its setting for minimum number of operational connections,
     * the request fails.
     * </p>
     * <p>
     * Any virtual interfaces that are directly associated with the connection are automatically re-associated with the
     * LAG. If the connection was originally associated with a different LAG, the virtual interfaces remain associated
     * with the original LAG.
     * </p>
     * <p>
     * For interconnects, any hosted connections are automatically re-associated with the LAG. If the interconnect was
     * originally associated with a different LAG, the hosted connections remain associated with the original LAG.
     * </p>
     *
     * @param associateConnectionWithLagRequest
     * @return A Java Future containing the result of the AssociateConnectionWithLag operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.AssociateConnectionWithLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateConnectionWithLag"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateConnectionWithLagResponse> associateConnectionWithLag(
            AssociateConnectionWithLagRequest associateConnectionWithLagRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateConnectionWithLagRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateConnectionWithLagRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateConnectionWithLag");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateConnectionWithLagResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateConnectionWithLagResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AssociateConnectionWithLagResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateConnectionWithLagRequest, AssociateConnectionWithLagResponse>()
                            .withOperationName("AssociateConnectionWithLag").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateConnectionWithLagRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateConnectionWithLagRequest));
            CompletableFuture<AssociateConnectionWithLagResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a hosted connection and its virtual interfaces with a link aggregation group (LAG) or interconnect. If
     * the target interconnect or LAG has an existing hosted connection with a conflicting VLAN number or IP address,
     * the operation fails. This action temporarily interrupts the hosted connection's connectivity to Amazon Web
     * Services as it is being migrated.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note>
     *
     * @param associateHostedConnectionRequest
     * @return A Java Future containing the result of the AssociateHostedConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.AssociateHostedConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateHostedConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateHostedConnectionResponse> associateHostedConnection(
            AssociateHostedConnectionRequest associateHostedConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateHostedConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateHostedConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateHostedConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateHostedConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateHostedConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AssociateHostedConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateHostedConnectionRequest, AssociateHostedConnectionResponse>()
                            .withOperationName("AssociateHostedConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateHostedConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateHostedConnectionRequest));
            CompletableFuture<AssociateHostedConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a MAC Security (MACsec) Connection Key Name (CKN)/ Connectivity Association Key (CAK) pair with a
     * Direct Connect connection.
     * </p>
     * <p>
     * You must supply either the <code>secretARN,</code> or the CKN/CAK (<code>ckn</code> and <code>cak</code>) pair in
     * the request.
     * </p>
     * <p>
     * For information about MAC Security (MACsec) key considerations, see <a href=
     * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-key-consideration"
     * >MACsec pre-shared CKN/CAK key considerations </a> in the <i>Direct Connect User Guide</i>.
     * </p>
     *
     * @param associateMacSecKeyRequest
     * @return A Java Future containing the result of the AssociateMacSecKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.AssociateMacSecKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateMacSecKey"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateMacSecKeyResponse> associateMacSecKey(AssociateMacSecKeyRequest associateMacSecKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateMacSecKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateMacSecKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateMacSecKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateMacSecKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateMacSecKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AssociateMacSecKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateMacSecKeyRequest, AssociateMacSecKeyResponse>()
                            .withOperationName("AssociateMacSecKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateMacSecKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateMacSecKeyRequest));
            CompletableFuture<AssociateMacSecKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a virtual interface with a specified link aggregation group (LAG) or connection. Connectivity to
     * Amazon Web Services is temporarily interrupted as the virtual interface is being migrated. If the target
     * connection or LAG has an associated virtual interface with a conflicting VLAN number or a conflicting IP address,
     * the operation fails.
     * </p>
     * <p>
     * Virtual interfaces associated with a hosted connection cannot be associated with a LAG; hosted connections must
     * be migrated along with their virtual interfaces using <a>AssociateHostedConnection</a>.
     * </p>
     * <p>
     * To reassociate a virtual interface to a new connection or LAG, the requester must own either the virtual
     * interface itself or the connection to which the virtual interface is currently associated. Additionally, the
     * requester must own the connection or LAG for the association.
     * </p>
     *
     * @param associateVirtualInterfaceRequest
     * @return A Java Future containing the result of the AssociateVirtualInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.AssociateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AssociateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateVirtualInterfaceResponse> associateVirtualInterface(
            AssociateVirtualInterfaceRequest associateVirtualInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateVirtualInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateVirtualInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateVirtualInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateVirtualInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AssociateVirtualInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateVirtualInterfaceRequest, AssociateVirtualInterfaceResponse>()
                            .withOperationName("AssociateVirtualInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateVirtualInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateVirtualInterfaceRequest));
            CompletableFuture<AssociateVirtualInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Confirms the creation of the specified hosted connection on an interconnect.
     * </p>
     * <p>
     * Upon creation, the hosted connection is initially in the <code>Ordering</code> state, and remains in this state
     * until the owner confirms creation of the hosted connection.
     * </p>
     *
     * @param confirmConnectionRequest
     * @return A Java Future containing the result of the ConfirmConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.ConfirmConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmConnectionResponse> confirmConnection(ConfirmConnectionRequest confirmConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ConfirmConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ConfirmConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ConfirmConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConfirmConnectionRequest, ConfirmConnectionResponse>()
                            .withOperationName("ConfirmConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ConfirmConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(confirmConnectionRequest));
            CompletableFuture<ConfirmConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The confirmation of the terms of agreement when creating the connection/link aggregation group (LAG).
     * </p>
     *
     * @param confirmCustomerAgreementRequest
     * @return A Java Future containing the result of the ConfirmCustomerAgreement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.ConfirmCustomerAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmCustomerAgreement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmCustomerAgreementResponse> confirmCustomerAgreement(
            ConfirmCustomerAgreementRequest confirmCustomerAgreementRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmCustomerAgreementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmCustomerAgreementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmCustomerAgreement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ConfirmCustomerAgreementResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ConfirmCustomerAgreementResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ConfirmCustomerAgreementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConfirmCustomerAgreementRequest, ConfirmCustomerAgreementResponse>()
                            .withOperationName("ConfirmCustomerAgreement").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ConfirmCustomerAgreementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(confirmCustomerAgreementRequest));
            CompletableFuture<ConfirmCustomerAgreementResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts ownership of a private virtual interface created by another Amazon Web Services account.
     * </p>
     * <p>
     * After the virtual interface owner makes this call, the virtual interface is created and attached to the specified
     * virtual private gateway or Direct Connect gateway, and is made available to handle traffic.
     * </p>
     *
     * @param confirmPrivateVirtualInterfaceRequest
     * @return A Java Future containing the result of the ConfirmPrivateVirtualInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.ConfirmPrivateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPrivateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmPrivateVirtualInterfaceResponse> confirmPrivateVirtualInterface(
            ConfirmPrivateVirtualInterfaceRequest confirmPrivateVirtualInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmPrivateVirtualInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                confirmPrivateVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmPrivateVirtualInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ConfirmPrivateVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ConfirmPrivateVirtualInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ConfirmPrivateVirtualInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConfirmPrivateVirtualInterfaceRequest, ConfirmPrivateVirtualInterfaceResponse>()
                            .withOperationName("ConfirmPrivateVirtualInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ConfirmPrivateVirtualInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(confirmPrivateVirtualInterfaceRequest));
            CompletableFuture<ConfirmPrivateVirtualInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts ownership of a public virtual interface created by another Amazon Web Services account.
     * </p>
     * <p>
     * After the virtual interface owner makes this call, the specified virtual interface is created and made available
     * to handle traffic.
     * </p>
     *
     * @param confirmPublicVirtualInterfaceRequest
     * @return A Java Future containing the result of the ConfirmPublicVirtualInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.ConfirmPublicVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPublicVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmPublicVirtualInterfaceResponse> confirmPublicVirtualInterface(
            ConfirmPublicVirtualInterfaceRequest confirmPublicVirtualInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmPublicVirtualInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                confirmPublicVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmPublicVirtualInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ConfirmPublicVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ConfirmPublicVirtualInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ConfirmPublicVirtualInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConfirmPublicVirtualInterfaceRequest, ConfirmPublicVirtualInterfaceResponse>()
                            .withOperationName("ConfirmPublicVirtualInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ConfirmPublicVirtualInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(confirmPublicVirtualInterfaceRequest));
            CompletableFuture<ConfirmPublicVirtualInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accepts ownership of a transit virtual interface created by another Amazon Web Services account.
     * </p>
     * <p>
     * After the owner of the transit virtual interface makes this call, the specified transit virtual interface is
     * created and made available to handle traffic.
     * </p>
     *
     * @param confirmTransitVirtualInterfaceRequest
     * @return A Java Future containing the result of the ConfirmTransitVirtualInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.ConfirmTransitVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmTransitVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ConfirmTransitVirtualInterfaceResponse> confirmTransitVirtualInterface(
            ConfirmTransitVirtualInterfaceRequest confirmTransitVirtualInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmTransitVirtualInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                confirmTransitVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmTransitVirtualInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ConfirmTransitVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ConfirmTransitVirtualInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ConfirmTransitVirtualInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConfirmTransitVirtualInterfaceRequest, ConfirmTransitVirtualInterfaceResponse>()
                            .withOperationName("ConfirmTransitVirtualInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ConfirmTransitVirtualInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(confirmTransitVirtualInterfaceRequest));
            CompletableFuture<ConfirmTransitVirtualInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a BGP peer on the specified virtual interface.
     * </p>
     * <p>
     * You must create a BGP peer for the corresponding address family (IPv4/IPv6) in order to access Amazon Web
     * Services resources that also use that address family.
     * </p>
     * <p>
     * If logical redundancy is not supported by the connection, interconnect, or LAG, the BGP peer cannot be in the
     * same address family as an existing BGP peer on the virtual interface.
     * </p>
     * <p>
     * When creating a IPv6 BGP peer, omit the Amazon address and customer address. IPv6 addresses are automatically
     * assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     * </p>
     * <important>
     * <p>
     * If you let Amazon Web Services auto-assign IPv4 addresses, a /30 CIDR will be allocated from 169.254.0.0/16.
     * Amazon Web Services does not recommend this option if you intend to use the customer router peer IP address as
     * the source and destination for traffic. Instead you should use RFC 1918 or other addressing, and specify the
     * address yourself. For more information about RFC 1918 see <a
     * href="https://datatracker.ietf.org/doc/html/rfc1918"> Address Allocation for Private Internets</a>.
     * </p>
     * </important>
     * <p>
     * For a public virtual interface, the Autonomous System Number (ASN) must be private or already on the allow list
     * for the virtual interface.
     * </p>
     *
     * @param createBgpPeerRequest
     * @return A Java Future containing the result of the CreateBGPPeer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.CreateBGPPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateBGPPeer" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBgpPeerResponse> createBGPPeer(CreateBgpPeerRequest createBgpPeerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBgpPeerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBgpPeerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBGPPeer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBgpPeerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateBgpPeerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateBgpPeerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBgpPeerRequest, CreateBgpPeerResponse>()
                            .withOperationName("CreateBGPPeer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBgpPeerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createBgpPeerRequest));
            CompletableFuture<CreateBgpPeerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a connection between a customer network and a specific Direct Connect location.
     * </p>
     * <p>
     * A connection links your internal network to an Direct Connect location over a standard Ethernet fiber-optic
     * cable. One end of the cable is connected to your router, the other to an Direct Connect router.
     * </p>
     * <p>
     * To find the locations for your Region, use <a>DescribeLocations</a>.
     * </p>
     * <p>
     * You can automatically add the new connection to a link aggregation group (LAG) by specifying a LAG ID in the
     * request. This ensures that the new connection is allocated on the same Direct Connect endpoint that hosts the
     * specified LAG. If there are no available ports on the endpoint, the request fails and no connection is created.
     * </p>
     *
     * @param createConnectionRequest
     * @return A Java Future containing the result of the CreateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>TooManyTagsException You have reached the limit on the number of tags that can be assigned.</li>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.CreateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConnectionResponse> createConnection(CreateConnectionRequest createConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConnectionRequest, CreateConnectionResponse>()
                            .withOperationName("CreateConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createConnectionRequest));
            CompletableFuture<CreateConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Direct Connect gateway, which is an intermediate object that enables you to connect a set of virtual
     * interfaces and virtual private gateways. A Direct Connect gateway is global and visible in any Amazon Web
     * Services Region after it is created. The virtual interfaces and virtual private gateways that are connected
     * through a Direct Connect gateway can be in different Amazon Web Services Regions. This enables you to connect to
     * a VPC in any Region, regardless of the Region in which the virtual interfaces are located, and pass traffic
     * between them.
     * </p>
     *
     * @param createDirectConnectGatewayRequest
     * @return A Java Future containing the result of the CreateDirectConnectGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.CreateDirectConnectGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDirectConnectGatewayResponse> createDirectConnectGateway(
            CreateDirectConnectGatewayRequest createDirectConnectGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDirectConnectGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDirectConnectGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDirectConnectGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDirectConnectGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDirectConnectGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateDirectConnectGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDirectConnectGatewayRequest, CreateDirectConnectGatewayResponse>()
                            .withOperationName("CreateDirectConnectGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDirectConnectGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDirectConnectGatewayRequest));
            CompletableFuture<CreateDirectConnectGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an association between a Direct Connect gateway and a virtual private gateway. The virtual private
     * gateway must be attached to a VPC and must not be associated with another Direct Connect gateway.
     * </p>
     *
     * @param createDirectConnectGatewayAssociationRequest
     * @return A Java Future containing the result of the CreateDirectConnectGatewayAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.CreateDirectConnectGatewayAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDirectConnectGatewayAssociationResponse> createDirectConnectGatewayAssociation(
            CreateDirectConnectGatewayAssociationRequest createDirectConnectGatewayAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDirectConnectGatewayAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDirectConnectGatewayAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDirectConnectGatewayAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDirectConnectGatewayAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateDirectConnectGatewayAssociationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateDirectConnectGatewayAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDirectConnectGatewayAssociationRequest, CreateDirectConnectGatewayAssociationResponse>()
                            .withOperationName("CreateDirectConnectGatewayAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDirectConnectGatewayAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDirectConnectGatewayAssociationRequest));
            CompletableFuture<CreateDirectConnectGatewayAssociationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a proposal to associate the specified virtual private gateway or transit gateway with the specified
     * Direct Connect gateway.
     * </p>
     * <p>
     * You can associate a Direct Connect gateway and virtual private gateway or transit gateway that is owned by any
     * Amazon Web Services account.
     * </p>
     *
     * @param createDirectConnectGatewayAssociationProposalRequest
     * @return A Java Future containing the result of the CreateDirectConnectGatewayAssociationProposal operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.CreateDirectConnectGatewayAssociationProposal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateDirectConnectGatewayAssociationProposal"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDirectConnectGatewayAssociationProposalResponse> createDirectConnectGatewayAssociationProposal(
            CreateDirectConnectGatewayAssociationProposalRequest createDirectConnectGatewayAssociationProposalRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createDirectConnectGatewayAssociationProposalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDirectConnectGatewayAssociationProposalRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDirectConnectGatewayAssociationProposal");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDirectConnectGatewayAssociationProposalResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateDirectConnectGatewayAssociationProposalResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateDirectConnectGatewayAssociationProposalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDirectConnectGatewayAssociationProposalRequest, CreateDirectConnectGatewayAssociationProposalResponse>()
                            .withOperationName("CreateDirectConnectGatewayAssociationProposal")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDirectConnectGatewayAssociationProposalRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDirectConnectGatewayAssociationProposalRequest));
            CompletableFuture<CreateDirectConnectGatewayAssociationProposalResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an interconnect between an Direct Connect Partner's network and a specific Direct Connect location.
     * </p>
     * <p>
     * An interconnect is a connection that is capable of hosting other connections. The Direct Connect Partner can use
     * an interconnect to provide Direct Connect hosted connections to customers through their own network services.
     * Like a standard connection, an interconnect links the partner's network to an Direct Connect location over a
     * standard Ethernet fiber-optic cable. One end is connected to the partner's router, the other to an Direct Connect
     * router.
     * </p>
     * <p>
     * You can automatically add the new interconnect to a link aggregation group (LAG) by specifying a LAG ID in the
     * request. This ensures that the new interconnect is allocated on the same Direct Connect endpoint that hosts the
     * specified LAG. If there are no available ports on the endpoint, the request fails and no interconnect is created.
     * </p>
     * <p>
     * For each end customer, the Direct Connect Partner provisions a connection on their interconnect by calling
     * <a>AllocateHostedConnection</a>. The end customer can then connect to Amazon Web Services resources by creating a
     * virtual interface on their connection, using the VLAN assigned to them by the Direct Connect Partner.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note>
     *
     * @param createInterconnectRequest
     * @return A Java Future containing the result of the CreateInterconnect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>TooManyTagsException You have reached the limit on the number of tags that can be assigned.</li>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.CreateInterconnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateInterconnect"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInterconnectResponse> createInterconnect(CreateInterconnectRequest createInterconnectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInterconnectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInterconnectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInterconnect");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInterconnectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateInterconnectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateInterconnectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInterconnectRequest, CreateInterconnectResponse>()
                            .withOperationName("CreateInterconnect").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateInterconnectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createInterconnectRequest));
            CompletableFuture<CreateInterconnectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a link aggregation group (LAG) with the specified number of bundled physical dedicated connections
     * between the customer network and a specific Direct Connect location. A LAG is a logical interface that uses the
     * Link Aggregation Control Protocol (LACP) to aggregate multiple interfaces, enabling you to treat them as a single
     * interface.
     * </p>
     * <p>
     * All connections in a LAG must use the same bandwidth (either 1Gbps, 10Gbps, 100Gbps, or 400Gbps) and must
     * terminate at the same Direct Connect endpoint.
     * </p>
     * <p>
     * You can have up to 10 dedicated connections per location. Regardless of this limit, if you request more
     * connections for the LAG than Direct Connect can allocate on a single endpoint, no LAG is created..
     * </p>
     * <p>
     * You can specify an existing physical dedicated connection or interconnect to include in the LAG (which counts
     * towards the total number of connections). Doing so interrupts the current physical dedicated connection, and
     * re-establishes them as a member of the LAG. The LAG will be created on the same Direct Connect endpoint to which
     * the dedicated connection terminates. Any virtual interfaces associated with the dedicated connection are
     * automatically disassociated and re-associated with the LAG. The connection ID does not change.
     * </p>
     * <p>
     * If the Amazon Web Services account used to create a LAG is a registered Direct Connect Partner, the LAG is
     * automatically enabled to host sub-connections. For a LAG owned by a partner, any associated virtual interfaces
     * cannot be directly configured.
     * </p>
     *
     * @param createLagRequest
     * @return A Java Future containing the result of the CreateLag operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>TooManyTagsException You have reached the limit on the number of tags that can be assigned.</li>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.CreateLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateLag" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLagResponse> createLag(CreateLagRequest createLagRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLagRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLag");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLagResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateLagResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateLagResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLagRequest, CreateLagResponse>().withOperationName("CreateLag")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateLagRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(createLagRequest));
            CompletableFuture<CreateLagResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a private virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A
     * private virtual interface can be connected to either a Direct Connect gateway or a Virtual Private Gateway (VGW).
     * Connecting the private virtual interface to a Direct Connect gateway enables the possibility for connecting to
     * multiple VPCs, including VPCs in different Amazon Web Services Regions. Connecting the private virtual interface
     * to a VGW only provides access to a single VPC within the same Region.
     * </p>
     * <p>
     * Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause an update to the underlying physical
     * connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity
     * for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection
     * supports jumbo frames, call <a>DescribeConnections</a>. To check whether your virtual interface supports jumbo
     * frames, call <a>DescribeVirtualInterfaces</a>.
     * </p>
     *
     * @param createPrivateVirtualInterfaceRequest
     * @return A Java Future containing the result of the CreatePrivateVirtualInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>TooManyTagsException You have reached the limit on the number of tags that can be assigned.</li>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.CreatePrivateVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePrivateVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePrivateVirtualInterfaceResponse> createPrivateVirtualInterface(
            CreatePrivateVirtualInterfaceRequest createPrivateVirtualInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPrivateVirtualInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createPrivateVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePrivateVirtualInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePrivateVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePrivateVirtualInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreatePrivateVirtualInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePrivateVirtualInterfaceRequest, CreatePrivateVirtualInterfaceResponse>()
                            .withOperationName("CreatePrivateVirtualInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePrivateVirtualInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPrivateVirtualInterfaceRequest));
            CompletableFuture<CreatePrivateVirtualInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a public virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A
     * public virtual interface supports sending traffic to public services of Amazon Web Services such as Amazon S3.
     * </p>
     * <p>
     * When creating an IPv6 public virtual interface (<code>addressFamily</code> is <code>ipv6</code>), leave the
     * <code>customer</code> and <code>amazon</code> address fields blank to use auto-assigned IPv6 space. Custom IPv6
     * addresses are not supported.
     * </p>
     *
     * @param createPublicVirtualInterfaceRequest
     * @return A Java Future containing the result of the CreatePublicVirtualInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>TooManyTagsException You have reached the limit on the number of tags that can be assigned.</li>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.CreatePublicVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePublicVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePublicVirtualInterfaceResponse> createPublicVirtualInterface(
            CreatePublicVirtualInterfaceRequest createPublicVirtualInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPublicVirtualInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPublicVirtualInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePublicVirtualInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePublicVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePublicVirtualInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreatePublicVirtualInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePublicVirtualInterfaceRequest, CreatePublicVirtualInterfaceResponse>()
                            .withOperationName("CreatePublicVirtualInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePublicVirtualInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPublicVirtualInterfaceRequest));
            CompletableFuture<CreatePublicVirtualInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a transit virtual interface. A transit virtual interface should be used to access one or more transit
     * gateways associated with Direct Connect gateways. A transit virtual interface enables the connection of multiple
     * VPCs attached to a transit gateway to a Direct Connect gateway.
     * </p>
     * <important>
     * <p>
     * If you associate your transit gateway with one or more Direct Connect gateways, the Autonomous System Number
     * (ASN) used by the transit gateway and the Direct Connect gateway must be different. For example, if you use the
     * default ASN 64512 for both your the transit gateway and Direct Connect gateway, the association request fails.
     * </p>
     * </important>
     * <p>
     * A jumbo MTU value must be either 1500 or 8500. No other values will be accepted. Setting the MTU of a virtual
     * interface to 8500 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated
     * to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces
     * associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call
     * <a>DescribeConnections</a>. To check whether your virtual interface supports jumbo frames, call
     * <a>DescribeVirtualInterfaces</a>.
     * </p>
     *
     * @param createTransitVirtualInterfaceRequest
     * @return A Java Future containing the result of the CreateTransitVirtualInterface operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>TooManyTagsException You have reached the limit on the number of tags that can be assigned.</li>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.CreateTransitVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateTransitVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTransitVirtualInterfaceResponse> createTransitVirtualInterface(
            CreateTransitVirtualInterfaceRequest createTransitVirtualInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitVirtualInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitVirtualInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTransitVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTransitVirtualInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateTransitVirtualInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTransitVirtualInterfaceRequest, CreateTransitVirtualInterfaceResponse>()
                            .withOperationName("CreateTransitVirtualInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTransitVirtualInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTransitVirtualInterfaceRequest));
            CompletableFuture<CreateTransitVirtualInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified BGP peer on the specified virtual interface with the specified customer address and ASN.
     * </p>
     * <p>
     * You cannot delete the last BGP peer from a virtual interface.
     * </p>
     *
     * @param deleteBgpPeerRequest
     * @return A Java Future containing the result of the DeleteBGPPeer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DeleteBGPPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteBGPPeer" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBgpPeerResponse> deleteBGPPeer(DeleteBgpPeerRequest deleteBgpPeerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBgpPeerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBgpPeerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBGPPeer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBgpPeerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteBgpPeerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteBgpPeerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBgpPeerRequest, DeleteBgpPeerResponse>()
                            .withOperationName("DeleteBGPPeer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBgpPeerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBgpPeerRequest));
            CompletableFuture<DeleteBgpPeerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified connection.
     * </p>
     * <p>
     * Deleting a connection only stops the Direct Connect port hour and data transfer charges. If you are partnering
     * with any third parties to connect with the Direct Connect location, you must cancel your service with them
     * separately.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest deleteConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConnectionRequest, DeleteConnectionResponse>()
                            .withOperationName("DeleteConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConnectionRequest));
            CompletableFuture<DeleteConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Direct Connect gateway. You must first delete all virtual interfaces that are attached to
     * the Direct Connect gateway and disassociate all virtual private gateways associated with the Direct Connect
     * gateway.
     * </p>
     *
     * @param deleteDirectConnectGatewayRequest
     * @return A Java Future containing the result of the DeleteDirectConnectGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DeleteDirectConnectGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDirectConnectGatewayResponse> deleteDirectConnectGateway(
            DeleteDirectConnectGatewayRequest deleteDirectConnectGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDirectConnectGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDirectConnectGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDirectConnectGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDirectConnectGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDirectConnectGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteDirectConnectGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDirectConnectGatewayRequest, DeleteDirectConnectGatewayResponse>()
                            .withOperationName("DeleteDirectConnectGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDirectConnectGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDirectConnectGatewayRequest));
            CompletableFuture<DeleteDirectConnectGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the association between the specified Direct Connect gateway and virtual private gateway.
     * </p>
     * <p>
     * We recommend that you specify the <code>associationID</code> to delete the association. Alternatively, if you own
     * virtual gateway and a Direct Connect gateway association, you can specify the <code>virtualGatewayId</code> and
     * <code>directConnectGatewayId</code> to delete an association.
     * </p>
     *
     * @param deleteDirectConnectGatewayAssociationRequest
     * @return A Java Future containing the result of the DeleteDirectConnectGatewayAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DeleteDirectConnectGatewayAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDirectConnectGatewayAssociationResponse> deleteDirectConnectGatewayAssociation(
            DeleteDirectConnectGatewayAssociationRequest deleteDirectConnectGatewayAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDirectConnectGatewayAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDirectConnectGatewayAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDirectConnectGatewayAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDirectConnectGatewayAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteDirectConnectGatewayAssociationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteDirectConnectGatewayAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDirectConnectGatewayAssociationRequest, DeleteDirectConnectGatewayAssociationResponse>()
                            .withOperationName("DeleteDirectConnectGatewayAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDirectConnectGatewayAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDirectConnectGatewayAssociationRequest));
            CompletableFuture<DeleteDirectConnectGatewayAssociationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the association proposal request between the specified Direct Connect gateway and virtual private gateway
     * or transit gateway.
     * </p>
     *
     * @param deleteDirectConnectGatewayAssociationProposalRequest
     * @return A Java Future containing the result of the DeleteDirectConnectGatewayAssociationProposal operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DeleteDirectConnectGatewayAssociationProposal
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteDirectConnectGatewayAssociationProposal"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDirectConnectGatewayAssociationProposalResponse> deleteDirectConnectGatewayAssociationProposal(
            DeleteDirectConnectGatewayAssociationProposalRequest deleteDirectConnectGatewayAssociationProposalRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteDirectConnectGatewayAssociationProposalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDirectConnectGatewayAssociationProposalRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDirectConnectGatewayAssociationProposal");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDirectConnectGatewayAssociationProposalResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteDirectConnectGatewayAssociationProposalResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteDirectConnectGatewayAssociationProposalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDirectConnectGatewayAssociationProposalRequest, DeleteDirectConnectGatewayAssociationProposalResponse>()
                            .withOperationName("DeleteDirectConnectGatewayAssociationProposal")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDirectConnectGatewayAssociationProposalRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDirectConnectGatewayAssociationProposalRequest));
            CompletableFuture<DeleteDirectConnectGatewayAssociationProposalResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified interconnect.
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note>
     *
     * @param deleteInterconnectRequest
     * @return A Java Future containing the result of the DeleteInterconnect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DeleteInterconnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnect"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInterconnectResponse> deleteInterconnect(DeleteInterconnectRequest deleteInterconnectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInterconnectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInterconnectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInterconnect");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInterconnectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteInterconnectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteInterconnectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInterconnectRequest, DeleteInterconnectResponse>()
                            .withOperationName("DeleteInterconnect").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteInterconnectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInterconnectRequest));
            CompletableFuture<DeleteInterconnectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified link aggregation group (LAG). You cannot delete a LAG if it has active virtual interfaces
     * or hosted connections.
     * </p>
     *
     * @param deleteLagRequest
     * @return A Java Future containing the result of the DeleteLag operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DeleteLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteLag" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLagResponse> deleteLag(DeleteLagRequest deleteLagRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLagRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLag");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteLagResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteLagResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteLagResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLagRequest, DeleteLagResponse>().withOperationName("DeleteLag")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteLagRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteLagRequest));
            CompletableFuture<DeleteLagResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a virtual interface.
     * </p>
     *
     * @param deleteVirtualInterfaceRequest
     * @return A Java Future containing the result of the DeleteVirtualInterface operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DeleteVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVirtualInterfaceResponse> deleteVirtualInterface(
            DeleteVirtualInterfaceRequest deleteVirtualInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVirtualInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVirtualInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVirtualInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVirtualInterfaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVirtualInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteVirtualInterfaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVirtualInterfaceRequest, DeleteVirtualInterfaceResponse>()
                            .withOperationName("DeleteVirtualInterface").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteVirtualInterfaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVirtualInterfaceRequest));
            CompletableFuture<DeleteVirtualInterfaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays the specified connection or all connections in this Region.
     * </p>
     *
     * @param describeConnectionsRequest
     * @return A Java Future containing the result of the DescribeConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnections"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConnectionsResponse> describeConnections(
            DescribeConnectionsRequest describeConnectionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConnectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConnectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConnections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConnectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeConnectionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeConnectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConnectionsRequest, DescribeConnectionsResponse>()
                            .withOperationName("DescribeConnections").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeConnectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConnectionsRequest));
            CompletableFuture<DescribeConnectionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get and view a list of customer agreements, along with their signed status and whether the customer is an
     * NNIPartner, NNIPartnerV2, or a nonPartner.
     * </p>
     *
     * @param describeCustomerMetadataRequest
     * @return A Java Future containing the result of the DescribeCustomerMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DescribeCustomerMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeCustomerMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCustomerMetadataResponse> describeCustomerMetadata(
            DescribeCustomerMetadataRequest describeCustomerMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCustomerMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCustomerMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomerMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCustomerMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCustomerMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeCustomerMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomerMetadataRequest, DescribeCustomerMetadataResponse>()
                            .withOperationName("DescribeCustomerMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCustomerMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCustomerMetadataRequest));
            CompletableFuture<DescribeCustomerMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more association proposals for connection between a virtual private gateway or transit gateway
     * and a Direct Connect gateway.
     * </p>
     *
     * @param describeDirectConnectGatewayAssociationProposalsRequest
     * @return A Java Future containing the result of the DescribeDirectConnectGatewayAssociationProposals operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DescribeDirectConnectGatewayAssociationProposals
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociationProposals"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDirectConnectGatewayAssociationProposalsResponse> describeDirectConnectGatewayAssociationProposals(
            DescribeDirectConnectGatewayAssociationProposalsRequest describeDirectConnectGatewayAssociationProposalsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeDirectConnectGatewayAssociationProposalsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDirectConnectGatewayAssociationProposalsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDirectConnectGatewayAssociationProposals");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDirectConnectGatewayAssociationProposalsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeDirectConnectGatewayAssociationProposalsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDirectConnectGatewayAssociationProposalsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDirectConnectGatewayAssociationProposalsRequest, DescribeDirectConnectGatewayAssociationProposalsResponse>()
                            .withOperationName("DescribeDirectConnectGatewayAssociationProposals")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(
                                    new DescribeDirectConnectGatewayAssociationProposalsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDirectConnectGatewayAssociationProposalsRequest));
            CompletableFuture<DescribeDirectConnectGatewayAssociationProposalsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the associations between your Direct Connect gateways and virtual private gateways and transit gateways.
     * You must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A Direct Connect gateway
     * </p>
     * <p>
     * The response contains all virtual private gateways and transit gateways associated with the Direct Connect
     * gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A virtual private gateway
     * </p>
     * <p>
     * The response contains the Direct Connect gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A transit gateway
     * </p>
     * <p>
     * The response contains the Direct Connect gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Direct Connect gateway and a virtual private gateway
     * </p>
     * <p>
     * The response contains the association between the Direct Connect gateway and virtual private gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Direct Connect gateway and a transit gateway
     * </p>
     * <p>
     * The response contains the association between the Direct Connect gateway and transit gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Direct Connect gateway and a virtual private gateway
     * </p>
     * <p>
     * The response contains the association between the Direct Connect gateway and virtual private gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Direct Connect gateway association to a Cloud WAN core network
     * </p>
     * <p>
     * The response contains the Cloud WAN core network ID that the Direct Connect gateway is associated to.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeDirectConnectGatewayAssociationsRequest
     * @return A Java Future containing the result of the DescribeDirectConnectGatewayAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DescribeDirectConnectGatewayAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDirectConnectGatewayAssociationsResponse> describeDirectConnectGatewayAssociations(
            DescribeDirectConnectGatewayAssociationsRequest describeDirectConnectGatewayAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeDirectConnectGatewayAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDirectConnectGatewayAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDirectConnectGatewayAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDirectConnectGatewayAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeDirectConnectGatewayAssociationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDirectConnectGatewayAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDirectConnectGatewayAssociationsRequest, DescribeDirectConnectGatewayAssociationsResponse>()
                            .withOperationName("DescribeDirectConnectGatewayAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDirectConnectGatewayAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDirectConnectGatewayAssociationsRequest));
            CompletableFuture<DescribeDirectConnectGatewayAssociationsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the attachments between your Direct Connect gateways and virtual interfaces. You must specify a Direct
     * Connect gateway, a virtual interface, or both. If you specify a Direct Connect gateway, the response contains all
     * virtual interfaces attached to the Direct Connect gateway. If you specify a virtual interface, the response
     * contains all Direct Connect gateways attached to the virtual interface. If you specify both, the response
     * contains the attachment between the Direct Connect gateway and the virtual interface.
     * </p>
     *
     * @param describeDirectConnectGatewayAttachmentsRequest
     * @return A Java Future containing the result of the DescribeDirectConnectGatewayAttachments operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DescribeDirectConnectGatewayAttachments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGatewayAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDirectConnectGatewayAttachmentsResponse> describeDirectConnectGatewayAttachments(
            DescribeDirectConnectGatewayAttachmentsRequest describeDirectConnectGatewayAttachmentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDirectConnectGatewayAttachmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDirectConnectGatewayAttachmentsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDirectConnectGatewayAttachments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDirectConnectGatewayAttachmentsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeDirectConnectGatewayAttachmentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDirectConnectGatewayAttachmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDirectConnectGatewayAttachmentsRequest, DescribeDirectConnectGatewayAttachmentsResponse>()
                            .withOperationName("DescribeDirectConnectGatewayAttachments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDirectConnectGatewayAttachmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDirectConnectGatewayAttachmentsRequest));
            CompletableFuture<DescribeDirectConnectGatewayAttachmentsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all your Direct Connect gateways or only the specified Direct Connect gateway. Deleted Direct Connect
     * gateways are not returned.
     * </p>
     *
     * @param describeDirectConnectGatewaysRequest
     * @return A Java Future containing the result of the DescribeDirectConnectGateways operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DescribeDirectConnectGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeDirectConnectGateways"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDirectConnectGatewaysResponse> describeDirectConnectGateways(
            DescribeDirectConnectGatewaysRequest describeDirectConnectGatewaysRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDirectConnectGatewaysRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDirectConnectGatewaysRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDirectConnectGateways");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDirectConnectGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDirectConnectGatewaysResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDirectConnectGatewaysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDirectConnectGatewaysRequest, DescribeDirectConnectGatewaysResponse>()
                            .withOperationName("DescribeDirectConnectGateways").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDirectConnectGatewaysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDirectConnectGatewaysRequest));
            CompletableFuture<DescribeDirectConnectGatewaysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the hosted connections that have been provisioned on the specified interconnect or link aggregation group
     * (LAG).
     * </p>
     * <note>
     * <p>
     * Intended for use by Direct Connect Partners only.
     * </p>
     * </note>
     *
     * @param describeHostedConnectionsRequest
     * @return A Java Future containing the result of the DescribeHostedConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DescribeHostedConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeHostedConnections"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHostedConnectionsResponse> describeHostedConnections(
            DescribeHostedConnectionsRequest describeHostedConnectionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeHostedConnectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeHostedConnectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeHostedConnections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeHostedConnectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeHostedConnectionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeHostedConnectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeHostedConnectionsRequest, DescribeHostedConnectionsResponse>()
                            .withOperationName("DescribeHostedConnections").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeHostedConnectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeHostedConnectionsRequest));
            CompletableFuture<DescribeHostedConnectionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the interconnects owned by the Amazon Web Services account or only the specified interconnect.
     * </p>
     *
     * @param describeInterconnectsRequest
     * @return A Java Future containing the result of the DescribeInterconnects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DescribeInterconnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnects"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInterconnectsResponse> describeInterconnects(
            DescribeInterconnectsRequest describeInterconnectsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInterconnectsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInterconnectsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInterconnects");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInterconnectsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeInterconnectsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeInterconnectsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInterconnectsRequest, DescribeInterconnectsResponse>()
                            .withOperationName("DescribeInterconnects").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeInterconnectsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInterconnectsRequest));
            CompletableFuture<DescribeInterconnectsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes all your link aggregation groups (LAG) or the specified LAG.
     * </p>
     *
     * @param describeLagsRequest
     * @return A Java Future containing the result of the DescribeLags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DescribeLags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLags" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLagsResponse> describeLags(DescribeLagsRequest describeLagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeLagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeLagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeLagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLagsRequest, DescribeLagsResponse>()
                            .withOperationName("DescribeLags").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeLagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeLagsRequest));
            CompletableFuture<DescribeLagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the LOA-CFA for a connection, interconnect, or link aggregation group (LAG).
     * </p>
     * <p>
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when
     * establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see <a
     * href="https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html">Requesting Cross Connects at
     * Direct Connect Locations</a> in the <i>Direct Connect User Guide</i>.
     * </p>
     *
     * @param describeLoaRequest
     * @return A Java Future containing the result of the DescribeLoa operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DescribeLoa
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLoa" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLoaResponse> describeLoa(DescribeLoaRequest describeLoaRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLoaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLoaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLoa");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeLoaResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeLoaResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeLoaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLoaRequest, DescribeLoaResponse>()
                            .withOperationName("DescribeLoa").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeLoaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeLoaRequest));
            CompletableFuture<DescribeLoaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the Direct Connect locations in the current Amazon Web Services Region. These are the locations that can be
     * selected when calling <a>CreateConnection</a> or <a>CreateInterconnect</a>.
     * </p>
     *
     * @param describeLocationsRequest
     * @return A Java Future containing the result of the DescribeLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DescribeLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLocations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLocationsResponse> describeLocations(DescribeLocationsRequest describeLocationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLocationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLocationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLocations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeLocationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeLocationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeLocationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLocationsRequest, DescribeLocationsResponse>()
                            .withOperationName("DescribeLocations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeLocationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeLocationsRequest));
            CompletableFuture<DescribeLocationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Details about the router.
     * </p>
     *
     * @param describeRouterConfigurationRequest
     *        Provides the details about a virtual interface's router.
     * @return A Java Future containing the result of the DescribeRouterConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DescribeRouterConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeRouterConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRouterConfigurationResponse> describeRouterConfiguration(
            DescribeRouterConfigurationRequest describeRouterConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRouterConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRouterConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRouterConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRouterConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRouterConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeRouterConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRouterConfigurationRequest, DescribeRouterConfigurationResponse>()
                            .withOperationName("DescribeRouterConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRouterConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRouterConfigurationRequest));
            CompletableFuture<DescribeRouterConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the tags associated with the specified Direct Connect resources.
     * </p>
     *
     * @param describeTagsRequest
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeTags" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTagsRequest, DescribeTagsResponse>()
                            .withOperationName("DescribeTags").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTagsRequest));
            CompletableFuture<DescribeTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * Deprecated. Use <code>DescribeVpnGateways</code> instead. See <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnGateways.html"
     * >DescribeVPNGateways</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </note>
     * <p>
     * Lists the virtual private gateways owned by the Amazon Web Services account.
     * </p>
     * <p>
     * You can create one or more Direct Connect private virtual interfaces linked to a virtual private gateway.
     * </p>
     *
     * @param describeVirtualGatewaysRequest
     * @return A Java Future containing the result of the DescribeVirtualGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DescribeVirtualGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualGateways"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVirtualGatewaysResponse> describeVirtualGateways(
            DescribeVirtualGatewaysRequest describeVirtualGatewaysRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeVirtualGatewaysRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeVirtualGatewaysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeVirtualGateways");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeVirtualGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeVirtualGatewaysResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeVirtualGatewaysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeVirtualGatewaysRequest, DescribeVirtualGatewaysResponse>()
                            .withOperationName("DescribeVirtualGateways").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeVirtualGatewaysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeVirtualGatewaysRequest));
            CompletableFuture<DescribeVirtualGatewaysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays all virtual interfaces for an Amazon Web Services account. Virtual interfaces deleted fewer than 15
     * minutes before you make the request are also returned. If you specify a connection ID, only the virtual
     * interfaces associated with the connection are returned. If you specify a virtual interface ID, then only a single
     * virtual interface is returned.
     * </p>
     * <p>
     * A virtual interface (VLAN) transmits the traffic between the Direct Connect location and the customer network.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you're using an <code>asn</code>, the response includes ASN value in both the <code>asn</code> and
     * <code>asnLong</code> fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you're using <code>asnLong</code>, the response returns a value of <code>0</code> (zero) for the
     * <code>asn</code> attribute because it exceeds the highest ASN value of 2,147,483,647 that it can support
     * </p>
     * </li>
     * </ul>
     *
     * @param describeVirtualInterfacesRequest
     * @return A Java Future containing the result of the DescribeVirtualInterfaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DescribeVirtualInterfaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeVirtualInterfacesResponse> describeVirtualInterfaces(
            DescribeVirtualInterfacesRequest describeVirtualInterfacesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeVirtualInterfacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeVirtualInterfacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeVirtualInterfaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeVirtualInterfacesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeVirtualInterfacesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeVirtualInterfacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeVirtualInterfacesRequest, DescribeVirtualInterfacesResponse>()
                            .withOperationName("DescribeVirtualInterfaces").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeVirtualInterfacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeVirtualInterfacesRequest));
            CompletableFuture<DescribeVirtualInterfacesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a connection from a link aggregation group (LAG). The connection is interrupted and re-established
     * as a standalone connection (the connection is not deleted; to delete the connection, use the
     * <a>DeleteConnection</a> request). If the LAG has associated virtual interfaces or hosted connections, they remain
     * associated with the LAG. A disassociated connection owned by an Direct Connect Partner is automatically converted
     * to an interconnect.
     * </p>
     * <p>
     * If disassociating the connection would cause the LAG to fall below its setting for minimum number of operational
     * connections, the request fails, except when it's the last member of the LAG. If all connections are
     * disassociated, the LAG continues to exist as an empty LAG with no physical connections.
     * </p>
     *
     * @param disassociateConnectionFromLagRequest
     * @return A Java Future containing the result of the DisassociateConnectionFromLag operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DisassociateConnectionFromLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DisassociateConnectionFromLag"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateConnectionFromLagResponse> disassociateConnectionFromLag(
            DisassociateConnectionFromLagRequest disassociateConnectionFromLagRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateConnectionFromLagRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateConnectionFromLagRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateConnectionFromLag");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateConnectionFromLagResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateConnectionFromLagResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DisassociateConnectionFromLagResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateConnectionFromLagRequest, DisassociateConnectionFromLagResponse>()
                            .withOperationName("DisassociateConnectionFromLag").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateConnectionFromLagRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateConnectionFromLagRequest));
            CompletableFuture<DisassociateConnectionFromLagResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the association between a MAC Security (MACsec) security key and a Direct Connect connection.
     * </p>
     *
     * @param disassociateMacSecKeyRequest
     * @return A Java Future containing the result of the DisassociateMacSecKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.DisassociateMacSecKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DisassociateMacSecKey"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateMacSecKeyResponse> disassociateMacSecKey(
            DisassociateMacSecKeyRequest disassociateMacSecKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateMacSecKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMacSecKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMacSecKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateMacSecKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateMacSecKeyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DisassociateMacSecKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateMacSecKeyRequest, DisassociateMacSecKeyResponse>()
                            .withOperationName("DisassociateMacSecKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateMacSecKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateMacSecKeyRequest));
            CompletableFuture<DisassociateMacSecKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the virtual interface failover test history.
     * </p>
     *
     * @param listVirtualInterfaceTestHistoryRequest
     * @return A Java Future containing the result of the ListVirtualInterfaceTestHistory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.ListVirtualInterfaceTestHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ListVirtualInterfaceTestHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListVirtualInterfaceTestHistoryResponse> listVirtualInterfaceTestHistory(
            ListVirtualInterfaceTestHistoryRequest listVirtualInterfaceTestHistoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVirtualInterfaceTestHistoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listVirtualInterfaceTestHistoryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVirtualInterfaceTestHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVirtualInterfaceTestHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListVirtualInterfaceTestHistoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListVirtualInterfaceTestHistoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVirtualInterfaceTestHistoryRequest, ListVirtualInterfaceTestHistoryResponse>()
                            .withOperationName("ListVirtualInterfaceTestHistory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListVirtualInterfaceTestHistoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listVirtualInterfaceTestHistoryRequest));
            CompletableFuture<ListVirtualInterfaceTestHistoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts the virtual interface failover test that verifies your configuration meets your resiliency requirements by
     * placing the BGP peering session in the DOWN state. You can then send traffic to verify that there are no outages.
     * </p>
     * <p>
     * You can run the test on public, private, transit, and hosted virtual interfaces.
     * </p>
     * <p>
     * You can use <a
     * href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ListVirtualInterfaceTestHistory.html"
     * >ListVirtualInterfaceTestHistory</a> to view the virtual interface test history.
     * </p>
     * <p>
     * If you need to stop the test before the test interval completes, use <a
     * href="https://docs.aws.amazon.com/directconnect/latest/APIReference/API_StopBgpFailoverTest.html"
     * >StopBgpFailoverTest</a>.
     * </p>
     *
     * @param startBgpFailoverTestRequest
     * @return A Java Future containing the result of the StartBgpFailoverTest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.StartBgpFailoverTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/StartBgpFailoverTest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartBgpFailoverTestResponse> startBgpFailoverTest(
            StartBgpFailoverTestRequest startBgpFailoverTestRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startBgpFailoverTestRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startBgpFailoverTestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartBgpFailoverTest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartBgpFailoverTestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartBgpFailoverTestResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartBgpFailoverTestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartBgpFailoverTestRequest, StartBgpFailoverTestResponse>()
                            .withOperationName("StartBgpFailoverTest").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartBgpFailoverTestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startBgpFailoverTestRequest));
            CompletableFuture<StartBgpFailoverTestResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops the virtual interface failover test.
     * </p>
     *
     * @param stopBgpFailoverTestRequest
     * @return A Java Future containing the result of the StopBgpFailoverTest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.StopBgpFailoverTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/StopBgpFailoverTest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopBgpFailoverTestResponse> stopBgpFailoverTest(
            StopBgpFailoverTestRequest stopBgpFailoverTestRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopBgpFailoverTestRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopBgpFailoverTestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopBgpFailoverTest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopBgpFailoverTestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopBgpFailoverTestResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopBgpFailoverTestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopBgpFailoverTestRequest, StopBgpFailoverTestResponse>()
                            .withOperationName("StopBgpFailoverTest").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopBgpFailoverTestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopBgpFailoverTestRequest));
            CompletableFuture<StopBgpFailoverTestResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds the specified tags to the specified Direct Connect resource. Each resource can have a maximum of 50 tags.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the
     * resource, this action updates its value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DuplicateTagKeysException A tag key was specified more than once.</li>
     *         <li>TooManyTagsException You have reached the limit on the number of tags that can be assigned.</li>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags from the specified Direct Connect resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the Direct Connect connection configuration.
     * </p>
     * <p>
     * You can update the following parameters for a connection:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The connection name
     * </p>
     * </li>
     * <li>
     * <p>
     * The connection's MAC Security (MACsec) encryption mode.
     * </p>
     * </li>
     * </ul>
     *
     * @param updateConnectionRequest
     * @return A Java Future containing the result of the UpdateConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.UpdateConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConnectionResponse> updateConnection(UpdateConnectionRequest updateConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateConnectionRequest, UpdateConnectionResponse>()
                            .withOperationName("UpdateConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateConnectionRequest));
            CompletableFuture<UpdateConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the name of a current Direct Connect gateway.
     * </p>
     *
     * @param updateDirectConnectGatewayRequest
     * @return A Java Future containing the result of the UpdateDirectConnectGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.UpdateDirectConnectGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateDirectConnectGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDirectConnectGatewayResponse> updateDirectConnectGateway(
            UpdateDirectConnectGatewayRequest updateDirectConnectGatewayRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDirectConnectGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDirectConnectGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDirectConnectGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDirectConnectGatewayResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDirectConnectGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateDirectConnectGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDirectConnectGatewayRequest, UpdateDirectConnectGatewayResponse>()
                            .withOperationName("UpdateDirectConnectGateway").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDirectConnectGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDirectConnectGatewayRequest));
            CompletableFuture<UpdateDirectConnectGatewayResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified attributes of the Direct Connect gateway association.
     * </p>
     * <p>
     * Add or remove prefixes from the association.
     * </p>
     *
     * @param updateDirectConnectGatewayAssociationRequest
     * @return A Java Future containing the result of the UpdateDirectConnectGatewayAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.UpdateDirectConnectGatewayAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateDirectConnectGatewayAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDirectConnectGatewayAssociationResponse> updateDirectConnectGatewayAssociation(
            UpdateDirectConnectGatewayAssociationRequest updateDirectConnectGatewayAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDirectConnectGatewayAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateDirectConnectGatewayAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDirectConnectGatewayAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDirectConnectGatewayAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateDirectConnectGatewayAssociationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateDirectConnectGatewayAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDirectConnectGatewayAssociationRequest, UpdateDirectConnectGatewayAssociationResponse>()
                            .withOperationName("UpdateDirectConnectGatewayAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDirectConnectGatewayAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDirectConnectGatewayAssociationRequest));
            CompletableFuture<UpdateDirectConnectGatewayAssociationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the attributes of the specified link aggregation group (LAG).
     * </p>
     * <p>
     * You can update the following LAG attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The name of the LAG.
     * </p>
     * </li>
     * <li>
     * <p>
     * The value for the minimum number of connections that must be operational for the LAG itself to be operational.
     * </p>
     * </li>
     * <li>
     * <p>
     * The LAG's MACsec encryption mode.
     * </p>
     * <p>
     * Amazon Web Services assigns this value to each connection which is part of the LAG.
     * </p>
     * </li>
     * <li>
     * <p>
     * The tags
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you adjust the threshold value for the minimum number of operational connections, ensure that the new value
     * does not cause the LAG to fall below the threshold and become non-operational.
     * </p>
     * </note>
     *
     * @param updateLagRequest
     * @return A Java Future containing the result of the UpdateLag operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.UpdateLag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateLag" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateLagResponse> updateLag(UpdateLagRequest updateLagRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateLagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLagRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLag");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateLagResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateLagResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateLagResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateLagRequest, UpdateLagResponse>().withOperationName("UpdateLag")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateLagRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateLagRequest));
            CompletableFuture<UpdateLagResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified attributes of the specified virtual private interface.
     * </p>
     * <p>
     * Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause an update to the underlying physical
     * connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity
     * for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection
     * supports jumbo frames, call <a>DescribeConnections</a>. To check whether your virtual interface supports jumbo
     * frames, call <a>DescribeVirtualInterfaces</a>.
     * </p>
     *
     * @param updateVirtualInterfaceAttributesRequest
     * @return A Java Future containing the result of the UpdateVirtualInterfaceAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectConnectServerException A server-side error occurred.</li>
     *         <li>DirectConnectClientException One or more parameters are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectConnectException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectConnectAsyncClient.UpdateVirtualInterfaceAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateVirtualInterfaceAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateVirtualInterfaceAttributesResponse> updateVirtualInterfaceAttributes(
            UpdateVirtualInterfaceAttributesRequest updateVirtualInterfaceAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateVirtualInterfaceAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateVirtualInterfaceAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Direct Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVirtualInterfaceAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVirtualInterfaceAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateVirtualInterfaceAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DuplicateTagKeysException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateTagKeysException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DuplicateTagKeysException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "DirectConnectServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectServerException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectServerException::builder).build());
                case "DirectConnectClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectConnectClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectConnectClientException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateVirtualInterfaceAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVirtualInterfaceAttributesRequest, UpdateVirtualInterfaceAttributesResponse>()
                            .withOperationName("UpdateVirtualInterfaceAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateVirtualInterfaceAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateVirtualInterfaceAttributesRequest));
            CompletableFuture<UpdateVirtualInterfaceAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final DirectConnectServiceClientConfiguration serviceClientConfiguration() {
        return new DirectConnectServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(DirectConnectException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        DirectConnectServiceClientConfigurationBuilder serviceConfigBuilder = new DirectConnectServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
