/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.Lag;
import software.amazon.awssdk.services.directconnect.model.LagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLagsResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeLagsResponse> {
    private static final SdkField<List<Lag>> LAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lags").getter(DescribeLagsResponse.getter(DescribeLagsResponse::lags)).setter(DescribeLagsResponse.setter(Builder::lags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Lag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeLagsResponse.getter(DescribeLagsResponse::nextToken)).setter(DescribeLagsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeLagsResponse.memberNameToFieldInitializer();
    private final List<Lag> lags;
    private final String nextToken;

    private DescribeLagsResponse(BuilderImpl builder) {
        super(builder);
        this.lags = builder.lags;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLags() {
        return this.lags != null && !(this.lags instanceof SdkAutoConstructList);
    }

    public final List<Lag> lags() {
        return this.lags;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLags() ? this.lags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLagsResponse)) {
            return false;
        }
        DescribeLagsResponse other = (DescribeLagsResponse)((Object)obj);
        return this.hasLags() == other.hasLags() && Objects.equals(this.lags(), other.lags()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLagsResponse").add("Lags", this.hasLags() ? this.lags() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lags": {
                return Optional.ofNullable(clazz.cast(this.lags()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lags", LAGS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLagsResponse, T> g) {
        return obj -> g.apply((DescribeLagsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<Lag> lags = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLagsResponse model) {
            super(model);
            this.lags(model.lags);
            this.nextToken(model.nextToken);
        }

        public final List<Lag.Builder> getLags() {
            List<Lag.Builder> result = LagListCopier.copyToBuilder(this.lags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLags(Collection<Lag.BuilderImpl> lags) {
            this.lags = LagListCopier.copyFromBuilder(lags);
        }

        @Override
        public final Builder lags(Collection<Lag> lags) {
            this.lags = LagListCopier.copy(lags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lags(Lag ... lags) {
            this.lags(Arrays.asList(lags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lags(Consumer<Lag.Builder> ... lags) {
            this.lags(Stream.of(lags).map(c -> (Lag)((Lag.Builder)Lag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeLagsResponse build() {
            return new DescribeLagsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLagsResponse> {
        public Builder lags(Collection<Lag> var1);

        public Builder lags(Lag ... var1);

        public Builder lags(Consumer<Lag.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

