/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfirmPrivateVirtualInterfaceResponse extends DirectConnectResponse implements
        ToCopyableBuilder<ConfirmPrivateVirtualInterfaceResponse.Builder, ConfirmPrivateVirtualInterfaceResponse> {
    private static final SdkField<String> VIRTUAL_INTERFACE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceState")
            .getter(getter(ConfirmPrivateVirtualInterfaceResponse::virtualInterfaceStateAsString))
            .setter(setter(Builder::virtualInterfaceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceState").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String virtualInterfaceState;

    private ConfirmPrivateVirtualInterfaceResponse(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceState = builder.virtualInterfaceState;
    }

    /**
     * <p>
     * The state of the virtual interface. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface
     * owner. If the owner of the virtual interface is different from the owner of the connection on which it is
     * provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface
     * owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs
     * validation before the virtual interface can be created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual
     * interface is ready to forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code>: A virtual interface that is able to forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>down</code>: A virtual interface that is BGP down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>testing</code>: A virtual interface is in this state immediately after calling <a>StartBgpFailoverTest</a>
     * and remains in this state during the duration of the test.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: A virtual interface is in this state immediately after calling
     * <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: A virtual interface that cannot forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual
     * interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface
     * enters the <code>Rejected</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown</code>: The state of the virtual interface is not available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualInterfaceState} will return {@link VirtualInterfaceState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #virtualInterfaceStateAsString}.
     * </p>
     * 
     * @return The state of the virtual interface. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual
     *         interface owner. If the owner of the virtual interface is different from the owner of the connection on
     *         which it is provisioned, then the virtual interface will remain in this state until it is confirmed by
     *         the virtual interface owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual
     *         interface needs validation before the virtual interface can be created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: A virtual interface is in this state from the time that it is created until the
     *         virtual interface is ready to forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code>: A virtual interface that is able to forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>down</code>: A virtual interface that is BGP down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>testing</code>: A virtual interface is in this state immediately after calling
     *         <a>StartBgpFailoverTest</a> and remains in this state during the duration of the test.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: A virtual interface is in this state immediately after calling
     *         <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: A virtual interface that cannot forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a
     *         virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the
     *         virtual interface enters the <code>Rejected</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown</code>: The state of the virtual interface is not available.
     *         </p>
     *         </li>
     * @see VirtualInterfaceState
     */
    public final VirtualInterfaceState virtualInterfaceState() {
        return VirtualInterfaceState.fromValue(virtualInterfaceState);
    }

    /**
     * <p>
     * The state of the virtual interface. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual interface
     * owner. If the owner of the virtual interface is different from the owner of the connection on which it is
     * provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual interface
     * owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface needs
     * validation before the virtual interface can be created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual
     * interface is ready to forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code>: A virtual interface that is able to forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>down</code>: A virtual interface that is BGP down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>testing</code>: A virtual interface is in this state immediately after calling <a>StartBgpFailoverTest</a>
     * and remains in this state during the duration of the test.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: A virtual interface is in this state immediately after calling
     * <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: A virtual interface that cannot forward traffic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a virtual
     * interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual interface
     * enters the <code>Rejected</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown</code>: The state of the virtual interface is not available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualInterfaceState} will return {@link VirtualInterfaceState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #virtualInterfaceStateAsString}.
     * </p>
     * 
     * @return The state of the virtual interface. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual
     *         interface owner. If the owner of the virtual interface is different from the owner of the connection on
     *         which it is provisioned, then the virtual interface will remain in this state until it is confirmed by
     *         the virtual interface owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual
     *         interface needs validation before the virtual interface can be created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: A virtual interface is in this state from the time that it is created until the
     *         virtual interface is ready to forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code>: A virtual interface that is able to forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>down</code>: A virtual interface that is BGP down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>testing</code>: A virtual interface is in this state immediately after calling
     *         <a>StartBgpFailoverTest</a> and remains in this state during the duration of the test.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: A virtual interface is in this state immediately after calling
     *         <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: A virtual interface that cannot forward traffic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a
     *         virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the
     *         virtual interface enters the <code>Rejected</code> state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown</code>: The state of the virtual interface is not available.
     *         </p>
     *         </li>
     * @see VirtualInterfaceState
     */
    public final String virtualInterfaceStateAsString() {
        return virtualInterfaceState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmPrivateVirtualInterfaceResponse)) {
            return false;
        }
        ConfirmPrivateVirtualInterfaceResponse other = (ConfirmPrivateVirtualInterfaceResponse) obj;
        return Objects.equals(virtualInterfaceStateAsString(), other.virtualInterfaceStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfirmPrivateVirtualInterfaceResponse")
                .add("VirtualInterfaceState", virtualInterfaceStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualInterfaceState":
            return Optional.ofNullable(clazz.cast(virtualInterfaceStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("virtualInterfaceState", VIRTUAL_INTERFACE_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfirmPrivateVirtualInterfaceResponse, T> g) {
        return obj -> g.apply((ConfirmPrivateVirtualInterfaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ConfirmPrivateVirtualInterfaceResponse> {
        /**
         * <p>
         * The state of the virtual interface. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual
         * interface owner. If the owner of the virtual interface is different from the owner of the connection on which
         * it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual
         * interface owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface
         * needs validation before the virtual interface can be created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual
         * interface is ready to forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code>: A virtual interface that is able to forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>down</code>: A virtual interface that is BGP down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>testing</code>: A virtual interface is in this state immediately after calling
         * <a>StartBgpFailoverTest</a> and remains in this state during the duration of the test.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: A virtual interface is in this state immediately after calling
         * <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: A virtual interface that cannot forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a
         * virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual
         * interface enters the <code>Rejected</code> state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown</code>: The state of the virtual interface is not available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param virtualInterfaceState
         *        The state of the virtual interface. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>confirming</code>: The creation of the virtual interface is pending confirmation from the
         *        virtual interface owner. If the owner of the virtual interface is different from the owner of the
         *        connection on which it is provisioned, then the virtual interface will remain in this state until it
         *        is confirmed by the virtual interface owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual
         *        interface needs validation before the virtual interface can be created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: A virtual interface is in this state from the time that it is created until the
         *        virtual interface is ready to forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code>: A virtual interface that is able to forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>down</code>: A virtual interface that is BGP down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>testing</code>: A virtual interface is in this state immediately after calling
         *        <a>StartBgpFailoverTest</a> and remains in this state during the duration of the test.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: A virtual interface is in this state immediately after calling
         *        <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: A virtual interface that cannot forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If
         *        a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner,
         *        the virtual interface enters the <code>Rejected</code> state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown</code>: The state of the virtual interface is not available.
         *        </p>
         *        </li>
         * @see VirtualInterfaceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualInterfaceState
         */
        Builder virtualInterfaceState(String virtualInterfaceState);

        /**
         * <p>
         * The state of the virtual interface. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>confirming</code>: The creation of the virtual interface is pending confirmation from the virtual
         * interface owner. If the owner of the virtual interface is different from the owner of the connection on which
         * it is provisioned, then the virtual interface will remain in this state until it is confirmed by the virtual
         * interface owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual interface
         * needs validation before the virtual interface can be created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: A virtual interface is in this state from the time that it is created until the virtual
         * interface is ready to forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code>: A virtual interface that is able to forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>down</code>: A virtual interface that is BGP down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>testing</code>: A virtual interface is in this state immediately after calling
         * <a>StartBgpFailoverTest</a> and remains in this state during the duration of the test.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: A virtual interface is in this state immediately after calling
         * <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: A virtual interface that cannot forward traffic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If a
         * virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner, the virtual
         * interface enters the <code>Rejected</code> state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown</code>: The state of the virtual interface is not available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param virtualInterfaceState
         *        The state of the virtual interface. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>confirming</code>: The creation of the virtual interface is pending confirmation from the
         *        virtual interface owner. If the owner of the virtual interface is different from the owner of the
         *        connection on which it is provisioned, then the virtual interface will remain in this state until it
         *        is confirmed by the virtual interface owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>verifying</code>: This state only applies to public virtual interfaces. Each public virtual
         *        interface needs validation before the virtual interface can be created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: A virtual interface is in this state from the time that it is created until the
         *        virtual interface is ready to forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code>: A virtual interface that is able to forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>down</code>: A virtual interface that is BGP down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>testing</code>: A virtual interface is in this state immediately after calling
         *        <a>StartBgpFailoverTest</a> and remains in this state during the duration of the test.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: A virtual interface is in this state immediately after calling
         *        <a>DeleteVirtualInterface</a> until it can no longer forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: A virtual interface that cannot forward traffic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rejected</code>: The virtual interface owner has declined creation of the virtual interface. If
         *        a virtual interface in the <code>Confirming</code> state is deleted by the virtual interface owner,
         *        the virtual interface enters the <code>Rejected</code> state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown</code>: The state of the virtual interface is not available.
         *        </p>
         *        </li>
         * @see VirtualInterfaceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualInterfaceState
         */
        Builder virtualInterfaceState(VirtualInterfaceState virtualInterfaceState);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private String virtualInterfaceState;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmPrivateVirtualInterfaceResponse model) {
            super(model);
            virtualInterfaceState(model.virtualInterfaceState);
        }

        public final String getVirtualInterfaceState() {
            return virtualInterfaceState;
        }

        public final void setVirtualInterfaceState(String virtualInterfaceState) {
            this.virtualInterfaceState = virtualInterfaceState;
        }

        @Override
        public final Builder virtualInterfaceState(String virtualInterfaceState) {
            this.virtualInterfaceState = virtualInterfaceState;
            return this;
        }

        @Override
        public final Builder virtualInterfaceState(VirtualInterfaceState virtualInterfaceState) {
            this.virtualInterfaceState(virtualInterfaceState == null ? null : virtualInterfaceState.toString());
            return this;
        }

        @Override
        public ConfirmPrivateVirtualInterfaceResponse build() {
            return new ConfirmPrivateVirtualInterfaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
