/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRouterConfigurationResponse extends DirectConnectResponse implements
        ToCopyableBuilder<DescribeRouterConfigurationResponse.Builder, DescribeRouterConfigurationResponse> {
    private static final SdkField<String> CUSTOMER_ROUTER_CONFIG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerRouterConfig").getter(getter(DescribeRouterConfigurationResponse::customerRouterConfig))
            .setter(setter(Builder::customerRouterConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerRouterConfig").build())
            .build();

    private static final SdkField<RouterType> ROUTER_FIELD = SdkField.<RouterType> builder(MarshallingType.SDK_POJO)
            .memberName("router").getter(getter(DescribeRouterConfigurationResponse::router)).setter(setter(Builder::router))
            .constructor(RouterType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("router").build()).build();

    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceId").getter(getter(DescribeRouterConfigurationResponse::virtualInterfaceId))
            .setter(setter(Builder::virtualInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build())
            .build();

    private static final SdkField<String> VIRTUAL_INTERFACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualInterfaceName").getter(getter(DescribeRouterConfigurationResponse::virtualInterfaceName))
            .setter(setter(Builder::virtualInterfaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_ROUTER_CONFIG_FIELD,
            ROUTER_FIELD, VIRTUAL_INTERFACE_ID_FIELD, VIRTUAL_INTERFACE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String customerRouterConfig;

    private final RouterType router;

    private final String virtualInterfaceId;

    private final String virtualInterfaceName;

    private DescribeRouterConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.customerRouterConfig = builder.customerRouterConfig;
        this.router = builder.router;
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.virtualInterfaceName = builder.virtualInterfaceName;
    }

    /**
     * <p>
     * The customer router configuration.
     * </p>
     * 
     * @return The customer router configuration.
     */
    public final String customerRouterConfig() {
        return customerRouterConfig;
    }

    /**
     * <p>
     * The details about the router.
     * </p>
     * 
     * @return The details about the router.
     */
    public final RouterType router() {
        return router;
    }

    /**
     * <p>
     * The ID assigned to the virtual interface.
     * </p>
     * 
     * @return The ID assigned to the virtual interface.
     */
    public final String virtualInterfaceId() {
        return virtualInterfaceId;
    }

    /**
     * <p>
     * Provides the details about a virtual interface's router.
     * </p>
     * 
     * @return Provides the details about a virtual interface's router.
     */
    public final String virtualInterfaceName() {
        return virtualInterfaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customerRouterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(router());
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouterConfigurationResponse)) {
            return false;
        }
        DescribeRouterConfigurationResponse other = (DescribeRouterConfigurationResponse) obj;
        return Objects.equals(customerRouterConfig(), other.customerRouterConfig()) && Objects.equals(router(), other.router())
                && Objects.equals(virtualInterfaceId(), other.virtualInterfaceId())
                && Objects.equals(virtualInterfaceName(), other.virtualInterfaceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRouterConfigurationResponse").add("CustomerRouterConfig", customerRouterConfig())
                .add("Router", router()).add("VirtualInterfaceId", virtualInterfaceId())
                .add("VirtualInterfaceName", virtualInterfaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customerRouterConfig":
            return Optional.ofNullable(clazz.cast(customerRouterConfig()));
        case "router":
            return Optional.ofNullable(clazz.cast(router()));
        case "virtualInterfaceId":
            return Optional.ofNullable(clazz.cast(virtualInterfaceId()));
        case "virtualInterfaceName":
            return Optional.ofNullable(clazz.cast(virtualInterfaceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customerRouterConfig", CUSTOMER_ROUTER_CONFIG_FIELD);
        map.put("router", ROUTER_FIELD);
        map.put("virtualInterfaceId", VIRTUAL_INTERFACE_ID_FIELD);
        map.put("virtualInterfaceName", VIRTUAL_INTERFACE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRouterConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeRouterConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRouterConfigurationResponse> {
        /**
         * <p>
         * The customer router configuration.
         * </p>
         * 
         * @param customerRouterConfig
         *        The customer router configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerRouterConfig(String customerRouterConfig);

        /**
         * <p>
         * The details about the router.
         * </p>
         * 
         * @param router
         *        The details about the router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder router(RouterType router);

        /**
         * <p>
         * The details about the router.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouterType.Builder} avoiding the need to
         * create one manually via {@link RouterType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouterType.Builder#build()} is called immediately and its result
         * is passed to {@link #router(RouterType)}.
         * 
         * @param router
         *        a consumer that will call methods on {@link RouterType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #router(RouterType)
         */
        default Builder router(Consumer<RouterType.Builder> router) {
            return router(RouterType.builder().applyMutation(router).build());
        }

        /**
         * <p>
         * The ID assigned to the virtual interface.
         * </p>
         * 
         * @param virtualInterfaceId
         *        The ID assigned to the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceId(String virtualInterfaceId);

        /**
         * <p>
         * Provides the details about a virtual interface's router.
         * </p>
         * 
         * @param virtualInterfaceName
         *        Provides the details about a virtual interface's router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceName(String virtualInterfaceName);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private String customerRouterConfig;

        private RouterType router;

        private String virtualInterfaceId;

        private String virtualInterfaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouterConfigurationResponse model) {
            super(model);
            customerRouterConfig(model.customerRouterConfig);
            router(model.router);
            virtualInterfaceId(model.virtualInterfaceId);
            virtualInterfaceName(model.virtualInterfaceName);
        }

        public final String getCustomerRouterConfig() {
            return customerRouterConfig;
        }

        public final void setCustomerRouterConfig(String customerRouterConfig) {
            this.customerRouterConfig = customerRouterConfig;
        }

        @Override
        public final Builder customerRouterConfig(String customerRouterConfig) {
            this.customerRouterConfig = customerRouterConfig;
            return this;
        }

        public final RouterType.Builder getRouter() {
            return router != null ? router.toBuilder() : null;
        }

        public final void setRouter(RouterType.BuilderImpl router) {
            this.router = router != null ? router.build() : null;
        }

        @Override
        public final Builder router(RouterType router) {
            this.router = router;
            return this;
        }

        public final String getVirtualInterfaceId() {
            return virtualInterfaceId;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final String getVirtualInterfaceName() {
            return virtualInterfaceName;
        }

        public final void setVirtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
        }

        @Override
        public final Builder virtualInterfaceName(String virtualInterfaceName) {
            this.virtualInterfaceName = virtualInterfaceName;
            return this;
        }

        @Override
        public DescribeRouterConfigurationResponse build() {
            return new DescribeRouterConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
