/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.Attribute;
import software.amazon.awssdk.services.directory.model.AttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Computer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Computer> {
    private static final SdkField<String> COMPUTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Computer.getter(Computer::computerId)).setter(Computer.setter(Builder::computerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerId").build()}).build();
    private static final SdkField<String> COMPUTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Computer.getter(Computer::computerName)).setter(Computer.setter(Builder::computerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerName").build()}).build();
    private static final SdkField<List<Attribute>> COMPUTER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Computer.getter(Computer::computerAttributes)).setter(Computer.setter(Builder::computerAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTER_ID_FIELD, COMPUTER_NAME_FIELD, COMPUTER_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String computerId;
    private final String computerName;
    private final List<Attribute> computerAttributes;

    private Computer(BuilderImpl builder) {
        this.computerId = builder.computerId;
        this.computerName = builder.computerName;
        this.computerAttributes = builder.computerAttributes;
    }

    public String computerId() {
        return this.computerId;
    }

    public String computerName() {
        return this.computerName;
    }

    public List<Attribute> computerAttributes() {
        return this.computerAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.computerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.computerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.computerAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Computer)) {
            return false;
        }
        Computer other = (Computer)obj;
        return Objects.equals(this.computerId(), other.computerId()) && Objects.equals(this.computerName(), other.computerName()) && Objects.equals(this.computerAttributes(), other.computerAttributes());
    }

    public String toString() {
        return ToString.builder((String)"Computer").add("ComputerId", (Object)this.computerId()).add("ComputerName", (Object)this.computerName()).add("ComputerAttributes", this.computerAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComputerId": {
                return Optional.ofNullable(clazz.cast(this.computerId()));
            }
            case "ComputerName": {
                return Optional.ofNullable(clazz.cast(this.computerName()));
            }
            case "ComputerAttributes": {
                return Optional.ofNullable(clazz.cast(this.computerAttributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Computer, T> g) {
        return obj -> g.apply((Computer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String computerId;
        private String computerName;
        private List<Attribute> computerAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Computer model) {
            this.computerId(model.computerId);
            this.computerName(model.computerName);
            this.computerAttributes(model.computerAttributes);
        }

        public final String getComputerId() {
            return this.computerId;
        }

        @Override
        public final Builder computerId(String computerId) {
            this.computerId = computerId;
            return this;
        }

        public final void setComputerId(String computerId) {
            this.computerId = computerId;
        }

        public final String getComputerName() {
            return this.computerName;
        }

        @Override
        public final Builder computerName(String computerName) {
            this.computerName = computerName;
            return this;
        }

        public final void setComputerName(String computerName) {
            this.computerName = computerName;
        }

        public final Collection<Attribute.Builder> getComputerAttributes() {
            return this.computerAttributes != null ? (Collection)this.computerAttributes.stream().map(Attribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder computerAttributes(Collection<Attribute> computerAttributes) {
            this.computerAttributes = AttributesCopier.copy(computerAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computerAttributes(Attribute ... computerAttributes) {
            this.computerAttributes(Arrays.asList(computerAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computerAttributes(Consumer<Attribute.Builder> ... computerAttributes) {
            this.computerAttributes(Stream.of(computerAttributes).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComputerAttributes(Collection<Attribute.BuilderImpl> computerAttributes) {
            this.computerAttributes = AttributesCopier.copyFromBuilder(computerAttributes);
        }

        public Computer build() {
            return new Computer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Computer> {
        public Builder computerId(String var1);

        public Builder computerName(String var1);

        public Builder computerAttributes(Collection<Attribute> var1);

        public Builder computerAttributes(Attribute ... var1);

        public Builder computerAttributes(Consumer<Attribute.Builder> ... var1);
    }
}

