/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a DeleteTrust request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTrustResponse extends DirectoryResponse implements
        ToCopyableBuilder<DeleteTrustResponse.Builder, DeleteTrustResponse> {
    private static final SdkField<String> TRUST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteTrustResponse::trustId)).setter(setter(Builder::trustId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_ID_FIELD));

    private final String trustId;

    private DeleteTrustResponse(BuilderImpl builder) {
        super(builder);
        this.trustId = builder.trustId;
    }

    /**
     * <p>
     * The Trust ID of the trust relationship that was deleted.
     * </p>
     * 
     * @return The Trust ID of the trust relationship that was deleted.
     */
    public String trustId() {
        return trustId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trustId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTrustResponse)) {
            return false;
        }
        DeleteTrustResponse other = (DeleteTrustResponse) obj;
        return Objects.equals(trustId(), other.trustId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteTrustResponse").add("TrustId", trustId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustId":
            return Optional.ofNullable(clazz.cast(trustId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTrustResponse, T> g) {
        return obj -> g.apply((DeleteTrustResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteTrustResponse> {
        /**
         * <p>
         * The Trust ID of the trust relationship that was deleted.
         * </p>
         * 
         * @param trustId
         *        The Trust ID of the trust relationship that was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustId(String trustId);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private String trustId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTrustResponse model) {
            super(model);
            trustId(model.trustId);
        }

        public final String getTrustId() {
            return trustId;
        }

        @Override
        public final Builder trustId(String trustId) {
            this.trustId = trustId;
            return this;
        }

        public final void setTrustId(String trustId) {
            this.trustId = trustId;
        }

        @Override
        public DeleteTrustResponse build() {
            return new DeleteTrustResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
